/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.queue;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveJob;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveJobAdapter;

public class InteractiveQueue {
    private static final transient Logger logger = LoggerFactory.getLogger(InteractiveQueue.class);
    private final BlockingDeque<InteractiveJob> jobQueue = new LinkedBlockingDeque<InteractiveJob>();
    private Job handlerJob;
    private boolean isDisposed = false;

    public InteractiveQueue() {
        this.createHandlerJob();
    }

    private void createHandlerJob() {
        if (this.handlerJob != null) {
            return;
        }
        this.handlerJob = new Job("Interactive queue handling"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    logger.debug("Interactive queue service started");
                    while (!InteractiveQueue.this.isDisposed) {
                        if (iProgressMonitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        InteractiveJob interactiveJob = (InteractiveJob)InteractiveQueue.this.jobQueue.take();
                        if (interactiveJob.isNull()) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        try {
                            interactiveJob.run(iProgressMonitor);
                        }
                        catch (Exception exception) {
                            logger.error("Cannot run job", (Throwable)exception);
                        }
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InterruptedException interruptedException) {
                    logger.error("Interactive queue exiting...", (Throwable)interruptedException);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    logger.debug("Interactive queue service ended");
                }
            }
        };
        this.handlerJob.setPriority(30);
        this.handlerJob.setUser(false);
        this.handlerJob.setSystem(true);
        this.handlerJob.schedule();
    }

    public void addJob(InteractiveJob interactiveJob) {
        if (this.isDisposed || this.handlerJob == null) {
            throw new IllegalStateException("handler job gone");
        }
        this.jobQueue.clear();
        this.jobQueue.add(interactiveJob);
    }

    private void interrupt() {
        if (this.jobQueue != null) {
            this.jobQueue.clear();
        }
        if (this.handlerJob != null) {
            if (this.jobQueue != null) {
                this.jobQueue.add(new InteractiveJobAdapter());
            }
            if (this.handlerJob != null) {
                this.handlerJob.cancel();
            }
            try {
                if (this.handlerJob != null) {
                    this.handlerJob.join();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("Cannot join", (Throwable)interruptedException);
            }
        }
        this.handlerJob = null;
    }

    public void dispose() {
        this.interrupt();
        this.isDisposed = true;
    }
}

