/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.projects;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.projects.DataFilesFilter;

public class DataProjectSupport {
    private static final Logger logger = LoggerFactory.getLogger(DataProjectSupport.class);

    public static IProject createProject(String string, String string2, IProgressMonitor iProgressMonitor) {
        return DataProjectSupport.createProject(string, string2, iProgressMonitor, null);
    }

    public static IProject createProject(String string, String string2, IProgressMonitor iProgressMonitor, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        IProject iProject = DataProjectSupport.createBaseProject(string, null);
        File file = new File(string2);
        File[] fileArray = file.listFiles(new DataFilesFilter());
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                if (!ArrayUtils.contains((Object[])stringArray, (Object)fileArray[n].getName())) {
                    iProgressMonitor.subTask("Importing directory: " + fileArray[n].getAbsolutePath());
                    DataProjectSupport.addToProjectStructure(iProject, fileArray[n], iProgressMonitor);
                }
            } else {
                iProgressMonitor.subTask("Import file: " + fileArray[n].getName());
                DataProjectSupport.addFilesToProjectStructure(iProject, fileArray[n], iProgressMonitor);
            }
            ++n;
        }
        return iProject;
    }

    private static void addFilesToProjectStructure(IProject iProject, File file, IProgressMonitor iProgressMonitor) {
        IFile iFile = iProject.getFile(file.getName());
        if (!iFile.exists()) {
            try {
                iFile.createLink((IPath)new Path(file.getAbsolutePath()), 0, iProgressMonitor);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private static void addToProjectStructure(IProject iProject, File file, IProgressMonitor iProgressMonitor) {
        String string = file.getName();
        IFolder iFolder = iProject.getFolder(string);
        try {
            DataProjectSupport.createFolder(iFolder, file, iProgressMonitor);
        }
        catch (CoreException coreException) {
            logger.warn("Exception trying to create link to folder " + string, (Throwable)coreException);
        }
    }

    private static void createFolder(IFolder iFolder, File file, IProgressMonitor iProgressMonitor) throws CoreException {
        IContainer iContainer = iFolder.getParent();
        if (iContainer instanceof IFolder) {
            DataProjectSupport.createFolder((IFolder)iContainer, file, iProgressMonitor);
        }
        if (!iFolder.exists()) {
            iFolder.createLink((IPath)new Path(file.getAbsolutePath()), 0, iProgressMonitor);
        }
    }

    private static IProject createBaseProject(String string, URI uRI) {
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (!iProject.exists()) {
            URI uRI2 = uRI;
            IProjectDescription iProjectDescription = iProject.getWorkspace().newProjectDescription(string);
            iProjectDescription.setLocationURI(uRI2);
            try {
                iProject.create(iProjectDescription, null);
                if (!iProject.isOpen()) {
                    iProject.open(null);
                }
            }
            catch (CoreException coreException) {
                logger.warn("Exception trying to create new workspace project " + string, (Throwable)coreException);
            }
        }
        return iProject;
    }
}

