/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.PrintSettings;

public class PrintSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo scaleCombo;
    private Combo printerListCombo;
    private Combo orientationCombo;
    private Combo resolutionCombo;
    private PrintSettings settings;
    private Printer printer;

    public PrintSettingsPreferencePage() {
    }

    public PrintSettingsPreferencePage(String string) {
        super(string);
    }

    public PrintSettingsPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Print Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData2 = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData2);
        Label label = new Label((Composite)group, 16384);
        label.setText("Printer Name: ");
        this.printerListCombo = new Combo((Composite)group, 131080);
        this.printerListCombo.setToolTipText("List of all available printers");
        if (this.settings == null) {
            this.settings = new PrintSettings();
        }
        this.printer = new Printer(this.settings.getPrinterData());
        PrinterData[] printerDataArray = Printer.getPrinterList();
        int n = 0;
        while (n < printerDataArray.length) {
            this.printerListCombo.add(printerDataArray[n].name);
            ++n;
        }
        Label label2 = new Label((Composite)group, 16384);
        label2.setText("Scale: ");
        this.scaleCombo = new Combo((Composite)group, 131080);
        this.scaleCombo.setToolTipText("Change the scale of the plot to be printed");
        PrintSettings.Scale[] scaleArray = PrintSettings.Scale.values();
        int n2 = 0;
        while (n2 < scaleArray.length) {
            this.scaleCombo.add(scaleArray[n2].getName().toString());
            ++n2;
        }
        Label label3 = new Label((Composite)group, 16384);
        label3.setText("Resolution: ");
        this.resolutionCombo = new Combo((Composite)group, 131080);
        this.resolutionCombo.setToolTipText("Change the resolution of the plot to be printed");
        PrintSettings.Resolution[] resolutionArray = PrintSettings.Resolution.values();
        int n3 = 0;
        while (n3 < resolutionArray.length) {
            this.resolutionCombo.add(resolutionArray[n3].getName().toString());
            ++n3;
        }
        Label label4 = new Label((Composite)group, 16384);
        label4.setText("Orientation: ");
        this.orientationCombo = new Combo((Composite)group, 131080);
        this.orientationCombo.setEnabled(false);
        this.orientationCombo.setToolTipText("Not yet fully functional");
        PrintSettings.Orientation[] orientationArray = PrintSettings.Orientation.values();
        int n4 = 0;
        while (n4 < orientationArray.length) {
            this.orientationCombo.add(orientationArray[n4].getName().toString());
            ++n4;
        }
        this.initializePage();
        return composite2;
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
    }

    private void initializePage() {
        this.scaleCombo.select(this.getScalePreference());
        this.printerListCombo.select(this.getPrinterNamePreference());
        this.orientationCombo.select(this.getOrientationPreference());
        this.resolutionCombo.select(this.getResolutionPreference());
    }

    private void loadDefaultPreferences() {
        this.scaleCombo.select(this.getDefaultScalePreference());
        this.printerListCombo.select(this.getDefaultPrinterNamePreference());
        this.orientationCombo.select(this.getDefaultOrientationPreference());
        this.resolutionCombo.select(this.getDefaultOrientationPreference());
    }

    private void storePreferences() {
        this.setScalePreference(this.scaleCombo.getSelectionIndex());
        this.setPrinterNamePreference(this.printerListCombo.getSelectionIndex());
        this.setOrientationPreference(this.orientationCombo.getSelectionIndex());
        this.setResolutionPreference(this.resolutionCombo.getSelectionIndex());
    }

    public int getDefaultPrinterNamePreference() {
        return this.getPreferenceStore().getDefaultInt("printsettings.printername");
    }

    public int getDefaultOrientationPreference() {
        return this.getPreferenceStore().getDefaultInt("printsettings.orientation");
    }

    public int getDefaultScalePreference() {
        return this.getPreferenceStore().getDefaultInt("printsettings.scale");
    }

    public int getDefaultResolutionPreference() {
        return this.getPreferenceStore().getDefaultInt("printsettings.resolution");
    }

    public int getPrinterNamePreference() {
        if (this.getPreferenceStore().isDefault("printsettings.printername")) {
            return this.getPreferenceStore().getDefaultInt("printsettings.printername");
        }
        return this.getPreferenceStore().getInt("printsettings.printername");
    }

    public int getOrientationPreference() {
        if (this.getPreferenceStore().isDefault("printsettings.orientation")) {
            return this.getPreferenceStore().getDefaultInt("printsettings.orientation");
        }
        return this.getPreferenceStore().getInt("printsettings.orientation");
    }

    public int getScalePreference() {
        if (this.getPreferenceStore().isDefault("printsettings.scale")) {
            return this.getPreferenceStore().getDefaultInt("printsettings.scale");
        }
        return this.getPreferenceStore().getInt("printsettings.scale");
    }

    public int getResolutionPreference() {
        if (this.getPreferenceStore().isDefault("printsettings.resolution")) {
            return this.getPreferenceStore().getDefaultInt("printsettings.resolution");
        }
        return this.getPreferenceStore().getInt("printsettings.resolution");
    }

    public void setScalePreference(int n) {
        this.settings.setScale(PrintSettings.Scale.values()[n]);
        this.getPreferenceStore().setValue("printsettings.scale", n);
    }

    public void setOrientationPreference(int n) {
        this.settings.setOrientation(PrintSettings.Orientation.values()[n]);
        this.getPreferenceStore().setValue("printsettings.orientation", n);
    }

    public void setPrinterNamePreference(int n) {
        this.settings.setPrinterData(Printer.getPrinterList()[n]);
        this.getPreferenceStore().setValue("printsettings.printername", n);
    }

    public void setResolutionPreference(int n) {
        this.settings.setResolution(PrintSettings.Resolution.values()[n]);
        this.getPreferenceStore().setValue("printsettings.resolution", n);
    }
}

