/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;

public class PlotViewPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo cmbColourMap;
    private Combo cmbColourScale;
    private Combo cmbCameraPerspective;
    private Button chkExpertMode;
    private Button chkAutoContrast;
    private Button chkScrollbars;
    private Spinner spnAutoLoThreshold;
    private Spinner spnAutoHiThreshold;

    public PlotViewPreferencePage() {
    }

    public PlotViewPreferencePage(String string) {
        super(string);
    }

    public PlotViewPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setText("Plot 1DStack");
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 16384);
        label.setText("Camera projection: ");
        this.cmbCameraPerspective = new Combo((Composite)group, 131080);
        this.cmbCameraPerspective.add("Orthographic");
        this.cmbCameraPerspective.add("Perspective");
        Group group2 = new Group(composite2, 0);
        group2.setText("Plot 2D");
        group2.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(4, 4, true, false);
        group2.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)group2, 16384);
        label2.setText("Default colour mapping");
        this.cmbColourMap = new Combo((Composite)group2, 131080);
        int n = 0;
        while (n < GlobalColourMaps.colourMapNames.length) {
            this.cmbColourMap.add(GlobalColourMaps.colourMapNames[n]);
            ++n;
        }
        Label label3 = new Label((Composite)group2, 16384);
        label3.setText("Colour map expert mode");
        this.chkExpertMode = new Button((Composite)group2, 131104);
        Label label4 = new Label((Composite)group2, 16384);
        label4.setText("Auto contrast");
        this.chkAutoContrast = new Button((Composite)group2, 131104);
        Label label5 = new Label((Composite)group2, 16384);
        label5.setText("Auto-contrast lower threshold (in %)");
        this.spnAutoLoThreshold = new Spinner((Composite)group2, 131072);
        this.spnAutoLoThreshold.setMinimum(0);
        this.spnAutoLoThreshold.setMaximum(99);
        this.spnAutoLoThreshold.setIncrement(1);
        this.spnAutoLoThreshold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = PlotViewPreferencePage.this.spnAutoLoThreshold.getSelection() + 1;
                if (PlotViewPreferencePage.this.spnAutoHiThreshold.getSelection() < n) {
                    PlotViewPreferencePage.this.spnAutoHiThreshold.setSelection(n);
                }
                PlotViewPreferencePage.this.spnAutoHiThreshold.setMinimum(n);
            }
        });
        Label label6 = new Label((Composite)group2, 16384);
        label6.setText("Auto-contrast upper threshold (in %)");
        this.spnAutoHiThreshold = new Spinner((Composite)group2, 131072);
        this.spnAutoHiThreshold.setMinimum(1);
        this.spnAutoHiThreshold.setMaximum(100);
        this.spnAutoHiThreshold.setIncrement(1);
        this.spnAutoHiThreshold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = PlotViewPreferencePage.this.spnAutoHiThreshold.getSelection() - 1;
                if (PlotViewPreferencePage.this.spnAutoLoThreshold.getSelection() > n) {
                    PlotViewPreferencePage.this.spnAutoLoThreshold.setSelection(n);
                }
                PlotViewPreferencePage.this.spnAutoLoThreshold.setMaximum(n);
            }
        });
        Label label7 = new Label((Composite)group2, 16384);
        label7.setText("Colour scaling");
        this.cmbColourScale = new Combo((Composite)group2, 131080);
        this.cmbColourScale.add("Linear");
        this.cmbColourScale.add("Logarithmic");
        Label label8 = new Label((Composite)group2, 16384);
        label8.setText("Show scrollbars");
        this.chkScrollbars = new Button((Composite)group2, 131104);
        this.initializePage();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
    }

    private void initializePage() {
        this.cmbColourMap.select(this.getColourMapChoicePreference());
        this.chkExpertMode.setSelection(this.getExpertModePreference());
        this.chkAutoContrast.setSelection(this.getAutoContrastPreference());
        this.spnAutoLoThreshold.setSelection(this.getAutoContrastLoPreference());
        this.spnAutoHiThreshold.setSelection(this.getAutoContrastHiPreference());
        this.cmbColourScale.select(this.getColourScaleChoicePreference());
        this.cmbCameraPerspective.select(this.getPerspectivePreference());
        this.chkScrollbars.setSelection(this.getScrollBarPreference());
    }

    private void loadDefaultPreferences() {
        this.cmbColourMap.select(this.getDefaultColourMapChoicePreference());
        this.chkExpertMode.setSelection(this.getDefaultExpertModePreference());
        this.chkAutoContrast.setSelection(this.getDefaultAutoContrastPreference());
        this.spnAutoLoThreshold.setSelection(this.getDefaultAutoContrastLoPreference());
        this.spnAutoHiThreshold.setSelection(this.getDefaultAutoContrastHiPreference());
        this.cmbColourScale.select(this.getDefautColourScaleChoicePreference());
        this.cmbCameraPerspective.select(this.getDefaultPerspectivePreference());
        this.chkScrollbars.setSelection(this.getDefaultScrollBarPreference());
    }

    private void storePreferences() {
        this.setColourMapChoicePreference(this.cmbColourMap.getSelectionIndex());
        this.setExpertModePreference(this.chkExpertMode.getSelection());
        this.setAutoContrastPreference(this.chkAutoContrast.getSelection());
        this.setAutoContrastLoPreference(this.spnAutoLoThreshold.getSelection());
        this.setAutoContrastHiPreference(this.spnAutoHiThreshold.getSelection());
        this.setColourScaleChoicePreference(this.cmbColourScale.getSelectionIndex());
        this.setCameraPerspective(this.cmbCameraPerspective.getSelectionIndex());
        this.setScrollBarPreference(this.chkScrollbars.getSelection());
    }

    private int getDefaultPerspectivePreference() {
        return this.getPreferenceStore().getDefaultInt("plotView.multi1Dcamera");
    }

    private int getDefaultColourMapChoicePreference() {
        return this.getPreferenceStore().getDefaultInt("plotView.plot2DcolourMap");
    }

    private int getDefautColourScaleChoicePreference() {
        return this.getPreferenceStore().getDefaultInt("plotView.plot2Dscaling");
    }

    private boolean getDefaultExpertModePreference() {
        return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DcmapExpert");
    }

    private boolean getDefaultAutoContrastPreference() {
        return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DautoContrast");
    }

    private int getDefaultAutoContrastLoPreference() {
        return this.getPreferenceStore().getDefaultInt("plotView.autoContrastLoThreshold");
    }

    private int getDefaultAutoContrastHiPreference() {
        return this.getPreferenceStore().getDefaultInt("plotView.autoContrastHiThreshold");
    }

    private boolean getDefaultScrollBarPreference() {
        return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DshowScrollbar");
    }

    private int getPerspectivePreference() {
        if (this.getPreferenceStore().isDefault("plotView.multi1Dcamera")) {
            return this.getPreferenceStore().getDefaultInt("plotView.multi1Dcamera");
        }
        return this.getPreferenceStore().getInt("plotView.multi1Dcamera");
    }

    private int getColourMapChoicePreference() {
        if (this.getPreferenceStore().isDefault("plotView.plot2DcolourMap")) {
            return this.getPreferenceStore().getDefaultInt("plotView.plot2DcolourMap");
        }
        return this.getPreferenceStore().getInt("plotView.plot2DcolourMap");
    }

    private boolean getExpertModePreference() {
        if (this.getPreferenceStore().isDefault("plotView.plot2DcmapExpert")) {
            return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DcmapExpert");
        }
        return this.getPreferenceStore().getBoolean("plotView.plot2DcmapExpert");
    }

    private boolean getAutoContrastPreference() {
        if (this.getPreferenceStore().isDefault("plotView.plot2DautoContrast")) {
            return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DautoContrast");
        }
        return this.getPreferenceStore().getBoolean("plotView.plot2DautoContrast");
    }

    private int getAutoContrastLoPreference() {
        if (this.getPreferenceStore().isDefault("plotView.autoContrastLoThreshold")) {
            return this.getPreferenceStore().getDefaultInt("plotView.autoContrastLoThreshold");
        }
        return this.getPreferenceStore().getInt("plotView.autoContrastLoThreshold");
    }

    private int getAutoContrastHiPreference() {
        if (this.getPreferenceStore().isDefault("plotView.autoContrastHiThreshold")) {
            return this.getPreferenceStore().getDefaultInt("plotView.autoContrastHiThreshold");
        }
        return this.getPreferenceStore().getInt("plotView.autoContrastHiThreshold");
    }

    private int getColourScaleChoicePreference() {
        if (this.getPreferenceStore().isDefault("plotView.plot2Dscaling")) {
            return this.getPreferenceStore().getDefaultInt("plotView.plot2Dscaling");
        }
        return this.getPreferenceStore().getInt("plotView.plot2Dscaling");
    }

    private boolean getScrollBarPreference() {
        if (this.getPreferenceStore().isDefault("plotView.plot2DshowScrollbar")) {
            return this.getPreferenceStore().getDefaultBoolean("plotView.plot2DshowScrollbar");
        }
        return this.getPreferenceStore().getBoolean("plotView.plot2DshowScrollbar");
    }

    private void setColourMapChoicePreference(int n) {
        this.getPreferenceStore().setValue("plotView.plot2DcolourMap", n);
    }

    private void setColourScaleChoicePreference(int n) {
        this.getPreferenceStore().setValue("plotView.plot2Dscaling", n);
    }

    private void setExpertModePreference(boolean bl) {
        this.getPreferenceStore().setValue("plotView.plot2DcmapExpert", bl);
    }

    private void setAutoContrastPreference(boolean bl) {
        this.getPreferenceStore().setValue("plotView.plot2DautoContrast", bl);
    }

    private void setAutoContrastLoPreference(int n) {
        this.getPreferenceStore().setValue("plotView.autoContrastLoThreshold", n);
    }

    private void setAutoContrastHiPreference(int n) {
        this.getPreferenceStore().setValue("plotView.autoContrastHiThreshold", n);
    }

    private void setCameraPerspective(int n) {
        this.getPreferenceStore().setValue("plotView.multi1Dcamera", n);
    }

    private void setScrollBarPreference(boolean bl) {
        this.getPreferenceStore().setValue("plotView.plot2DshowScrollbar", bl);
    }
}

