/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.GlobalColourMaps;
import uk.ac.diamond.scisoft.analysis.rcp.views.ImageExplorerView;

public class ImageExplorerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo cmbColourMap;
    private Spinner spnAutoLoThreshold;
    private Spinner spnAutoHiThreshold;
    private Spinner spnWaitTime;
    private Spinner spnSkipImages;
    private Combo cmbDisplayViews;

    public ImageExplorerPreferencePage() {
    }

    public ImageExplorerPreferencePage(String string) {
        super(string);
    }

    public ImageExplorerPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        String string2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite2, 16384);
        label.setText("Default colour mapping");
        this.cmbColourMap = new Combo(composite2, 131080);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.cmbColourMap.setLayoutData((Object)gridData);
        int n = 0;
        while (n < GlobalColourMaps.colourMapNames.length) {
            this.cmbColourMap.add(GlobalColourMaps.colourMapNames[n]);
            ++n;
        }
        Label label2 = new Label(composite2, 16384);
        label2.setText("Auto-contrast lower threshold (in %)");
        this.spnAutoLoThreshold = new Spinner(composite2, 131072);
        this.spnAutoLoThreshold.setMinimum(0);
        this.spnAutoLoThreshold.setMaximum(99);
        this.spnAutoLoThreshold.setIncrement(1);
        this.spnAutoLoThreshold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImageExplorerPreferencePage.this.spnAutoLoThreshold.getSelection() + 1;
                if (ImageExplorerPreferencePage.this.spnAutoHiThreshold.getSelection() < n) {
                    ImageExplorerPreferencePage.this.spnAutoHiThreshold.setSelection(n);
                }
                ImageExplorerPreferencePage.this.spnAutoHiThreshold.setMinimum(n);
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.spnAutoLoThreshold.setLayoutData((Object)gridData);
        Label label3 = new Label(composite2, 16384);
        label3.setText("Auto-contrast upper threshold (in %)");
        this.spnAutoHiThreshold = new Spinner(composite2, 131072);
        this.spnAutoHiThreshold.setMinimum(1);
        this.spnAutoHiThreshold.setMaximum(100);
        this.spnAutoHiThreshold.setIncrement(1);
        this.spnAutoHiThreshold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImageExplorerPreferencePage.this.spnAutoHiThreshold.getSelection() - 1;
                if (ImageExplorerPreferencePage.this.spnAutoLoThreshold.getSelection() > n) {
                    ImageExplorerPreferencePage.this.spnAutoLoThreshold.setSelection(n);
                }
                ImageExplorerPreferencePage.this.spnAutoLoThreshold.setMaximum(n);
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.spnAutoHiThreshold.setLayoutData((Object)gridData);
        Label label4 = new Label(composite2, 16384);
        label4.setText("Time delay for next image in play mode");
        this.spnWaitTime = new Spinner(composite2, 131072);
        this.spnWaitTime.setMinimum(150);
        this.spnWaitTime.setMaximum(15000);
        this.spnWaitTime.setIncrement(50);
        Label label5 = new Label(composite2, 16384);
        label5.setText("in ms");
        Label label6 = new Label(composite2, 16384);
        label6.setText("View to use for playback");
        this.cmbDisplayViews = new Combo(composite2, 131080);
        List<String> list = ImageExplorerView.getRegisteredViews();
        for (String string2 : list) {
            this.cmbDisplayViews.add(string2);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.cmbDisplayViews.setLayoutData((Object)gridData);
        string2 = new Label(composite2, 16384);
        string2.setText("Playback every");
        this.spnSkipImages = new Spinner(composite2, 131072);
        this.spnSkipImages.setMinimum(1);
        this.spnSkipImages.setMaximum(100);
        this.spnSkipImages.setIncrement(1);
        Label label7 = new Label(composite2, 16384);
        label7.setText("image");
        this.initializePage();
        composite.layout();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
    }

    private void initializePage() {
        this.cmbColourMap.select(this.getColourMapChoicePreference());
        this.spnAutoLoThreshold.setSelection(this.getAutoContrastLoPreference());
        this.spnAutoHiThreshold.setSelection(this.getAutoContrastHiPreference());
        this.spnWaitTime.setSelection(this.getTimeDelayPreference());
        this.spnSkipImages.setSelection(this.getPlaybackRatePreference());
        String string = this.getPlaybackViewPreference();
        int n = 0;
        while (n < this.cmbDisplayViews.getItems().length) {
            if (this.cmbDisplayViews.getItems()[n].equals(string)) {
                this.cmbDisplayViews.select(n);
            }
            ++n;
        }
    }

    private void storePreferences() {
        this.setColourMapChoicePreference(this.cmbColourMap.getSelectionIndex());
        this.setAutoContrastLoPreference(this.spnAutoLoThreshold.getSelection());
        this.setAutoContrastHiPreference(this.spnAutoHiThreshold.getSelection());
        this.setTimeDelayPreference(this.spnWaitTime.getSelection());
        this.setPlaybackViewPreference(this.cmbDisplayViews.getItem(this.cmbDisplayViews.getSelectionIndex()));
        this.setPlaybackRatePreference(this.spnSkipImages.getSelection());
    }

    private void loadDefaultPreferences() {
        this.cmbColourMap.select(this.getDefaultColourMapChoicePreference());
        this.spnAutoLoThreshold.setSelection(this.getDefaultAutoContrastLoPreference());
        this.spnAutoHiThreshold.setSelection(this.getDefaultAutoContrastHiPreference());
        this.spnWaitTime.setSelection(this.getDefaultTimeDelayPreference());
        this.spnSkipImages.setSelection(this.getDefaultPlaybackRatePreference());
        String string = this.getDefaultPlaybackViewPreference();
        int n = 0;
        while (n < this.cmbDisplayViews.getItems().length) {
            if (this.cmbDisplayViews.getItems()[n].equals(string)) {
                this.cmbDisplayViews.select(n);
            }
            ++n;
        }
    }

    private int getDefaultColourMapChoicePreference() {
        return this.getPreferenceStore().getDefaultInt("imageExplorer.colourMap");
    }

    private int getDefaultAutoContrastLoPreference() {
        return this.getPreferenceStore().getDefaultInt("imageExplorer.autoContrastLoThreshold");
    }

    private int getDefaultAutoContrastHiPreference() {
        return this.getPreferenceStore().getDefaultInt("imageExplorer.autoContrastHiThreshold");
    }

    private int getDefaultTimeDelayPreference() {
        return this.getPreferenceStore().getDefaultInt("imageExplorer.timeDelay");
    }

    private String getDefaultPlaybackViewPreference() {
        return this.getPreferenceStore().getDefaultString("imageExplorer.playbackView");
    }

    private int getDefaultPlaybackRatePreference() {
        return this.getPreferenceStore().getDefaultInt("imageExplorer.playbackRate");
    }

    private int getColourMapChoicePreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.colourMap")) {
            return this.getPreferenceStore().getDefaultInt("imageExplorer.colourMap");
        }
        return this.getPreferenceStore().getInt("imageExplorer.colourMap");
    }

    private int getAutoContrastLoPreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.autoContrastLoThreshold")) {
            return this.getPreferenceStore().getDefaultInt("imageExplorer.autoContrastLoThreshold");
        }
        return this.getPreferenceStore().getInt("imageExplorer.autoContrastLoThreshold");
    }

    private int getAutoContrastHiPreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.autoContrastHiThreshold")) {
            return this.getPreferenceStore().getDefaultInt("imageExplorer.autoContrastHiThreshold");
        }
        return this.getPreferenceStore().getInt("imageExplorer.autoContrastHiThreshold");
    }

    private int getTimeDelayPreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.timeDelay")) {
            return this.getPreferenceStore().getDefaultInt("imageExplorer.timeDelay");
        }
        return this.getPreferenceStore().getInt("imageExplorer.timeDelay");
    }

    private int getPlaybackRatePreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.playbackRate")) {
            return this.getPreferenceStore().getDefaultInt("imageExplorer.playbackRate");
        }
        return this.getPreferenceStore().getInt("imageExplorer.playbackRate");
    }

    private String getPlaybackViewPreference() {
        if (this.getPreferenceStore().isDefault("imageExplorer.playbackView")) {
            return this.getPreferenceStore().getDefaultString("imageExplorer.playbackView");
        }
        return this.getPreferenceStore().getString("imageExplorer.playbackView");
    }

    private void setColourMapChoicePreference(int n) {
        this.getPreferenceStore().setValue("imageExplorer.colourMap", n);
    }

    private void setAutoContrastLoPreference(int n) {
        this.getPreferenceStore().setValue("imageExplorer.autoContrastLoThreshold", n);
    }

    private void setAutoContrastHiPreference(int n) {
        this.getPreferenceStore().setValue("imageExplorer.autoContrastHiThreshold", n);
    }

    private void setTimeDelayPreference(int n) {
        this.getPreferenceStore().setValue("imageExplorer.timeDelay", n);
    }

    private void setPlaybackViewPreference(String string) {
        this.getPreferenceStore().setValue("imageExplorer.playbackView", string);
    }

    private void setPlaybackRatePreference(int n) {
        this.getPreferenceStore().setValue("imageExplorer.playbackRate", n);
    }
}

