/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;

public class GridScanPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text pixelResx;
    private Text pixelResy;
    private FloatSpinner xBeamCentre;
    private FloatSpinner yBeamCentre;

    public GridScanPreferencePage() {
    }

    public GridScanPreferencePage(String string) {
        super(string);
    }

    public GridScanPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Image Resolution Calibration");
        group.setLayout((Layout)new GridLayout(3, false));
        GridData gridData2 = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData2);
        Label label = new Label((Composite)group, 16384);
        label.setText("X Axis: 1mm maps to ");
        this.pixelResx = new Text((Composite)group, 133124);
        this.pixelResx.setToolTipText("Set number of pixels on x axis used to display 1mm for plot view image");
        GridData gridData3 = new GridData();
        gridData3.widthHint = 50;
        this.pixelResx.setLayoutData((Object)gridData3);
        Label label2 = new Label((Composite)group, 16384);
        label2.setText("pixels.");
        Label label3 = new Label((Composite)group, 16384);
        label3.setText("Y Axis: 1mm maps to ");
        this.pixelResy = new Text((Composite)group, 133124);
        this.pixelResy.setToolTipText("Set number of pixels on y axis used to display 1mm for plot view image");
        this.pixelResy.setLayoutData((Object)gridData3);
        Label label4 = new Label((Composite)group, 16384);
        label4.setText("pixels.");
        this.pixelResx.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GridScanPreferencePage.this.validatePage();
            }
        });
        this.pixelResy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GridScanPreferencePage.this.validatePage();
            }
        });
        Group group2 = new Group(composite2, 0);
        group2.setText("Beam Centre Settings");
        group2.setLayout((Layout)new GridLayout(3, false));
        GridData gridData4 = new GridData(4, 4, true, true);
        group2.setLayoutData((Object)gridData4);
        Label label5 = new Label((Composite)group2, 16384);
        label5.setText("Beam centre x axis position: ");
        this.xBeamCentre = new FloatSpinner((Composite)group2, 133124, 6, 0);
        this.xBeamCentre.setMinimum(0.0);
        Label label6 = new Label((Composite)group2, 16384);
        label6.setText("pixels.");
        Label label7 = new Label((Composite)group2, 16384);
        label7.setText("Beam centre y axis position: ");
        this.yBeamCentre = new FloatSpinner((Composite)group2, 133124, 6, 0);
        this.yBeamCentre.setMinimum(0.0);
        Label label8 = new Label((Composite)group2, 16384);
        label8.setText("pixels.");
        this.xBeamCentre.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GridScanPreferencePage.this.validatePage();
            }
        });
        this.yBeamCentre.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GridScanPreferencePage.this.validatePage();
            }
        });
        this.initializePage();
        return composite2;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    private void loadDefaultPreferences() {
        String string = Double.toString(this.getDefaultXResolutionPreference());
        this.pixelResx.setText(string);
        string = Double.toString(this.getDefaultYResolutionPreference());
        this.pixelResy.setText(string);
        this.xBeamCentre.setDouble(this.getDefaultXBeamCentrePreference());
        this.yBeamCentre.setDouble(this.getDefaultYBeamCentrePreference());
    }

    private void initializePage() {
        String string = Double.toString(this.getXResPreference());
        this.pixelResx.setText(string);
        String string2 = Double.toString(this.getYResPreference());
        this.pixelResy.setText(string2);
        this.xBeamCentre.setDouble(this.getXBeamCentrePreference());
        this.yBeamCentre.setDouble(this.getYBeamCentrePreference());
    }

    private void storePreferences() {
        String string = this.pixelResx.getText().trim();
        String string2 = this.pixelResy.getText().trim();
        try {
            this.setXResPreference(Double.parseDouble(string));
            this.setYResPreference(Double.parseDouble(string2));
        }
        catch (NumberFormatException numberFormatException) {}
        this.setXBeamCentrePreference(this.xBeamCentre.getDouble());
        this.setYBeamCentrePreference(this.yBeamCentre.getDouble());
    }

    public void validatePage() {
        boolean bl = true;
        this.setErrorMessage(null);
        String string = this.pixelResx.getText().trim();
        String string2 = this.pixelResy.getText().trim();
        try {
            Double.parseDouble(string);
            Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Please enter a valid value " + numberFormatException.getMessage());
            bl = false;
        }
        this.setValid(bl);
    }

    public void setXResPreference(double d) {
        this.getPreferenceStore().setValue("gridscan.res.x", d);
    }

    public void setYResPreference(double d) {
        this.getPreferenceStore().setValue("gridscan.res.y", d);
    }

    public void setXBeamCentrePreference(double d) {
        this.getPreferenceStore().setValue("gridscan.beamline.posx", d);
    }

    public void setYBeamCentrePreference(double d) {
        this.getPreferenceStore().setValue("gridscan.beamline.posy", d);
    }

    public double getXResPreference() {
        if (this.getPreferenceStore().isDefault("gridscan.res.x")) {
            return this.getPreferenceStore().getDefaultDouble("gridscan.res.x");
        }
        return this.getPreferenceStore().getDouble("gridscan.res.x");
    }

    public double getYResPreference() {
        if (this.getPreferenceStore().isDefault("gridscan.res.y")) {
            return this.getPreferenceStore().getDefaultDouble("gridscan.res.y");
        }
        return this.getPreferenceStore().getDouble("gridscan.res.y");
    }

    public double getXBeamCentrePreference() {
        if (this.getPreferenceStore().isDefault("gridscan.beamline.posx")) {
            return this.getPreferenceStore().getDefaultDouble("gridscan.beamline.posx");
        }
        return this.getPreferenceStore().getDouble("gridscan.beamline.posx");
    }

    public double getYBeamCentrePreference() {
        if (this.getPreferenceStore().isDefault("gridscan.beamline.posy")) {
            return this.getPreferenceStore().getDefaultDouble("gridscan.beamline.posy");
        }
        return this.getPreferenceStore().getDouble("gridscan.beamline.posy");
    }

    public double getDefaultXResolutionPreference() {
        return this.getPreferenceStore().getDefaultDouble("gridscan.res.x");
    }

    public double getDefaultYResolutionPreference() {
        return this.getPreferenceStore().getDefaultDouble("gridscan.res.y");
    }

    public double getDefaultXBeamCentrePreference() {
        return this.getPreferenceStore().getDefaultDouble("gridscan.beamline.posx");
    }

    public double getDefaultYBeamCentrePreference() {
        return this.getPreferenceStore().getDefaultDouble("gridscan.beamline.posy");
    }
}

