/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;

public class Fitting1DPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String STRING_DELIMITER = "]}\u00ac\u00ac{[";
    private Combo algType;
    private FloatSpinner accuracy;
    private Spinner smoothing;
    private Button autoSmooth;
    private Button autoStopping;
    private Spinner threshold;
    private Combo thresholdingMeasure;
    private Combo peakType;
    private Spinner numPeaks;
    private Spinner decimalPlaces;

    public Fitting1DPreferencePage() {
    }

    public Fitting1DPreferencePage(String string) {
        super(string);
    }

    public Fitting1DPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(16384, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Peak Controls");
        Label label = new Label((Composite)group, 0);
        label.setText("Peak type");
        label.setToolTipText("Choose the probability density function to be fitted");
        this.peakType = new Combo((Composite)group, 8);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Number of peaks to be fitted");
        this.numPeaks = new Spinner((Composite)group, 0);
        this.numPeaks.setDigits(0);
        this.numPeaks.setMinimum(-1);
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData((Object)new GridData(16384, 128, true, false));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setText("Algorithm Controls");
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("Fitting algorithm");
        this.algType = new Combo((Composite)group2, 8);
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Accuracy");
        label4.setToolTipText("This sets the accuracy of the optomisation. The lower the number to more accurate the calculation");
        this.accuracy = new FloatSpinner((Composite)group2, 0, 6, 5);
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Smoothing");
        label5.setToolTipText("Smoothing over that many data points will be applied by the peak searching algorithm");
        this.smoothing = new Spinner((Composite)group2, 0);
        this.smoothing.setDigits(0);
        this.smoothing.setMinimum(0);
        this.smoothing.setMaximum(10000);
        this.smoothing.setEnabled(false);
        Label label6 = new Label((Composite)group2, 0);
        label6.setText("Auto Smooth");
        label6.setToolTipText("Sets the smoothing to 1% of the data size (not recommened)");
        this.autoSmooth = new Button((Composite)group2, 32);
        this.autoSmooth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Fitting1DPreferencePage.this.smoothing.setEnabled(!Fitting1DPreferencePage.this.autoSmooth.getSelection());
            }
        });
        Group group3 = new Group(composite2, 0);
        group3.setLayoutData((Object)new GridData(16384, 128, true, false));
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setText("Stopping Criteria");
        Label label7 = new Label((Composite)group3, 0);
        label7.setText("Auto Stopping");
        label7.setToolTipText("Stops the fitting routine at a given criterium");
        this.autoStopping = new Button((Composite)group3, 32);
        this.autoStopping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Fitting1DPreferencePage.this.controlAutoStoppingGUI();
            }
        });
        Label label8 = new Label((Composite)group3, 0);
        label8.setText("Stopping Threshold");
        label8.setToolTipText("Stops the fitting routine when the next peak is less than the indicated proportion in size of the largest peak.");
        this.threshold = new Spinner((Composite)group3, 0);
        this.threshold.setDigits(2);
        this.threshold.setMinimum(1);
        this.threshold.setMaximum(99);
        this.threshold.setEnabled(false);
        this.threshold.setToolTipText("Stops the fitting routine when the next peak is less than the indicated porportion in size of the largest peak.");
        Label label9 = new Label((Composite)group3, 0);
        label9.setText("Thresholding Measure");
        this.thresholdingMeasure = new Combo((Composite)group3, 8);
        Group group4 = new Group(composite2, 0);
        group4.setLayoutData((Object)new GridData(16384, 128, true, false));
        group4.setLayout((Layout)new GridLayout(2, false));
        group4.setText("Significant Figures");
        group4.setToolTipText("Set the number of significant figures in the table of fitted peaks");
        Label label10 = new Label((Composite)group4, 0);
        label10.setText("Decimal Places");
        this.decimalPlaces = new Spinner((Composite)group4, 0);
        this.decimalPlaces.setValues(2, 0, 10, 0, 1, 1);
        this.initializePage();
        return composite2;
    }

    private void initializePage() {
        this.populateAlgList();
        this.populateThresholdingMeasureList();
        this.populatePeakNameList();
        this.accuracy.setDouble(this.getAccuracy());
        this.numPeaks.setSelection(this.getNumPeaks());
        this.smoothing.setSelection(this.getSmoothing());
        this.autoSmooth.setSelection(this.getDefaultAutoSmoothing());
        this.autoStopping.setSelection(this.getAutoFitting());
        this.threshold.setSelection(this.getThreshold());
        this.decimalPlaces.setSelection(this.getDecimalPlaces());
        this.controlAutoStoppingGUI();
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    protected void performDefaults() {
        this.numPeaks.setSelection(this.getDefaultPeakNum());
        this.peakType.select(this.getDefaultPeak());
        this.accuracy.setDouble(this.getDefaultAccuracy());
        this.smoothing.setSelection(this.getDefaultSmoothing());
        this.autoSmooth.setSelection(this.getDefaultAutoSmoothing());
        this.autoStopping.setSelection(this.getDefaultAutoStopping());
        this.threshold.setSelection(this.getDefaultThreshold());
        this.algType.select(this.getDetaultAlg());
        this.thresholdingMeasure.select(this.getDefaultMeasure());
        this.decimalPlaces.setSelection(this.getDefaultDecimalPlaces());
        this.controlAutoStoppingGUI();
    }

    private void storePreferences() {
        this.setNumPeaks(this.numPeaks.getSelection());
        this.setPeakName(this.peakType.getText());
        this.setAccuracy(this.accuracy.getDouble());
        this.setSmoothing(this.smoothing.getSelection());
        this.setAlgType(this.algType.getText());
        this.setAutoFitting(this.autoStopping.getSelection());
        this.setThreshold(this.threshold.getSelection());
        this.setThresholdingMeasure(this.thresholdingMeasure.getText());
        this.setDecimalPlaces(this.decimalPlaces.getSelection());
    }

    private boolean getDefaultAutoStopping() {
        return this.getPreferenceStore().getDefaultBoolean("fitting.alg.autostopping");
    }

    private int getDefaultThreshold() {
        return this.getPreferenceStore().getDefaultInt("fitting.alg.stopping.threshold");
    }

    private boolean getDefaultAutoSmoothing() {
        return this.getPreferenceStore().getDefaultBoolean("fitting.alg.autosmoothing");
    }

    private int getDefaultSmoothing() {
        return this.getPreferenceStore().getDefaultInt("fitting1d.alg.smoothing");
    }

    private double getDefaultAccuracy() {
        return this.getPreferenceStore().getDefaultDouble("fitting1d.alg.accuracy");
    }

    private int getDefaultPeakNum() {
        return this.getPreferenceStore().getDefaultInt("fitting1d.peak.num");
    }

    private int getDetaultAlg() {
        String string = this.getPreferenceStore().getDefaultString("fitting1d.alg.type");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAlgorithmTypeList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void populateAlgList() {
        String string = this.getAlgType();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAlgorithmTypeList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.algType.add(string2);
            if (string2.equalsIgnoreCase(string)) {
                this.algType.select(n);
            }
            ++n;
        }
    }

    private int getDefaultMeasure() {
        String string = this.getPreferenceStore().getDefaultString("fitting.alg.threshold.measure");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getThresholdingMeasureList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void populateThresholdingMeasureList() {
        String string = this.getThresholdingMeasure();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getThresholdingMeasureList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.thresholdingMeasure.add(string2);
            if (string2.equalsIgnoreCase(string)) {
                this.thresholdingMeasure.select(n);
            }
            ++n;
        }
    }

    private int getDefaultPeak() {
        String string = this.getPreferenceStore().getDefaultString("fitting1d.peak.type");
        StringTokenizer stringTokenizer = new StringTokenizer(this.getThresholdingMeasureList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private void populatePeakNameList() {
        String string = this.getPeakName();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getPeakNameList(), "]}\u00ac\u00ac{[");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.peakType.add(string2);
            if (string2.equalsIgnoreCase(string)) {
                this.peakType.select(n);
            }
            ++n;
        }
    }

    protected void controlAutoStoppingGUI() {
        this.thresholdingMeasure.setEnabled(this.autoStopping.getSelection());
        this.threshold.setEnabled(this.autoStopping.getSelection());
        this.numPeaks.setEnabled(!this.autoStopping.getSelection());
    }

    private String getPeakName() {
        if (this.getPreferenceStore().isDefault("fitting1d.peak.type")) {
            return this.getPreferenceStore().getDefaultString("fitting1d.peak.type");
        }
        return this.getPreferenceStore().getString("fitting1d.peak.type");
    }

    private void setPeakName(String string) {
        this.getPreferenceStore().setValue("fitting1d.peak.type", string);
    }

    public String getAlgType() {
        if (this.getPreferenceStore().isDefault("fitting1d.alg.type")) {
            return this.getPreferenceStore().getDefaultString("fitting1d.alg.type");
        }
        return this.getPreferenceStore().getString("fitting1d.alg.type");
    }

    public void setAlgType(String string) {
        this.getPreferenceStore().setValue("fitting1d.alg.type", string);
    }

    public int getSmoothing() {
        if (this.getPreferenceStore().isDefault("fitting1d.alg.smoothing")) {
            return this.getPreferenceStore().getDefaultInt("fitting1d.alg.smoothing");
        }
        return this.getPreferenceStore().getInt("fitting1d.alg.smoothing");
    }

    public void setSmoothing(int n) {
        this.getPreferenceStore().setDefault("fitting1d.alg.smoothing", n);
    }

    public double getAccuracy() {
        if (this.getPreferenceStore().isDefault("fitting1d.alg.accuracy")) {
            return this.getPreferenceStore().getDefaultDouble("fitting1d.alg.accuracy");
        }
        return this.getPreferenceStore().getDouble("fitting1d.alg.accuracy");
    }

    public void setAccuracy(double d) {
        this.getPreferenceStore().setValue("fitting1d.alg.accuracy", d);
    }

    public boolean getAutoFitting() {
        if (this.getPreferenceStore().isDefault("fitting.alg.autostopping")) {
            return this.getPreferenceStore().getDefaultBoolean("fitting.alg.autostopping");
        }
        return this.getPreferenceStore().getBoolean("fitting.alg.autostopping");
    }

    public void setAutoFitting(boolean bl) {
        this.getPreferenceStore().setValue("fitting.alg.autostopping", bl);
    }

    private int getThreshold() {
        if (this.getPreferenceStore().isDefault("fitting.alg.stopping.threshold")) {
            return this.getPreferenceStore().getDefaultInt("fitting.alg.stopping.threshold");
        }
        return this.getPreferenceStore().getInt("fitting.alg.stopping.threshold");
    }

    private void setThreshold(int n) {
        this.getPreferenceStore().setValue("fitting.alg.stopping.threshold", n);
    }

    private String getThresholdingMeasure() {
        if (this.getPreferenceStore().isDefault("fitting.alg.threshold.measure")) {
            return this.getPreferenceStore().getDefaultString("fitting.alg.threshold.measure");
        }
        return this.getPreferenceStore().getString("fitting.alg.threshold.measure");
    }

    private void setThresholdingMeasure(String string) {
        this.getPreferenceStore().setValue("fitting.alg.threshold.measure", string);
    }

    private int getNumPeaks() {
        if (this.getPreferenceStore().isDefault("fitting1d.peak.num")) {
            return this.getPreferenceStore().getDefaultInt("fitting1d.peak.num");
        }
        return this.getPreferenceStore().getInt("fitting1d.peak.num");
    }

    private void setNumPeaks(int n) {
        this.getPreferenceStore().setValue("fitting1d.peak.num", n);
    }

    private String getThresholdingMeasureList() {
        if (this.getPreferenceStore().isDefault("fitting.alg.threshold.measure.list")) {
            return this.getPreferenceStore().getDefaultString("fitting.alg.threshold.measure.list");
        }
        return this.getPreferenceStore().getString("fitting.alg.threshold.measure.list");
    }

    public String getAlgorithmTypeList() {
        if (this.getPreferenceStore().isDefault("fitting1d.alg.list")) {
            return this.getPreferenceStore().getDefaultString("fitting1d.alg.list");
        }
        return this.getPreferenceStore().getString("fitting1d.alg.list");
    }

    private String getPeakNameList() {
        if (this.getPreferenceStore().isDefault("fitting1d.peak.list")) {
            return this.getPreferenceStore().getDefaultString("fitting1d.peak.list");
        }
        return this.getPreferenceStore().getString("fitting1d.peak.list");
    }

    private int getDecimalPlaces() {
        if (this.getPreferenceStore().isDefault("fitting1d.peak.dp")) {
            return this.getPreferenceStore().getDefaultInt("fitting1d.peak.dp");
        }
        return this.getPreferenceStore().getInt("fitting1d.peak.dp");
    }

    private int getDefaultDecimalPlaces() {
        return this.getPreferenceStore().getDefaultInt("fitting1d.peak.dp");
    }

    private void setDecimalPlaces(int n) {
        this.getPreferenceStore().setValue("fitting1d.peak.dp", n);
    }
}

