/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;

public class DiffractionViewerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String STRING_DELIMITER = "]}\u00ac\u00ac{[";
    private Combo pullDownPeaks;
    private Spinner maxNumPeaks;
    private Spinner spnPixeloverloadThreshold;
    private List standardType;
    private Button add;
    private StringFieldEditor sfeNewCal;
    private StringFieldEditor sfeNewCalDSpacing;
    private Button remove;
    private ArrayList<String> standardNames;
    private ArrayList<String> standardDistances;
    private Button autoStopping;
    private Spinner stoppingThreshold;
    private static String[] peaknames = new String[]{"Gaussian", "Lorentzian", "Pearson VII", "PseudoVoigt"};

    public DiffractionViewerPreferencePage() {
    }

    public DiffractionViewerPreferencePage(String string) {
        super(string);
    }

    public DiffractionViewerPreferencePage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite composite) {
        TabFolder tabFolder = new TabFolder(composite, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Peak Fitting");
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Peak distribution Selection");
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gridData2 = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData2);
        Label label = new Label((Composite)group, 0);
        label.setText("Peak Type");
        this.pullDownPeaks = new Combo((Composite)group, 8);
        int n = 0;
        while (n < peaknames.length) {
            this.pullDownPeaks.add(peaknames[n]);
            ++n;
        }
        Group group2 = new Group(composite2, 0);
        group2.setText("Maximum number of peaks fitted");
        group2.setLayout((Layout)new GridLayout(4, false));
        GridData gridData3 = new GridData(4, 4, true, false);
        group2.setLayoutData((Object)gridData3);
        Label label2 = new Label((Composite)group2, 0);
        label2.setText("Auto Stopping");
        label2.setToolTipText("Stops the fitting once all the peaks above a threshold are found.");
        this.autoStopping = new Button((Composite)group2, 32);
        this.autoStopping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerPreferencePage.this.setAutoStopping(DiffractionViewerPreferencePage.this.autoStopping.getSelection());
                DiffractionViewerPreferencePage.this.controlAutoStoppingGUI();
            }
        });
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("Number of peaks ");
        this.maxNumPeaks = new Spinner((Composite)group2, 0);
        this.maxNumPeaks.setDigits(0);
        this.maxNumPeaks.setMaximum(100);
        this.maxNumPeaks.setMinimum(0);
        this.maxNumPeaks.setIncrement(1);
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Stopping threshold");
        label4.setToolTipText("Sets the stopping threshold for the fitting algorithm");
        this.stoppingThreshold = new Spinner((Composite)group2, 0);
        this.stoppingThreshold.setDigits(2);
        this.stoppingThreshold.setMinimum(1);
        this.stoppingThreshold.setMaximum(99);
        this.stoppingThreshold.setIncrement(1);
        tabItem.setControl((Control)composite2);
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText("Calibration");
        Composite composite3 = new Composite((Composite)tabFolder, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        GridData gridData4 = new GridData(4, 4, true, true);
        composite3.setLayoutData((Object)gridData4);
        Group group3 = new Group(composite3, 0);
        group3.setText("Detector Calibration Samples:");
        GridData gridData5 = new GridData(4, 4, true, true);
        group3.setLayoutData((Object)gridData5);
        GridData gridData6 = new GridData(1808);
        this.standardType = new List((Composite)group3, 2048);
        this.standardType.setLayoutData((Object)gridData6);
        this.standardType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerPreferencePage.this.sfeNewCal.setStringValue((String)DiffractionViewerPreferencePage.this.standardNames.get(DiffractionViewerPreferencePage.this.standardType.getSelectionIndex()));
                DiffractionViewerPreferencePage.this.sfeNewCalDSpacing.setStringValue((String)DiffractionViewerPreferencePage.this.standardDistances.get(DiffractionViewerPreferencePage.this.standardType.getSelectionIndex()));
            }
        });
        Group group4 = new Group(composite3, 0);
        group4.setText("Add New Calibrant");
        group3.setLayout((Layout)new GridLayout(2, false));
        GridData gridData7 = new GridData(4, 4, true, false);
        group4.setLayoutData((Object)gridData7);
        this.sfeNewCal = new StringFieldEditor("diffviewer.standardName", "Calibrant Name: ", (Composite)group4);
        this.sfeNewCalDSpacing = new StringFieldEditor("diffviewer.standardDistances", "Calibrant d spacing", (Composite)group4);
        this.sfeNewCalDSpacing.setStringValue("Separated my comas");
        this.add = new Button((Composite)group4, 0);
        this.add.setText("Add");
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerPreferencePage.this.validateStandard();
            }
        });
        this.remove = new Button((Composite)group4, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerPreferencePage.this.standardDistances.remove(DiffractionViewerPreferencePage.this.standardType.getSelectionIndex());
                DiffractionViewerPreferencePage.this.standardNames.remove(DiffractionViewerPreferencePage.this.standardType.getSelectionIndex());
                DiffractionViewerPreferencePage.this.updateGUIList();
            }
        });
        tabItem2.setControl((Control)composite3);
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText("Other");
        Composite composite4 = new Composite((Composite)tabFolder, 0);
        composite4.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(4, 4, true, true);
        composite4.setLayoutData((Object)gridData);
        tabItem3.setControl((Control)composite4);
        Group group5 = new Group(composite4, 0);
        group5.setText("Detector pixel overload");
        group5.setLayout((Layout)new GridLayout(2, false));
        gridData3 = new GridData(4, 4, true, false);
        group5.setLayoutData((Object)gridData3);
        Label label5 = new Label((Composite)group5, 0);
        label5.setText("Threshold value ");
        this.spnPixeloverloadThreshold = new Spinner((Composite)group5, 0);
        this.spnPixeloverloadThreshold.setDigits(0);
        this.spnPixeloverloadThreshold.setMaximum(100000);
        this.spnPixeloverloadThreshold.setMinimum(0);
        this.spnPixeloverloadThreshold.setIncrement(1);
        this.initializePage();
        return tabFolder;
    }

    private void populateLists(boolean bl) {
        StringTokenizer stringTokenizer;
        StringTokenizer stringTokenizer2;
        if (bl) {
            stringTokenizer2 = new StringTokenizer(this.getDefaultStandardList(), STRING_DELIMITER);
            stringTokenizer = new StringTokenizer(this.getDefaultStandardDistanceList(), STRING_DELIMITER);
        } else {
            stringTokenizer2 = new StringTokenizer(this.getStandardList(), STRING_DELIMITER);
            stringTokenizer = new StringTokenizer(this.getStandardDistanceList(), STRING_DELIMITER);
        }
        this.standardNames = new ArrayList();
        this.standardDistances = new ArrayList();
        int n = 0;
        int n2 = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            String string = stringTokenizer2.nextToken();
            this.standardNames.add(string);
            ++n;
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.standardDistances.add(stringTokenizer.nextToken());
            ++n2;
        }
        if (n2 != n) {
            System.err.println("There was a difference beteween the number od samples and the cooresponding distances");
        }
        this.updateGUIList();
    }

    private void updateGUIList() {
        this.standardType.removeAll();
        String string = this.getDefaultStandardName();
        int n = 0;
        for (String string2 : this.standardNames) {
            this.standardType.add(string2);
            if (string.compareToIgnoreCase(string2) == 0) {
                this.standardType.select(n);
            }
            ++n;
        }
    }

    private void validateStandard() {
        boolean bl = false;
        if (this.sfeNewCal.getStringValue().isEmpty()) {
            this.sfeNewCal.setStringValue("Enter Standard Name");
        }
        if (this.sfeNewCalDSpacing.getStringValue().equalsIgnoreCase("Separated my comas")) {
            this.sfeNewCalDSpacing.setStringValue("Enter d values");
        }
        if (Pattern.matches("([\\d]*\\.?[\\d]+)(\\s*\\,\\s*[\\d]*\\.?[\\d]+)*", this.sfeNewCalDSpacing.getStringValue()) && this.checkUnique()) {
            bl = true;
        }
        if (!bl) {
            this.sfeNewCalDSpacing.setStringValue("Duplicate or incorrect entery");
        }
        if (bl && !this.sfeNewCal.getStringValue().isEmpty()) {
            this.standardNames.add(this.sfeNewCal.getStringValue());
            this.standardDistances.add(this.sfeNewCalDSpacing.getStringValue());
            this.updateGUIList();
        }
    }

    private boolean checkUnique() {
        for (String string : this.standardNames) {
            if (!string.equalsIgnoreCase(this.sfeNewCal.getStringValue())) continue;
            return false;
        }
        for (String string : this.standardDistances) {
            if (!string.equalsIgnoreCase(this.sfeNewCalDSpacing.getStringValue())) continue;
            return false;
        }
        return true;
    }

    private void initializePage() {
        this.maxNumPeaks.setSelection(this.getMaxNumPeaks());
        this.pullDownPeaks.select(this.getPeakNumber(this.getPeakType()));
        this.spnPixeloverloadThreshold.setSelection(this.getPixelOverloadThreshold());
        this.stoppingThreshold.setSelection(this.getStoppingThreshold());
        this.autoStopping.setSelection(this.getAutoStopping());
        this.controlAutoStoppingGUI();
        this.populateLists(false);
    }

    protected void controlAutoStoppingGUI() {
        this.maxNumPeaks.setEnabled(!this.getAutoStopping());
        this.stoppingThreshold.setEnabled(this.getAutoStopping());
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
    }

    private int getPeakNumber(String string) {
        if (string.compareToIgnoreCase("Gaussian") == 0) {
            return 0;
        }
        if (string.compareToIgnoreCase("Lorentzian") == 0) {
            return 1;
        }
        if (string.compareToIgnoreCase("Pearson VII") == 0) {
            return 2;
        }
        if (string.compareToIgnoreCase("PseudoVoigt") == 0) {
            return 3;
        }
        return 0;
    }

    private void loadDefaultPreferences() {
        this.pullDownPeaks.select(this.getPeakNumber(this.getDefaultPeakType()));
        this.maxNumPeaks.setSelection(this.getDefaultMaxNumPeaks());
        this.stoppingThreshold.setSelection(this.getDefaultStoppingThreshold());
        this.populateLists(true);
    }

    public String getDefaultStandardName() {
        return this.getPreferenceStore().getDefaultString("diffviewer.standardName");
    }

    public String getStandardName() {
        if (this.getPreferenceStore().isDefault("diffviewer.standardName")) {
            return this.getPreferenceStore().getDefaultString("diffviewer.standardName");
        }
        return this.getPreferenceStore().getString("diffviewer.standardName");
    }

    public void setStandardName(String string) {
        this.getPreferenceStore().setValue("diffviewer.standardName", string);
    }

    public String getDefaultStandardDistance() {
        return this.getPreferenceStore().getDefaultString("diffviewer.standardDistances");
    }

    public String getStandardDistance() {
        if (this.getPreferenceStore().isDefault("diffviewer.standardDistances")) {
            return this.getPreferenceStore().getDefaultString("diffviewer.standardDistances");
        }
        return this.getPreferenceStore().getString("diffviewer.standardDistances");
    }

    public void setStandardDistance(String string) {
        this.getPreferenceStore().setValue("diffviewer.standardDistances", string);
    }

    public String getDefaultStandardDistanceList() {
        return this.getPreferenceStore().getDefaultString("diffviewer.standardDistancesList");
    }

    public String getStandardDistanceList() {
        if (this.getPreferenceStore().isDefault("diffviewer.standardDistancesList")) {
            return this.getPreferenceStore().getDefaultString("diffviewer.standardDistancesList");
        }
        return this.getPreferenceStore().getString("diffviewer.standardDistancesList");
    }

    public void setStandardDistanceList(String string) {
        this.getPreferenceStore().setValue("diffviewer.standardDistancesList", string);
    }

    public String getDefaultStandardList() {
        return this.getPreferenceStore().getDefaultString("diffviewer.standardNameList");
    }

    public String getStandardList() {
        if (this.getPreferenceStore().isDefault("diffviewer.standardNameList")) {
            return this.getPreferenceStore().getDefaultString("diffviewer.standardNameList");
        }
        return this.getPreferenceStore().getString("diffviewer.standardNameList");
    }

    public void setStandardList(String string) {
        this.getPreferenceStore().setValue("diffviewer.standardNameList", string);
    }

    public String getDefaultPeakType() {
        return this.getPreferenceStore().getDefaultString("diffviewer.peaktype");
    }

    public String getPeakType() {
        if (this.getPreferenceStore().isDefault("diffviewer.peaktype")) {
            return this.getPreferenceStore().getDefaultString("diffviewer.peaktype");
        }
        return this.getPreferenceStore().getString("diffviewer.peaktype");
    }

    public void setPeakType(String string) {
        this.getPreferenceStore().setValue("diffviewer.peaktype", string);
    }

    public int getDefaultMaxNumPeaks() {
        return this.getPreferenceStore().getDefaultInt("diffviewer.maxNumPeaks");
    }

    public int getMaxNumPeaks() {
        if (this.getPreferenceStore().isDefault("diffviewer.maxNumPeaks")) {
            return this.getPreferenceStore().getDefaultInt("diffviewer.maxNumPeaks");
        }
        return this.getPreferenceStore().getInt("diffviewer.maxNumPeaks");
    }

    public void setMaxNumPeaks(int n) {
        this.getPreferenceStore().setValue("diffviewer.maxNumPeaks", n);
    }

    public boolean getDefaultAutoStopping() {
        return this.getPreferenceStore().getDefaultBoolean("diffviewer.autoStopping");
    }

    public boolean getAutoStopping() {
        if (this.getPreferenceStore().isDefault("diffviewer.autoStopping")) {
            return this.getPreferenceStore().getDefaultBoolean("diffviewer.autoStopping");
        }
        return this.getPreferenceStore().getBoolean("diffviewer.autoStopping");
    }

    public void setAutoStopping(boolean bl) {
        this.getPreferenceStore().setValue("diffviewer.autoStopping", bl);
    }

    public int getDefaultStoppingThreshold() {
        return this.getPreferenceStore().getDefaultInt("diffviewer.stoppingThreshold");
    }

    public int getStoppingThreshold() {
        if (this.getPreferenceStore().isDefault("diffviewer.stoppingThreshold")) {
            return this.getPreferenceStore().getDefaultInt("diffviewer.stoppingThreshold");
        }
        return this.getPreferenceStore().getInt("diffviewer.stoppingThreshold");
    }

    public void setStoppingThreshold(int n) {
        this.getPreferenceStore().setValue("diffviewer.stoppingThreshold", n);
    }

    public int getDefaultPixelOverloadThreshold() {
        return this.getPreferenceStore().getDefaultInt("diffviewer.pixelOverLoadThreshold");
    }

    public int getPixelOverloadThreshold() {
        if (this.getPreferenceStore().isDefault("diffviewer.pixelOverLoadThreshold")) {
            return this.getPreferenceStore().getDefaultInt("diffviewer.pixelOverLoadThreshold");
        }
        return this.getPreferenceStore().getInt("diffviewer.pixelOverLoadThreshold");
    }

    public void setPixelOverloadThreshold(int n) {
        this.getPreferenceStore().setValue("diffviewer.pixelOverLoadThreshold", n);
    }

    public boolean performOk() {
        this.storePreferences();
        return true;
    }

    private void storePreferences() {
        this.setMaxNumPeaks(this.maxNumPeaks.getSelection());
        this.setPeakType(peaknames[this.pullDownPeaks.getSelectionIndex()]);
        this.setPixelOverloadThreshold(this.spnPixeloverloadThreshold.getSelection());
        this.setAutoStopping(this.autoStopping.getSelection());
        this.setStoppingThreshold(this.stoppingThreshold.getSelection());
        this.storeLists();
        this.storeSelectedStandard();
    }

    private void storeSelectedStandard() {
        this.setStandardName(this.standardNames.get(this.standardType.getSelectionIndex()));
        this.setStandardDistance(this.standardDistances.get(this.standardType.getSelectionIndex()));
    }

    private void storeLists() {
        String string = "";
        String string2 = "";
        for (String string3 : this.standardNames) {
            string = String.valueOf(string) + string3 + STRING_DELIMITER;
        }
        for (String string3 : this.standardDistances) {
            string2 = String.valueOf(string2) + string3 + STRING_DELIMITER;
        }
        this.setStandardList(string);
        this.setStandardDistanceList(string2);
    }
}

