/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.preference;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import uk.ac.diamond.scisoft.analysis.AnalysisRpcServerProvider;
import uk.ac.diamond.scisoft.analysis.RMIServerProvider;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.gda.ui.preferences.LabelFieldEditor;

public class AnalysisRpcAndRmiPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(AnalysisRCPActivator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new LabelFieldEditor("Analysis RPC Temporary File Location (blank for default of system temp directory)", this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor("analysisrpc.tempfile", "Directory:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor("analysisrpc.server.port", "Analysis RPC Port: (0 for auto, requires restart)", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor("rmi.server.port", "RMI Port: (0 for auto, requires restart)", this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor("The currently in use ports are:\n- Analysis RPC: " + AnalysisRpcServerProvider.getInstance().getPort() + "\n" + "- RMI: " + RMIServerProvider.getInstance().getPort() + "\n" + "\n" + "SDA automatically passes the parameters on this page using environment variables \n" + "which are set up in the PyDev Interpreter Info preference pages. \n" + "These are automatically used by scisoftpy. The environment variables are: \n" + "Analysis RPC Port: SCISOFT_RPC_PORT\n" + "RMI Port: SCISOFT_RMI_PORT\n" + "Temporary File Location: SCISOFT_RPC_TEMP\n", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("analysisrpcrmi.injectvariables", "Add above variables automatically to PyDev's Interpretters", this.getFieldEditorParent()));
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        if (bl) {
            boolean bl2;
            int n = RMIServerProvider.getInstance().getPort();
            int n2 = AnalysisRpcServerProvider.getInstance().getPort();
            int n3 = AnalysisRpcAndRmiPreferencePage.getAnalysisRpcPort();
            int n4 = AnalysisRpcAndRmiPreferencePage.getRmiPort();
            boolean bl3 = n3 != 0 && n2 != n3;
            boolean bl4 = bl2 = n4 != 0 && n != n4;
            if ((bl3 || bl2) && new MessageDialog(null, "Restart Required", null, "The ports have changed and will not take effect until the workbench is restarted. Restart now?", 3, new String[]{"Yes", "No"}, 1).open() == 0) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return bl;
    }

    public static int getAnalysisRpcPort() {
        return AnalysisRCPActivator.getDefault().getPreferenceStore().getInt("analysisrpc.server.port");
    }

    public static String getAnalysisRpcTempFileLocation() {
        String string = AnalysisRCPActivator.getDefault().getPreferenceStore().getString("analysisrpc.tempfile");
        if (string == null || "".equals(string)) {
            return null;
        }
        return string;
    }

    public static int getRmiPort() {
        return AnalysisRCPActivator.getDefault().getPreferenceStore().getInt("rmi.server.port");
    }

    public static boolean isInjectVariablesAutomaticallyIntoPyDev() {
        return AnalysisRCPActivator.getDefault().getPreferenceStore().getBoolean("analysisrpcrmi.injectvariables");
    }
}

