/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.utils;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.mapfunctions.AbstractMapFunction;

public class SWTImageUtils {
    private static ImageData createImageFromRGBADataset(RGBDataset rGBDataset, long l, long l2) {
        ImageData imageData;
        IndexIterator indexIterator = rGBDataset.getIterator(true);
        int[] nArray = indexIterator.getPos();
        int[] nArray2 = rGBDataset.getShape();
        int n = nArray2[0];
        int n2 = nArray2.length == 1 ? 1 : nArray2[1];
        long l3 = l2 - l;
        short s = (short)l;
        short[] sArray = rGBDataset.getData();
        if (l3 < 32L) {
            imageData = new ImageData(n2, n, 16, new PaletteData(31744, 992, 31));
            while (indexIterator.hasNext()) {
                int n3 = indexIterator.index;
                int n4 = (sArray[n3] - s & 0x1F) << 10 | (sArray[n3 + 1] - s & 0x1F) << 5 | sArray[n3 + 2] - s & 0x1F;
                imageData.setPixel(nArray[1], nArray[0], n4);
            }
        } else if (l3 < 64L) {
            imageData = new ImageData(n2, n, 16, new PaletteData(63488, 2016, 31));
            while (indexIterator.hasNext()) {
                int n5 = indexIterator.index;
                int n6 = (sArray[n5] - s >> 1 & 0x1F) << 10 | (sArray[n5 + 1] - s & 0x3F) << 5 | sArray[n5 + 2] - s >> 1 & 0x1F;
                imageData.setPixel(nArray[1], nArray[0], n6);
            }
        } else if (l3 < 256L) {
            imageData = new ImageData(n2, n, 24, new PaletteData(0xFF0000, 65280, 255));
            while (indexIterator.hasNext()) {
                int n7 = indexIterator.index;
                int n8 = (sArray[n7] - s & 0xFF) << 16 | (sArray[n7 + 1] - s & 0xFF) << 8 | sArray[n7 + 2] - s & 0xFF;
                imageData.setPixel(nArray[1], nArray[0], n8);
            }
        } else {
            int n9 = 0;
            while (l3 >= 256L) {
                ++n9;
                l3 >>= 1;
            }
            imageData = new ImageData(n2, n, 24, new PaletteData(0xFF0000, 65280, 255));
            while (indexIterator.hasNext()) {
                int n10 = indexIterator.index;
                int n11 = (sArray[n10] - s >> n9 & 0xFF) << 16 | (sArray[n10 + 1] - s >> n9 & 0xFF) << 8 | sArray[n10 + 2] - s >> n9 & 0xFF;
                imageData.setPixel(nArray[1], nArray[0], n11);
            }
        }
        return imageData;
    }

    private static ImageData createImageFromDataset(AbstractDataset abstractDataset, double d, double d2, AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, boolean bl, boolean bl2, boolean bl3) {
        int[] nArray = abstractDataset.getShape();
        int n = nArray[0];
        int n2 = nArray.length == 1 ? 1 : nArray[1];
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        ImageData imageData = new ImageData(n2, n, 24, new PaletteData(0xFF0000, 65280, 255));
        double d3 = d2 - d;
        while (indexIterator.hasNext()) {
            double d4 = (abstractDataset.getElementDoubleAbs(indexIterator.index) - d) / d3;
            int n3 = bl ? 255 - abstractMapFunction.mapToByte(d4) : abstractMapFunction.mapToByte(d4);
            int n4 = bl2 ? 255 - abstractMapFunction2.mapToByte(d4) : abstractMapFunction2.mapToByte(d4);
            int n5 = bl3 ? 255 - abstractMapFunction3.mapToByte(d4) : abstractMapFunction3.mapToByte(d4);
            int n6 = n3 << 16 | n4 << 8 | n5;
            imageData.setPixel(nArray2[1], nArray2[0], n6);
        }
        return imageData;
    }

    public static ImageData createImageData(AbstractDataset abstractDataset, Number number, AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, boolean bl, boolean bl2, boolean bl3) {
        return SWTImageUtils.createImageData(abstractDataset, 0, number, abstractMapFunction, abstractMapFunction2, abstractMapFunction3, bl, bl2, bl3);
    }

    public static ImageData createImageData(AbstractDataset abstractDataset, Number number, Number number2, AbstractMapFunction abstractMapFunction, AbstractMapFunction abstractMapFunction2, AbstractMapFunction abstractMapFunction3, boolean bl, boolean bl2, boolean bl3) {
        ImageData imageData = abstractDataset instanceof RGBDataset ? SWTImageUtils.createImageFromRGBADataset((RGBDataset)abstractDataset, number.longValue(), number2.longValue()) : SWTImageUtils.createImageFromDataset(abstractDataset, number.doubleValue(), number2.doubleValue(), abstractMapFunction, abstractMapFunction2, abstractMapFunction3, bl, bl2, bl3);
        return imageData;
    }

    public static RGBDataset createRGBDataset(ImageData imageData) {
        int[] nArray = new int[imageData.width];
        RGBDataset rGBDataset = new RGBDataset(new int[]{imageData.height, imageData.width});
        short[] sArray = new short[3];
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            int n = 0;
            while (n < imageData.height) {
                imageData.getPixels(0, n, imageData.width, nArray, 0);
                int n2 = 0;
                while (n2 < imageData.width) {
                    int n3 = nArray[n2];
                    sArray[0] = paletteData.redShift >= 0 ? (short)((n3 & paletteData.redMask) << paletteData.redShift) : (short)((n3 & paletteData.redMask) >>> -paletteData.redShift);
                    sArray[1] = paletteData.greenShift >= 0 ? (short)((n3 & paletteData.greenMask) << paletteData.greenShift) : (short)((n3 & paletteData.greenMask) >>> -paletteData.greenShift);
                    sArray[2] = paletteData.blueShift >= 0 ? (short)((n3 & paletteData.blueMask) << paletteData.blueShift) : (short)((n3 & paletteData.blueMask) >>> -paletteData.blueShift);
                    rGBDataset.setItem(sArray, new int[]{n, n2++});
                }
                ++n;
            }
        } else {
            RGB[] rGBArray = paletteData.getRGBs();
            int n = 0;
            while (n < imageData.height) {
                imageData.getPixels(0, n, imageData.width, nArray, 0);
                int n4 = 0;
                while (n4 < imageData.width) {
                    RGB rGB = rGBArray[nArray[n4]];
                    sArray[0] = (short)rGB.red;
                    sArray[1] = (short)rGB.green;
                    sArray[2] = (short)rGB.blue;
                    rGBDataset.setItem(sArray, new int[]{n, n4++});
                }
                ++n;
            }
        }
        return rGBDataset;
    }
}

