/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.utils;

import de.jreality.scene.Viewer;
import de.jreality.softviewer.PSRenderer;
import de.jreality.softviewer.SVGRenderer;
import de.jreality.ui.viewerapp.AbstractViewerApp;
import de.jreality.ui.viewerapp.actions.file.ExportImage;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;

public class PlotExportUtil {
    public static final String[] FILE_TYPES = new String[]{"PNG/JPEG File", "Postscript File", "SVG File"};
    private static final Logger logger = LoggerFactory.getLogger(PlotExportUtil.class);
    private static final String tempDirectory = System.getProperty("java.io.tmpdir");

    private static void savePostScript(File file, AbstractViewerApp abstractViewerApp) throws FileNotFoundException {
        Dimension dimension = abstractViewerApp.getCurrentViewer().getViewingComponentSize();
        PSRenderer pSRenderer = new PSRenderer(new PrintWriter(file), dimension.width, dimension.height);
        pSRenderer.setCameraPath(abstractViewerApp.getCurrentViewer().getCameraPath());
        pSRenderer.setSceneRoot(abstractViewerApp.getCurrentViewer().getSceneRoot());
        pSRenderer.setAuxiliaryRoot(abstractViewerApp.getCurrentViewer().getAuxiliaryRoot());
        pSRenderer.render();
    }

    private static void saveSVG(File file, AbstractViewerApp abstractViewerApp) throws FileNotFoundException {
        Dimension dimension = abstractViewerApp.getCurrentViewer().getViewingComponentSize();
        SVGRenderer sVGRenderer = new SVGRenderer(new PrintWriter(file), dimension.width, dimension.height);
        sVGRenderer.setCameraPath(abstractViewerApp.getCurrentViewer().getCameraPath());
        sVGRenderer.setSceneRoot(abstractViewerApp.getCurrentViewer().getSceneRoot());
        sVGRenderer.setAuxiliaryRoot(abstractViewerApp.getCurrentViewer().getAuxiliaryRoot());
        sVGRenderer.render();
    }

    private static void copytoClipboard(AbstractViewerApp abstractViewerApp) {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
        File file = new File(String.valueOf(tempDirectory) + "/" + iWorkbenchPart.getTitle() + ".png");
        ExportImage.exportImage((Viewer)abstractViewerApp.getCurrentViewer(), (File)file, (int)1);
        Display display = Display.getCurrent();
        Clipboard clipboard = new Clipboard(display);
        String[] stringArray = new String[]{file.getAbsolutePath()};
        clipboard.setContents(new Object[]{stringArray}, new Transfer[]{FileTransfer.getInstance()});
        clipboard.dispose();
    }

    public static synchronized void saveGraph(String string, String string2, AbstractViewerApp abstractViewerApp) throws Exception {
        if (!Arrays.asList(FILE_TYPES).contains(string2)) {
            throw new RuntimeException("Cannot deal with file type " + string2);
        }
        String string3 = string.toLowerCase();
        if (string3.endsWith(".png") || string3.endsWith(".jpg") || string3.endsWith(".jpeg")) {
            string2 = FILE_TYPES[0];
        }
        if (string3.endsWith(".ps") || string3.endsWith(".eps")) {
            string2 = FILE_TYPES[1];
        }
        if (string3.endsWith(".svg")) {
            string2 = FILE_TYPES[2];
        }
        if (string2.equals(FILE_TYPES[0])) {
            if (!(string3.endsWith(".png") || string3.endsWith(".jpg") || string3.endsWith(".jpeg"))) {
                string = String.valueOf(string) + ".png";
            }
            ExportImage.exportImage((Viewer)abstractViewerApp.getCurrentViewer(), (File)new File(string), (int)1);
        } else if (string2.equals(FILE_TYPES[1])) {
            if (!string3.endsWith(".ps") && !string3.endsWith(".eps")) {
                string = String.valueOf(string) + ".ps";
            }
            PlotExportUtil.savePostScript(new File(string), abstractViewerApp);
        } else if (string2.equals(FILE_TYPES[2])) {
            if (!string3.endsWith(".svg")) {
                string = String.valueOf(string) + ".svg";
            }
            PlotExportUtil.saveSVG(new File(string), abstractViewerApp);
        } else {
            throw new RuntimeException("Cannot process " + string2);
        }
    }

    public static synchronized void copyGraph(AbstractViewerApp abstractViewerApp) {
        PlotExportUtil.copytoClipboard(abstractViewerApp);
    }

    public static synchronized void printGraph(PrinterData printerData, AbstractViewerApp abstractViewerApp, Display display, Plot1DGraphTable plot1DGraphTable, float f) {
        if (printerData != null) {
            File file = null;
            try {
                file = File.createTempFile("test", ".png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (file != null) {
                GC gC;
                GC gC2;
                ImageData imageData;
                ImageLoader imageLoader;
                int n;
                Printer printer = new Printer(printerData);
                Rectangle rectangle = printer.getClientArea();
                Point point = printer.getDPI();
                int n2 = n = point.x < 100 ? 1 : 4;
                if (n == 1) {
                    logger.info("Printer dpi was lower than 100 ({}) so oversampling not used", (Object)point.x);
                }
                Dimension dimension = abstractViewerApp.getCurrentViewer().getViewingComponentSize();
                float f2 = (float)dimension.width / (float)dimension.height;
                float f3 = (float)rectangle.width / (float)rectangle.height;
                int n3 = 1;
                if (SWT.getPlatform().toLowerCase().equals("gtk")) {
                    n3 = 4;
                }
                if (f2 > f3) {
                    ExportImage.exportImage((Viewer)abstractViewerApp.getCurrentViewer(), (File)file, (int)(rectangle.height * n3), (int)(rectangle.width * n3), (int)n);
                    imageLoader = new ImageLoader();
                    imageData = imageLoader.load(file.getAbsolutePath())[0];
                    gC2 = new Image((Device)display, rectangle.width * n3, rectangle.height * n3);
                    gC = new GC((Drawable)gC2);
                    gC.setAdvanced(true);
                    if (!gC.getAdvanced()) {
                        logger.warn("Warning: no advanced graphics!");
                    }
                    Image image = new Image((Device)display, imageData);
                    Transform transform = new Transform((Device)display);
                    transform.translate((float)(rectangle.width * n3), 0.0f);
                    transform.rotate(90.0f);
                    transform.scale(f, f);
                    gC.setTransform(transform);
                    gC.drawImage(image, 0, 0);
                    transform.dispose();
                    gC.dispose();
                    image.dispose();
                    imageData = gC2.getImageData();
                } else {
                    ExportImage.exportImage((Viewer)abstractViewerApp.getCurrentViewer(), (File)file, (int)rectangle.width, (int)rectangle.height, (int)n);
                    imageLoader = new ImageLoader();
                    imageData = imageLoader.load(file.getAbsolutePath())[0];
                }
                imageLoader = printer.computeTrim(0, 0, 0, 0);
                if (printer.startJob("Graph print")) {
                    gC2 = new GC((Drawable)printer);
                    if (printer.startPage()) {
                        gC = new Image((Device)printer, imageData);
                        int n4 = 0;
                        int n5 = 0;
                        if (plot1DGraphTable != null) {
                            int n6 = 0;
                            while (n6 < plot1DGraphTable.getLegendSize()) {
                                if (plot1DGraphTable.getLegendEntry(n6).isVisible()) {
                                    ++n5;
                                }
                                ++n6;
                            }
                            n4 = 10 + Math.max(1, n5 / 4) * 32;
                        }
                        float f4 = -500.0f * f + 500.0f;
                        if (f2 > f3) {
                            gC2.drawImage((Image)gC, 0, 0, imageData.width, imageData.height, -imageLoader.x + n4, -imageLoader.y, rectangle.width - (imageLoader.x + imageLoader.width), rectangle.height - (imageLoader.y + imageLoader.height));
                            if (plot1DGraphTable != null) {
                                int n7 = 0;
                                int n8 = 0;
                                while (n8 < plot1DGraphTable.getLegendSize()) {
                                    Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n8);
                                    if (plot1DAppearance.isVisible()) {
                                        int n9 = -10 + n4 - n7 / 4 * 25 + (int)f4;
                                        int n10 = -imageLoader.y + 60 + n7 % 4 * 200;
                                        plot1DAppearance.drawApp(n9, n10, gC2, display, f2 > f3);
                                        ++n7;
                                    }
                                    ++n8;
                                }
                            }
                        } else {
                            gC2.drawImage((Image)gC, 0, 0, imageData.width, imageData.height, -imageLoader.x, -imageLoader.y, rectangle.width - (imageLoader.x + imageLoader.width), rectangle.height - (imageLoader.y + imageLoader.height) - n4);
                            if (plot1DGraphTable != null) {
                                int n11 = 0;
                                int n12 = 0;
                                while (n12 < plot1DGraphTable.getLegendSize()) {
                                    Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n12);
                                    if (plot1DAppearance.isVisible()) {
                                        int n13 = imageLoader.x + 60 + n11 % 4 * 200 + (int)f4;
                                        int n14 = rectangle.height - n4 + n11 / 4 * 25;
                                        plot1DAppearance.drawApp(n13, n14, gC2, display, f2 > f3);
                                        ++n11;
                                    }
                                    ++n12;
                                }
                            }
                        }
                        gC.dispose();
                        printer.endPage();
                    }
                    printer.endJob();
                    gC2.dispose();
                }
                printer.dispose();
                file.delete();
            }
        }
    }

    public static synchronized Image createImage(AbstractViewerApp abstractViewerApp, Display display, Plot1DGraphTable plot1DGraphTable, PrinterData printerData, int n) {
        int n2;
        int n3;
        File file = null;
        try {
            file = File.createTempFile("test", ".png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Image image = null;
        Printer printer = new Printer(printerData);
        Point point = printer.getDPI();
        int n4 = n3 = point.x < 100 ? 1 : 3;
        if (n3 == 1) {
            logger.info("Printer dpi was lower than 100 ({}) so oversampling not used", (Object)point.x);
        }
        int n5 = 1;
        if (SWT.getPlatform().toLowerCase().equals("gtk")) {
            n5 = n;
        }
        ExportImage.exportImage((Viewer)abstractViewerApp.getCurrentViewer(), (File)file, (int)(abstractViewerApp.getCurrentViewer().getViewingComponentSize().width * n5), (int)(abstractViewerApp.getCurrentViewer().getViewingComponentSize().height * n5), (int)n3);
        ImageLoader imageLoader = new ImageLoader();
        ImageData imageData = imageLoader.load(file.getAbsolutePath())[0];
        Image image2 = new Image((Device)display, imageData);
        Image image3 = new Image((Device)display, image2.getBounds().width + 100, image2.getBounds().height + 100);
        GC gC = new GC((Drawable)image3);
        int n6 = 0;
        Rectangle rectangle = printer.computeTrim(0, 0, 0, 0);
        if (plot1DGraphTable != null) {
            n2 = 0;
            while (n2 < plot1DGraphTable.getLegendSize()) {
                if (plot1DGraphTable.getLegendEntry(n2).isVisible()) {
                    ++n6;
                }
                ++n2;
            }
            int cfr_ignored_0 = 10 + Math.max(1, n6 / 4) * 32;
        }
        gC.drawImage(image2, 0, 0, image2.getBounds().width, image2.getBounds().height, -rectangle.x, -rectangle.y, image2.getBounds().width, image2.getBounds().height);
        if (plot1DGraphTable != null) {
            n2 = 0;
            int n7 = 0;
            while (n7 < plot1DGraphTable.getLegendSize()) {
                Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n7);
                if (plot1DAppearance.isVisible()) {
                    int n8 = 60 - n2 / 4;
                    int n9 = image2.getBounds().height + 20 + n2 % 4;
                    plot1DAppearance.drawApp(n8, n9, gC, display, false, n5);
                    ++n2;
                }
                ++n7;
            }
        }
        image2.dispose();
        image = gC.getGCData().image;
        gC.dispose();
        file.delete();
        return image;
    }
}

