/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.utils;

public class JOGLGLSLShaderGenerator {
    private static final String FRAGLOGPNAME = "Log";
    private static final String FRAGPROGNAME = "FloatProg";
    private static final String FRAGCOLORPASSTHROUGHNAME = "RGBPassThrough";
    private static final String DIFFRAGPROGNAME = "Diff";
    private static final String GRADIENTPROGNAME = "GradientImage";
    private static final String FRAGCOLORPASSTHROUGH = "uniform sampler2D sampler;\nuniform sampler2D overlaySampler;\nvoid main(void)\n{\nvec4 image = texture2D(sampler,gl_TexCoord[0].st);\nvec4 overlay = texture2D(overlaySampler,gl_TexCoord[0].st);\ngl_FragColor = image;\n}\n";
    private static final String COMMOMFRAGPROGHEADPART = "uniform sampler2D sampler;\nuniform sampler2D tableSampler;\nuniform sampler2D overlaySampler;\nuniform float maxValue;\nuniform float minValue;\n";
    private static final String DIFFRACTIONHEADPART = "uniform float threshold;\n";
    private static final String GRADIENTHEADERPART = "uniform float threshold;\nuniform vec2 delta;\n";
    private static final String LOGPROGPART = "const float EULER = 2.7182818284590452353602874713527;\n\nfloat scaling(float invalue) {\tbool negValue = (invalue < 0.0);\n\tif (negValue)\n\t\tinvalue = abs(invalue); \n\tif (invalue < EULER) \n\t\tinvalue+=(EULER - invalue) / EULER;\n\tfloat outvalue = log(invalue); \n\treturn (negValue ? -outvalue : outvalue);\n}\n";
    private static final String COMMONMAINPART = "void main(void)\n{\n float dataValue = texture2D(sampler,gl_TexCoord[0].st).x;\n";
    private static final String DIFFRACTIONPART = " if (dataValue < -1.0) image = vec4(0.3,1.0,0.15,1.0);\n if (dataValue >= threshold) image = vec4(1,1,0,1);\n";
    private static final String COMMONENDPART = " vec4 overlay = texture2D(overlaySampler, gl_TexCoord[0].st);\n image = image * (1.0-overlay.w) + overlay * overlay.w;\n gl_FragColor = image;\n}\n";
    private static final String NORMALLINEARPART = " float nDataValue = min(1.0,(dataValue - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(nDataValue,nDataValue));\n";
    private static final String GRADIENTPART = " float temp_X_Y = texture2D(sampler,gl_TexCoord[0].st - delta).x;\n float temp_Y = texture2D(sampler,gl_TexCoord[0].st + vec2(0,-delta.y)).x;\n float tempX_Y = texture2D(sampler,gl_TexCoord[0].st + vec2(delta.x,-delta.y)).x;\n float temp_X = texture2D(sampler,gl_TexCoord[0].st + vec2(-delta.x,0.0)).x;\n float tempX = texture2D(sampler,gl_TexCoord[0].st + vec2(delta.x,0.0)).x;\n float temp_XY = texture2D(sampler,gl_TexCoord[0].st + vec2(-delta.x,delta.y)).x;\n float tempY = texture2D(sampler,gl_TexCoord[0].st + vec2(0.0,delta.y)).x;\n float tempXY = texture2D(sampler,gl_TexCoord[0].st + delta).x;\n float gy = temp_XY + 2.0 * tempY + tempXY - temp_X_Y - 2.0 * temp_Y - tempX_Y;\n float gx = tempX_Y + 2.0 * tempX + tempXY - temp_X_Y - 2.0 * temp_X - temp_XY;\n float g = threshold * sqrt(gx*gx+gy*gy);\n float nDataValue = min(1.0,(g - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(nDataValue,nDataValue));\n";
    private static final String NORMALLOGPART = " float nDataValue = min(1.0,(scaling(dataValue) - minValue) / (maxValue-minValue));\n vec4 image = texture2D(tableSampler,vec2(nDataValue,nDataValue));\n";

    public static String generateShader(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            return FRAGCOLORPASSTHROUGH;
        }
        String string = COMMOMFRAGPROGHEADPART;
        if (bl3) {
            string = String.valueOf(string) + DIFFRACTIONHEADPART;
        }
        if (bl4) {
            string = String.valueOf(string) + GRADIENTHEADERPART;
            string = String.valueOf(string) + COMMONMAINPART;
            string = String.valueOf(string) + GRADIENTPART;
            string = String.valueOf(string) + COMMONENDPART;
        } else if (bl) {
            string = String.valueOf(string) + LOGPROGPART;
            string = String.valueOf(string) + COMMONMAINPART;
            string = String.valueOf(string) + NORMALLOGPART;
            if (bl3) {
                string = String.valueOf(string) + DIFFRACTIONPART;
            }
            string = String.valueOf(string) + COMMONENDPART;
        } else {
            string = String.valueOf(string) + COMMONMAINPART;
            string = String.valueOf(string) + NORMALLINEARPART;
            if (bl3) {
                string = String.valueOf(string) + DIFFRACTIONPART;
            }
            string = String.valueOf(string) + COMMONENDPART;
        }
        return string;
    }

    public static String generateShaderName(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl2) {
            return FRAGCOLORPASSTHROUGHNAME;
        }
        String string = FRAGPROGNAME;
        if (bl) {
            string = String.valueOf(string) + ".Log";
        }
        if (bl3) {
            string = String.valueOf(string) + ".Diff";
        }
        if (bl4) {
            string = String.valueOf(string) + ".GradientImage";
        }
        return string;
    }

    public static String generateCompositeShader(boolean bl, int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + "uniform sampler2D sampler" + n2 + ";\n";
            ++n2;
        }
        string = String.valueOf(string) + "uniform sampler2D tableSampler;\nuniform float maxValue;\nuniform float minValue;\nuniform float weight[7];\nuniform int ops[7];\nuniform int isRGB[7];\nuniform vec3 mask[7];\nvoid main(void)\n{\n  vec4 result = vec4(0,0,0,1);\n  vec4 image = vec4(0,0,0,0);\n  float dataResult = 0.0;\n  float dataValue = 0.0;\n  float nDataValue = 0.0;\n  float totalRGBWeights = 0.0;\n  float totalNONRGBWeights = 0.0;\n";
        n2 = 0;
        while (n2 < n) {
            string = n2 == 0 ? String.valueOf(string) + "  if (isRGB[" + n2 + "] == 1) {\n" + "     image = texture2D(sampler" + n2 + ",gl_TexCoord[0].st);\n" + "     result.xyz += weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz;\n" + "     totalRGBWeights += weight[" + n2 + "];\n" + "  } else {\n" + "     dataValue = texture2D(sampler" + n2 + ",gl_TexCoord[0].st).x;\n" + "     nDataValue = min(1.0,(dataValue - minValue) / (maxValue-minValue));\n" + "     dataResult += weight[" + n2 + "] * nDataValue;\n" + "     totalNONRGBWeights += weight[" + n2 + "];\n" + "  }\n" : String.valueOf(string) + "  if (isRGB[" + n2 + "] == 1) {\n" + "     image = texture2D(sampler" + n2 + ",gl_TexCoord[0].st);\n" + "     totalRGBWeights += weight[" + n2 + "];\n" + "     if (ops[" + n2 + "] == 0)\n" + "        result.xyz += weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz;\n" + "     else if (ops[" + n2 + "] == 1)\n" + "        result.xyz -= weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz;\n" + "     else if (ops[" + n2 + "] == 2)\n" + "        result.xyz *= weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz;\n" + "     else if (ops[" + n2 + "] == 3)\n" + "        result.xyz /= weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz;\n" + "     else if (ops[" + n2 + "] == 4)\n" + "        result.xyz = min(result.xyz,weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz);\n" + "     else if (ops[" + n2 + "] == 5)\n" + "        result.xyz = max(result.xyz,weight[" + n2 + "] * mask[" + n2 + "].xyz * image.xyz);\n" + "  } else {\n" + "     totalNONRGBWeights += weight[" + n2 + "];\n" + "     dataValue = texture2D(sampler" + n2 + ",gl_TexCoord[0].st).x;\n" + "     nDataValue = min(1.0,(dataValue - minValue) / (maxValue-minValue));\n" + "     if (ops[" + n2 + "] == 0)\n" + "        dataResult += weight[" + n2 + "] * nDataValue;\n" + "     else if (ops[" + n2 + "] == 1)\n" + "        dataResult -= weight[" + n2 + "] * nDataValue;\n" + "     else if (ops[" + n2 + "] == 2)\n" + "        dataResult *= weight[" + n2 + "] * nDataValue;\n" + "     else if (ops[" + n2 + "] == 3)\n" + "        dataResult /= weight[" + n2 + "] * nDataValue;\n" + "     else if (ops[" + n2 + "] == 4)\n" + "        dataResult = min(dataResult,weight[" + n2 + "] * nDataValue);\n" + "     else if (ops[" + n2 + "] == 5)\n" + "        dataResult = max(dataResult,weight[" + n2 + "] * nDataValue);\n" + "  }\n";
            ++n2;
        }
        string = String.valueOf(string) + "  totalNONRGBWeights = min(totalNONRGBWeights,1.0);\n";
        string = String.valueOf(string) + "  totalRGBWeights = min(totalRGBWeights,1.0);\n";
        string = String.valueOf(string) + "  image = texture2D(tableSampler,vec2(dataResult,dataResult));\n";
        string = String.valueOf(string) + "  gl_FragColor = totalNONRGBWeights * image + totalRGBWeights * result;\n";
        string = String.valueOf(string) + "}\n";
        return string;
    }

    public static String generateCompositeShaderName(boolean bl, int n) {
        String string = "compositeShader.#" + n;
        return string;
    }
}

