/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.util.Iterator;
import java.util.LinkedList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PanActionListener;

public class PanningTool
extends AbstractTool {
    private static InputSlot activate = InputSlot.getDevice((String)"PrimaryMenu");
    private static InputSlot trafo = InputSlot.getDevice((String)"PointerNDC");
    private static InputSlot worldToNDC = InputSlot.getDevice((String)"WorldToNDC");
    private SceneGraphComponent node;
    private double[] tempStorage = new double[16];
    private double[] oldTrafo = new double[16];
    private double[] newTrafo = new double[16];
    private double xSize = 1.0;
    private double ySize = 1.0;
    private LinkedList<PanActionListener> listeners = null;

    public PanningTool(SceneGraphComponent sceneGraphComponent) {
        super(new InputSlot[]{activate});
        this.addCurrentSlot(trafo);
        this.node = sceneGraphComponent;
        this.listeners = new LinkedList();
    }

    public void activate(ToolContext toolContext) {
        if (this.node.getTransformation() == null) {
            this.node.setTransformation(new Transformation());
        }
        DoubleArray doubleArray = toolContext.getTransformationMatrix(trafo);
        doubleArray.toDoubleArray(this.oldTrafo);
    }

    public void setDataDimension(double d, double d2) {
        this.xSize = d;
        this.ySize = d2;
    }

    public void perform(ToolContext toolContext) {
        DoubleArray doubleArray = toolContext.getTransformationMatrix(trafo);
        doubleArray.toDoubleArray(this.newTrafo);
        double d = this.newTrafo[3] - this.oldTrafo[3];
        double d2 = this.newTrafo[7] - this.oldTrafo[7];
        System.arraycopy(this.newTrafo, 0, this.oldTrafo, 0, 16);
        DoubleArray doubleArray2 = toolContext.getTransformationMatrix(worldToNDC);
        doubleArray.toDoubleArray(this.tempStorage);
        Matrix matrix = new Matrix(doubleArray2);
        double[] dArray = new double[]{this.xSize - 0.5 * this.xSize, this.ySize - 0.5 * this.ySize, 0.0};
        matrix.transformVector(dArray);
        double d3 = dArray[0];
        double d4 = dArray[1];
        dArray[0] = -0.5 * this.xSize;
        dArray[1] = -0.5 * this.ySize;
        matrix.transformVector(dArray);
        double d5 = this.xSize / (d3 -= dArray[0]) * d;
        double d6 = this.ySize / (d4 -= dArray[1]) * d2;
        this.tempStorage[3] = d5;
        this.tempStorage[7] = d6;
        this.tempStorage[11] = 0.0;
        Matrix matrix2 = MatrixBuilder.euclidean((Transformation)this.node.getTransformation()).times(this.tempStorage).getMatrix();
        this.notifyPanActionListener(matrix2.getEntry(0, 3), matrix2.getEntry(1, 3));
    }

    private void notifyPanActionListener(double d, double d2) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((PanActionListener)iterator.next()).panPerformed(d, d2);
        }
    }

    public void removePanActionListener(PanActionListener panActionListener) {
        this.listeners.remove(panActionListener);
    }

    public void removeAllPanActionListener() {
        this.listeners.clear();
    }

    public void addPanActionListener(PanActionListener panActionListener) {
        this.listeners.add(panActionListener);
    }
}

