/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.math.Matrix;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IDataPositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ImagePositionListener;

public class ImagePositionTool
extends AbstractTool {
    private static final InputSlot pointerSlot = InputSlot.getDevice((String)"PointerTransformation");
    private static final InputSlot leftMouseButtonSlot = InputSlot.getDevice((String)"PrimaryAction");
    private static final InputSlot rightMouseButtonSlot = InputSlot.getDevice((String)"PrimarySelection");
    private static final InputSlot ctrlKeySlot = InputSlot.getDevice((String)"Meta");
    private static final InputSlot shiftKeySlot = InputSlot.getDevice((String)"Secondary");
    private Matrix pointerTrans = new Matrix();
    private boolean geometryMatched;
    private boolean leftMButton = false;
    private boolean rightMButton = false;
    private double[] pickedPointTC;
    private int[] pickedPointInPixel = new int[2];
    private boolean initial = false;
    private LinkedList<ImagePositionListener> listeners;
    private int primID = -1;
    int imageWidth;
    int imageHeight;
    double maxX;
    double maxY;

    public ImagePositionTool(int n, int n2, double d, double d2) {
        super(new InputSlot[]{leftMouseButtonSlot, rightMouseButtonSlot});
        this.addCurrentSlot(pointerSlot);
        this.addCurrentSlot(ctrlKeySlot);
        this.addCurrentSlot(shiftKeySlot);
        this.maxX = d;
        this.maxY = d2;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.listeners = new LinkedList();
    }

    public void setMaxXY(double d, double d2) {
        this.maxX = d;
        this.maxY = d2;
    }

    public void setImageWidth(int n) {
        this.imageWidth = n;
    }

    public void setImageHeight(int n) {
        this.imageHeight = n;
    }

    public void activate(ToolContext toolContext) {
        this.initial = true;
        this.perform(toolContext);
        ListIterator listIterator = this.listeners.listIterator();
        short s = 0;
        if (toolContext.getAxisState(rightMouseButtonSlot).isPressed()) {
            this.rightMButton = true;
            s = (short)(s + 2);
        }
        if (toolContext.getAxisState(leftMouseButtonSlot).isPressed()) {
            this.leftMButton = true;
            s = (short)(s + 1);
        }
        if (toolContext.getAxisState(ctrlKeySlot).isPressed()) {
            s = (short)(s + 4);
        }
        if (toolContext.getAxisState(shiftKeySlot).isPressed()) {
            s = (short)(s + 8);
        }
        while (listIterator.hasNext()) {
            ImagePositionListener imagePositionListener = (ImagePositionListener)listIterator.next();
            ImagePositionEvent imagePositionEvent = new ImagePositionEvent(this, this.pickedPointTC, this.pickedPointInPixel, this.primID, s, IDataPositionEvent.Mode.START);
            imagePositionListener.imageStart(imagePositionEvent);
        }
        this.initial = false;
    }

    public void perform(ToolContext toolContext) {
        Object object;
        Object object2;
        PickResult pickResult;
        toolContext.getTransformationMatrix(pointerSlot).toDoubleArray(this.pointerTrans.getArray());
        boolean bl = this.geometryMatched = toolContext.getCurrentPick() != null;
        if (this.geometryMatched) {
            pickResult = null;
            if (toolContext.getCurrentPick().getPickType() == 1 || toolContext.getCurrentPick().getPickType() == 2 || toolContext.getCurrentPick().getPickType() == 4) {
                List list = toolContext.getCurrentPicks();
                object2 = list.iterator();
                this.primID = -1;
                while (object2.hasNext()) {
                    object = (PickResult)object2.next();
                    String string = object.getPickPath().getLastComponent().getName();
                    if (string.length() >= "overlayPrim".length() && string.contains("overlayPrim")) {
                        String string2 = "";
                        string2 = string.substring("overlayPrim".length());
                        try {
                            int n = Integer.parseInt(string2);
                            if (n <= this.primID) continue;
                            this.primID = n;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!string.contains("graph.subGraph") && !string.contains("background")) continue;
                    pickResult = object;
                }
                if (pickResult != null) {
                    this.pickedPointTC = pickResult.getObjectCoordinates();
                    if (this.pickedPointTC[0] < 0.0) {
                        this.pickedPointTC[0] = 0.0;
                    }
                    if (this.pickedPointTC[0] > this.maxX) {
                        this.pickedPointTC[0] = this.maxX;
                    }
                    if (this.pickedPointTC[1] < 0.0) {
                        this.pickedPointTC[1] = 0.0;
                    }
                    if (this.pickedPointTC[1] > this.maxY) {
                        this.pickedPointTC[1] = this.maxY;
                    }
                    this.pickedPointInPixel[0] = (int)(this.pickedPointTC[0] / this.maxX * (double)this.imageWidth);
                    this.pickedPointInPixel[1] = (int)((this.maxY - this.pickedPointTC[1]) / this.maxY * (double)this.imageHeight);
                }
            }
        }
        if (!this.initial) {
            pickResult = this.listeners.listIterator();
            short s = 0;
            if (toolContext.getAxisState(rightMouseButtonSlot).isPressed()) {
                this.rightMButton = true;
                s = (short)(s + 2);
            }
            if (toolContext.getAxisState(leftMouseButtonSlot).isPressed()) {
                this.leftMButton = true;
                s = (short)(s + 1);
            }
            if (toolContext.getAxisState(ctrlKeySlot).isPressed()) {
                s = (short)(s + 4);
            }
            if (toolContext.getAxisState(shiftKeySlot).isPressed()) {
                s = (short)(s + 8);
            }
            while (pickResult.hasNext()) {
                object2 = (ImagePositionListener)pickResult.next();
                object = new ImagePositionEvent(this, this.pickedPointTC, this.pickedPointInPixel, this.primID, s, IDataPositionEvent.Mode.DRAG);
                object2.imageDragged((IImagePositionEvent)object);
            }
        }
    }

    public void deactivate(ToolContext toolContext) {
        ListIterator listIterator = this.listeners.listIterator();
        short s = 0;
        if (toolContext.getAxisState(rightMouseButtonSlot).isReleased() && this.rightMButton) {
            s = (short)(s + 2);
        }
        if (toolContext.getAxisState(leftMouseButtonSlot).isReleased() && this.leftMButton) {
            s = (short)(s + 1);
        }
        if (toolContext.getAxisState(ctrlKeySlot).isPressed()) {
            s = (short)(s + 4);
        }
        if (toolContext.getAxisState(shiftKeySlot).isPressed()) {
            s = (short)(s + 8);
        }
        while (listIterator.hasNext()) {
            ImagePositionListener imagePositionListener = (ImagePositionListener)listIterator.next();
            ImagePositionEvent imagePositionEvent = new ImagePositionEvent(this, this.pickedPointTC, this.pickedPointInPixel, this.primID, s, IDataPositionEvent.Mode.END);
            imagePositionListener.imageFinished(imagePositionEvent);
        }
        this.rightMButton = false;
        this.leftMButton = false;
    }

    public void addImagePositionListener(ImagePositionListener imagePositionListener) {
        this.listeners.add(imagePositionListener);
    }

    public void removeImagePositionListener(ImagePositionListener imagePositionListener) {
        this.listeners.remove(imagePositionListener);
    }
}

