/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.tools;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.util.Rectangle3D;

public class ClickWheelZoomTool
extends AbstractTool {
    protected static final InputSlot pointerSlot = InputSlot.getDevice((String)"PointerTransformation");
    protected static InputSlot worldToNDC = InputSlot.getDevice((String)"WorldToNDC");
    protected SceneGraphComponent sceneNode;
    protected SceneGraphComponent translationNode;
    private double speed = 1.05;
    protected Rectangle3D rect = null;

    public ClickWheelZoomTool(SceneGraphComponent sceneGraphComponent, SceneGraphComponent sceneGraphComponent2) {
        super(new InputSlot[]{InputSlot.getDevice((String)"PrimaryUp"), InputSlot.getDevice((String)"PrimaryDown")});
        this.sceneNode = sceneGraphComponent;
        this.translationNode = sceneGraphComponent2;
        if (this.sceneNode.getTransformation() == null) {
            this.sceneNode.setTransformation(new Transformation());
        }
    }

    protected void updateEdgePoints(Matrix matrix) {
    }

    protected void updateEdgePointsAfterMouse(Matrix matrix) {
    }

    public void activate(ToolContext toolContext) {
        DoubleArray doubleArray = toolContext.getTransformationMatrix(pointerSlot);
        DoubleArray doubleArray2 = toolContext.getTransformationMatrix(worldToNDC);
        Matrix matrix = new Matrix(doubleArray);
        Matrix matrix2 = new Matrix(doubleArray2);
        matrix.multiplyOnLeft(matrix2);
        double d = matrix.getEntry(0, 3) / matrix.getEntry(3, 3);
        double d2 = matrix.getEntry(1, 3) / matrix.getEntry(3, 3);
        double[] dArray = null;
        if (this.rect == null) {
            this.rect = BoundingBoxUtility.calculateChildrenBoundingBox((SceneGraphComponent)this.sceneNode);
        }
        int n = 0;
        if (toolContext.getSource() == InputSlot.getDevice((String)"PrimaryUp")) {
            n = 1;
        } else if (toolContext.getSource() == InputSlot.getDevice((String)"PrimaryDown")) {
            n = -1;
        }
        if (n != 0) {
            dArray = this.sceneNode.getTransformation().getMatrix();
            double d3 = dArray[0];
            double d4 = dArray[3];
            double d5 = dArray[7];
            double d6 = dArray[11];
            double d7 = n < 0 ? this.speed : 1.0 / this.speed;
            double d8 = -this.rect.getExtent()[0] * 0.5;
            double d9 = -this.rect.getExtent()[1] * 0.5;
            double d10 = this.rect.getExtent()[0] * 0.5;
            double d11 = this.rect.getExtent()[1] * 0.5;
            d3 *= d7;
            if (this.translationNode != null) {
                dArray = this.translationNode.getTransformation().getMatrix();
                d8 -= dArray[3];
                d9 -= dArray[7];
                d10 -= dArray[3];
                d11 -= dArray[7];
            }
            d = d8 + (d + 1.0) * 0.5 * (d10 - d8);
            d2 = d9 + (d2 + 1.0) * 0.5 * (d11 - d9);
            Matrix matrix3 = MatrixBuilder.euclidean().translate(d4, d5, d6).scale(d3).getMatrix();
            MatrixBuilder.euclidean().translate(d4, d5, d6).scale(d3).assignTo(this.sceneNode);
            this.updateEdgePoints(matrix3);
            if (this.translationNode != null) {
                dArray = this.translationNode.getTransformation().getMatrix();
                double d12 = dArray[3];
                double d13 = dArray[7];
                double d14 = dArray[11];
                d12 -= d;
                d13 -= d2;
                Matrix matrix4 = MatrixBuilder.euclidean().translate(d12 += d - (d * d7 - d), d13 += d2 - (d2 * d7 - d2), d14).getMatrix();
                MatrixBuilder.euclidean().translate(d12, d13, d14).assignTo(this.translationNode);
                this.updateEdgePointsAfterMouse(matrix4);
            }
        }
        toolContext.getViewer().render();
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.speed = d;
    }
}

