/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.ScaleType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionComplexEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotActionEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.PlotRightClickActionTool;

public class SidePlotter1D
extends DataSetPlotter
implements PlotActionEventListener {
    private Composite parent;
    Display display;
    private String title;
    private ContextDialog popup;

    public SidePlotter1D(Composite composite, String string) {
        super(PlottingMode.ONED, composite, false);
        this.title = string;
        this.parent = composite;
        this.display = composite.getDisplay();
        ((DataSet3DPlot1D)this.plotter).addPlotActionEventListener(this);
        this.setPlotRightClickActionEnabled(true);
        this.setZoomMode(true);
        this.setZoomEnabled(true);
        if (this.getPreferenceSidePlotterLogY()) {
            this.setYAxisScaling(ScaleType.LOG10);
        }
        this.popup = new ContextDialog(composite.getShell());
    }

    @Override
    public void plotActionPerformed(PlotActionEvent plotActionEvent) {
        if (plotActionEvent instanceof PlotActionComplexEvent && plotActionEvent.getSource() instanceof PlotRightClickActionTool) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    SidePlotter1D.this.popup.open();
                }
            });
        }
    }

    private boolean getPreferenceSidePlotterLogY() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("sideplotter1d.useLog.y") ? iPreferenceStore.getDefaultBoolean("sideplotter1d.useLog.y") : iPreferenceStore.getBoolean("sideplotter1d.useLog.y");
    }

    private void setPreferenceSidePlotterLogY(boolean bl) {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        if (!iPreferenceStore.isDefault("sideplotter1d.useLog.y")) {
            iPreferenceStore.setValue("sideplotter1d.useLog.y", bl);
        }
    }

    class ContextDialog
    extends ViewSettingsDialog {
        boolean logScale;

        public ContextDialog(Shell shell) {
            super(shell);
            this.logScale = SidePlotter1D.this.getPreferenceSidePlotterLogY();
            this.setShellStyle(2144);
            this.setBlockOnOpen(false);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(String.valueOf(SidePlotter1D.this.title) + " options");
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.createButton(composite, 1024, "Toggle y logscale", false);
            this.createButton(composite, 1025, "Unzoom", false);
            this.createButton(composite, 1026, "Reset", false);
            this.createButton(composite, 0, IDialogConstants.CLOSE_LABEL, true);
        }

        protected void buttonPressed(int n) {
            switch (n) {
                case 1024: {
                    boolean bl = this.logScale = !this.logScale;
                    if (this.logScale) {
                        SidePlotter1D.this.setYAxisScaling(ScaleType.LOG10);
                        break;
                    }
                    SidePlotter1D.this.setYAxisScaling(ScaleType.LINEAR);
                    break;
                }
                case 1025: {
                    SidePlotter1D.this.undoZoom();
                    break;
                }
                case 1026: {
                    SidePlotter1D.this.resetZoom();
                    break;
                }
                default: {
                    super.buttonPressed(n);
                }
            }
            SidePlotter1D.this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SidePlotter1D.this.refresh(false);
                }
            });
        }
    }
}

