/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;
import uk.ac.diamond.scisoft.analysis.plotserver.AxisMapBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBeanException;
import uk.ac.diamond.scisoft.analysis.plotserver.DataSetWithAxisInformation;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIHandles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveQueue;
import uk.ac.diamond.scisoft.analysis.rcp.views.PlotView;
import uk.ac.diamond.scisoft.analysis.roi.MaskingBean;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.ROIList;

public abstract class SidePlotProfile
extends SidePlot
implements Overlay2DConsumer,
SelectionListener,
ICellEditorListener {
    private static Logger logger = LoggerFactory.getLogger(SidePlotProfile.class);
    protected AbstractDataset data;
    protected AbstractDataset subData;
    protected double subFactor;
    private static final int DMAXDIM = 500;
    protected ROIBase roi = null;
    protected ROIData roiData = null;
    protected ROIDataList roiDataList = null;
    protected Class<? extends ROIBase> roiClass = null;
    protected Class<?> roiListClass = null;
    protected Overlay2DProvider oProvider;
    protected boolean dragging = false;
    protected Color oColour;
    protected Color dColour = new Color(255, 0, 0);
    protected Color cColour;
    protected double oThickness = 2.0;
    protected double oTransparency = 0.6;
    protected int[] cpt = new int[2];
    protected List<Integer> dragIDs;
    protected List<Integer> roiIDs;
    protected List<Integer> roisIDs;
    protected ROIHandles roiHandler;
    protected int dragHandle = -1;
    private static final int HSIZEMIN = 5;
    private static final int HSIZEMAX = 100;
    private static final double HSIZEFRACTION = 0.05;
    protected ROITableViewer tViewer;
    protected boolean isBulkUpdate = false;
    protected BooleanDataset mask;
    protected BooleanDataset subMask;
    protected InteractiveQueue roiQueue = null;
    protected SelectionListener copyButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SidePlotProfile.this.roi = null;
            SidePlotProfile.this.roiData.setPlot(false);
            SidePlotProfile.this.roiDataList.add(SidePlotProfile.this.roiData);
            SidePlotProfile.this.roisIDs.add(-1);
            SidePlotProfile.this.removeCurrentROI();
            SidePlotProfile.this.sendROIs(null);
            SidePlotProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).SidePlotProfile.this.tViewer.refresh();
                    SidePlotProfile.this.hideCurrent();
                    SidePlotProfile.this.removeIDs((this).SidePlotProfile.this.roiIDs);
                    SidePlotProfile.this.removeHandles();
                    SidePlotProfile.this.drawOverlays();
                    SidePlotProfile.this.updatePlot();
                }
            });
        }
    };
    protected SelectionListener deleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SidePlotProfile.this.roi = null;
            SidePlotProfile.this.removeCurrentROI();
            SidePlotProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).SidePlotProfile.this.tViewer.refresh();
                    SidePlotProfile.this.hideCurrent();
                    SidePlotProfile.this.removeHandles();
                    SidePlotProfile.this.updatePlot();
                }
            });
        }
    };
    protected SelectionListener brightnessButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            SidePlotProfile.this.oColour = ((Button)selectionEvent.widget).getSelection() ? SidePlotProfile.this.cColour : SidePlotProfile.this.dColour;
            SidePlotProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SidePlotProfile.this.drawOverlays();
                    SidePlotProfile.this.drawCurrentOverlay();
                }
            });
        }
    };

    @Override
    public void dispose() {
        if (this.roiQueue != null) {
            this.roiQueue.dispose();
        }
        super.dispose();
    }

    @Override
    public void createPartControl(Composite composite) {
        this.roiQueue = new InteractiveQueue();
    }

    public int calcHandleSize(int[] nArray) {
        int n = nArray.length < 2 ? nArray[0] : Math.min(nArray[0], nArray[1]);
        int n2 = (int)((double)n * 0.05);
        if (n2 < 5) {
            n2 = 5;
        }
        if ((double)n2 > (double)n * 0.25 && (n2 = n / 4) < 1) {
            n2 = 1;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        return n2;
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.oProvider = (Overlay2DProvider)overlayProvider;
    }

    @Override
    public void unregisterProvider() {
        this.hideOverlays();
        this.removePrimitives();
        this.oProvider = null;
    }

    @Override
    public void hideOverlays() {
        if (this.oProvider == null) {
            return;
        }
        this.hideIDs(this.dragIDs);
        this.hideCurrent();
        this.hideIDs(this.roisIDs);
    }

    @Override
    public void showOverlays() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.drawOverlays();
                SidePlotProfile.this.drawCurrentOverlay();
            }
        });
    }

    @Override
    public void showSidePlot() {
        GuiBean guiBean;
        this.mask = null;
        if (this.guiUpdateManager != null && (guiBean = this.guiUpdateManager.getGUIInfo()).containsKey((Object)GuiParameters.MASKING)) {
            MaskingBean maskingBean = (MaskingBean)guiBean.get((Object)GuiParameters.MASKING);
            this.mask = maskingBean.getMask();
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.tViewer.setInput(SidePlotProfile.this.roiDataList);
                SidePlotProfile.this.updatePlot();
            }
        });
        int n = 0;
        if (this.guiUpdateManager != null) {
            n = this.updateGUI(this.guiUpdateManager.getGUIInfo(), true);
        }
        if (n & true) {
            this.sendCurrentROI(this.roi);
        }
        if ((n & 2) != 0) {
            this.sendROIs(this.roiClass);
        }
        if (n != 0) {
            this.updateDataList();
        }
        if (this.roi == null && this.roiDataList.size() == 0) {
            return;
        }
        this.showOverlays();
    }

    protected void hideCurrent() {
        this.hideIDs(this.roiIDs);
        int n = 0;
        int n2 = this.roiHandler.size();
        while (n < n2) {
            if ((Integer)this.roiHandler.get(n) != -1) {
                this.oProvider.setPrimitiveVisible((Integer)this.roiHandler.get(n), false);
            }
            ++n;
        }
    }

    protected void hideIDs(List<Integer> list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            int n3 = list.get(n);
            if (n3 != -1) {
                this.oProvider.setPrimitiveVisible(n3, false);
            }
            ++n;
        }
    }

    @Override
    public void removePrimitives() {
        if (this.oProvider == null) {
            return;
        }
        this.removeIDs(this.dragIDs);
        this.removeIDs(this.roiIDs);
        this.removeHandles();
        this.removeIDs(this.roisIDs);
    }

    protected void removeHandles() {
        int n = this.roiHandler.size();
        if (n > 0) {
            this.oProvider.unregisterPrimitive(this.roiHandler);
            int n2 = 0;
            while (n2 < n) {
                this.roiHandler.set(n2, -1);
                ++n2;
            }
        }
    }

    protected void removeIDs(List<Integer> list) {
        int n = list.size();
        if (n > 0) {
            this.oProvider.unregisterPrimitive(list);
            int n2 = 0;
            while (n2 < n) {
                list.set(n2, -1);
                ++n2;
            }
        }
    }

    protected void updatePlot() {
        this.updatePlot(this.roi);
    }

    protected abstract void updatePlot(ROIBase var1);

    protected abstract void drawCurrentOverlay();

    protected abstract void drawOverlays();

    protected abstract void updateAllSpinners(ROIBase var1);

    protected void updateDataList() {
        if (this.getDataset()) {
            int n = 0;
            int n2 = this.roiDataList.size();
            while (n < n2) {
                ROIData rOIData = (ROIData)this.roiDataList.get(n);
                this.roiDataList.set(n, this.createNewROIData(rOIData.getROI()));
                ++n;
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tViewer.getSelection();
        if (iStructuredSelection != null && selectionEvent.widget instanceof MenuItem) {
            ROIData rOIData = (ROIData)iStructuredSelection.getFirstElement();
            int n = this.roiDataList.indexOf(rOIData);
            switch (this.tViewer.getContextMenu().indexOf((MenuItem)selectionEvent.widget)) {
                case 0: {
                    this.roi = rOIData.getROI();
                    this.roiHandler.setROI(this.roi);
                    this.removeIDs(this.roiIDs);
                    this.roiIDs.set(0, this.roisIDs.get(n));
                    this.roisIDs.remove(n);
                    this.roiDataList.remove(rOIData);
                    this.sendCurrentROI(this.roi);
                    this.sendROIs(null);
                    this.updateAllSpinners(this.roi);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.tViewer.refresh();
                            SidePlotProfile.this.removeHandles();
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.drawCurrentOverlay();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                    break;
                }
                case 1: {
                    this.roi = rOIData.getROI().copy();
                    this.roiHandler.setROI(this.roi);
                    this.sendCurrentROI(this.roi);
                    this.updateAllSpinners(this.roi);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.drawCurrentOverlay();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                    break;
                }
                case 2: {
                    this.oProvider.unregisterPrimitive(this.roisIDs.get(n));
                    this.roisIDs.remove(n);
                    this.roiDataList.remove(rOIData);
                    this.sendROIs(null);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.tViewer.refresh();
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                    break;
                }
                case 3: {
                    this.removeIDs(this.roisIDs);
                    this.roisIDs.clear();
                    this.roiDataList.clear();
                    this.sendROIs(null);
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.tViewer.refresh();
                            SidePlotProfile.this.drawOverlays();
                            SidePlotProfile.this.updatePlot();
                        }
                    });
                }
            }
        }
    }

    public void applyEditorValue() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SidePlotProfile.this.sendROIs(null);
                SidePlotProfile.this.updatePlot();
            }
        });
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    protected void sendCurrentROI(ROIBase rOIBase) {
        if (rOIBase == null) {
            this.removeCurrentROI();
            return;
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.ROIDATA, (Serializable)rOIBase.copy());
        }
    }

    protected void sendROIs(Class<? extends ROIBase> clazz) {
        this.removeROIs();
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.ROIDATALIST, (Serializable)this.createROIList());
        }
    }

    protected void removeCurrentROI() {
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.removeGUIInfo(GuiParameters.ROIDATA);
        }
    }

    protected void removeROIs() {
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.removeGUIInfo(GuiParameters.ROIDATALIST);
        }
    }

    public abstract ROIData createNewROIData(ROIBase var1);

    public abstract ROIList<? extends ROIBase> createROIList();

    public int updateGUI(GuiBean guiBean, boolean bl) {
        Serializable serializable;
        int n = 0;
        if (guiBean == null) {
            return n;
        }
        logger.debug("Bean: {}", (Object)guiBean);
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA)) {
            serializable = guiBean.get((Object)GuiParameters.ROIDATA);
            if (serializable == null) {
                if (this.roi != null) {
                    if (!bl) {
                        this.hideCurrent();
                        this.roi = null;
                        this.roiHandler.setROI(this.roi);
                        this.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SidePlotProfile.this.hideCurrent();
                                SidePlotProfile.this.updatePlot();
                                SidePlotProfile.this.drawOverlays();
                            }
                        });
                        this.updateAllSpinners(this.roi);
                    }
                    n |= 1;
                }
            } else if (serializable.getClass().equals(this.roiClass)) {
                this.hideCurrent();
                this.roi = (ROIBase)serializable;
                this.roiHandler.setROI(this.roi);
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SidePlotProfile.this.updatePlot();
                        SidePlotProfile.this.drawOverlays();
                        SidePlotProfile.this.drawCurrentOverlay();
                    }
                });
                this.updateAllSpinners(this.roi);
                n |= 1;
            } else if (bl && this.roi != null) {
                n |= 1;
            }
        } else if (bl && this.roi != null) {
            n |= 1;
        }
        if (this.data == null) {
            return n;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATALIST)) {
            serializable = guiBean.get((Object)GuiParameters.ROIDATALIST);
            if (serializable == null) {
                if (!bl) {
                    this.getDataset();
                    this.removeIDs(this.roisIDs);
                    this.roisIDs.clear();
                    this.roiDataList.clear();
                    this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SidePlotProfile.this.updatePlot();
                            SidePlotProfile.this.tViewer.setInput(SidePlotProfile.this.roiDataList);
                            SidePlotProfile.this.hideOverlays();
                            SidePlotProfile.this.removeIDs(SidePlotProfile.this.roiIDs);
                            SidePlotProfile.this.removeHandles();
                            SidePlotProfile.this.drawCurrentOverlay();
                        }
                    });
                }
                n |= 2;
            } else if (serializable.getClass().equals(this.roiListClass)) {
                ArrayList arrayList = (ArrayList)serializable;
                this.getDataset();
                this.removeIDs(this.roisIDs);
                this.roisIDs.clear();
                this.roiDataList.clear();
                for (ROIBase rOIBase : arrayList) {
                    this.roiDataList.add(this.createNewROIData(rOIBase));
                    this.roisIDs.add(-1);
                }
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SidePlotProfile.this.updatePlot();
                        SidePlotProfile.this.tViewer.setInput(SidePlotProfile.this.roiDataList);
                        SidePlotProfile.this.hideCurrent();
                        SidePlotProfile.this.removeIDs(SidePlotProfile.this.roiIDs);
                        SidePlotProfile.this.removeHandles();
                        SidePlotProfile.this.drawOverlays();
                        SidePlotProfile.this.drawCurrentOverlay();
                    }
                });
                n |= 2;
            } else if (bl) {
                n |= 2;
            }
        } else if (bl && this.roiDataList.size() > 0) {
            n |= 2;
        }
        return n;
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        return this.updateGUI(guiBean, false);
    }

    private void createDownsampledDataset() {
        int[] nArray = this.data.getShape();
        int n = Math.max(nArray[0], nArray[1]);
        this.subFactor = Math.ceil((double)n / 500.0);
        if (this.subFactor > 1.0) {
            nArray[0] = (int)this.subFactor;
            nArray[1] = (int)this.subFactor;
            Downsample downsample = new Downsample(DownsampleMode.MAXIMUM, nArray);
            this.subData = (AbstractDataset)downsample.value(new IDataset[]{this.data}).get(0);
        } else {
            this.subData = null;
        }
    }

    public boolean getDataset() {
        IDataset iDataset = this.mainPlotter.getCurrentDataSet();
        if (iDataset != null) {
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset((ILazyDataset)iDataset);
            if (!abstractDataset.equals((Object)this.data)) {
                this.data = abstractDataset;
                this.createDownsampledDataset();
                return true;
            }
            if (this.data != null && this.subData == null) {
                this.createDownsampledDataset();
            }
        }
        return false;
    }

    @Override
    public void processPlotUpdate() {
        this.updateDataList();
        if (this.oProvider != null) {
            this.updatePlot();
            this.tViewer.setInput(this.roiDataList);
            this.drawOverlays();
            this.drawCurrentOverlay();
        }
    }

    public void pushPlottingData(IWorkbenchPartSite iWorkbenchPartSite, String string, int n) {
        if (this.roiData != null) {
            PlotView plotView = null;
            try {
                plotView = (PlotView)iWorkbenchPartSite.getPage().showView(string);
            }
            catch (PartInitException partInitException) {
                logger.error("All over now! Cannot find plotview: {} ", (Object)string);
                logger.error(partInitException.toString());
                return;
            }
            if (plotView == null) {
                return;
            }
            plotView.updatePlotMode(GuiPlotMode.ONED);
            DataBean dataBean = this.getPlottingData(n);
            if (dataBean != null) {
                plotView.processPlotUpdate(dataBean);
            }
        }
    }

    DataBean getPlottingData(int n) {
        DataBean dataBean = null;
        if (this.roiData != null && this.roiData.getProfileData().length > n) {
            dataBean = new DataBean(GuiPlotMode.ONED);
            DataSetWithAxisInformation dataSetWithAxisInformation = new DataSetWithAxisInformation();
            AxisMapBean axisMapBean = new AxisMapBean(AxisMapBean.DIRECT);
            dataBean.addAxis("x-axis", (IDataset)this.roiData.getXAxis(n).toDataset());
            axisMapBean.setAxisID(new String[]{"x-axis"});
            dataSetWithAxisInformation.setData((IDataset)this.roiData.getProfileData(n));
            dataSetWithAxisInformation.setAxisMap(axisMapBean);
            try {
                dataBean.addData(dataSetWithAxisInformation);
            }
            catch (DataBeanException dataBeanException) {
                logger.debug("Could not add data to bean");
                dataBeanException.printStackTrace();
                dataBean = null;
            }
        }
        return dataBean;
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        Action action = new Action(){

            public void run() {
                SidePlotProfile.this.addToHistory();
            }
        };
        action.setText("Add current profiles to history");
        action.setToolTipText("Adds the current profiles to the plot history");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_put.png"));
        Action action2 = new Action(){

            public void run() {
                SidePlotProfile.this.removeFromHistory();
            }
        };
        action2.setText("Remove last profiles from history");
        action2.setToolTipText("Remove the last profiles from the plot history");
        action2.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_remove.png"));
        iToolBarManager.add((IAction)action);
        iToolBarManager.add((IAction)action2);
    }
}

