/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IGuiInfoManager;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IMainPlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.ISidePlot;

public abstract class SidePlot
implements ISidePlot {
    protected IGuiInfoManager guiUpdateManager;
    protected IMainPlot mainPlotter;
    protected IPlotUI mainPlotUI;
    protected long updateInterval = 0L;
    protected long nextTime = 0L;
    protected Composite container;
    protected boolean isDisposed = true;

    @Override
    public void setUpdateInterval(long l) {
        this.updateInterval = l;
        this.nextTime = System.currentTimeMillis() + l;
    }

    @Override
    public void setGuiInfoManager(IGuiInfoManager iGuiInfoManager) {
        this.guiUpdateManager = iGuiInfoManager;
    }

    @Override
    public void setMainPlotter(IMainPlot iMainPlot) {
        this.mainPlotter = iMainPlot;
    }

    @Override
    public IMainPlot getMainPlotter() {
        return this.mainPlotter;
    }

    @Override
    public void processHistogramUpdate(HistogramUpdate histogramUpdate) {
    }

    @Override
    public Action createSwitchAction(final int n, final IPlotUI iPlotUI) {
        Action action = new Action("", 2){

            public void run() {
                iPlotUI.getSidePlotView().switchSidePlot(iPlotUI, n);
                if (SidePlot.this.mainPlotter instanceof DataSetPlotter) {
                    ((DataSetPlotter)SidePlot.this.mainPlotter).getComposite().setFocus();
                }
            }
        };
        return action;
    }

    @Override
    public Control getControl() {
        return this.container;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void setDisposed(boolean bl) {
        this.isDisposed = bl;
    }

    @Override
    public void dispose() {
        this.guiUpdateManager = null;
        this.mainPlotter = null;
        this.mainPlotUI = null;
        if (this.container != null && !this.container.isDisposed()) {
            this.container.dispose();
        }
        this.container = null;
        this.isDisposed = true;
    }

    @Override
    public void setMainPlotUI(IPlotUI iPlotUI) {
        this.mainPlotUI = iPlotUI;
    }

    protected IPlotUI getMainPlotUI() {
        return this.mainPlotUI;
    }
}

