/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider2;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayImage;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.MCView;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.roi.MaskingBean;

public class MaskCreator
extends SidePlot
implements Overlay2DConsumer {
    private Logger logger = LoggerFactory.getLogger(MaskCreator.class);
    private Overlay2DProvider2 provider;
    private OverlayImage oi;
    private AbstractDataset mainDataSet;
    private BooleanDataset maskDataSet;
    private int noOfMaskedPixels = 0;
    private MCView mcv = new MCView(this);
    private BooleanDataset oldMaskDataSet;
    private int[] lastPoint;
    private boolean clearing = false;
    private Integer minthres;
    private Integer maxthres;

    private void populateOI() {
        IndexIterator indexIterator = this.maskDataSet.getIterator(true);
        int[] nArray = indexIterator.getPos();
        this.oi.zap();
        this.noOfMaskedPixels = 0;
        while (indexIterator.hasNext()) {
            if (this.maskDataSet.get(nArray)) continue;
            ++this.noOfMaskedPixels;
            if (this.mcv.othercolor) {
                this.oi.putPixel(nArray[1], nArray[0], (short)255, (short)128, (short)255, (short)128);
                continue;
            }
            this.oi.putPixel(nArray[1], nArray[0], (short)0, (short)128, (short)0, (short)128);
        }
    }

    @Override
    public void hideOverlays() {
        this.logger.debug("hideoverlay");
        if (!this.mcv.keepVisible) {
            this.provider.begin(OverlayType.IMAGE);
            if (this.oi != null) {
                this.oi.zap();
            }
            this.provider.end(OverlayType.IMAGE);
        }
    }

    @Override
    public void showOverlays() {
        this.logger.debug("showerlay");
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay2DProvider2)overlayProvider;
        this.drawOverlay();
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
        this.oi = null;
    }

    protected void drawOverlay() {
        try {
            String string;
            if (this.maskDataSet == null || this.maskDataSet.all()) {
                string = " No pixels masked.";
            } else {
                int n = this.noOfMaskedPixels;
                float f = 100.0f * (float)n / (float)this.maskDataSet.getSize();
                string = String.format("%d pixel%s masked (%2.2f%% of the detector area).", n, n == 1 ? "" : "s", Float.valueOf(f));
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((MaskCreator)MaskCreator.this).mcv.statusLabel.setText(string);
                }
            });
            if (this.provider != null) {
                if (this.maskDataSet == null || this.maskDataSet.all()) {
                    this.provider.begin(OverlayType.IMAGE);
                    if (this.oi != null) {
                        this.oi.zap();
                    }
                    this.provider.end(OverlayType.IMAGE);
                } else {
                    this.provider.begin(OverlayType.IMAGE);
                    if (this.oi == null || !Arrays.equals(this.maskDataSet.getShape(), this.oi.getShape())) {
                        this.oi = this.provider.registerOverlayImage(this.maskDataSet.getShape()[1], this.maskDataSet.getShape()[0]);
                    }
                    this.populateOI();
                    this.provider.end(OverlayType.IMAGE);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("do bad {}", (Throwable)exception);
        }
    }

    @Override
    public void removePrimitives() {
        this.logger.debug("rp");
        if (this.provider == null) {
            return;
        }
        this.oi = null;
    }

    private void toggle(MCView.PaintMode paintMode, int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (n3 < 0) {
                return;
            }
            ++n2;
        }
        try {
            if (paintMode == MCView.PaintMode.DRAW) {
                this.maskDataSet.set((Object)false, nArray);
                return;
            }
            if (paintMode == MCView.PaintMode.ERASE) {
                this.maskDataSet.set((Object)true, nArray);
                return;
            }
            this.maskDataSet.set((Object)(!this.maskDataSet.get(nArray) ? 1 : 0), nArray);
        }
        catch (Exception exception) {}
    }

    private void manipulate(int[] nArray) {
        MCView.PaintMode paintMode = this.mcv.getPaintMode();
        int n = this.mcv.getPenSize() - 1;
        int n2 = n / 2;
        boolean bl = this.mcv.isSquarePen();
        int n3 = -n2;
        while (n3 <= n2) {
            int n4 = -n2;
            while (n4 <= n2) {
                if (bl || Math.sqrt(n3 * n3 + n4 * n4) <= (double)n2) {
                    this.toggle(paintMode, new int[]{nArray[1] + n3, nArray[0] + n4});
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void lineBresenham(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray[0];
        int n4 = nArray2[0];
        int n5 = nArray[1];
        int n6 = nArray2[1];
        int n7 = n6 - n5;
        int n8 = n4 - n3;
        if (n7 < 0) {
            n7 = -n7;
            n2 = -1;
        } else {
            n2 = 1;
        }
        if (n8 < 0) {
            n8 = -n8;
            n = -1;
        } else {
            n = 1;
        }
        this.manipulate(new int[]{n3, n5});
        if ((n8 <<= 1) > (n7 <<= 1)) {
            int n9 = n7 - (n8 >> 1);
            while (n3 != n4) {
                if (n9 >= 0) {
                    n5 += n2;
                    n9 -= n8;
                }
                n9 += n7;
                this.manipulate(new int[]{n3 += n, n5});
            }
        } else {
            int n10 = n8 - (n7 >> 1);
            while (n5 != n6) {
                if (n10 >= 0) {
                    n3 += n;
                    n10 -= n7;
                }
                n10 += n8;
                this.manipulate(new int[]{n3, n5 += n2});
            }
        }
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.save();
        if (this.maskDataSet == null || !this.maskDataSet.isCompatibleWith((ILazyDataset)this.mainDataSet)) {
            this.maskDataSet = new BooleanDataset(this.mainDataSet.getShape());
            this.maskDataSet.setName("mask");
            this.maskDataSet.setExtendible(false);
            this.maskDataSet.fill((Object)true);
        }
        this.lastPoint = iImagePositionEvent.getImagePosition();
        this.manipulate(this.lastPoint);
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        this.lineBresenham(this.lastPoint, iImagePositionEvent.getImagePosition());
        this.lastPoint = iImagePositionEvent.getImagePosition();
        this.drawOverlay();
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        this.drawOverlay();
        this.updateBean();
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public void createPartControl(Composite composite) {
        this.mcv.createPartControl(composite);
        this.container = this.mcv.container;
        this.mcv.btnUndo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MaskCreator.this.undo();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.mcv.btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MaskCreator.this.clearMask();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Create Mask");
        action.setToolTipText("Switch side plot into mask creation mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/Gas-Mask-icon.png"));
        return action;
    }

    @Override
    public void processPlotUpdate() {
        this.mainDataSet = DatasetUtils.convertToAbstractDataset((ILazyDataset)this.getMainPlotter().getCurrentDataSet());
        if (this.mainDataSet != null) {
            if (this.maskDataSet != null && !this.mainDataSet.isCompatibleWith((ILazyDataset)this.maskDataSet)) {
                this.maskDataSet = null;
            }
        } else {
            this.maskDataSet = null;
        }
        this.drawOverlay();
        this.mcv.setMinMax(this.mainDataSet.min().intValue(), this.mainDataSet.max().intValue());
    }

    @Override
    public void showSidePlot() {
        this.processPlotUpdate();
        if (this.guiUpdateManager != null) {
            this.updateGUI(this.guiUpdateManager.getGUIInfo());
        }
        this.drawOverlay();
    }

    private void updateBean() {
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.MASKING, (Serializable)new MaskingBean(this.maskDataSet, this.minthres, this.maxthres));
        }
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        this.logger.debug("update {}", (Object)guiBean);
        if (!guiBean.containsKey((Object)GuiParameters.MASKING)) {
            return 0;
        }
        MaskingBean maskingBean = (MaskingBean)guiBean.get((Object)GuiParameters.MASKING);
        if (this.mainDataSet != null && maskingBean != null && maskingBean.mask != null && this.mainDataSet.isCompatibleWith((ILazyDataset)maskingBean.mask)) {
            this.save();
            this.maskDataSet = maskingBean.mask;
            this.drawOverlay();
        }
        return 0;
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
    }

    private void save() {
        this.oldMaskDataSet = this.maskDataSet != null ? (BooleanDataset)this.maskDataSet.clone() : null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((MaskCreator)MaskCreator.this).mcv.btnUndo.setEnabled(true);
                ((MaskCreator)MaskCreator.this).mcv.btnUndo.setText("Undo");
            }
        });
    }

    private void undo() {
        BooleanDataset booleanDataset = this.maskDataSet;
        this.maskDataSet = this.oldMaskDataSet;
        this.oldMaskDataSet = booleanDataset;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if ("Undo".equals(((MaskCreator)MaskCreator.this).mcv.btnUndo.getText())) {
                    ((MaskCreator)MaskCreator.this).mcv.btnUndo.setText("Redo");
                } else {
                    ((MaskCreator)MaskCreator.this).mcv.btnUndo.setText("Undo");
                }
            }
        });
        this.drawOverlay();
        this.updateBean();
    }

    private void clearMask() {
        this.clearing = true;
        try {
            this.save();
            this.maskDataSet = null;
            this.mcv.btnMaskAbove.setSelection(false);
            this.mcv.btnMaskBelow.setSelection(false);
            this.drawOverlay();
        }
        finally {
            this.clearing = false;
        }
        this.updateBean();
    }

    public void updateThreshold(Integer n, Integer n2) {
        if (this.clearing) {
            return;
        }
        this.minthres = n;
        this.maxthres = n2;
        if (n2 == null && n == null) {
            return;
        }
        this.save();
        IndexIterator indexIterator = this.mainDataSet.getIterator(true);
        int[] nArray = indexIterator.getPos();
        if (this.maskDataSet == null || !this.maskDataSet.isCompatibleWith((ILazyDataset)this.mainDataSet)) {
            this.maskDataSet = new BooleanDataset(this.mainDataSet.getShape());
            this.maskDataSet.setName("mask");
            this.maskDataSet.setExtendible(false);
            this.maskDataSet.fill((Object)true);
        }
        while (indexIterator.hasNext()) {
            if (n != null && this.mainDataSet.getElementLongAbs(indexIterator.index) < (long)n.intValue()) {
                this.maskDataSet.set((Object)false, nArray);
                continue;
            }
            if (n2 == null || this.mainDataSet.getElementLongAbs(indexIterator.index) <= (long)n2.intValue()) continue;
            this.maskDataSet.set((Object)false, nArray);
        }
        this.drawOverlay();
        this.updateBean();
    }
}

