/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.part.ViewPart;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.MaskCreator;

public class MCView
extends ViewPart {
    private MaskCreator mc;
    protected Label maindsmax;
    protected Label maindsmin;
    private PaintMode paintMode = PaintMode.DRAW;
    private boolean square = false;
    private int pensize = 1;
    protected Button btnClear;
    protected Button btnUndo;
    protected Button btnMaskAbove;
    protected Button btnMaskBelow;
    private Spinner spinnerabove;
    private Spinner spinnerbelow;
    protected ScrolledComposite container;
    protected Label statusLabel;
    protected boolean othercolor = false;
    protected boolean keepVisible = false;

    public MCView() {
        this.mc = new MaskCreator();
    }

    MCView(MaskCreator maskCreator) {
        this.mc = maskCreator;
    }

    public void createPartControl(Composite composite) {
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Integer n = null;
                Integer n2 = null;
                if (MCView.this.btnMaskAbove.getSelection()) {
                    n = MCView.this.spinnerabove.getSelection();
                }
                if (MCView.this.btnMaskBelow.getSelection()) {
                    n2 = MCView.this.spinnerbelow.getSelection();
                }
                MCView.this.mc.updateThreshold(n2, n);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        this.container = new ScrolledComposite(composite, 512);
        final Composite composite2 = new Composite((Composite)this.container, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 2048);
        group.setText("Masking");
        GridLayout gridLayout2 = new GridLayout(4, false);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnMaskAbove = new Button((Composite)group, 32);
        this.btnMaskAbove.setAlignment(0x1000000);
        this.btnMaskAbove.setText("mask above");
        this.btnMaskAbove.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.btnMaskAbove.addSelectionListener(selectionListener);
        this.spinnerabove = new Spinner((Composite)group, 2048);
        this.spinnerabove.setMaximum(1000000);
        this.spinnerabove.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.spinnerabove.addSelectionListener(selectionListener);
        this.btnMaskBelow = new Button((Composite)group, 32);
        this.btnMaskBelow.setAlignment(0x1000000);
        this.btnMaskBelow.setText("mask below");
        this.btnMaskBelow.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.btnMaskBelow.addSelectionListener(selectionListener);
        this.spinnerbelow = new Spinner((Composite)group, 2048);
        this.spinnerbelow.setMaximum(1000000);
        this.spinnerbelow.setMinimum(-1);
        this.spinnerbelow.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.spinnerbelow.addSelectionListener(selectionListener);
        Label label = new Label((Composite)group, 131072);
        label.setText("Max: ");
        this.maindsmax = new Label((Composite)group, 131072);
        Label label2 = new Label((Composite)group, 131072);
        label2.setText("Min: ");
        this.maindsmin = new Label((Composite)group, 131072);
        final Button button = new Button((Composite)group, 32);
        button.setText("toggle mask color");
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MCView.this.othercolor = button.getSelection();
                MCView.this.mc.drawOverlay();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        final Button button2 = new Button((Composite)group, 32);
        button2.setText("keep mask visible");
        button2.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MCView.this.keepVisible = button2.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        group = new Group(composite2, 2048);
        group.setText("Pen properties");
        gridLayout2 = new GridLayout(2, false);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Label((Composite)group, 0);
        label.setText("Pen size");
        label2 = new Spinner((Composite)group, 2048);
        label2.setMaximum(200);
        label2.setMinimum(1);
        label2.addModifyListener(new ModifyListener((Spinner)label2){
            private final /* synthetic */ Spinner val$penSpinner;
            {
                this.val$penSpinner = spinner;
            }

            public void modifyText(ModifyEvent modifyEvent) {
                MCView.this.pensize = this.val$penSpinner.getSelection();
            }
        });
        button = new Composite((Composite)group, 0);
        gridLayout2 = new GridLayout(1, true);
        button.setLayout((Layout)gridLayout2);
        button.setLayoutData((Object)new GridData(4, 4, true, true));
        button2 = new Button((Composite)button, 16);
        button2.setText("square");
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MCView.this.square = button2.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        final Button button3 = new Button((Composite)button, 16);
        button3.setText("round");
        button3.setSelection(true);
        button = new Composite((Composite)group, 0);
        gridLayout2 = new GridLayout(1, true);
        button.setLayout((Layout)gridLayout2);
        button.setLayoutData((Object)new GridData(4, 4, true, true));
        button2 = new Button((Composite)button, 16);
        button2.setText("draw");
        button2.setSelection(true);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button2.getSelection()) {
                    MCView.this.paintMode = PaintMode.DRAW;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        button3 = new Button((Composite)button, 16);
        button3.setText("erase");
        button3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button3.getSelection()) {
                    MCView.this.paintMode = PaintMode.ERASE;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnClear = new Button((Composite)group, 0);
        this.btnClear.setText("Clear");
        this.btnClear.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnUndo = new Button((Composite)group, 0);
        this.btnUndo.setText("Undo");
        this.btnUndo.setEnabled(false);
        this.btnUndo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.statusLabel = new Label(composite2, 0x1000000);
        this.statusLabel.setText("1000000000 pixels masked (100.00% of the detector area).");
        this.statusLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        label = new Composite(composite2, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Composite(composite2, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.container.setContent((Control)composite2);
        this.container.setExpandVertical(true);
        this.container.setExpandHorizontal(true);
        this.container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Rectangle rectangle = MCView.this.container.getClientArea();
                MCView.this.container.setMinSize(composite2.computeSize(rectangle.width, -1));
            }
        });
        this.mc.processPlotUpdate();
    }

    protected PaintMode getPaintMode() {
        return this.paintMode;
    }

    protected boolean isSquarePen() {
        return this.square;
    }

    protected int getPenSize() {
        return this.pensize;
    }

    public void setFocus() {
    }

    void setMinMax(final int n, final int n2) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MCView.this.maindsmax.setText(String.format("%d", n2));
                MCView.this.maindsmin.setText(String.format("%d", n));
                if (!MCView.this.btnMaskAbove.getSelection()) {
                    MCView.this.spinnerabove.setMaximum(n2 + 1);
                    MCView.this.spinnerabove.setMinimum(n);
                }
                if (!MCView.this.btnMaskBelow.getSelection()) {
                    MCView.this.spinnerbelow.setMinimum(n - 1);
                    MCView.this.spinnerbelow.setMaximum(n2);
                }
            }
        });
    }

    static enum PaintMode {
        DRAW,
        TOGGLE,
        ERASE;

    }
}

