/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import com.swtdesigner.SWTResourceManager;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.DropDownAction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.LinearROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.LinearROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.LinearROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotter1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.StaticScanPlotView;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.LinearROIList;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class LineProfile
extends SidePlotProfile {
    private static Logger logger = LoggerFactory.getLogger(LineProfile.class);
    private SidePlotter1D lpPlotter;
    private static final double lineStep = 0.5;
    private DropDownAction pushPlottingData;
    private Action pushPlottingDataPlot1;
    private Action pushPlottingDataPlot2;
    private Action addtoHistory;
    private Action removefromHistory;
    private Action saveGraph;
    private Action copyGraph;
    private Action printGraph;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private Composite parent;
    private HandleStatus hStatus = HandleStatus.NONE;
    private Spinner spsx;
    private Spinner spsy;
    private FloatSpinner spex;
    private FloatSpinner spey;
    private FloatSpinner splen;
    private FloatSpinner spang;
    private Text txSum;
    private SelectionListener crossButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            LinearROI linearROI = (LinearROI)LineProfile.this.roi;
            if (((Button)selectionEvent.widget).getSelection()) {
                linearROI.setCrossHair(true);
            } else {
                linearROI.setCrossHair(false);
            }
            LineProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LineProfile.this.drawCurrentOverlay();
                    LineProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener startPosListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            LinearROI linearROI = (LinearROI)LineProfile.this.roi;
            double[] dArray = linearROI.getEndPoint();
            linearROI.setPoint(LineProfile.this.spsx.getSelection(), LineProfile.this.spsy.getSelection());
            linearROI.setEndPoint(dArray);
            if (LineProfile.this.isBulkUpdate) {
                return;
            }
            LineProfile.this.sendCurrentROI(LineProfile.this.roi);
            LineProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LineProfile.this.updatePlot();
                    LineProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener endPosListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            final LinearROI linearROI = (LinearROI)LineProfile.this.roi;
            if (linearROI != null) {
                linearROI.setEndPoint(new double[]{LineProfile.this.spex.getDouble(), LineProfile.this.spey.getDouble()});
                if (!LineProfile.this.isBulkUpdate) {
                    LineProfile.this.sendCurrentROI(LineProfile.this.roi);
                }
                LineProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LineProfile.this.splen.setDouble(linearROI.getLength());
                        LineProfile.this.spang.setDouble(linearROI.getAngleDegrees());
                        if ((this).LineProfile.this.isBulkUpdate) {
                            return;
                        }
                        LineProfile.this.updatePlot();
                        LineProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener lenAngListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            final LinearROI linearROI = (LinearROI)LineProfile.this.roi;
            if (linearROI != null) {
                linearROI.setLength(LineProfile.this.splen.getDouble());
                linearROI.setAngleDegrees(LineProfile.this.spang.getDouble());
                if (!LineProfile.this.isBulkUpdate) {
                    LineProfile.this.sendCurrentROI(LineProfile.this.roi);
                }
                LineProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LineProfile.this.spex.setDouble(linearROI.getEndPoint()[0]);
                        LineProfile.this.spey.setDouble(linearROI.getEndPoint()[1]);
                        if ((this).LineProfile.this.isBulkUpdate) {
                            return;
                        }
                        LineProfile.this.updatePlot();
                        LineProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };

    public LineProfile() {
        this.roiClass = LinearROI.class;
        this.roiListClass = LinearROIList.class;
    }

    @Override
    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.container = new Composite(this.parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.container, 512);
        this.lpPlotter = new SidePlotter1D((Composite)sashForm, "Line profile");
        this.lpPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.lpPlotter.setXAxisLabel("Distance along line");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Current ROI");
        new Label((Composite)group, 0).setText("Start x:");
        this.spsx = new Spinner((Composite)group, 2048);
        this.spsx.setMinimum(-10000);
        this.spsx.setMaximum(10000);
        this.spsx.setIncrement(1);
        this.spsx.setPageIncrement(5);
        this.spsx.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("End x:");
        this.spex = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.spex.addSelectionListener(this.endPosListener);
        new Label((Composite)group, 0).setText("Length:");
        this.splen = new FloatSpinner((Composite)group, 2048, 7, 2);
        this.splen.addSelectionListener(this.lenAngListener);
        new Label((Composite)group, 0).setText("Start y:");
        this.spsy = new Spinner((Composite)group, 2048);
        this.spsy.setMinimum(-10000);
        this.spsy.setMaximum(10000);
        this.spsy.setIncrement(1);
        this.spsy.setPageIncrement(5);
        this.spsy.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("End y:");
        this.spey = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.spey.addSelectionListener(this.endPosListener);
        new Label((Composite)group, 0).setText("Angle:");
        this.spang = new FloatSpinner((Composite)group, 2048, 5, 2);
        this.spang.setMinimum(0.0);
        this.spang.setMaximum(360.0);
        this.spang.addSelectionListener(this.lenAngListener);
        new Label((Composite)group, 0).setText("Sum:");
        this.txSum = new Text((Composite)group, 2056);
        this.txSum.setTextLimit(12);
        new Label((Composite)group, 0).setText("");
        new Label((Composite)group, 0).setText("");
        new Label((Composite)group, 0).setText("");
        new Label((Composite)group, 0).setText("");
        Object object = new GridData();
        object.horizontalSpan = 2;
        Button button = new Button((Composite)group, 32);
        button.setLayoutData(object);
        button.setText("Invert brightness");
        button.setToolTipText("Invert overlay brightness");
        button.addSelectionListener(this.brightnessButtonListener);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Button button2 = new Button((Composite)group, 32);
        button2.setLayoutData((Object)gridData);
        button2.setText("Cross hair");
        button2.setToolTipText("Add line 90 degrees to current line");
        button2.addSelectionListener(this.crossButtonListener);
        new Label((Composite)group, 0).setText("");
        new Label((Composite)group, 0).setText("");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        Button button3 = new Button((Composite)group, 8);
        button3.setLayoutData((Object)gridData2);
        button3.setText("Copy current to table");
        button3.addSelectionListener(this.copyButtonListener);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        Button button4 = new Button((Composite)group, 8);
        button4.setLayoutData((Object)gridData3);
        button4.setText("Delete current");
        button4.addSelectionListener(this.deleteButtonListener);
        group = new Composite((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{50, 30, 20});
        group.setLayout((Layout)new FillLayout());
        this.tViewer = new LinearROITableViewer((Composite)group, this, this);
        scrolledComposite.setContent((Control)composite2);
        composite2.setSize(composite2.computeSize(-1, -1));
        this.lpPlotter.refresh(false);
        this.updateAllSpinnersInt((LinearROI)this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.tViewer.setInput(this.roiDataList);
        this.roiHandler = new LinearROIHandler((LinearROI)this.roi);
        this.dColour = new Color(0, 255, 255);
        object = Color.RGBtoHSB(this.dColour.getRed(), this.dColour.getGreen(), this.dColour.getBlue(), null);
        this.cColour = Color.getHSBColor((float)object[0], (float)object[1], (float)(1.0 - 0.7 * (double)object[2]));
        this.oColour = this.dColour;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.lpPlotter != null) {
            this.lpPlotter.cleanUp();
        }
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        Plot1DAppearance plot1DAppearance;
        LinearROI linearROI = (LinearROI)rOIBase;
        this.updateDataList();
        if (this.data == null) {
            logger.warn("No data");
            return;
        }
        if (linearROI != null) {
            this.roiData = new LinearROIData(linearROI, this.data, 0.5);
            if (!this.roiData.isPlot()) {
                return;
            }
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LineProfile.this.txSum.setText(String.format("%.2f", LineProfile.this.roiData.getProfileSum()));
                }
            });
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        int n = 0;
        int n2 = 0;
        Plot1DGraphTable plot1DGraphTable = this.lpPlotter.getColourTable();
        int n3 = this.lpPlotter.getNumHistory();
        if (linearROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add(this.roiData.getProfileData(0));
            arrayList2.add(this.roiData.getXAxis(0));
            if (linearROI.isCrossHair()) {
                if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.DASHED, "Cross Line 1");
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                    plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                    plot1DAppearance.setName("Cross Line 1");
                }
                arrayList.add(this.roiData.getProfileData(1));
                arrayList2.add(this.roiData.getXAxis(1));
            }
            ++n2;
            ++n;
        }
        int n4 = 0;
        int n5 = this.roiDataList.size();
        while (n4 < n5) {
            LinearROIData linearROIData = (LinearROIData)this.roiDataList.get(n4);
            Color color = PlotColorUtility.getDefaultColour(n4 + 1);
            RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            linearROIData.setPlotColourRGB(rGB);
            if (linearROIData.isPlot()) {
                arrayList.add(linearROIData.getProfileData(0));
                arrayList2.add(linearROIData.getXAxis(0));
                if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(color);
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                if (linearROIData.getROI().isCrossHair()) {
                    arrayList.add(linearROIData.getProfileData(1));
                    arrayList2.add(linearROIData.getXAxis(1));
                    if (++n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                        plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.DASHED, "Cross Line " + (n + 1));
                        plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                    } else {
                        plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                        plot1DAppearance.setColour(color);
                        plot1DAppearance.setStyle(Plot1DStyles.DASHED);
                        plot1DAppearance.setName("Cross Line " + (n + 1));
                    }
                }
                ++n2;
                ++n;
            }
            ++n4;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.lpPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        this.lpPlotter.updateAllAppearance();
        this.lpPlotter.refresh(false);
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        LinearROI linearROI = (LinearROI)rOIBase;
        double[] dArray = linearROI.getPoint();
        double[] dArray2 = linearROI.getEndPoint();
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawLine(n2, dArray[0], dArray[1], dArray2[0], dArray2[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.dragIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        }
        ++n;
        if (linearROI.isCrossHair()) {
            dArray = linearROI.getPerpendicularBisectorPoint(0.0);
            dArray2 = linearROI.getPerpendicularBisectorPoint(1.0);
            this.oProvider.setPrimitiveVisible(n2, true);
            this.oProvider.drawLine(n2, dArray[0], dArray[1], dArray2[0], dArray2[1]);
            this.oProvider.setColour(n2, this.oColour);
            this.oProvider.setTransparency(n2, this.oTransparency);
        } else {
            this.oProvider.setPrimitiveVisible(n2, false);
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawCurrentOverlay() {
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roiIDs.isEmpty()) {
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
        }
        int n = 0;
        LinearROI linearROI = (LinearROI)this.roi;
        double[] dArray = this.roi.getPoint();
        double[] dArray2 = linearROI.getEndPoint();
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        this.oProvider.drawArrow(n2, dArray[0], dArray[1], dArray2[0], dArray2[1], 0.6666666666666666);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.roiIDs.get(++n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        }
        ++n;
        if (linearROI.isCrossHair()) {
            double[] dArray3 = linearROI.getPerpendicularBisectorPoint(0.0);
            double[] dArray4 = linearROI.getPerpendicularBisectorPoint(1.0);
            this.oProvider.setPrimitiveVisible(n2, true);
            this.oProvider.drawLine(n2, dArray3[0], dArray3[1], dArray4[0], dArray4[1]);
            this.oProvider.setColour(n2, this.oColour);
            this.oProvider.setTransparency(n2, this.oTransparency);
        } else {
            this.oProvider.setPrimitiveVisible(n2, false);
        }
        this.getDataset();
        int n3 = this.calcHandleSize(this.data.getShape());
        int n4 = 0;
        int n5 = this.roiHandler.size();
        while (n4 < n5) {
            int n6 = (Integer)this.roiHandler.get(n4);
            if (n6 == -1) {
                n6 = this.oProvider.registerPrimitive(PrimitiveType.BOX, true);
                this.roiHandler.set(n4, n6);
            } else {
                this.oProvider.setPrimitiveVisible(n6, true);
            }
            int[] nArray = this.roiHandler.getHandlePoint(n4, n3);
            if (nArray != null) {
                this.oProvider.drawBox(n6, nArray[0], nArray[1], nArray[0] + n3, nArray[1] + n3);
                nArray = this.roiHandler.getAnchorPoint(n4, n3);
                this.oProvider.setAnchorPoints(n6, nArray[0], nArray[1]);
                this.oProvider.setStyle(n6, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setColour(n6, this.oColour);
                this.oProvider.setOutlineColour(n6, this.oColour);
                this.oProvider.setLineThickness(n6, this.oThickness);
                this.oProvider.setTransparency(n6, 0.9);
                this.oProvider.setOutlineTransparency(n6, this.oTransparency);
            }
            ++n4;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawOverlays() {
        if (this.oProvider == null) {
            return;
        }
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.roisIDs.size() != this.roiDataList.size()) {
            logger.warn("Mismatch in number of primitives and ROIs!");
        }
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        int n2 = this.roiDataList.size();
        while (n < n2) {
            int n3 = -1;
            try {
                n3 = (Integer)this.roisIDs.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.roisIDs.add(n, -1);
            }
            if (n3 == -1) {
                n3 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
                this.roisIDs.set(n, n3);
            } else {
                this.oProvider.setPrimitiveVisible(n3, true);
            }
            LinearROI linearROI = (LinearROI)((ROIData)this.roiDataList.get(n)).getROI();
            double[] dArray = linearROI.getPoint();
            double[] dArray2 = linearROI.getEndPoint();
            this.oProvider.drawArrow(n3, dArray[0], dArray[1], dArray2[0], dArray2[1]);
            this.oProvider.setColour(n3, this.oColour);
            this.oProvider.setTransparency(n3, this.oTransparency);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new LinearROI();
            this.roi.setPlot(true);
            this.roiHandler.setROI(this.roi);
        }
        int n = iImagePositionEvent.getPrimitiveID();
        short s = iImagePositionEvent.getFlags();
        this.cpt = iImagePositionEvent.getImagePosition();
        if ((s & 1) != 0) {
            if (n == -1 || !this.roiHandler.contains(n)) {
                this.roi.setPoint(this.cpt);
                if (this.oProvider != null) {
                    this.oProvider.setPlotAreaCursor(2);
                }
                this.hideCurrent();
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LineProfile.this.spsx.setSelection(LineProfile.this.roi.getIntPoint()[0]);
                        LineProfile.this.spsy.setSelection(LineProfile.this.roi.getIntPoint()[1]);
                    }
                });
                this.dragging = true;
            } else if (this.roiHandler.contains(n)) {
                int n2 = this.roiHandler.indexOf(n);
                if (n2 == 0 || n2 == 2) {
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.REORIENT;
                        this.oProvider.setPlotAreaCursor(19);
                    } else {
                        this.hStatus = HandleStatus.RESIZE;
                        this.oProvider.setPlotAreaCursor(5);
                    }
                } else if (n2 == 1) {
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                        this.oProvider.setPlotAreaCursor(3);
                    } else {
                        this.hStatus = HandleStatus.MOVE;
                        this.oProvider.setPlotAreaCursor(21);
                    }
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
            }
        } else if ((s & 2) != 0 && this.roiHandler.contains(n)) {
            int n3 = this.roiHandler.indexOf(n);
            if (n3 == 0 || n3 == 2) {
                this.hStatus = HandleStatus.REORIENT;
                this.oProvider.setPlotAreaCursor(19);
            } else if (n3 == 1) {
                this.hStatus = HandleStatus.ROTATE;
                this.oProvider.setPlotAreaCursor(3);
            }
            this.hideCurrent();
            this.drawDraggedOverlay(this.roi);
            this.dragging = true;
            this.dragHandle = n3;
        }
    }

    private LinearROI interpretMouseDragging(int[] nArray) {
        LinearROI linearROI = (LinearROI)this.roi;
        LinearROI linearROI2 = null;
        switch (this.hStatus) {
            case MOVE: {
                linearROI2 = linearROI.copy();
                linearROI2.addPoint(nArray);
                linearROI2.subPoint(this.cpt);
                break;
            }
            case NONE: {
                linearROI2 = linearROI.copy();
                linearROI2.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                linearROI2 = ((LinearROIHandler)this.roiHandler).reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                linearROI2 = ((LinearROIHandler)this.roiHandler).resize(this.dragHandle, nArray);
                break;
            }
            case ROTATE: {
                linearROI2 = linearROI.copy();
                double d = linearROI2.getAngleRelativeToMidPoint(nArray);
                double[] dArray = linearROI2.getMidPoint();
                linearROI2.setAngle(d);
                linearROI2.setMidPoint(dArray);
            }
        }
        return linearROI2;
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        LinearROI linearROI;
        if (this.dragging && (linearROI = this.interpretMouseDragging(iImagePositionEvent.getImagePosition())) != null) {
            this.drawDraggedOverlay((ROIBase)linearROI);
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                this.updatePlot((ROIBase)linearROI);
                this.sendCurrentROI((ROIBase)linearROI);
                this.updateAllSpinners((ROIBase)linearROI);
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.hideIDs(this.dragIDs);
            this.oProvider.restoreDefaultPlotAreaCursor();
            this.roi = this.interpretMouseDragging(iImagePositionEvent.getImagePosition());
            this.roiHandler.setROI(this.roi);
            this.dragHandle = -1;
            this.hStatus = HandleStatus.NONE;
            this.drawCurrentOverlay();
            this.sendCurrentROI(this.roi);
            this.updateAllSpinners(this.roi);
        }
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
        final LinearROI linearROI = (LinearROI)rOIBase;
        if (linearROI == null) {
            return;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LineProfile.this.updateAllSpinnersInt(linearROI);
            }
        });
    }

    private void updateAllSpinnersInt(LinearROI linearROI) {
        if (linearROI == null) {
            return;
        }
        this.isBulkUpdate = true;
        this.spsx.setSelection(linearROI.getIntPoint()[0]);
        this.spsy.setSelection(linearROI.getIntPoint()[1]);
        this.splen.setDouble(linearROI.getLength());
        this.spang.setDouble(linearROI.getAngleDegrees());
        this.spex.setDouble(linearROI.getEndPoint()[0]);
        this.isBulkUpdate = false;
        this.spey.setDouble(linearROI.getEndPoint()[1]);
    }

    public LinearROIList createROIList() {
        LinearROIList linearROIList = new LinearROIList();
        if (this.roiDataList != null) {
            for (ROIData rOIData : this.roiDataList) {
                linearROIList.add((Object)((LinearROI)rOIData.getROI()));
            }
        }
        return linearROIList;
    }

    @Override
    public ROIData createNewROIData(ROIBase rOIBase) {
        return new LinearROIData((LinearROI)rOIBase, this.data, 0.5);
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Line profile");
        action.setToolTipText("Switch side plot to line profile mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ProfileLine.png"));
        return action;
    }

    @Override
    public void addToHistory() {
        Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.lpPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.lpPlotter.getNumHistory());
        this.lpPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.lpPlotter.pushGraphOntoHistory();
    }

    @Override
    public void removeFromHistory() {
        if (this.lpPlotter.getNumHistory() > 0) {
            this.lpPlotter.getColourTable().deleteLegendEntry(this.lpPlotter.getColourTable().getLegendSize() - 1);
            this.lpPlotter.popGraphFromHistory();
            this.lpPlotter.refresh(true);
        }
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        this.createExportActions();
        this.createHistoryActions();
        this.createPushPlotActions();
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "historyActions"));
        iToolBarManager.add((IAction)this.addtoHistory);
        iToolBarManager.add((IAction)this.removefromHistory);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushPlotActions"));
        iToolBarManager.add((IAction)this.pushPlottingData);
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
        this.createExportActions();
        this.createHistoryActions();
        this.createPushPlotActions();
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iMenuManager.add((IAction)this.saveGraph);
        iMenuManager.add((IAction)this.copyGraph);
        iMenuManager.add((IAction)this.printGraph);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "historyActions"));
        iMenuManager.add((IAction)this.addtoHistory);
        iMenuManager.add((IAction)this.removefromHistory);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushPlotActions"));
        iMenuManager.add((IAction)this.pushPlottingDataPlot1);
        iMenuManager.add((IAction)this.pushPlottingDataPlot2);
    }

    private void createExportActions() {
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(LineProfile.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                LineProfile.this.lpPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                LineProfile.this.lpPlotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                LineProfile.this.lpPlotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
    }

    private void createHistoryActions() {
        this.addtoHistory = new Action(){

            public void run() {
                LineProfile.this.addToHistory();
            }
        };
        this.addtoHistory.setText("Add current profiles to history");
        this.addtoHistory.setToolTipText("Add the current profiles to the plot history");
        this.addtoHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_put.png"));
        this.removefromHistory = new Action(){

            public void run() {
                LineProfile.this.removeFromHistory();
            }
        };
        this.removefromHistory.setText("Remove last profiles from history");
        this.removefromHistory.setToolTipText("Remove the last profiles from the plot history");
        this.removefromHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_remove.png"));
    }

    private void createPushPlotActions() {
        final IWorkbenchPartSite iWorkbenchPartSite = EclipseUtils.getPage().getActivePart().getSite();
        this.pushPlottingDataPlot1 = new Action(){

            public void run() {
                LineProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView1", 0);
            }
        };
        this.pushPlottingDataPlot1.setText("Push line profiles to plot 1");
        Image image = SWTResourceManager.getImage(StaticScanPlotView.class, "/icons/chart_curve_add.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.pushPlottingDataPlot1.setImageDescriptor(imageDescriptor);
        this.pushPlottingDataPlot1.setToolTipText("Push line profiles to plot 1");
        this.pushPlottingDataPlot2 = new Action(){

            public void run() {
                LineProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView2", 0);
            }
        };
        this.pushPlottingDataPlot2.setText("Push line profiles to plot 2");
        this.pushPlottingDataPlot2.setImageDescriptor(imageDescriptor);
        this.pushPlottingDataPlot2.setToolTipText("Push line profiles to plot 2");
        this.pushPlottingData = new DropDownAction();
        this.pushPlottingData.setToolTipText("Push plotting to plot 1 or 2");
        this.pushPlottingData.setImageDescriptor(imageDescriptor);
        this.pushPlottingData.add(this.pushPlottingDataPlot1);
        this.pushPlottingData.add(this.pushPlottingDataPlot2);
    }

    private static enum HandleStatus {
        NONE,
        MOVE,
        RESIZE,
        REORIENT,
        ROTATE;

    }
}

