/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider2;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.PointListObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;

public class InfoSidePlot
extends SidePlot
implements Overlay2DConsumer,
SelectionListener {
    private Text txtMaxValue;
    private Text txtMinValue;
    private Button btnShowMax;
    private Button btnShowMin;
    private List<Integer> xMaxPos = new ArrayList<Integer>();
    private List<Integer> yMaxPos = new ArrayList<Integer>();
    private List<Integer> xMinPos = new ArrayList<Integer>();
    private List<Integer> yMinPos = new ArrayList<Integer>();
    private Overlay2DProvider2 provider = null;
    private PointListObject maxPoints = null;
    private PointListObject minPoints = null;

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setId("uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.InfoSidePlot");
        action.setText("Information");
        action.setToolTipText("Get some raw information");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/new.png"));
        return action;
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(this.container, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("Dataset information");
        Label label = new Label((Composite)group, 0);
        label.setText("Maximum data value: ");
        this.txtMaxValue = new Text((Composite)group, 0);
        this.txtMaxValue.setEditable(false);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, false);
        gridData.minimumWidth = 80;
        gridData.widthHint = 80;
        this.txtMaxValue.setLayoutData((Object)gridData);
        this.txtMaxValue.setText(Integer.toString(0));
        this.btnShowMax = new Button((Composite)group, 2);
        this.btnShowMax.setText("Show position(s) in plot");
        this.btnShowMax.addSelectionListener((SelectionListener)this);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Minimum data value: ");
        this.txtMinValue = new Text((Composite)group, 0);
        this.txtMinValue.setEditable(false);
        this.txtMinValue.setLayoutData((Object)gridData);
        this.txtMinValue.setText(Integer.toString(0));
        this.btnShowMin = new Button((Composite)group, 2);
        this.btnShowMin.setText("Show position(s) in plot");
        this.btnShowMin.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
    }

    private boolean determineMinMaxXYPos(IDataset iDataset, float f, float f2) {
        boolean bl = false;
        if (iDataset instanceof DoubleDataset) {
            DoubleDataset doubleDataset = (DoubleDataset)iDataset;
            double[] dArray = doubleDataset.getData();
            IndexIterator indexIterator = doubleDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray;
                if (dArray[indexIterator.index] == (double)f2) {
                    nArray = doubleDataset.getNDPosition(indexIterator.index);
                    if (nArray.length > 1) {
                        this.yMaxPos.add(nArray[0]);
                        this.xMaxPos.add(nArray[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray[0]);
                    continue;
                }
                if (dArray[indexIterator.index] != (double)f) continue;
                nArray = doubleDataset.getNDPosition(indexIterator.index);
                if (nArray.length > 1) {
                    this.yMinPos.add(nArray[0]);
                    this.xMinPos.add(nArray[1]);
                    continue;
                }
                this.xMinPos.add(nArray[0]);
            }
        } else if (iDataset instanceof FloatDataset) {
            FloatDataset floatDataset = (FloatDataset)iDataset;
            float[] fArray = floatDataset.getData();
            IndexIterator indexIterator = floatDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray;
                if (fArray[indexIterator.index] == f2) {
                    nArray = floatDataset.getNDPosition(indexIterator.index);
                    if (nArray.length > 1) {
                        this.yMaxPos.add(nArray[0]);
                        this.xMaxPos.add(nArray[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray[0]);
                    continue;
                }
                if (fArray[indexIterator.index] != f) continue;
                nArray = floatDataset.getNDPosition(indexIterator.index);
                if (nArray.length > 1) {
                    this.yMinPos.add(nArray[0]);
                    this.xMinPos.add(nArray[1]);
                    continue;
                }
                this.xMinPos.add(nArray[0]);
            }
        } else if (iDataset instanceof LongDataset) {
            LongDataset longDataset = (LongDataset)iDataset;
            long[] lArray = longDataset.getData();
            IndexIterator indexIterator = longDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray;
                if (lArray[indexIterator.index] == (long)f2) {
                    nArray = longDataset.getNDPosition(indexIterator.index);
                    if (nArray.length > 1) {
                        this.yMaxPos.add(nArray[0]);
                        this.xMaxPos.add(nArray[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray[0]);
                    continue;
                }
                if (lArray[indexIterator.index] != (long)f) continue;
                nArray = longDataset.getNDPosition(indexIterator.index);
                if (nArray.length > 1) {
                    this.yMinPos.add(nArray[0]);
                    this.xMinPos.add(nArray[1]);
                    continue;
                }
                this.xMinPos.add(nArray[0]);
            }
        } else if (iDataset instanceof IntegerDataset) {
            IntegerDataset integerDataset = (IntegerDataset)iDataset;
            int[] nArray = integerDataset.getData();
            IndexIterator indexIterator = integerDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray2;
                if (nArray[indexIterator.index] == (int)f2) {
                    nArray2 = integerDataset.getNDPosition(indexIterator.index);
                    if (nArray2.length > 1) {
                        this.yMaxPos.add(nArray2[0]);
                        this.xMaxPos.add(nArray2[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray2[0]);
                    continue;
                }
                if (nArray[indexIterator.index] != (int)f) continue;
                nArray2 = integerDataset.getNDPosition(indexIterator.index);
                if (nArray2.length > 1) {
                    this.yMinPos.add(nArray2[0]);
                    this.xMinPos.add(nArray2[1]);
                    continue;
                }
                this.xMinPos.add(nArray2[0]);
            }
        } else if (iDataset instanceof ShortDataset) {
            ShortDataset shortDataset = (ShortDataset)iDataset;
            short[] sArray = shortDataset.getData();
            IndexIterator indexIterator = shortDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray;
                if (sArray[indexIterator.index] == (short)f2) {
                    nArray = shortDataset.getNDPosition(indexIterator.index);
                    if (nArray.length > 1) {
                        this.yMaxPos.add(nArray[0]);
                        this.xMaxPos.add(nArray[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray[0]);
                    continue;
                }
                if (sArray[indexIterator.index] != (short)f) continue;
                nArray = shortDataset.getNDPosition(indexIterator.index);
                if (nArray.length > 1) {
                    this.yMinPos.add(nArray[0]);
                    this.xMinPos.add(nArray[1]);
                    continue;
                }
                this.xMinPos.add(nArray[0]);
            }
        } else if (iDataset instanceof ByteDataset) {
            ByteDataset byteDataset = (ByteDataset)iDataset;
            byte[] byArray = byteDataset.getData();
            IndexIterator indexIterator = byteDataset.getIterator();
            while (indexIterator.hasNext()) {
                int[] nArray;
                if (byArray[indexIterator.index] == (byte)f2) {
                    nArray = byteDataset.getNDPosition(indexIterator.index);
                    if (nArray.length > 1) {
                        this.yMaxPos.add(nArray[0]);
                        this.xMaxPos.add(nArray[1]);
                        continue;
                    }
                    this.xMaxPos.add(nArray[0]);
                    continue;
                }
                if (byArray[indexIterator.index] != (byte)f) continue;
                nArray = byteDataset.getNDPosition(indexIterator.index);
                if (nArray.length > 1) {
                    this.yMinPos.add(nArray[0]);
                    this.xMinPos.add(nArray[1]);
                    continue;
                }
                this.xMinPos.add(nArray[0]);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void processPlotUpdate() {
        if (this.mainPlotter == null) {
            return;
        }
        List<IDataset> list = this.mainPlotter.getCurrentDataSets();
        this.xMaxPos.clear();
        this.yMaxPos.clear();
        this.xMinPos.clear();
        this.yMinPos.clear();
        if (this.minPoints != null) {
            this.minPoints = null;
        }
        if (this.maxPoints != null) {
            this.maxPoints = null;
        }
        if (list != null && list.size() > 0) {
            IDataset iDataset = list.get(0);
            final float f = iDataset.min().floatValue();
            final float f2 = iDataset.max().floatValue();
            final boolean bl = this.determineMinMaxXYPos(iDataset, f, f2);
            this.txtMaxValue.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InfoSidePlot.this.txtMaxValue.setText(Float.toString(f2));
                    InfoSidePlot.this.txtMinValue.setText(Float.toString(f));
                    InfoSidePlot.this.btnShowMax.setEnabled(!bl);
                    InfoSidePlot.this.btnShowMin.setEnabled(!bl);
                    InfoSidePlot.this.btnShowMax.setSelection(false);
                    InfoSidePlot.this.btnShowMin.setSelection(false);
                }
            });
        }
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public void showSidePlot() {
        this.processPlotUpdate();
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        return 0;
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        if (overlayProvider instanceof Overlay2DProvider2) {
            this.provider = (Overlay2DProvider2)overlayProvider;
        }
    }

    @Override
    public void removePrimitives() {
        if (this.maxPoints != null) {
            this.maxPoints = null;
        }
        if (this.minPoints != null) {
            this.minPoints = null;
        }
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void hideOverlays() {
    }

    @Override
    public void showOverlays() {
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void displayMax() {
        if (this.provider != null) {
            if (this.maxPoints == null) {
                this.maxPoints = (PointListObject)this.provider.registerObject(PrimitiveType.POINTLIST);
            }
            double[] dArray = new double[this.xMaxPos.size()];
            double[] dArray2 = new double[this.yMaxPos.size()];
            int n = 0;
            Iterator<Integer> iterator = this.xMaxPos.iterator();
            Iterator<Integer> iterator2 = this.yMaxPos.iterator();
            while (iterator.hasNext()) {
                dArray[n] = iterator.next().intValue();
                dArray2[n++] = iterator2.next().intValue();
            }
            this.maxPoints.setPointPositions(dArray, dArray2);
            this.provider.begin(OverlayType.VECTOR2D);
            this.maxPoints.setColour(Color.RED);
            this.maxPoints.setThick(true);
            this.maxPoints.draw();
            this.provider.end(OverlayType.VECTOR2D);
        }
    }

    private void displayMin() {
        if (this.provider != null) {
            if (this.minPoints == null) {
                this.minPoints = (PointListObject)this.provider.registerObject(PrimitiveType.POINTLIST);
            }
            double[] dArray = new double[this.xMinPos.size()];
            double[] dArray2 = new double[this.yMinPos.size()];
            int n = 0;
            Iterator<Integer> iterator = this.xMinPos.iterator();
            Iterator<Integer> iterator2 = this.yMinPos.iterator();
            while (iterator.hasNext()) {
                dArray[n] = iterator.next().intValue();
                dArray2[n++] = iterator2.next().intValue();
            }
            this.minPoints.setPointPositions(dArray, dArray2);
            this.provider.begin(OverlayType.VECTOR2D);
            this.minPoints.setColour(Color.BLUE);
            this.minPoints.setThick(true);
            this.minPoints.draw();
            this.provider.end(OverlayType.VECTOR2D);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.btnShowMax)) {
            if (this.btnShowMax.getSelection()) {
                if (this.maxPoints == null) {
                    this.displayMax();
                } else if (this.provider != null) {
                    this.provider.begin(OverlayType.VECTOR2D);
                    this.maxPoints.setVisible(true);
                    this.provider.end(OverlayType.VECTOR2D);
                }
            } else if (this.maxPoints != null && this.provider != null) {
                this.provider.begin(OverlayType.VECTOR2D);
                this.maxPoints.setVisible(false);
                this.provider.end(OverlayType.VECTOR2D);
            }
        } else if (selectionEvent.getSource().equals(this.btnShowMin)) {
            if (this.btnShowMin.getSelection()) {
                if (this.minPoints == null) {
                    this.displayMin();
                } else if (this.provider != null) {
                    this.provider.begin(OverlayType.VECTOR2D);
                    this.minPoints.setVisible(true);
                    this.provider.end(OverlayType.VECTOR2D);
                }
            } else if (this.minPoints != null && this.provider != null) {
                this.provider.begin(OverlayType.VECTOR2D);
                this.minPoints.setVisible(false);
                this.provider.end(OverlayType.VECTOR2D);
            }
        }
    }
}

