/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.GridROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.GridROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.GridROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;
import uk.ac.diamond.scisoft.analysis.roi.GridPreferences;
import uk.ac.diamond.scisoft.analysis.roi.GridROI;
import uk.ac.diamond.scisoft.analysis.roi.GridROIList;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;

public class GridProfile
extends SidePlotProfile {
    private static Logger logger = LoggerFactory.getLogger(GridProfile.class);
    private GridPreferences gridPrefs;
    private Color rColour = new Color(255, 0, 0);
    private List<Integer> beamlineIDs;
    private IPropertyChangeListener propListener;
    private HandleStatus hStatus = HandleStatus.NONE;
    private FloatSpinner spsx;
    private FloatSpinner spsy;
    private FloatSpinner resx;
    private FloatSpinner resy;
    private FloatSpinner splmaj;
    private FloatSpinner splmin;
    private FloatSpinner spang;
    private Button midpoint;
    private Button gridpoint;
    private Color pointColor = Color.WHITE;
    private Text tdim;
    private SelectionListener midpointListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            GridROI gridROI = (GridROI)GridProfile.this.roi;
            if (((Button)selectionEvent.widget).getSelection()) {
                gridROI.setMidPointOn(true);
            } else {
                gridROI.setMidPointOn(false);
            }
            GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GridProfile.this.updatePlot();
                    GridProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener gridpointListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            GridROI gridROI = (GridROI)GridProfile.this.roi;
            if (((Button)selectionEvent.widget).getSelection()) {
                gridROI.setGridLineOn(true);
            } else {
                gridROI.setGridLineOn(false);
            }
            GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GridProfile.this.updatePlot();
                    GridProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener resolutionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            double d = GridProfile.this.getGridPrefs().getXPixelsFromMicronsLen(GridProfile.this.resx.getDouble());
            double d2 = GridProfile.this.getGridPrefs().getYPixelsFromMicronsLen(GridProfile.this.resy.getDouble());
            GridROI gridROI = (GridROI)GridProfile.this.roi;
            if (gridROI != null) {
                gridROI.setxySpacing(d, d2);
                GridProfile.this.sendCurrentROI(GridProfile.this.roi);
                GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridProfile.this.updatePlot();
                        GridProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener startPosListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (GridProfile.this.roi == null) {
                return;
            }
            GridProfile.this.roi.setPoint(GridProfile.this.getGridPrefs().getXPixelsFromMicronsCoord(GridProfile.this.spsx.getDouble()), GridProfile.this.getGridPrefs().getYPixelsFromMicronsCoord(GridProfile.this.spsy.getDouble()));
            GridProfile.this.sendCurrentROI(GridProfile.this.roi);
            GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GridProfile.this.updatePlot();
                    GridProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener lensListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            final GridROI gridROI = (GridROI)GridProfile.this.roi;
            if (gridROI != null) {
                gridROI.setLengths(GridProfile.this.getGridPrefs().getXPixelsFromMicronsLen(GridProfile.this.splmaj.getDouble()), GridProfile.this.getGridPrefs().getYPixelsFromMicronsLen(GridProfile.this.splmin.getDouble()));
                GridProfile.this.sendCurrentROI(GridProfile.this.roi);
                GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridProfile.this.splmaj.setDouble(GridProfile.this.getGridPrefs().getXMicronsFromPixelsLen(gridROI.getLengths()[0]));
                        GridProfile.this.splmin.setDouble(GridProfile.this.getGridPrefs().getYMicronsFromPixelsLen(gridROI.getLengths()[1]));
                        GridProfile.this.updatePlot();
                        GridProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener angListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            GridROI gridROI = (GridROI)GridProfile.this.roi;
            if (gridROI != null) {
                gridROI.setAngleDegrees(GridProfile.this.spang.getDouble());
                GridProfile.this.sendCurrentROI(GridProfile.this.roi);
                GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridProfile.this.updatePlot();
                        GridProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };

    public GridProfile() {
        this.roiClass = GridROI.class;
        this.roiListClass = GridROIList.class;
    }

    @Override
    public void createPartControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.container, 512);
        Composite composite2 = new Composite((Composite)sashForm, 0);
        composite2.setLayout((Layout)new FillLayout(256));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("Grid Settings");
        new Label((Composite)group, 0).setText("X-axis resolution:");
        this.resx = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.resx.setMinimum(0.0);
        this.resx.addSelectionListener(this.resolutionListener);
        new Label((Composite)group, 0).setText("microns.");
        new Label((Composite)group, 0).setText("Y-axis resolution:");
        this.resy = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.resy.setMinimum(0.0);
        this.resy.addSelectionListener(this.resolutionListener);
        new Label((Composite)group, 0).setText("microns.");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.midpoint = new Button((Composite)group, 32);
        this.midpoint.setLayoutData((Object)gridData);
        this.midpoint.setText("Display grid mid-points");
        this.midpoint.setToolTipText("Toggles the visibility of the grid mid-points");
        this.midpoint.addSelectionListener(this.midpointListener);
        Object object = new GridData();
        object.horizontalSpan = 4;
        this.gridpoint = new Button((Composite)group, 32);
        this.gridpoint.setLayoutData(object);
        this.gridpoint.setText("Display gridlines");
        this.gridpoint.setToolTipText("Toggles the visibility of the gridlines");
        this.gridpoint.addSelectionListener(this.gridpointListener);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 4;
        Button button = new Button((Composite)group, 32);
        button.setLayoutData((Object)gridData2);
        button.setText("Invert brightness");
        button.setToolTipText("Invert overlay brightness");
        button.addSelectionListener(this.brightnessButtonListener);
        this.addControlWidgets(composite2);
        group = new Composite((Composite)sashForm, 0);
        group.setLayout((Layout)new FillLayout(512));
        gridData = new Group((Composite)group, 0);
        gridData.setLayout((Layout)new GridLayout(6, false));
        gridData.setText("Current ROI");
        new Label((Composite)gridData, 0).setText("Start x:");
        this.spsx = new FloatSpinner((Composite)gridData, 2048, 6, 2);
        this.spsx.addSelectionListener(this.startPosListener);
        new Label((Composite)gridData, 0).setText("Length major:");
        this.splmaj = new FloatSpinner((Composite)gridData, 2048, 6, 2);
        this.splmaj.addSelectionListener(this.lensListener);
        object = new Label((Composite)gridData, 16384);
        object.setText("Angle:");
        gridData2 = new GridData(131072, 0x1000000, false, false, 1, 1);
        object.setLayoutData((Object)gridData2);
        this.spang = new FloatSpinner((Composite)gridData, 2048, 7, 2);
        this.spang.setMinimum(0.0);
        this.spang.setMaximum(360.0);
        this.spang.addSelectionListener(this.angListener);
        new Label((Composite)gridData, 0).setText("Start y:");
        this.spsy = new FloatSpinner((Composite)gridData, 2048, 6, 2);
        this.spsy.addSelectionListener(this.startPosListener);
        new Label((Composite)gridData, 0).setText("Length minor:");
        this.splmin = new FloatSpinner((Composite)gridData, 2048, 6, 2);
        this.splmin.addSelectionListener(this.lensListener);
        new Label((Composite)gridData, 0).setText("Grid dimensions:");
        this.tdim = new Text((Composite)gridData, 2048);
        button = new GridData(16384, 0x1000000, false, false, 1, 1);
        button.widthHint = 145;
        this.tdim.setLayoutData((Object)button);
        this.tdim.setEditable(false);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        Button button2 = new Button((Composite)gridData, 8);
        button2.setLayoutData((Object)gridData3);
        button2.setText("Copy current to table");
        button2.addSelectionListener(this.copyButtonListener);
        gridData = new Composite((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{20, 15, 15});
        gridData.setLayout((Layout)new FillLayout());
        this.tViewer = new GridROITableViewer((Composite)gridData, this, this, this);
        this.updateAllSpinnersInt((GridROI)this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        this.beamlineIDs = new ArrayList<Integer>();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.tViewer.setInput(this.roiDataList);
        this.roiHandler = new GridROIHandler((GridROI)this.roi);
        this.dColour = new Color(0, 255, 0);
        object = Color.RGBtoHSB(this.dColour.getRed(), this.dColour.getGreen(), this.dColour.getBlue(), null);
        this.cColour = Color.getHSBColor((float)object[0], (float)object[1], (float)(1.0 - 0.7 * (double)object[2]));
        this.oColour = this.dColour;
        this.addPropertyListeners();
    }

    protected void addControlWidgets(Composite composite) {
    }

    private void addPropertyListeners() {
        AnalysisRCPActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (string.equals("gridscan.res.x") || string.equals("gridscan.res.y") || string.equals("gridscan.beamline.posx") || string.equals("gridscan.beamline.posy")) {
                    IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
                    double d = iPreferenceStore.isDefault("gridscan.res.x") ? iPreferenceStore.getDefaultDouble("gridscan.res.x") : iPreferenceStore.getDouble("gridscan.res.x");
                    GridProfile.this.getGridPrefs().setResolutionX(d);
                    double d2 = iPreferenceStore.isDefault("gridscan.res.y") ? iPreferenceStore.getDefaultDouble("gridscan.res.y") : iPreferenceStore.getDouble("gridscan.res.y");
                    GridProfile.this.getGridPrefs().setResolutionY(d2);
                    double d3 = iPreferenceStore.isDefault("gridscan.beamline.posx") ? iPreferenceStore.getDefaultDouble("gridscan.beamline.posx") : iPreferenceStore.getDouble("gridscan.beamline.posx");
                    GridProfile.this.getGridPrefs().setBeamlinePosX(d3);
                    double d4 = iPreferenceStore.isDefault("gridscan.beamline.posy") ? iPreferenceStore.getDefaultDouble("gridscan.beamline.posy") : iPreferenceStore.getDouble("gridscan.beamline.posy");
                    GridProfile.this.getGridPrefs().setBeamlinePosY(d4);
                    GridProfile.this.sendPreferences(GridProfile.this.getGridPrefs());
                    GridProfile.this.updateAllSpinners(GridProfile.this.roi);
                    GridProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).GridProfile.this.tViewer.refresh();
                            GridProfile.this.drawEverything();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.propListener != null) {
            AnalysisRCPActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.propListener);
        }
    }

    @Override
    public void unregisterProvider() {
        super.unregisterProvider();
        this.hideIDs(this.beamlineIDs);
    }

    @Override
    public void hideOverlays() {
        super.hideOverlays();
        this.hideIDs(this.beamlineIDs);
    }

    @Override
    public void showOverlays() {
        super.showOverlays();
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GridProfile.this.drawBeamlineCentre();
            }
        });
    }

    @Override
    public void removePrimitives() {
        if (this.oProvider == null) {
            return;
        }
        super.removePrimitives();
        this.removeIDs(this.beamlineIDs);
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        GridROI gridROI = (GridROI)rOIBase;
        this.getDataset();
        if (this.data == null) {
            logger.warn("No data");
            return;
        }
        if (gridROI != null) {
            this.roiData = new GridROIData(gridROI, this.data);
            if (!this.roiData.isPlot()) {
                return;
            }
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        GridROI gridROI = (GridROI)rOIBase;
        int[] nArray = gridROI.getIntPoint();
        int[] nArray2 = gridROI.getIntLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawBox(n2, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
        this.oProvider.rotatePrimitive(n2, -gridROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawCurrentOverlay() {
        int n;
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roiIDs.isEmpty()) {
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
        }
        int n2 = 0;
        GridROI gridROI = (GridROI)this.roi;
        int[] nArray = gridROI.getIntPoint();
        int[] nArray2 = gridROI.getIntLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n3 = (Integer)this.roiIDs.get(n2);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.roiIDs.set(n2, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n2;
        this.oProvider.drawBox(n3, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
        this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n3, this.oColour);
        this.oProvider.setTransparency(n3, 0.9);
        this.oProvider.setStyle(n3, VectorOverlayStyles.FILLED);
        n3 = (Integer)this.roiIDs.get(n2);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n2, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n2;
        this.oProvider.drawArrow(n3, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1], 0.6666666666666666);
        this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n3, this.oColour);
        this.oProvider.setTransparency(n3, this.oTransparency);
        n3 = (Integer)this.roiIDs.get(n2);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n2, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n2;
        this.oProvider.drawArrow(n3, nArray[0], nArray[1], nArray[0], nArray[1] + nArray2[1], 0.3333333333333333);
        this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
        this.oProvider.setColour(n3, this.oColour);
        this.oProvider.setTransparency(n3, this.oTransparency);
        this.getDataset();
        int n4 = this.calcHandleSize(this.data.getShape());
        int n5 = 0;
        int n6 = this.roiHandler.size();
        while (n5 < n6) {
            n = (Integer)this.roiHandler.get(n5);
            if (n == -1) {
                n = this.oProvider.registerPrimitive(PrimitiveType.BOX, true);
                this.roiHandler.set(n5, n);
            } else {
                this.oProvider.setPrimitiveVisible(n, true);
            }
            int[] nArray3 = this.roiHandler.getHandlePoint(n5, n4);
            if (nArray3 == null) {
                this.oProvider.setPrimitiveVisible(n, false);
            } else {
                this.oProvider.drawBox(n, nArray3[0], nArray3[1], nArray3[0] + n4, nArray3[1] + n4);
                nArray3 = this.roiHandler.getAnchorPoint(n5, n4);
                this.oProvider.rotatePrimitive(n, -gridROI.getAngle(), nArray3[0], nArray3[1]);
                this.oProvider.setAnchorPoints(n, nArray3[0], nArray3[1]);
                this.oProvider.setStyle(n, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setColour(n, this.oColour);
                this.oProvider.setOutlineColour(n, this.oColour);
                this.oProvider.setLineThickness(n, this.oThickness);
                this.oProvider.setTransparency(n, 0.9);
                this.oProvider.setOutlineTransparency(n, this.oTransparency);
            }
            ++n5;
        }
        if (this.roiIDs.size() == n2) {
            this.roiIDs.add(-1);
        }
        if ((n3 = ((Integer)this.roiIDs.get(n2)).intValue()) == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.POINTLIST);
            this.roiIDs.set(n2, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n2;
        if (gridROI.isMidPointOn()) {
            double[][] dArray = gridROI.getGridPoints();
            n6 = dArray[0].length;
            n = dArray[1].length;
            if (n6 > 0 && n > 0) {
                int n7 = n6 * n;
                int[] nArray4 = new int[n7];
                int[] nArray5 = new int[n7];
                double[] dArray2 = new double[n7];
                double[] dArray3 = new double[n7];
                int n8 = 0;
                int n9 = 0;
                while (n9 < n6) {
                    int n10 = 0;
                    while (n10 < n) {
                        nArray4[n8] = (int)dArray[0][n9];
                        nArray5[n8] = (int)dArray[1][n10];
                        dArray2[n8] = dArray[0][n9];
                        dArray3[n8] = dArray[1][n10];
                        ++n8;
                        ++n10;
                    }
                    ++n9;
                }
                this.oProvider.drawPoints(n3, dArray2, dArray3);
                this.oProvider.setThickPoints(n3, true);
                this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
                this.oProvider.setColour(n3, this.pointColor);
                this.oProvider.setTransparency(n3, 0.0);
            } else {
                this.oProvider.setPrimitiveVisible(n3, false);
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, false);
        }
        if (gridROI.isGridLineOn()) {
            double[][] dArray = gridROI.getGridLines();
            n6 = dArray[0].length;
            n = dArray[1].length;
            if (n6 != 0 && n != 0) {
                int n11 = 0;
                while (n11 < n6) {
                    if (this.roiIDs.size() == n2) {
                        this.roiIDs.add(-1);
                    }
                    if ((n3 = ((Integer)this.roiIDs.get(n2)).intValue()) == -1) {
                        n3 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
                        this.roiIDs.set(n2, n3);
                        if (n3 == -1) {
                            return;
                        }
                    } else {
                        this.oProvider.setPrimitiveVisible(n3, true);
                    }
                    ++n2;
                    this.oProvider.drawLine(n3, dArray[0][n11], nArray[1], dArray[0][n11], nArray[1] + nArray2[1]);
                    this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
                    this.oProvider.setColour(n3, Color.BLACK);
                    this.oProvider.setTransparency(n3, 0.0);
                    ++n11;
                }
                n11 = 0;
                while (n11 < n) {
                    if (this.roiIDs.size() == n2) {
                        this.roiIDs.add(-1);
                    }
                    if ((n3 = ((Integer)this.roiIDs.get(n2)).intValue()) == -1) {
                        n3 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
                        this.roiIDs.set(n2, n3);
                        if (n3 == -1) {
                            return;
                        }
                    } else {
                        this.oProvider.setPrimitiveVisible(n3, true);
                    }
                    ++n2;
                    this.oProvider.drawLine(n3, nArray[0], dArray[1][n11], nArray[0] + nArray2[0], dArray[1][n11]);
                    this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
                    this.oProvider.setColour(n3, Color.BLACK);
                    this.oProvider.setTransparency(n3, 0.0);
                    ++n11;
                }
            }
        }
        this.oProvider.end(OverlayType.VECTOR2D);
        List<Integer> list = this.roiIDs.subList(n2, this.roiIDs.size());
        this.oProvider.unregisterPrimitive(list);
        while (n2 < this.roiIDs.size()) {
            this.roiIDs.set(n2, -1);
            ++n2;
        }
    }

    @Override
    protected void drawOverlays() {
        if (this.oProvider == null) {
            return;
        }
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.roisIDs.size() != this.roiDataList.size()) {
            logger.warn("Mismatch in number of primitives and ROIs!");
        }
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        int n2 = this.roiDataList.size();
        while (n < n2) {
            int n3 = -1;
            try {
                n3 = (Integer)this.roisIDs.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.roisIDs.add(n, -1);
            }
            if (n3 == -1) {
                n3 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                this.roisIDs.set(n, n3);
            } else {
                this.oProvider.setPrimitiveVisible(n3, true);
            }
            GridROI gridROI = (GridROI)((ROIData)this.roiDataList.get(n)).getROI();
            int[] nArray = gridROI.getIntPoint();
            int[] nArray2 = gridROI.getIntLengths();
            this.oProvider.drawBox(n3, nArray[0], nArray[1], nArray[0] + nArray2[0], nArray[1] + nArray2[1]);
            this.oProvider.rotatePrimitive(n3, -gridROI.getAngle(), nArray[0], nArray[1]);
            this.oProvider.setColour(n3, this.oColour);
            this.oProvider.setTransparency(n3, this.oTransparency);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void drawBeamlineCentre() {
        int[] nArray;
        if (this.oProvider == null) {
            return;
        }
        if (this.beamlineIDs.isEmpty()) {
            this.beamlineIDs.add(-1);
            this.beamlineIDs.add(-1);
            this.beamlineIDs.add(-1);
        }
        int n = 0;
        if (this.mainPlotter == null) {
            nArray = new int[]{100, 100};
        } else {
            this.getDataset();
            nArray = this.data.getShape();
        }
        int n2 = this.calcHandleSize(nArray);
        int n3 = this.beamlineIDs.get(n);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE, true);
            this.beamlineIDs.set(n, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n;
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n4 = (int)this.getGridPrefs().getBeamlinePosX();
        int n5 = (int)this.getGridPrefs().getBeamlinePosY();
        this.oProvider.drawCircle(n3, n4, n5, n2 / 2);
        this.oProvider.setAnchorPoints(n3, n4, n5);
        this.oProvider.setColour(n3, this.rColour);
        this.oProvider.setStyle(n3, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.oProvider.setOutlineColour(n3, this.rColour);
        this.oProvider.setLineThickness(n3, this.oThickness);
        this.oProvider.setTransparency(n3, 0.9);
        this.oProvider.setOutlineTransparency(n3, this.oTransparency);
        n3 = this.beamlineIDs.get(n);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.LINE, true);
            this.beamlineIDs.set(n, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n;
        this.oProvider.drawLine(n3, n4 - n2 / 2, n5, n4 + n2 / 2, n5);
        this.oProvider.setAnchorPoints(n3, n4, n5);
        this.oProvider.setColour(n3, this.rColour);
        this.oProvider.setTransparency(n3, this.oTransparency);
        n3 = this.beamlineIDs.get(n);
        if (n3 == -1) {
            n3 = this.oProvider.registerPrimitive(PrimitiveType.LINE, true);
            this.beamlineIDs.set(n, n3);
            if (n3 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n3, true);
        }
        ++n;
        this.oProvider.drawLine(n3, n4, n5 - n2 / 2, n4, n5 + n2 / 2);
        this.oProvider.setAnchorPoints(n3, n4, n5);
        this.oProvider.setColour(n3, this.rColour);
        this.oProvider.setTransparency(n3, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new GridROI(this.gridPrefs);
            this.roiHandler.setROI(this.roi);
        }
        int n = iImagePositionEvent.getPrimitiveID();
        short s = iImagePositionEvent.getFlags();
        this.cpt = iImagePositionEvent.getImagePosition();
        if ((s & 1) != 0) {
            if (n == -1 || !this.roiHandler.contains(n)) {
                this.roi.setPoint(this.cpt);
                this.hideCurrent();
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GridProfile.this.spsx.setDouble(GridProfile.this.getGridPrefs().getXMicronsFromPixelsCoord(GridProfile.this.roi.getPoint()[0]));
                        GridProfile.this.spsy.setDouble(GridProfile.this.getGridPrefs().getYMicronsFromPixelsCoord(GridProfile.this.roi.getPoint()[1]));
                    }
                });
                this.hStatus = HandleStatus.RESIZE;
                this.dragging = true;
            } else if (this.roiHandler.contains(n)) {
                int n2 = this.roiHandler.indexOf(n);
                if (n2 != 4) {
                    this.hStatus = HandleStatus.RESIZE;
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.REORIENT;
                        if (n2 % 2 == 1) {
                            this.hStatus = HandleStatus.ROTATE;
                        }
                    }
                } else if (n2 == 4) {
                    this.hStatus = HandleStatus.MOVE;
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                    }
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
                logger.debug("Selected handle {}", (Object)n2);
            }
        } else if ((s & 2) != 0 && this.roiHandler.contains(n)) {
            int n3 = this.roiHandler.indexOf(n);
            if (n3 != 4) {
                this.hStatus = HandleStatus.REORIENT;
                if (n3 % 2 == 1) {
                    this.hStatus = HandleStatus.ROTATE;
                }
            } else if (n3 == 4) {
                this.hStatus = HandleStatus.ROTATE;
            }
            this.hideCurrent();
            this.drawDraggedOverlay(this.roi);
            this.dragging = true;
            this.dragHandle = n3;
        }
    }

    private GridROI interpretMouseDragging(int[] nArray) {
        GridROI gridROI = null;
        GridROI gridROI2 = (GridROI)this.roi;
        switch (this.hStatus) {
            case MOVE: {
                gridROI = gridROI2.copy();
                nArray[0] = nArray[0] - this.cpt[0];
                nArray[1] = nArray[1] - this.cpt[1];
                gridROI.addPoint(nArray);
                break;
            }
            case NONE: {
                gridROI = gridROI2.copy();
                gridROI.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                gridROI = (GridROI)((RectangularROIHandler)this.roiHandler).reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                gridROI = (GridROI)((RectangularROIHandler)this.roiHandler).resize(this.dragHandle, this.cpt, nArray);
                break;
            }
            case ROTATE: {
                gridROI = gridROI2.copy();
                double d = gridROI.getAngleRelativeToMidPoint(nArray);
                double[] dArray = gridROI.getMidPoint();
                gridROI.setAngle(d);
                gridROI.setMidPoint(dArray);
            }
        }
        return gridROI;
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        GridROI gridROI;
        if (this.dragging && (gridROI = this.interpretMouseDragging(iImagePositionEvent.getImagePosition())) != null) {
            this.drawDraggedOverlay((ROIBase)gridROI);
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                this.sendCurrentROI((ROIBase)gridROI);
                this.updateAllSpinners((ROIBase)gridROI);
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.hideIDs(this.dragIDs);
            this.roi = this.interpretMouseDragging(iImagePositionEvent.getImagePosition());
            this.roiHandler.setROI(this.roi);
            this.dragHandle = -1;
            this.hStatus = HandleStatus.NONE;
            this.drawCurrentOverlay();
            this.sendCurrentROI(this.roi);
            this.updateAllSpinners(this.roi);
        }
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
        if (rOIBase == null) {
            return;
        }
        final GridROI gridROI = (GridROI)rOIBase;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GridProfile.this.updateAllSpinnersInt(gridROI);
            }
        });
    }

    protected void updateAllSpinnersInt(GridROI gridROI) {
        if (gridROI == null) {
            return;
        }
        this.resx.setDouble(this.getGridPrefs().getXMicronsFromPixelsLen(gridROI.getxSpacing()));
        this.resy.setDouble(this.getGridPrefs().getYMicronsFromPixelsLen(gridROI.getySpacing()));
        this.midpoint.setSelection(gridROI.isMidPointOn());
        this.gridpoint.setSelection(gridROI.isGridLineOn());
        this.spsx.setDouble(this.getGridPrefs().getXMicronsFromPixelsCoord(gridROI.getPoint()[0]));
        this.spsy.setDouble(this.getGridPrefs().getYMicronsFromPixelsCoord(gridROI.getPoint()[1]));
        this.splmaj.setDouble(this.getGridPrefs().getXMicronsFromPixelsLen(gridROI.getLengths()[0]));
        this.splmin.setDouble(this.getGridPrefs().getYMicronsFromPixelsLen(gridROI.getLengths()[1]));
        this.spang.setDouble(gridROI.getAngleDegrees());
        this.tdim.setText(String.format("%d x %d = %d point%s", gridROI.getDimensions()[0], gridROI.getDimensions()[1], gridROI.getDimensions()[0] * gridROI.getDimensions()[1], gridROI.getDimensions()[0] * gridROI.getDimensions()[1] == 1 ? "" : "s"));
    }

    public GridROIList createROIList() {
        GridROIList gridROIList = new GridROIList();
        if (this.roiDataList != null) {
            for (ROIData rOIData : this.roiDataList) {
                gridROIList.add((Object)((GridROI)rOIData.getROI()));
            }
        }
        return gridROIList;
    }

    @Override
    public ROIData createNewROIData(ROIBase rOIBase) {
        return new GridROIData((GridROI)rOIBase, this.data);
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        Serializable serializable;
        int n = 0;
        if (guiBean == null) {
            return n;
        }
        n = super.updateGUI(guiBean);
        if (guiBean.containsKey((Object)GuiParameters.GRIDPREFERENCES) && (serializable = guiBean.get((Object)GuiParameters.GRIDPREFERENCES)) instanceof GridPreferences) {
            GridPreferences gridPreferences = (GridPreferences)serializable;
            this.setGridPrefs(gridPreferences);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GridProfile.this.updatePlot();
                    GridProfile.this.drawEverything();
                }
            });
            this.updateAllSpinners(this.roi);
            n |= 4;
        }
        return n;
    }

    private void sendPreferences(GridPreferences gridPreferences) {
        if (gridPreferences == null || this.roi == null) {
            return;
        }
        ((GridROI)this.roi).setGridPreferences(gridPreferences);
        this.sendCurrentROI(this.roi);
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Mapping");
        action.setToolTipText("Switch side plot to grid scan mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ProfileGrid.png"));
        return action;
    }

    @Override
    public void processPlotUpdate() {
        this.updateDataList();
        if (this.oProvider != null) {
            this.updatePlot();
            this.tViewer.setInput(this.roiDataList);
            this.drawEverything();
        }
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void removeFromHistory() {
    }

    private void drawEverything() {
        this.drawOverlays();
        this.drawCurrentOverlay();
        this.drawBeamlineCentre();
    }

    private void setGridPrefs(GridPreferences gridPreferences) {
        this.gridPrefs = gridPreferences == null ? new GridPreferences() : gridPreferences;
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("gridscan.res.x", this.gridPrefs.getResolutionX());
        iPreferenceStore.setValue("gridscan.res.y", this.gridPrefs.getResolutionY());
        iPreferenceStore.setValue("gridscan.beamline.posx", this.gridPrefs.getBeamlinePosX());
        iPreferenceStore.setValue("gridscan.beamline.posy", this.gridPrefs.getBeamlinePosY());
    }

    public GridPreferences getGridPrefs() {
        if (this.gridPrefs == null) {
            if (this.roi != null) {
                this.setGridPrefs(((GridROI)this.roi).getGridPreferences());
            } else {
                GridPreferences gridPreferences = new GridPreferences();
                IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
                gridPreferences.setResolutionX(iPreferenceStore.isDefault("gridscan.res.x") ? iPreferenceStore.getDefaultDouble("gridscan.res.x") : iPreferenceStore.getDouble("gridscan.res.x"));
                gridPreferences.setResolutionY(iPreferenceStore.isDefault("gridscan.res.y") ? iPreferenceStore.getDefaultDouble("gridscan.res.y") : iPreferenceStore.getDouble("gridscan.res.y"));
                gridPreferences.setBeamlinePosX(iPreferenceStore.isDefault("gridscan.beamline.posx") ? iPreferenceStore.getDefaultDouble("gridscan.beamline.posx") : iPreferenceStore.getDouble("gridscan.beamline.posx"));
                gridPreferences.setBeamlinePosY(iPreferenceStore.isDefault("gridscan.beamline.posy") ? iPreferenceStore.getDefaultDouble("gridscan.beamline.posy") : iPreferenceStore.getDouble("gridscan.beamline.posy"));
                this.setGridPrefs(gridPreferences);
            }
        }
        return this.gridPrefs;
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
    }

    private static enum HandleStatus {
        NONE,
        MOVE,
        RESIZE,
        REORIENT,
        ROTATE;

    }
}

