/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.IAnalysisMonitor;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.fitting.Generic1DFitter;
import uk.ac.diamond.scisoft.analysis.fitting.functions.AFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.CompositeFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Gaussian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IFunction;
import uk.ac.diamond.scisoft.analysis.fitting.functions.IdentifiedPeak;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Lorentzian;
import uk.ac.diamond.scisoft.analysis.fitting.functions.Offset;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PearsonVII;
import uk.ac.diamond.scisoft.analysis.fitting.functions.PseudoVoigt;
import uk.ac.diamond.scisoft.analysis.optimize.ApacheNelderMead;
import uk.ac.diamond.scisoft.analysis.optimize.GeneticAlg;
import uk.ac.diamond.scisoft.analysis.optimize.IOptimizer;
import uk.ac.diamond.scisoft.analysis.optimize.NelderMead;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakTableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.FitData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.FitMenuDialog;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.PlotFittedPeaks;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;

public class Fitting1D
extends SidePlot
implements Overlay1DConsumer,
SelectionListener,
ICellEditorListener,
ISelectionChangedListener {
    private static final transient Logger logger = LoggerFactory.getLogger(Fitting1D.class);
    private Composite parent;
    private final FittedPeakList fittedPeakList = new FittedPeakList();
    private FittedPeakTableViewer fittedPeakTable;
    private PlotFittedPeaks fittedPlot;
    private Overlay1DProvider oProvider;
    private Combo peakType;
    private Combo chooseDataCombo;
    private Spinner numPeaks;
    private Button fitPeaks;
    private Button clearPeaks;
    private Button showAllPeaks;
    private int selectedAlg;
    private int selectedPeak;
    private String[] algNames;
    private String[] peaknames;
    private IOptimizer alg;
    private List<DoubleDataset> dataSetList;
    private DoubleDataset currentDataSet;
    private List<AxisValues> xAxisList;
    private AxisValues currentXAxis;
    private APeak peakToFit;
    private DoubleDataset slicedData;
    private List<Integer> primitiveIDs = new ArrayList<Integer>();
    private int draggingPrimID = -1;
    private double[] startCoord = new double[2];
    private double MAXYVALUE = 32767.0;
    private double accuracy;
    private int smoothing;
    private boolean currentlyZooming = false;
    private boolean autoStopping;
    private boolean thresholdMeasure;
    private double threshold;
    private final Color colorButtonFitted = Color.BLUE;
    private final Color colorDraggedFitted = Color.GREEN;
    private String BUTTON_FITTING_UUID;
    private String REFITTING_UUID;
    private IAction showLeg;
    private Action saveGraph;
    private Action copyGraph;
    private Action printGraph;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private IPropertyChangeListener ZOOM_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Fitting1D.this.currentlyZooming = (Boolean)propertyChangeEvent.getNewValue();
        }
    };
    private SelectionAdapter peakTypeSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Fitting1D.this.selectPeakFuction(Fitting1D.this.peakType.getSelectionIndex());
        }
    };
    private SelectionAdapter fitPeakListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Fitting1D.this.clearPeakTable();
            Fitting1D.this.removeAllPeakOverlays();
            Fitting1D.this.selectPeakFuction(Fitting1D.this.peakType.getSelectionIndex());
            IJobManager iJobManager = Job.getJobManager();
            iJobManager.cancel((Object)Fitting1D.this.BUTTON_FITTING_UUID);
            iJobManager.cancel((Object)Fitting1D.this.REFITTING_UUID);
            new FitWholeDataset(Fitting1D.this.currentXAxis.toDataset(), Fitting1D.this.currentDataSet, Fitting1D.this.peakToFit, Fitting1D.this.alg, Fitting1D.this.smoothing, Fitting1D.this.numPeaks.getSelection(), Fitting1D.this.threshold / 100.0, Fitting1D.this.autoStopping, Fitting1D.this.thresholdMeasure, Fitting1D.this.chooseDataCombo.getItem(Fitting1D.this.chooseDataCombo.getSelectionIndex()), Fitting1D.this.BUTTON_FITTING_UUID).schedule();
        }
    };
    private SelectionAdapter showAllPeaksOverlay = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (Fitting1D.this.showAllPeaks.getSelection()) {
                Fitting1D.this.drawAllPeakOverlays();
            }
            if (!Fitting1D.this.showAllPeaks.getSelection()) {
                Fitting1D.this.removeAllPeakOverlays();
            }
        }
    };
    private SelectionAdapter clearPeaksListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Fitting1D.this.fittedPeakList.clear();
            Fitting1D.this.peaksUpdated();
        }
    };

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.oProvider = (Overlay1DProvider)overlayProvider;
    }

    @Override
    public void removePrimitives() {
        int n = this.primitiveIDs.size();
        if (n > 0 && !this.mainPlotter.isDisposed()) {
            this.oProvider.unregisterPrimitive(this.primitiveIDs);
        }
        if (this.draggingPrimID != -1) {
            this.oProvider.unregisterPrimitive(this.draggingPrimID);
            this.draggingPrimID = -1;
        }
    }

    @Override
    public void unregisterProvider() {
        if (this.oProvider != null) {
            this.removePrimitives();
            this.oProvider = null;
        }
    }

    private void overlaysVisible(boolean bl) {
        if (this.oProvider != null) {
            for (Integer n : this.primitiveIDs) {
                this.oProvider.setPrimitiveVisible(n, bl);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fittedPeakTable.getSelection();
        if (iStructuredSelection != null && selectionEvent.widget instanceof MenuItem) {
            FittedPeakData fittedPeakData = (FittedPeakData)iStructuredSelection.getFirstElement();
            int n = this.fittedPeakList.indexOf(fittedPeakData);
            switch (this.fittedPeakTable.getContextMenu().indexOf((MenuItem)selectionEvent.widget)) {
                case 0: {
                    FitMenuDialog fitMenuDialog = new FitMenuDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.peaknames, this.algNames, this.selectedPeak, this.selectedAlg, this.accuracy);
                    boolean bl = fitMenuDialog.open();
                    if (!bl) {
                        this.overlaysVisible(false);
                        return;
                    }
                    APeak aPeak = fittedPeakData.getFittedPeak();
                    double d = aPeak.getPosition() - 2.0 * aPeak.getFWHM();
                    double d2 = aPeak.getPosition() + 2.0 * aPeak.getFWHM();
                    this.fitPeakFromOverlay(d, d2, fitMenuDialog.getFitData());
                    this.fittedPeakList.remove(n);
                    break;
                }
                case 2: {
                    this.fittedPeakList.remove(n);
                    this.peaksUpdated();
                    break;
                }
                case 3: {
                    this.fittedPeakList.clear();
                    this.peaksUpdated();
                    break;
                }
                case 1: {
                    logger.warn("This function has not been enabled");
                }
            }
        }
    }

    public void applyEditorValue() {
    }

    public void cancelEditor() {
    }

    public void editorValueChanged(boolean bl, boolean bl2) {
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void createPartControl(final Composite composite) {
        this.parent = composite;
        this.parent.setLayout((Layout)new FillLayout());
        this.container = new Composite(this.parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(this.container, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        final Composite composite2 = new Composite((Composite)scrolledComposite, 4);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new RowLayout(256));
        group.setText("Choose data and fit");
        this.chooseDataCombo = new Combo((Composite)group, 8);
        this.chooseDataCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Fitting1D.this.dataComboChanged();
            }
        });
        this.chooseDataCombo.add("                                       ");
        this.fitPeaks = new Button((Composite)group, 0);
        this.fitPeaks.setText("&Fit");
        this.fitPeaks.addSelectionListener((SelectionListener)this.fitPeakListener);
        this.clearPeaks = new Button((Composite)group, 0);
        this.clearPeaks.setText("Clear");
        this.clearPeaks.addSelectionListener((SelectionListener)this.clearPeaksListener);
        this.showAllPeaks = new Button((Composite)group, 32);
        this.showAllPeaks.setText("Show all peaks");
        this.showAllPeaks.setToolTipText("Show the position of all peaks as an overlay on the plot");
        this.showAllPeaks.addSelectionListener((SelectionListener)this.showAllPeaksOverlay);
        this.showAllPeaks.setSelection(true);
        ExpandableComposite expandableComposite = new ExpandableComposite(composite2, 0);
        expandableComposite.setText("Advanced controls");
        expandableComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        Group group2 = new Group((Composite)expandableComposite, 0);
        group2.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label((Composite)group2, 0);
        label.setText("Peak Type");
        this.peakType = new Combo((Composite)group2, 8);
        this.peakType.addSelectionListener((SelectionListener)this.peakTypeSelection);
        label = new Label((Composite)group2, 0);
        label.setText("Number of peaks");
        this.numPeaks = new Spinner((Composite)group2, 0);
        this.numPeaks.setMinimum(-1);
        this.numPeaks.setIncrement(1);
        this.numPeaks.setMaximum(200000);
        expandableComposite.setClient((Control)group2);
        ExpansionAdapter expansionAdapter = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                composite2.layout();
                scrolledComposite.setContent((Control)composite2);
                Point point = composite2.computeSize(-1, -1);
                composite2.setSize(point);
            }
        };
        expandableComposite.addExpansionListener((IExpansionListener)expansionAdapter);
        SashForm sashForm = new SashForm(this.container, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite((Composite)sashForm, 0);
        composite3.setLayout((Layout)new FillLayout());
        this.fittedPeakTable = new FittedPeakTableViewer(composite3, this, this, this);
        this.fittedPeakTable.setInput(this.fittedPeakList);
        this.fittedPlot = new PlotFittedPeaks(sashForm);
        sashForm.setWeights(new int[]{10, 20});
        scrolledComposite.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        composite2.setSize(point);
        this.addPropertyListeners();
        this.setupInitialValues();
        this.parent.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                composite.layout();
            }
        });
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("1D Fitting tool");
        action.setId("uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.Fitting1DAction");
        action.setToolTipText("Switch side plot to 1D fitting tool");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/SidePlot-PeakFit.png"));
        return action;
    }

    private void createExportActions() {
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(Fitting1D.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                Fitting1D.this.fittedPlot.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                Fitting1D.this.fittedPlot.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                Fitting1D.this.fittedPlot.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
    }

    private void createExtraActions() {
        this.showLeg = PlotFittedPeaks.createShowLegend();
        this.showLeg.setChecked(true);
    }

    @Override
    public void setMainPlotUI(IPlotUI iPlotUI) {
        Plot1DUIAdapter plot1DUIAdapter;
        if (this.mainPlotUI != null) {
            plot1DUIAdapter = (Plot1DUIAdapter)iPlotUI;
            plot1DUIAdapter.removeZoomListener(this.ZOOM_LISTENER);
        }
        super.setMainPlotUI(iPlotUI);
        if (this.mainPlotUI != null) {
            plot1DUIAdapter = (Plot1DUIAdapter)iPlotUI;
            plot1DUIAdapter.addZoomListener(this.ZOOM_LISTENER);
        } else {
            logger.error("Unable to determine IPlotUI, so cannot ignore zoom events!");
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fittedPlot != null) {
            this.fittedPlot.dispose();
        }
    }

    @Override
    public void processPlotUpdate() {
        try {
            if (this.dataSetList == null) {
                this.dataSetList = new ArrayList<DoubleDataset>();
            }
            this.dataSetList.clear();
            if (this.mainPlotter == null) {
                return;
            }
            List<IDataset> list = this.mainPlotter.getCurrentDataSets();
            if (list != null && !list.isEmpty()) {
                this.xAxisList = this.mainPlotter.getXAxisValues();
                for (IDataset iDataset : list) {
                    if (this.MAXYVALUE < iDataset.max().doubleValue()) {
                        this.MAXYVALUE = (double)iDataset.max().intValue() * 1.5;
                    }
                    if (-this.MAXYVALUE > iDataset.min().doubleValue()) {
                        this.MAXYVALUE = -iDataset.min().doubleValue() * 1.5;
                    }
                    this.dataSetList.add((DoubleDataset)DatasetUtils.cast((AbstractDataset)DatasetUtils.convertToAbstractDataset((ILazyDataset)iDataset), (int)6));
                }
            }
            this.updateDataSetComboBox(this.dataSetList);
        }
        catch (Throwable throwable) {
            logger.error("a disaster: {}", throwable);
        }
    }

    private void updateDataSetComboBox(List<DoubleDataset> list) {
        String string = this.chooseDataCombo.getSelectionIndex() == -1 ? "no dataset" : this.chooseDataCombo.getItem(this.chooseDataCombo.getSelectionIndex());
        this.chooseDataCombo.removeAll();
        if (this.dataSetList != null && !this.dataSetList.isEmpty()) {
            int n = 0;
            for (DoubleDataset doubleDataset : list) {
                String string2 = doubleDataset.getName();
                if (string2.isEmpty()) {
                    string2 = "Data Set " + n++;
                }
                this.chooseDataCombo.add(string2);
                if (!string2.equals(string)) continue;
                this.chooseDataCombo.select(n);
            }
            if (this.chooseDataCombo.getSelectionIndex() == -1) {
                this.chooseDataCombo.select(0);
            }
            this.setupSmoothing();
        }
        this.chooseDataCombo.update();
        this.dataComboChanged();
    }

    private void refitPeaks() {
        ArrayList<APeak> arrayList = new ArrayList<APeak>(this.fittedPeakList.size());
        IOptimizer iOptimizer = this.alg;
        int n = this.smoothing;
        FittedPeakList fittedPeakList = this.fittedPeakList;
        IJobManager iJobManager = Job.getJobManager();
        iJobManager.cancel((Object)this.BUTTON_FITTING_UUID);
        iJobManager.cancel((Object)this.REFITTING_UUID);
        new refitPeaksOnNewDataset(arrayList, iOptimizer, n, fittedPeakList, this.REFITTING_UUID).schedule();
    }

    private void clearPeakTable() {
        this.fittedPeakList.clear();
        this.peaksUpdated();
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        if (this.currentlyZooming) {
            this.overlaysVisible(false);
            return;
        }
        if (this.currentDataSet != null) {
            double[] dArray;
            this.oProvider.begin(OverlayType.VECTOR2D);
            if (this.draggingPrimID == -1) {
                this.draggingPrimID = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            }
            if (areaSelectEvent.getMode() == '\u0000') {
                this.overlaysVisible(false);
                this.oProvider.setColour(this.draggingPrimID, Color.GREEN);
                this.oProvider.setStyle(this.draggingPrimID, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setTransparency(this.draggingPrimID, 0.8);
                this.oProvider.setOutlineTransparency(this.draggingPrimID, 0.0);
                this.oProvider.setPrimitiveVisible(this.draggingPrimID, true);
                this.startCoord[0] = areaSelectEvent.getX();
                this.startCoord[1] = this.MAXYVALUE;
            }
            if (areaSelectEvent.getMode() == '\u0001') {
                dArray = new double[]{areaSelectEvent.getX(), -this.MAXYVALUE};
                this.oProvider.drawBox(this.draggingPrimID, this.startCoord[0], this.startCoord[1], dArray[0], dArray[1]);
            }
            if (areaSelectEvent.getMode() == '\u0002') {
                dArray = new double[]{areaSelectEvent.getX(), -this.MAXYVALUE};
                this.oProvider.drawBox(this.draggingPrimID, this.startCoord[0], this.startCoord[1], dArray[0], dArray[1]);
                this.slicedData = this.sliceDataSet(this.startCoord[0], dArray[0]);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FitMenuDialog fitMenuDialog = new FitMenuDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Fitting1D.this.peaknames, Fitting1D.this.algNames, Fitting1D.this.selectedPeak, Fitting1D.this.selectedAlg, Fitting1D.this.accuracy);
                        boolean bl = fitMenuDialog.open();
                        if (!bl) {
                            Fitting1D.this.overlaysVisible(false);
                            return;
                        }
                        Fitting1D.this.fitPeakFromOverlay(Fitting1D.this.startCoord[0], dArray[0], fitMenuDialog.getFitData());
                    }
                });
                this.overlaysVisible(true);
            }
            this.oProvider.end(OverlayType.VECTOR2D);
        }
    }

    private DoubleDataset sliceDataSet(double d, double d2) {
        int n;
        int n2;
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        if ((n2 = this.currentXAxis.nearestLowEntry(d)) < 0) {
            n2 = 0;
        }
        if ((n = this.currentXAxis.nearestUpEntry(d2)) < 0) {
            n = this.currentXAxis.size();
        }
        return this.currentDataSet.getSlice(new int[]{n2}, new int[]{n}, null);
    }

    private DoubleDataset createXData(double d, double d2) {
        int n;
        int n2;
        if (d2 < d) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        if ((n2 = this.currentXAxis.nearestLowEntry(d)) < 0) {
            n2 = 0;
        }
        if ((n = this.currentXAxis.nearestUpEntry(d2)) < 0) {
            n = this.currentXAxis.size();
        }
        return this.currentXAxis.subset(n2, n).toDataset();
    }

    public void fitPeakFromOverlay(final double d, final double d2, final FitData fitData) {
        Job job = new Job("Fit peaks from dragging"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Fitting1D.this.slicedData = Fitting1D.this.sliceDataSet(d, d2);
                DoubleDataset doubleDataset = Fitting1D.this.createXData(d, d2);
                Fitting1D.this.selectPeakFuction(fitData.getPeakSelection());
                Fitting1D.this.selectAlg(fitData.getAlgType());
                List list = null;
                list = fitData.getNumberOfPeaks() == 1 ? Fitting1D.this.fitSinglePeak((AbstractDataset)doubleDataset, (AbstractDataset)Fitting1D.this.slicedData, Fitting1D.this.alg, Fitting1D.this.peakToFit, d, d2) : Generic1DFitter.fitPeaks((AbstractDataset)doubleDataset, (AbstractDataset)Fitting1D.this.slicedData, (APeak)Fitting1D.this.peakToFit, (IOptimizer)Fitting1D.this.alg, (int)fitData.getSmoothing(), (int)fitData.getNumberOfPeaks());
                if (list == null || list.isEmpty()) {
                    logger.warn("No peaks were found when the region on the plot was selected");
                    return Status.OK_STATUS;
                }
                final List list2 = list;
                UIJob uIJob = new UIJob("Updating GUI"){

                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        Fitting1D.this.addPeaksToList(list2, Fitting1D.this.colorDraggedFitted);
                        return Status.OK_STATUS;
                    }
                };
                uIJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private List<APeak> fitSinglePeak(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, IOptimizer iOptimizer, APeak aPeak, double d, double d2) {
        ArrayList<APeak> arrayList = new ArrayList<APeak>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        IOptimizer iOptimizer2 = iOptimizer;
        double d3 = (d2 - d) / 4.0;
        arrayList2.add(d + d3);
        arrayList2.add(d2 - d3);
        IdentifiedPeak identifiedPeak = new IdentifiedPeak(abstractDataset.getDouble(new int[]{Math.round(abstractDataset.getSize() / 2)}), abstractDataset.getDouble(new int[]{0}), abstractDataset.getDouble(new int[]{abstractDataset.getSize() - 1}), ((Double)abstractDataset2.sum()).doubleValue(), abstractDataset2.max().doubleValue() - abstractDataset2.min().doubleValue(), this.currentXAxis.nearestLowEntry(d), this.currentXAxis.nearestUpEntry(d2), arrayList2);
        APeak aPeak2 = this.generatePeak(identifiedPeak, aPeak);
        double d4 = abstractDataset2.min().doubleValue();
        double d5 = (Double)abstractDataset2.mean();
        Offset offset = new Offset(d4, d5);
        CompositeFunction compositeFunction = new CompositeFunction();
        compositeFunction.addFunction((AFunction)aPeak2);
        compositeFunction.addFunction((AFunction)offset);
        try {
            iOptimizer2.optimize((IDataset[])new AbstractDataset[]{abstractDataset}, (IDataset)abstractDataset2, (IFunction)compositeFunction);
            arrayList.add(aPeak2);
        }
        catch (Exception exception) {
            logger.error("Could not fit single peak", (Throwable)exception);
        }
        return arrayList;
    }

    private APeak generatePeak(IdentifiedPeak identifiedPeak, APeak aPeak) {
        APeak aPeak2 = null;
        try {
            Constructor<?> constructor = aPeak.getClass().getConstructor(IdentifiedPeak.class);
            aPeak2 = (APeak)constructor.newInstance(identifiedPeak);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("There was a problem optimising the peak", (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            logger.error("The function could not be created for fitting", (Throwable)instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error("The peak function could not be created.", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("The function could not be created for fitting", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error("The function could not be created for fitting", (Throwable)invocationTargetException);
        }
        catch (Exception exception) {
            logger.error("There was a problem creating the optimizer.", (Throwable)exception);
        }
        return aPeak2;
    }

    private void selectAlg(int n) {
        String string = this.algNames[n];
        if (string.equalsIgnoreCase("Genetic Algorithm")) {
            this.alg = new GeneticAlg(this.accuracy);
        } else if (string.equalsIgnoreCase("Nelder Mead")) {
            this.alg = new NelderMead(this.accuracy);
        } else if (string.equalsIgnoreCase("Apache Nelder Mead")) {
            this.alg = new ApacheNelderMead();
        } else {
            throw new IllegalArgumentException("Did not recognise the fitting routine");
        }
    }

    private void addPeaksToList(List<APeak> list, Color color) {
        if (list == null || list.size() < 1) {
            this.clearPeakTable();
            return;
        }
        for (APeak aPeak : list) {
            this.fittedPeakList.add(new FittedPeakData(aPeak, color));
        }
        this.peaksUpdated();
    }

    private void selectPeakFuction(int n) {
        String string = this.peaknames[n];
        if (string.compareToIgnoreCase("Gaussian") == 0) {
            this.peakToFit = new Gaussian(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("Lorentzian") == 0) {
            this.peakToFit = new Lorentzian(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("Pearson VII") == 0) {
            this.peakToFit = new PearsonVII(1.0, 1.0, 1.0, 1.0);
        } else if (string.compareToIgnoreCase("PseudoVoigt") == 0) {
            this.peakToFit = new PseudoVoigt(1.0, 1.0, 1.0, 1.0);
        } else {
            logger.warn("Peak type not recognised. Defaulting to Gaussian");
            this.peakToFit = new Gaussian(1.0, 1.0, 1.0, 1.0);
            this.peakType.select(0);
        }
    }

    private void dataComboChanged() {
        if (this.dataSetList != null && this.dataSetList.size() > 0) {
            this.currentDataSet = this.dataSetList.get(this.chooseDataCombo.getSelectionIndex());
            this.currentXAxis = this.xAxisList.get(this.chooseDataCombo.getSelectionIndex());
            this.setupSmoothing();
            this.removeAllPeakOverlays();
            this.refitPeaks();
        }
    }

    private void setupSmoothing() {
        if (this.currentDataSet != null) {
            IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
            this.smoothing = iPreferenceStore.getBoolean("fitting.alg.autosmoothing") ? (int)((double)this.currentDataSet.getSize() * 0.01) : iPreferenceStore.getInt("fitting1d.alg.smoothing");
        }
    }

    private void setupInitialValues() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.accuracy = iPreferenceStore.getDouble("fitting1d.alg.accuracy");
        this.threshold = iPreferenceStore.getInt("fitting.alg.stopping.threshold");
        String string = iPreferenceStore.getString("fitting1d.peak.list");
        String string2 = iPreferenceStore.getString("fitting1d.peak.type");
        this.populateAndSelectPeak(string, string2);
        if (iPreferenceStore.getBoolean("fitting.alg.autostopping")) {
            this.numPeaks.setSelection(-1);
            this.numPeaks.setEnabled(false);
        } else {
            this.numPeaks.setEnabled(true);
            this.numPeaks.setSelection(iPreferenceStore.getInt("fitting1d.peak.num"));
        }
        this.autoStopping = iPreferenceStore.getBoolean("fitting.alg.autostopping");
        this.determineThresholdMeasure(iPreferenceStore.getString("fitting.alg.threshold.measure"));
        String string3 = iPreferenceStore.getDefaultString("fitting1d.alg.list");
        String string4 = iPreferenceStore.getString("fitting1d.alg.type");
        this.populateAndSelectAlgnames(string3, string4);
        this.BUTTON_FITTING_UUID = UUID.randomUUID().toString();
        this.REFITTING_UUID = UUID.randomUUID().toString();
    }

    private void populateAndSelectAlgnames(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "]}\u00ac\u00ac{[");
        this.algNames = new String[stringTokenizer.countTokens()];
        int n = 0;
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            this.algNames[n] = string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase(string2)) {
                string3 = string4;
                this.selectedAlg = n;
            }
            ++n;
        }
        if (string3.equalsIgnoreCase("Genetic Algorithm")) {
            this.alg = new GeneticAlg(this.accuracy);
        } else if (string3.equalsIgnoreCase("Nelder Mead")) {
            this.alg = new NelderMead(this.accuracy);
        } else if (string3.equalsIgnoreCase("Apache Nelder Mead")) {
            this.alg = new ApacheNelderMead();
        } else {
            throw new IllegalArgumentException("Did not recognise the fitting routine");
        }
    }

    private void populateAndSelectPeak(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "]}\u00ac\u00ac{[");
        this.peaknames = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            this.peaknames[n] = string3 = stringTokenizer.nextToken();
            this.peakType.add(string3);
            if (string3.equalsIgnoreCase(string2)) {
                this.selectedPeak = n;
            }
            ++n;
        }
        this.peakType.select(this.selectedPeak);
    }

    private void addPropertyListeners() {
        AnalysisRCPActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
                if (string.equals("fitting1d.alg.accuracy") || string.equals("fitting1d.alg.smoothing") || string.equals("fitting1d.alg.type") || string.equals("fitting.alg.autosmoothing") || string.equals("fitting1d.peak.type")) {
                    String string2 = iPreferenceStore.isDefault("fitting1d.peak.type") ? iPreferenceStore.getDefaultString("fitting1d.peak.type") : iPreferenceStore.getString("fitting1d.peak.type");
                    int n = 0;
                    while (n < Fitting1D.this.peaknames.length) {
                        if (Fitting1D.this.peaknames[n].equalsIgnoreCase(string2)) {
                            Fitting1D.this.peakType.select(n);
                            break;
                        }
                        ++n;
                    }
                    if (iPreferenceStore.isDefault("fitting1d.alg.accuracy")) {
                        Fitting1D.this.accuracy = iPreferenceStore.getDefaultDouble("fitting1d.alg.accuracy");
                    } else {
                        Fitting1D.this.accuracy = iPreferenceStore.getDouble("fitting1d.alg.accuracy");
                    }
                    n = iPreferenceStore.isDefault("fitting.alg.autosmoothing") ? (int)(iPreferenceStore.getDefaultBoolean("fitting.alg.autosmoothing") ? 1 : 0) : (int)(iPreferenceStore.getBoolean("fitting.alg.autosmoothing") ? 1 : 0);
                    if (n != 0) {
                        Fitting1D.this.setupSmoothing();
                    } else if (iPreferenceStore.isDefault("fitting1d.alg.smoothing")) {
                        Fitting1D.this.smoothing = iPreferenceStore.getDefaultInt("fitting1d.alg.smoothing");
                    } else {
                        Fitting1D.this.smoothing = iPreferenceStore.getInt("fitting1d.alg.smoothing");
                    }
                    String string3 = iPreferenceStore.isDefault("fitting1d.alg.list") ? iPreferenceStore.getDefaultString("fitting1d.alg.list") : iPreferenceStore.getString("fitting1d.alg.list");
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "]}\u00ac\u00ac{[");
                    Fitting1D.this.algNames = new String[stringTokenizer.countTokens()];
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        ((Fitting1D)Fitting1D.this).algNames[n2++] = stringTokenizer.nextToken();
                    }
                    String string4 = iPreferenceStore.isDefault("fitting1d.alg.type") ? iPreferenceStore.getDefaultString("fitting1d.alg.type") : iPreferenceStore.getString("fitting1d.alg.type");
                    if (string4.equalsIgnoreCase("Genetic Algorithm")) {
                        Fitting1D.this.alg = (IOptimizer)new GeneticAlg(Fitting1D.this.accuracy);
                        return;
                    } else if (string4.equalsIgnoreCase("Nelder Mead")) {
                        Fitting1D.this.alg = (IOptimizer)new NelderMead(Fitting1D.this.accuracy);
                        return;
                    } else {
                        if (!string4.equalsIgnoreCase("Apache Nelder Mead")) throw new IllegalArgumentException("Did not recognise the fitting routine");
                        Fitting1D.this.alg = (IOptimizer)new ApacheNelderMead();
                    }
                    return;
                } else if (string.equals("fitting.alg.autostopping") || string.equals("fitting.alg.stopping.threshold") || string.equals("fitting.alg.threshold.measure") || string.equals("fitting1d.peak.num")) {
                    if (iPreferenceStore.isDefault("fitting.alg.autostopping")) {
                        Fitting1D.this.autoStopping = iPreferenceStore.getDefaultBoolean("fitting.alg.autostopping");
                    } else {
                        Fitting1D.this.autoStopping = iPreferenceStore.getBoolean("fitting.alg.autostopping");
                    }
                    if (iPreferenceStore.isDefault("fitting.alg.stopping.threshold")) {
                        Fitting1D.this.threshold = iPreferenceStore.getDefaultInt("fitting.alg.stopping.threshold");
                    } else {
                        Fitting1D.this.threshold = iPreferenceStore.getInt("fitting.alg.stopping.threshold");
                    }
                    String string5 = iPreferenceStore.isDefault("fitting.alg.threshold.measure") ? iPreferenceStore.getDefaultString("fitting.alg.threshold.measure") : iPreferenceStore.getString("fitting.alg.threshold.measure");
                    Fitting1D.this.determineThresholdMeasure(string5);
                    if (Fitting1D.this.autoStopping) {
                        Fitting1D.this.numPeaks.setSelection(-1);
                        Fitting1D.this.numPeaks.setEnabled(false);
                        return;
                    } else {
                        Fitting1D.this.numPeaks.setEnabled(true);
                        if (iPreferenceStore.isDefault("fitting1d.peak.num")) {
                            Fitting1D.this.numPeaks.setSelection(iPreferenceStore.getDefaultInt("fitting1d.peak.num"));
                            return;
                        } else {
                            Fitting1D.this.numPeaks.setSelection(iPreferenceStore.getInt("fitting1d.peak.num"));
                        }
                    }
                    return;
                } else {
                    if (!string.equals("fitting1d.peak.dp")) return;
                    Fitting1D.this.fittedPeakTable.refresh();
                }
            }
        });
    }

    protected void determineThresholdMeasure(String string) {
        if (string.equalsIgnoreCase("Height")) {
            this.thresholdMeasure = true;
        } else if (string.equalsIgnoreCase("Area")) {
            this.thresholdMeasure = false;
        } else {
            throw new IllegalArgumentException("Did not recognise the threashold measure");
        }
    }

    private void drawAllPeakOverlays() {
        this.removeAllPeakOverlays();
        if (!this.showAllPeaks.getSelection()) {
            return;
        }
        if (this.fittedPeakList == null || this.fittedPeakList.isEmpty()) {
            return;
        }
        this.overlaysVisible(false);
        if (this.showAllPeaks.getSelection()) {
            for (FittedPeakData fittedPeakData : this.fittedPeakList) {
                int n = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                this.oProvider.begin(OverlayType.VECTOR2D);
                double d = fittedPeakData.getFittedPeak().getPosition();
                double d2 = fittedPeakData.getFittedPeak().getFWHM();
                this.oProvider.drawBox(n, d - d2 / 2.0, this.MAXYVALUE, d + d2 / 2.0, -this.MAXYVALUE);
                this.oProvider.setColour(n, Color.ORANGE);
                this.oProvider.setStyle(n, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setTransparency(n, 0.8);
                this.oProvider.setOutlineTransparency(n, 0.0);
                this.oProvider.end(OverlayType.VECTOR2D);
                this.primitiveIDs.add(n);
            }
        }
    }

    private void removeAllPeakOverlays() {
        this.oProvider.begin(OverlayType.VECTOR2D);
        if (this.draggingPrimID != -1) {
            this.oProvider.setPrimitiveVisible(this.draggingPrimID, false);
        }
        if (this.primitiveIDs != null && !this.primitiveIDs.isEmpty()) {
            this.oProvider.unregisterPrimitive(this.primitiveIDs);
            this.primitiveIDs.clear();
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void peaksUpdated() {
        this.updatePeaksTable();
        this.pushPeaksToPlotter();
        this.drawAllPeakOverlays();
    }

    private void pushPeaksToPlotter() {
        ArrayList<APeak> arrayList = new ArrayList<APeak>();
        for (FittedPeakData fittedPeakData : this.fittedPeakList) {
            arrayList.add(fittedPeakData.getFittedPeak());
        }
        if (this.guiUpdateManager != null) {
            this.guiUpdateManager.putGUIInfo(GuiParameters.FITTEDPEAKS, arrayList);
        }
    }

    private void updatePeaksTable() {
        Collections.sort(this.fittedPeakList, new Compare());
        this.fittedPeakTable.refresh();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        FittedPeakData fittedPeakData = (FittedPeakData)iStructuredSelection.getFirstElement();
        if (fittedPeakData != null) {
            this.processPeakInformation(fittedPeakData);
            this.drawFittedPeakOverlays(fittedPeakData);
            this.fittedPlot.removePrimitives();
            this.fittedPlot.drawCurrentOverlay(fittedPeakData);
        }
    }

    private void drawFittedPeakOverlays(FittedPeakData fittedPeakData) {
        int n = this.oProvider.registerPrimitive(PrimitiveType.BOX);
        this.overlaysVisible(false);
        this.oProvider.begin(OverlayType.VECTOR2D);
        double d = fittedPeakData.getFittedPeak().getPosition();
        double d2 = fittedPeakData.getFittedPeak().getFWHM();
        this.oProvider.drawBox(n, d - d2 / 2.0, this.MAXYVALUE, d + d2 / 2.0, -this.MAXYVALUE);
        this.oProvider.setColour(n, Color.ORANGE);
        this.oProvider.setStyle(n, VectorOverlayStyles.FILLED_WITH_OUTLINE);
        this.oProvider.setTransparency(n, 0.8);
        this.oProvider.setOutlineTransparency(n, 0.0);
        this.oProvider.end(OverlayType.VECTOR2D);
        this.primitiveIDs.add(n);
    }

    private void processPeakInformation(FittedPeakData fittedPeakData) {
        APeak aPeak = fittedPeakData.getFittedPeak();
        double d = aPeak.getPosition() - 2.0 * aPeak.getFWHM();
        double d2 = aPeak.getPosition() + 2.0 * aPeak.getFWHM();
        DoubleDataset doubleDataset = this.sliceDataSet(d, d2);
        double d3 = (Double)doubleDataset.min();
        CompositeFunction compositeFunction = new CompositeFunction();
        Offset offset = new Offset(d3, d3);
        compositeFunction.addFunction((AFunction)aPeak);
        compositeFunction.addFunction((AFunction)offset);
        DoubleDataset doubleDataset2 = this.createXData(d, d2);
        DoubleDataset doubleDataset3 = compositeFunction.makeDataset(new IDataset[]{doubleDataset2});
        this.fittedPlot.plotDataSets(doubleDataset, doubleDataset3, new AxisValues((AbstractDataset)doubleDataset2));
    }

    @Override
    public void showSidePlot() {
        this.processPlotUpdate();
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        return 0;
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, final IWorkbenchPartSite iWorkbenchPartSite) {
        this.createExportActions();
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iMenuManager.add((IAction)this.saveGraph);
        iMenuManager.add((IAction)this.copyGraph);
        iMenuManager.add((IAction)this.printGraph);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "extraActions"));
        Action action = new Action(){

            public void run() {
                IHandlerService iHandlerService = (IHandlerService)iWorkbenchPartSite.getService(IHandlerService.class);
                try {
                    iHandlerService.executeCommand("uk.ac.diamond.scisoft.analysis.rcp.Fitting1DSettings", null);
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                }
            }
        };
        action.setText("Preferences");
        iMenuManager.add((IAction)action);
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        this.createExportActions();
        this.createExtraActions();
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "extraActions"));
        iToolBarManager.add(this.showLeg);
    }

    private static class Compare
    implements Comparator<FittedPeakData> {
        private Compare() {
        }

        @Override
        public int compare(FittedPeakData fittedPeakData, FittedPeakData fittedPeakData2) {
            if (fittedPeakData.getFittedPeak().getPosition() > fittedPeakData2.getFittedPeak().getPosition()) {
                return 1;
            }
            if (fittedPeakData.getFittedPeak().getPosition() < fittedPeakData2.getFittedPeak().getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    private class FitWholeDataset
    extends Job {
        final DoubleDataset xAxis;
        final DoubleDataset yAxis;
        final APeak peak;
        final IOptimizer optomiser;
        final int smooth;
        final int numberOfPeaks;
        final double cutoff;
        final boolean autoStop;
        final boolean measure;
        private static final String name = "Fitting peaks";
        private String UUID;

        public FitWholeDataset(DoubleDataset doubleDataset, DoubleDataset doubleDataset2, APeak aPeak, IOptimizer iOptimizer, int n, int n2, double d, boolean bl, boolean bl2, String string, String string2) {
            super("Fitting peaks " + string);
            this.xAxis = doubleDataset;
            this.yAxis = doubleDataset2;
            this.peak = aPeak;
            this.optomiser = iOptimizer;
            this.smooth = n;
            this.numberOfPeaks = n2;
            this.cutoff = d;
            this.autoStop = bl;
            this.measure = bl2;
            this.UUID = string2;
        }

        protected IStatus run(final IProgressMonitor iProgressMonitor) {
            final List list = Generic1DFitter.fitPeaks((AbstractDataset)this.xAxis, (AbstractDataset)this.yAxis, (APeak)this.peak, (IOptimizer)this.optomiser, (int)this.smooth, (int)this.numberOfPeaks, (double)this.cutoff, (boolean)this.autoStop, (boolean)this.measure, (IAnalysisMonitor)new IAnalysisMonitor(){

                public boolean hasBeenCancelled() {
                    return iProgressMonitor.isCanceled();
                }
            });
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (list.isEmpty()) {
                logger.warn("No peaks found");
                return Status.OK_STATUS;
            }
            UIJob uIJob = new UIJob("Updating GUI"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    Fitting1D.this.addPeaksToList(list, Fitting1D.this.colorButtonFitted);
                    return Status.OK_STATUS;
                }
            };
            uIJob.schedule();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return this.UUID.equals(object);
        }
    }

    private class refitPeaksOnNewDataset
    extends Job {
        final List<APeak> newList;
        final IOptimizer optimiser;
        final int smooth;
        final FittedPeakList currentPeakList;
        private static final String name = "Refitting peaks on new Data";
        private String UUID;

        public refitPeaksOnNewDataset(List<APeak> list, IOptimizer iOptimizer, int n, FittedPeakList fittedPeakList, String string) {
            super(name);
            this.newList = list;
            this.optimiser = iOptimizer;
            this.smooth = n;
            this.currentPeakList = fittedPeakList;
            this.UUID = string;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Object object2;
            try {
                for (Object object2 : this.currentPeakList) {
                    if (iProgressMonitor.isCanceled()) {
                        this.newList.clear();
                        return Status.CANCEL_STATUS;
                    }
                    APeak aPeak = ((FittedPeakData)object2).getFittedPeak();
                    double d = aPeak.getPosition() - 2.0 * aPeak.getFWHM();
                    double d2 = aPeak.getPosition() + 2.0 * aPeak.getFWHM();
                    try {
                        List list = Generic1DFitter.fitPeaks((AbstractDataset)Fitting1D.this.createXData(d, d2), (AbstractDataset)Fitting1D.this.sliceDataSet(d, d2), (APeak)aPeak, (IOptimizer)this.optimiser, (int)this.smooth, (int)1);
                        if (list == null) continue;
                        this.newList.addAll(list);
                    }
                    catch (Throwable throwable) {
                        logger.info("exception trying to refit peaks {} - no problem usually", throwable);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                logger.debug("This was caused by the fitting continuing after the job was canceled");
            }
            if (iProgressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            object2 = new UIJob("Update Plot"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    Fitting1D.this.fittedPeakList.clear();
                    Fitting1D.this.addPeaksToList(refitPeaksOnNewDataset.this.newList, Fitting1D.this.colorDraggedFitted);
                    return Status.OK_STATUS;
                }
            };
            object2.schedule();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return this.UUID.equals(object);
        }
    }
}

