/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.FitData;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;
import uk.ac.diamond.scisoft.analysis.rcp.util.SDAUtils;
import uk.ac.gda.richbeans.beans.BeanUI;
import uk.ac.gda.richbeans.components.wrappers.ComboWrapper;
import uk.ac.gda.richbeans.components.wrappers.SpinnerWrapper;

public class FitMenuDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(FitMenuDialog.class);
    private final String[] peaks;
    private final String[] algNames;
    private Shell shell;
    private boolean ok = false;
    private ComboWrapper peakSelection;
    private SpinnerWrapper numberOfPeaks;
    private ComboWrapper algType;
    private FloatSpinner accuracySpinner;
    private double accuracy = 0.01;
    private SpinnerWrapper smoothing;
    private int selectAlg;
    private int selectPeak;
    private FitData fitData = new FitData();

    public FitMenuDialog(Shell shell, String[] stringArray, String[] stringArray2) {
        super(shell, 67680);
        this.peaks = stringArray;
        this.algNames = stringArray2;
        this.selectAlg = 0;
        this.selectPeak = 0;
    }

    public FitMenuDialog(Shell shell, String[] stringArray, String[] stringArray2, int n, int n2, double d) {
        super(shell, 67680);
        this.peaks = stringArray;
        this.algNames = stringArray2;
        this.selectAlg = n2;
        this.selectPeak = n;
        this.accuracy = d;
    }

    public boolean open() {
        this.createUI();
        this.shell.open();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ok;
    }

    private void createUI() {
        Shell shell = this.getParent();
        this.shell = new Shell(shell, 65552);
        this.shell.setText("Peak Fitting");
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.setSize(350, 290);
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Number of peaks");
        this.numberOfPeaks = new SpinnerWrapper((Composite)group, 2048);
        this.numberOfPeaks.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.numberOfPeaks.setMinimum(1);
        this.numberOfPeaks.setIncrement(1);
        this.numberOfPeaks.setValue((Object)1);
        ExpandableComposite expandableComposite = new ExpandableComposite((Composite)this.shell, 0);
        expandableComposite.setText("Advanced");
        expandableComposite.setLayoutData((Object)new GridData(4, 128, true, true));
        Group group2 = new Group((Composite)expandableComposite, 0);
        group2.setLayout((Layout)new GridLayout(2, false));
        Label label2 = new Label((Composite)group2, 0);
        label2.setText("Peak type");
        this.peakSelection = new ComboWrapper((Composite)group2, 8);
        this.peakSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.peakSelection.setItems(ComboWrapper.getItemMap((String[])this.peaks));
        this.peakSelection.setValue((Object)this.selectPeak);
        Label label3 = new Label((Composite)group2, 0);
        label3.setText("Fitting algorithm");
        this.algType = new ComboWrapper((Composite)group2, 8);
        this.algType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.algType.setItems(ComboWrapper.getItemMap((String[])this.algNames));
        this.algType.setValue((Object)this.selectAlg);
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Accuracy");
        label4.setToolTipText("This sets the accuracy of the optomisation. The lower the number to more accurate the calculation");
        this.accuracySpinner = new FloatSpinner((Composite)group2, 0, 6, 5);
        this.accuracySpinner.setMinimum(1.0E-5);
        this.accuracySpinner.setDouble(this.accuracy);
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Smoothing");
        label5.setToolTipText("Defines the smoothing which will be applied to the peak searching algorithm");
        this.smoothing = new SpinnerWrapper((Composite)group2, 0);
        this.smoothing.setDigits(0);
        this.smoothing.setValue((Object)1);
        this.smoothing.setMinimum(0);
        this.smoothing.setMaximum(10000);
        expandableComposite.setClient((Control)group2);
        ExpansionAdapter expansionAdapter = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                FitMenuDialog.this.shell.layout();
            }
        };
        expandableComposite.addExpansionListener((IExpansionListener)expansionAdapter);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Button button = new Button(composite, 8);
        button.setText("  &Fit  ");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FitMenuDialog.this.ok = true;
                FitMenuDialog.this.saveValues();
                FitMenuDialog.this.shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText("&Cancel");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FitMenuDialog.this.ok = false;
                FitMenuDialog.this.shell.dispose();
            }
        });
        try {
            BeanUI.switchState((Object)((Object)this), (boolean)true);
            this.loadValues();
        }
        catch (Exception exception) {
            logger.error("Cannot turn on UI", (Throwable)exception);
        }
    }

    private void saveValues() {
        XMLEncoder xMLEncoder = null;
        try {
            try {
                BeanUI.uiToBean((Object)((Object)this), (Object)this.fitData);
                File file = new File(String.valueOf(SDAUtils.getSdaHome()) + FitMenuDialog.class.getName() + ".xml");
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
                xMLEncoder.writeObject(this.fitData);
            }
            catch (Exception exception) {
                logger.error("Cannot save fit menu data!", (Throwable)exception);
                if (xMLEncoder != null) {
                    xMLEncoder.close();
                }
            }
        }
        finally {
            if (xMLEncoder != null) {
                xMLEncoder.close();
            }
        }
    }

    private void loadValues() {
        XMLDecoder xMLDecoder = null;
        try {
            File file = new File(String.valueOf(SDAUtils.getSdaHome()) + FitMenuDialog.class.getName() + ".xml");
            if (!file.exists()) {
                return;
            }
            try {
                xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
                this.fitData = (FitData)xMLDecoder.readObject();
                BeanUI.beanToUI((Object)this.fitData, (Object)((Object)this));
            }
            catch (Exception exception) {
                logger.error("Cannot open fit menu data!", (Throwable)exception);
            }
        }
        finally {
            if (xMLDecoder != null) {
                xMLDecoder.close();
            }
        }
    }

    public FitData getFitData() {
        return this.fitData;
    }

    public ComboWrapper getPeakSelection() {
        return this.peakSelection;
    }

    public SpinnerWrapper getNumberOfPeaks() {
        return this.numberOfPeaks;
    }

    public ComboWrapper getAlgType() {
        return this.algType;
    }

    public FloatSpinner getAccuracy() {
        return this.accuracySpinner;
    }

    public SpinnerWrapper getSmoothing() {
        return this.smoothing;
    }
}

