/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.text.DecimalFormat;
import java.util.Map;
import javax.vecmath.Vector3d;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewer;

public class DiffractionViewerMetadata
extends Composite {
    private Map<String, ? extends Object> metadata;
    public static int NUM_DEC_PLACES = 4;
    public static double scale = Math.pow(10.0, NUM_DEC_PLACES);
    private Text detectorSizeX;
    private Text detectorSizeY;
    private Text PixelSizeX;
    private Text PixelSizeY;
    private Spinner wavelength;
    private Text phiStart;
    private DiffractionViewer diffView;
    private Text phiStop;
    private Text phiRange;
    private Spinner distanceToDetector;
    private Text ExposureTime;
    private Text maxPxVal;
    private Text minPxVal;
    private Text meanPxVal;
    private Button showBeam;
    private Spinner xBeam;
    private Spinner yBeam;
    private static double arrowMovement = 1.0;
    public Vector3d beamCorrection;
    private DetectorProperties cachedDetConfig;
    private DiffractionCrystalEnvironment cachedDiffEnv;
    private Button save;
    private int zBeamValue;
    private int xBeamValue;
    private int yBeamValue;
    private boolean lockSettings = false;
    private Text overload;
    private DecimalFormat decimaPlaces;
    public static boolean CACHED_METADATA;
    public static boolean GUI_LOADED;
    private SelectionListener beamSpinnerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            DiffractionViewerMetadata.this.xBeamValue = DiffractionViewerMetadata.this.xBeam.getSelection();
            DiffractionViewerMetadata.this.yBeamValue = DiffractionViewerMetadata.this.yBeam.getSelection();
            DiffractionViewerMetadata.this.modifyDetectorOrigin();
        }
    };

    static {
        GUI_LOADED = false;
    }

    public DiffractionViewerMetadata(Composite composite, int n, DiffractionViewer diffractionViewer) {
        super(composite, n);
        this.diffView = diffractionViewer;
        this.setLayoutData(new GridData(4, 128, true, true));
        this.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        scrolledComposite.setLayoutData(this.getLayoutData());
        scrolledComposite.setLayout(this.getLayout());
        Composite composite2 = new Composite((Composite)scrolledComposite, 4);
        composite2.setLayoutData((Object)new GridData(4, 128, true, true));
        composite2.setLayout((Layout)new GridLayout(2, false));
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText("Experimental Information");
        Label label = new Label((Composite)group, 0);
        label.setText("Wavelength");
        this.wavelength = new Spinner((Composite)group, 0);
        this.wavelength.setToolTipText("wavelength");
        this.wavelength.setDigits(NUM_DEC_PLACES);
        this.wavelength.setMaximum(1000000);
        this.wavelength.setMinimum(0);
        this.wavelength.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GUI_LOADED) {
                    DiffractionViewerMetadata.this.cacheMetadata();
                    DiffractionViewerMetadata.this.modifyWavelength();
                }
            }
        });
        new Label((Composite)group, 0).setText("\u00c5");
        label = new Label((Composite)group, 0);
        label.setText("Start");
        this.phiStart = new Text((Composite)group, 8);
        this.phiStart.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Label((Composite)group, 0);
        label.setText("Stop");
        this.phiStop = new Text((Composite)group, 8);
        this.phiStop.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Label((Composite)group, 0);
        label.setText("Oscillation Range");
        this.phiRange = new Text((Composite)group, 8);
        this.phiRange.setBackground(group.getBackground());
        new Label((Composite)group, 0).setText("\u00b0");
        label = new Group(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 2));
        label.setLayout((Layout)new GridLayout(3, false));
        label.setText("Detector Metadata");
        Label label2 = new Label((Composite)label, 0);
        label2.setText("Distance");
        this.distanceToDetector = new Spinner((Composite)label, 0);
        this.distanceToDetector.setToolTipText("distance");
        this.distanceToDetector.setDigits(NUM_DEC_PLACES);
        this.distanceToDetector.setMaximum(100000000);
        this.distanceToDetector.setMinimum(0);
        this.distanceToDetector.setIncrement(100);
        this.distanceToDetector.setSelection(0);
        this.distanceToDetector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (GUI_LOADED) {
                    DiffractionViewerMetadata.this.cacheMetadata();
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_DISTANCE, DiffractionViewerMetadata.this.distanceToDetector.getSelection());
                }
            }
        });
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (x)");
        this.detectorSizeX = new Text((Composite)label, 8);
        this.detectorSizeX.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Size (y)");
        this.detectorSizeY = new Text((Composite)label, 8);
        this.detectorSizeY.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (x)");
        this.PixelSizeX = new Text((Composite)label, 8);
        this.PixelSizeX.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Pixel Size (y)");
        this.PixelSizeY = new Text((Composite)label, 8);
        this.PixelSizeY.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("mm");
        label2 = new Label((Composite)label, 0);
        label2.setText("Exposure Time");
        this.ExposureTime = new Text((Composite)label, 8);
        this.ExposureTime.setBackground(label.getBackground());
        new Label((Composite)label, 0).setText("s");
        label2 = new Label((Composite)label, 0);
        label2.setText("Maximum Value");
        label2.setToolTipText("Maximum pixel value of the dataset being plotted.");
        this.maxPxVal = new Text((Composite)label, 8);
        this.maxPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0);
        label2 = new Label((Composite)label, 0);
        label2.setText("Minimum Value");
        label2.setToolTipText("Minimum pixel value of the dataset being plotted.");
        this.minPxVal = new Text((Composite)label, 8);
        this.minPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0);
        label2 = new Label((Composite)label, 0);
        label2.setText("Mean Value");
        label2.setToolTipText("Mean pixel value of the dataset being plotted.");
        this.meanPxVal = new Text((Composite)label, 8);
        this.meanPxVal.setBackground(label.getBackground());
        new Label((Composite)label, 0);
        label2 = new Label((Composite)label, 0);
        label2.setText("Overload Value");
        label2.setToolTipText("Displays the maximum possible pixel value");
        this.overload = new Text((Composite)label, 8);
        this.overload.setBackground(label.getBackground());
        new Label((Composite)label, 0);
        label2 = new Group(composite2, 0);
        label2.setLayout((Layout)new GridLayout(2, false));
        label2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        label2.setText("Beam Centre");
        Composite composite3 = new Composite((Composite)label2, 0);
        composite3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        composite3.setLayout((Layout)new GridLayout(3, false));
        new Label(composite3, 0);
        Button button = new Button(composite3, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.cacheMetadata();
                if ((selectionEvent.stateMask & 0x40000) != 0) {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_UP, arrowMovement / 10.0);
                } else {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_UP, arrowMovement);
                }
            }
        });
        button.setImage(AnalysisRCPActivator.getImageDescriptor("/icons/arrow_up.png").createImage());
        new Label(composite3, 0);
        button = new Button(composite3, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.cacheMetadata();
                if ((selectionEvent.stateMask & 0x40000) != 0) {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_LEFT, arrowMovement / 10.0);
                } else {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_LEFT, arrowMovement);
                }
            }
        });
        button.setImage(AnalysisRCPActivator.getImageDescriptor("/icons/arrow_left.png").createImage());
        this.showBeam = new Button(composite3, 2);
        this.showBeam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.diffView.drawBeamCentre(DiffractionViewerMetadata.this.showBeam.getSelection());
                ((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.beamVisable = DiffractionViewerMetadata.this.showBeam.getSelection();
            }
        });
        this.showBeam.setToolTipText("Show beam centre");
        this.showBeam.setImage(AnalysisRCPActivator.getImageDescriptor("icons/asterisk_yellow.png").createImage());
        button = new Button(composite3, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.cacheMetadata();
                if ((selectionEvent.stateMask & 0x40000) != 0) {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_RIGHT, arrowMovement / 10.0);
                } else {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_RIGHT, arrowMovement);
                }
            }
        });
        button.setImage(AnalysisRCPActivator.getImageDescriptor("/icons/arrow_right.png").createImage());
        new Label(composite3, 0);
        button = new Button(composite3, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.cacheMetadata();
                if ((selectionEvent.stateMask & 0x40000) != 0) {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_DOWN, arrowMovement / 10.0);
                } else {
                    DiffractionViewerMetadata.this.moveDetectorOrigin(beamMovement.BEAM_DOWN, arrowMovement);
                }
            }
        });
        button.setImage(AnalysisRCPActivator.getImageDescriptor("/icons/arrow_down.png").createImage());
        new Label(composite3, 0);
        button = new Composite((Composite)label2, 4);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        button.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)button, 0);
        label3.setText("Beam X");
        this.xBeam = new Spinner((Composite)button, 0);
        this.xBeam.setToolTipText("xbeam");
        this.xBeam.setDigits(NUM_DEC_PLACES);
        this.xBeam.setMaximum(50000000);
        this.xBeam.setMinimum(0);
        this.xBeam.setIncrement((int)(scale / 10.0));
        this.xBeam.addSelectionListener(this.beamSpinnerListener);
        Label label4 = new Label((Composite)button, 0);
        label4.setText("Beam Y");
        this.yBeam = new Spinner((Composite)button, 0);
        this.yBeam.setToolTipText("ybeam");
        this.yBeam.setDigits(NUM_DEC_PLACES);
        this.yBeam.setMaximum(50000000);
        this.yBeam.setMinimum(0);
        this.yBeam.setIncrement((int)(scale / 10.0));
        this.yBeam.addSelectionListener(this.beamSpinnerListener);
        this.save = new Button(composite2, 2);
        this.save.setText("&Lock Settings");
        this.save.setToolTipText("Applies the changes to metatdata to remainder of session");
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.lockSettings = DiffractionViewerMetadata.this.save.getSelection();
            }
        });
        label2 = new Button(composite2, 0);
        label2.setToolTipText("Resets the metadata to the image metadata");
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label2.setText("&Reset");
        label2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewerMetadata.this.retrieveSettings();
                DiffractionViewerMetadata.this.save.setSelection(false);
            }
        });
        scrolledComposite.setContent((Control)composite2);
        label2 = composite2.computeSize(-1, -1);
        composite2.setSize((Point)label2);
        this.decimaPlaces = new DecimalFormat();
        this.decimaPlaces.setMaximumFractionDigits(NUM_DEC_PLACES);
        GUI_LOADED = true;
    }

    protected void modifyWavelength() {
        if (this.diffView.diffEnv == null) {
            return;
        }
        this.diffView.diffEnv.setWavelength((double)this.wavelength.getSelection() / scale);
        this.diffView.updateDiffractionObjects(this.showBeam.getSelection());
    }

    protected void moveDetectorOrigin(beamMovement beamMovement2, double d) {
        switch (beamMovement2) {
            case BEAM_UP: {
                this.yBeamValue = (int)((double)this.yBeamValue - d * scale);
                break;
            }
            case BEAM_DOWN: {
                this.yBeamValue = (int)((double)this.yBeamValue + d * scale);
                break;
            }
            case BEAM_LEFT: {
                this.xBeamValue = (int)((double)this.xBeamValue - d * scale);
                break;
            }
            case BEAM_RIGHT: {
                this.xBeamValue = (int)((double)this.xBeamValue + d * scale);
                break;
            }
            case BEAM_DISTANCE: {
                this.zBeamValue = this.distanceToDetector.getSelection();
            }
        }
        this.modifyDetectorOrigin();
    }

    private void modifyDetectorOrigin() {
        if (this.diffView.detConfig == null || this.diffView.diffEnv == null) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.xBeam.setSelection(DiffractionViewerMetadata.this.xBeamValue);
                DiffractionViewerMetadata.this.yBeam.setSelection(DiffractionViewerMetadata.this.yBeamValue);
                DiffractionViewerMetadata.this.distanceToDetector.setSelection(DiffractionViewerMetadata.this.zBeamValue);
            }
        });
        this.beamCorrection = new Vector3d((double)this.xBeamValue / scale, (double)this.yBeamValue / scale, (double)this.zBeamValue / scale);
        this.diffView.detConfig.setOrigin(this.beamCorrection);
        this.diffView.updateDiffractionObjects(this.showBeam.getSelection());
    }

    protected void cacheMetadata() {
        if (!(CACHED_METADATA || this.diffView.detConfig == null && this.diffView.diffEnv == null)) {
            this.cachedDetConfig = this.diffView.detConfig.clone();
            this.cachedDiffEnv = this.diffView.diffEnv.clone();
            CACHED_METADATA = true;
        }
    }

    protected void retrieveSettings() {
        if (this.cachedDetConfig != null || this.cachedDiffEnv != null) {
            this.diffView.detConfig = this.cachedDetConfig;
            this.diffView.diffEnv = this.cachedDiffEnv;
            this.setupSpinners();
            this.diffView.updateDiffractionObjects(this.showBeam.getSelection());
            CACHED_METADATA = false;
        }
    }

    protected void checkSubclass() {
    }

    public void dispose() {
    }

    public void setMetadata() {
        if (this.diffView.detConfig != null && this.diffView.diffEnv != null) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    double d = ((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.diffEnv.getPhiStart();
                    double d2 = ((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.diffEnv.getPhiRange();
                    DiffractionViewerMetadata.this.phiStart.setText(DiffractionViewerMetadata.this.decimaPlaces.format(d));
                    DiffractionViewerMetadata.this.phiRange.setText(DiffractionViewerMetadata.this.decimaPlaces.format(d2));
                    DiffractionViewerMetadata.this.phiStop.setText(DiffractionViewerMetadata.this.decimaPlaces.format(d + d2));
                    DiffractionViewerMetadata.this.ExposureTime.setText(DiffractionViewerMetadata.this.decimaPlaces.format(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.diffEnv.getExposureTime()));
                    DiffractionViewerMetadata.this.detectorSizeX.setText(DiffractionViewerMetadata.this.decimaPlaces.format(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getDetectorSizeH()));
                    DiffractionViewerMetadata.this.detectorSizeY.setText(DiffractionViewerMetadata.this.decimaPlaces.format(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getDetectorSizeV()));
                    DiffractionViewerMetadata.this.PixelSizeX.setText(DiffractionViewerMetadata.this.decimaPlaces.format(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getHPxSize()));
                    DiffractionViewerMetadata.this.PixelSizeY.setText(DiffractionViewerMetadata.this.decimaPlaces.format(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getVPxSize()));
                }
            });
            if (this.lockSettings) {
                CACHED_METADATA = false;
                this.cacheMetadata();
                this.diffView.detConfig.setOrigin(this.beamCorrection);
                this.diffView.diffEnv.setWavelength((double)this.wavelength.getSelection() / scale);
            }
        } else {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiffractionViewerMetadata.this.phiStart.setText("0.0");
                    DiffractionViewerMetadata.this.phiRange.setText("0.0");
                    DiffractionViewerMetadata.this.phiStop.setText("0.0");
                    DiffractionViewerMetadata.this.ExposureTime.setText("0.0");
                    DiffractionViewerMetadata.this.detectorSizeX.setText("0.0");
                    DiffractionViewerMetadata.this.detectorSizeY.setText("0.0");
                    DiffractionViewerMetadata.this.PixelSizeX.setText("0.0");
                    DiffractionViewerMetadata.this.PixelSizeY.setText("0.0");
                }
            });
        }
        this.setupSpinners();
    }

    protected void setupSpinners() {
        int n;
        if (this.diffView.detConfig == null || this.diffView.diffEnv == null) {
            this.xBeamValue = 0;
            this.yBeamValue = 0;
            this.zBeamValue = 0;
            n = 0;
            this.beamCorrection = new Vector3d((double)this.xBeamValue / scale, (double)this.yBeamValue / scale, (double)this.zBeamValue / scale);
        } else {
            this.xBeamValue = (int)Math.floor(this.diffView.detConfig.getOrigin().x * scale);
            this.yBeamValue = (int)Math.floor(this.diffView.detConfig.getOrigin().y * scale);
            this.zBeamValue = (int)Math.floor(this.diffView.detConfig.getOrigin().z * scale);
            n = (int)Math.floor(this.diffView.diffEnv.getWavelength() * scale);
            this.beamCorrection = new Vector3d((double)this.xBeamValue / scale, (double)this.yBeamValue / scale, (double)this.zBeamValue / scale);
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.wavelength.setSelection(n);
                DiffractionViewerMetadata.this.xBeam.setSelection(DiffractionViewerMetadata.this.xBeamValue);
                DiffractionViewerMetadata.this.yBeam.setSelection(DiffractionViewerMetadata.this.yBeamValue);
                DiffractionViewerMetadata.this.distanceToDetector.setSelection(DiffractionViewerMetadata.this.zBeamValue);
            }
        });
        this.diffView.updateDiffractionObjects(this.showBeam.getSelection());
    }

    private double getDoubleFromMetadata(String string) {
        Object object = this.metadata.get(string);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return 0.0;
    }

    public void setDatasetInformation(final Number number, final Number number2, final Number number3) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.minPxVal.setText(DiffractionViewerMetadata.this.decimaPlaces.format(number2.doubleValue()));
                DiffractionViewerMetadata.this.maxPxVal.setText(DiffractionViewerMetadata.this.decimaPlaces.format(number.doubleValue()));
                DiffractionViewerMetadata.this.meanPxVal.setText(DiffractionViewerMetadata.this.decimaPlaces.format(number3.doubleValue()));
            }
        });
    }

    public void updateBeamPositionFromDragging() {
        this.cacheMetadata();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                int n = (int)Math.floor(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getOrigin().x * scale);
                int n2 = (int)Math.floor(((DiffractionViewerMetadata)DiffractionViewerMetadata.this).diffView.detConfig.getOrigin().y * scale);
                DiffractionViewerMetadata.this.xBeam.setSelection(n);
                DiffractionViewerMetadata.this.yBeam.setSelection(n2);
                DiffractionViewerMetadata.this.xBeamValue = n;
                DiffractionViewerMetadata.this.yBeamValue = n2;
                DiffractionViewerMetadata.this.modifyDetectorOrigin();
            }
        });
    }

    public void showBeamCentre(final boolean bl) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.showBeam.setSelection(bl);
            }
        });
    }

    public boolean isBeamCentreToggled() {
        return this.showBeam.getSelection();
    }

    public void setThreshold(final double d) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewerMetadata.this.overload.setText(DiffractionViewerMetadata.this.decimaPlaces.format(d));
            }
        });
    }

    public static enum beamMovement {
        BEAM_LEFT,
        BEAM_UP,
        BEAM_RIGHT,
        BEAM_DOWN,
        BEAM_DISTANCE;

    }
}

