/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.Vector3d;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;
import uk.ac.diamond.scisoft.analysis.diffraction.Resolution;
import uk.ac.diamond.scisoft.analysis.io.IDiffractionMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSet3DPlot3D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.LinearROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionNumericalSpotExaminer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionPeakViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionSpotExaminer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewerMetadata;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewerResolutionRings;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.DiffractionViewerSpotFit;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.ImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.roi.LinearROI;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.ROIList;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.ResolutionRing;
import uk.ac.diamond.scisoft.analysis.roi.ResolutionRingList;

public class DiffractionViewer
extends SidePlotProfile
implements de.jreality.ui.viewerapp.SelectionListener {
    private static Logger logger = LoggerFactory.getLogger(DiffractionViewer.class);
    public static String ID = "uk.ac.diamond.scisoft.analysis.rcp.DiffractionViewer";
    public static final double lineStep = 0.5;
    public DetectorProperties detConfig;
    public DiffractionCrystalEnvironment diffEnv;
    public DiffractionViewerSpotFit diffSpotFit;
    public HashMap<String, Object> metadata;
    private DiffractionViewerMetadata diffViewMetadata;
    private DiffractionPeakViewer peakViewer;
    private DiffractionSpotExaminer spotEximiner;
    private DiffractionNumericalSpotExaminer numericalSpotEximiner;
    private RectangularROI rectROI = null;
    private RectangularROIHandler rectRioHandler;
    private Action setDiffractionMode;
    private String standardName;
    private String standardDistances;
    private HandleStatus hStatus = HandleStatus.NONE;
    private DiffractionViewerResolutionRings resRingTable;
    private ArrayList<Integer> boxIDs;
    private ArrayList<Integer> ringID;
    private boolean isLine;
    private int[] beamCentrePrimitive = new int[]{-1, -1};
    private int maskPrimID = -1;
    private boolean mask;
    public boolean beamVisable = false;
    private static int MAX_SIZE_3D_PLOT;
    private int[] tempMousePos;
    private HistogramUpdate histoUpdate = null;
    private TabFolder peakAndMetadata;
    private int tabFolderIndex = 2;
    private double threshold = 0.0;
    private Action diffractionViewer;
    private int rectROISizeX;
    private int rectROISizeY;
    private boolean rectRoiBox = false;
    private boolean draggedRectROI;
    private boolean beamRePosition;

    @Override
    public void createPartControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new FillLayout());
        this.peakAndMetadata = new TabFolder(this.container, 0);
        TabItem tabItem = new TabItem(this.peakAndMetadata, 0);
        tabItem.setText("Line Profile");
        this.diffSpotFit = new DiffractionViewerSpotFit((Composite)this.peakAndMetadata, 0, this);
        this.addPropertyListeners();
        this.setFittingDefaults();
        this.setThresholdDefaullts();
        tabItem.setControl((Control)this.diffSpotFit);
        TabItem tabItem2 = new TabItem(this.peakAndMetadata, 0);
        tabItem2.setText("Resolution Ring");
        this.resRingTable = new DiffractionViewerResolutionRings((Composite)this.peakAndMetadata, 0, this);
        tabItem2.setControl((Control)this.resRingTable);
        this.peakAndMetadata.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiffractionViewer.this.setRectRegionSize(DiffractionViewer.this.peakAndMetadata.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        TabItem tabItem3 = new TabItem(this.peakAndMetadata, 0);
        tabItem3.setText("Image Metadata");
        this.diffViewMetadata = new DiffractionViewerMetadata((Composite)this.peakAndMetadata, 0, this);
        tabItem3.setControl((Control)this.diffViewMetadata);
        TabItem tabItem4 = new TabItem(this.peakAndMetadata, 0);
        tabItem4.setText("Peak Profile");
        this.peakViewer = new DiffractionPeakViewer((Composite)this.peakAndMetadata, 0);
        tabItem4.setControl((Control)this.peakViewer);
        TabItem tabItem5 = new TabItem(this.peakAndMetadata, 0);
        tabItem5.setText("Spot View");
        this.spotEximiner = new DiffractionSpotExaminer((Composite)this.peakAndMetadata, 0);
        tabItem5.setControl((Control)this.spotEximiner);
        TabItem tabItem6 = new TabItem(this.peakAndMetadata, 0);
        tabItem6.setText("Numerical View");
        this.numericalSpotEximiner = new DiffractionNumericalSpotExaminer((Composite)this.peakAndMetadata, 0);
        tabItem6.setControl((Control)this.numericalSpotEximiner);
        this.peakAndMetadata.pack();
        if (this.histoUpdate != null) {
            this.peakViewer.sendHistogramUpdate(this.histoUpdate);
        }
        MAX_SIZE_3D_PLOT = (int)((double)(DataSet3DPlot3D.MAXDIM * DataSet3DPlot3D.MAXDIM) * 0.7);
        this.roiHandler = new LinearROIHandler((LinearROI)this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        this.ringID = new ArrayList();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.rectRioHandler = new RectangularROIHandler(this.rectROI);
        this.boxIDs = new ArrayList();
        this.oColour = new Color(0, 255, 0);
    }

    protected void setRectRegionSize(int n) {
        if (n <= 4) {
            this.rectROISizeX = 50;
            this.rectROISizeY = 50;
        }
        if (n == 5) {
            this.rectROISizeX = 30;
            this.rectROISizeY = 30;
        }
    }

    private void setThresholdDefaullts() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.threshold = iPreferenceStore.getInt("diffviewer.pixelOverLoadThreshold");
    }

    private void setFittingDefaults() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("diffviewer.peaktype");
        int n = iPreferenceStore.getInt("diffviewer.maxNumPeaks");
        Boolean bl = iPreferenceStore.getBoolean("diffviewer.autoStopping");
        int n2 = iPreferenceStore.getInt("diffviewer.stoppingThreshold");
        this.diffSpotFit.pushPreferences(string, n, bl, n2);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.diffViewMetadata.dispose();
        this.diffSpotFit.dispose();
        this.peakViewer.dispose();
        this.spotEximiner.dispose();
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Diffraction Viewer");
        action.setToolTipText("Switch side plot to Diffraction Viewer");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ruby.png"));
        return action;
    }

    @Override
    public void processPlotUpdate() {
        this.updateDataList();
        if (this.oProvider != null) {
            this.showOverlays();
            this.updatePlot();
            this.updatePlot3D();
        }
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public ROIList<? extends ROIBase> createROIList() {
        return null;
    }

    @Override
    public ROIData createNewROIData(ROIBase rOIBase) {
        return null;
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        Serializable serializable;
        int n = 0;
        if (guiBean == null) {
            return n;
        }
        if (guiBean.containsKey((Object)GuiParameters.ROIDATA) && (serializable = guiBean.get((Object)GuiParameters.ROIDATA)) instanceof LinearROI) {
            this.hideCurrent();
            this.roi = (LinearROI)serializable;
            this.roiHandler.setROI(this.roi);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiffractionViewer.this.updatePlot();
                    DiffractionViewer.this.updatePlot3D();
                    DiffractionViewer.this.drawCurrentOverlay();
                    DiffractionViewer.this.drawMask();
                    if (DiffractionViewer.this.rectROI != null) {
                        DiffractionViewer.this.drawRectangleOverlay(DiffractionViewer.this.rectROI);
                    }
                }
            });
            n |= 1;
        }
        return n;
    }

    @Override
    public void showOverlays() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.drawCurrentOverlay();
                DiffractionViewer.this.drawOverlays();
                DiffractionViewer.this.resRingTable.redrawExistingRings();
                DiffractionViewer.this.drawBeamCentre(DiffractionViewer.this.beamVisable);
                DiffractionViewer.this.showMask(DiffractionViewer.this.resRingTable.isMaskToggled());
            }
        });
    }

    @Override
    public void showSidePlot() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.updateDataList();
                DiffractionViewer.this.updatePlot();
                DiffractionViewer.this.updatePlot3D();
                DiffractionViewer.this.peakAndMetadata.setSelection(DiffractionViewer.this.tabFolderIndex);
            }
        });
        this.showOverlays();
    }

    @Override
    protected void drawOverlays() {
        if (this.rectROI != null) {
            this.drawRectangleOverlay(this.rectROI);
        }
    }

    @Override
    protected void drawCurrentOverlay() {
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roisIDs.isEmpty()) {
            this.roisIDs.add(-1);
        }
        int n = 0;
        LinearROI linearROI = (LinearROI)this.roi;
        int[] nArray = linearROI.getIntPoint();
        int[] nArray2 = linearROI.getIntEndPoint();
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n2 = (Integer)this.roisIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roisIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawArrow(n2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.setLineThickness(n2, this.oThickness);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        if (rOIBase != null) {
            this.diffSpotFit.processROI((IDataset)this.data, (LinearROI)rOIBase);
        }
    }

    private void updatePlot3D() {
        if (this.rectROI == null || this.mainPlotter == null) {
            return;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.spotEximiner.processROI((IDataset)DiffractionViewer.this.data, DiffractionViewer.this.rectROI);
            }
        });
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.peakViewer.processROI((IDataset)DiffractionViewer.this.data, DiffractionViewer.this.rectROI);
            }
        });
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.numericalSpotEximiner.populateTable((IDataset)DiffractionViewer.this.data, DiffractionViewer.this.rectROI);
            }
        });
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new LinearROI();
            this.roi.setPlot(true);
            this.roiHandler.setROI(this.roi);
        }
        int n = ((ImagePositionEvent)iImagePositionEvent).getPrimitiveID();
        short s = ((ImagePositionEvent)iImagePositionEvent).getFlags();
        this.cpt = ((ImagePositionEvent)iImagePositionEvent).getImagePosition();
        if ((s & 1) != 0) {
            if ((s & 4) != 0 && this.maskPrimID != -1) {
                if (this.maskPrimID == n) {
                    this.mask = true;
                    this.dragging = true;
                    this.isLine = false;
                }
            } else if ((s & 8) != 0 && this.beamVisable) {
                this.beamRePosition = true;
                this.dragging = true;
                this.isLine = false;
                this.diffViewMetadata.cacheMetadata();
            } else if (n == -1 || !this.roiHandler.contains(n)) {
                this.diffSpotFit.removePrimitives();
                this.roi.setPoint(this.cpt);
                this.hideCurrent();
                this.dragging = true;
                this.isLine = true;
            } else if (this.roiHandler.contains(n)) {
                int n2 = this.roiHandler.indexOf(n);
                if (n2 == 0 || n2 == 2) {
                    this.hStatus = HandleStatus.RESIZE;
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.REORIENT;
                    }
                } else if (n2 == 1) {
                    this.hStatus = HandleStatus.MOVE;
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                    }
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
                this.isLine = true;
            }
        }
        if ((s & 2) != 0) {
            if (this.mainPlotter instanceof DataSetPlotter) {
                ((DataSetPlotter)this.mainPlotter).getComposite().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((DataSetPlotter)DiffractionViewer.this.mainPlotter).getComposite().setFocus();
                    }
                });
            }
            if (this.rectROI == null) {
                this.rectROI = new RectangularROI();
            }
            if ((s & 4) != 0) {
                this.rectROI.setPoint(this.cpt);
                this.dragging = true;
                this.isLine = false;
                this.draggedRectROI = true;
                this.rectRoiBox = false;
            } else {
                double[] dArray = new double[]{this.cpt[0], this.cpt[1]};
                this.rectROI.setMidPoint(dArray);
                this.rectROI.setLengths((double)this.rectROISizeX, (double)this.rectROISizeY);
                this.drawRectangleOverlay(this.rectROI);
                this.rectRoiBox = true;
                this.draggedRectROI = false;
                this.dragging = false;
            }
        }
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        if (this.rectRoiBox) {
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                double[] dArray = new double[]{((ImagePositionEvent)iImagePositionEvent).getImagePosition()[0], ((ImagePositionEvent)iImagePositionEvent).getImagePosition()[1]};
                this.rectROI.setMidPoint(dArray);
                this.rectROI.setLengths((double)this.rectROISizeX, (double)this.rectROISizeY);
                this.drawRectangleOverlay(this.rectROI);
            }
        } else if (this.dragging) {
            if (this.beamRePosition) {
                if (System.currentTimeMillis() >= this.nextTime) {
                    this.nextTime = System.currentTimeMillis() + this.updateInterval;
                    this.updateBeamCentre(iImagePositionEvent);
                }
            } else if (this.mask && this.maskPrimID != -1) {
                if (System.currentTimeMillis() >= this.nextTime) {
                    this.nextTime = System.currentTimeMillis() + this.updateInterval;
                    this.updateMask(iImagePositionEvent);
                }
            } else if (this.isLine) {
                LinearROI linearROI = this.interpretMouseDragging(((ImagePositionEvent)iImagePositionEvent).getImagePosition());
                if (linearROI != null) {
                    this.drawDraggedOverlay((ROIBase)linearROI);
                    if (System.currentTimeMillis() >= this.nextTime) {
                        this.nextTime = System.currentTimeMillis() + this.updateInterval;
                        this.sendCurrentROI((ROIBase)linearROI);
                    }
                }
            } else {
                RectangularROI rectangularROI = this.interpretMouseDraggingRectangle(((ImagePositionEvent)iImagePositionEvent).getImagePosition());
                if (rectangularROI != null && System.currentTimeMillis() >= this.nextTime) {
                    this.nextTime = System.currentTimeMillis() + this.updateInterval;
                    if (rectangularROI.getIntLengths()[0] * rectangularROI.getIntLengths()[1] < MAX_SIZE_3D_PLOT) {
                        this.tempMousePos = iImagePositionEvent.getImagePosition();
                        this.drawRectangleOverlay(rectangularROI);
                    }
                }
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            if (this.mask) {
                this.mask = false;
            }
            if (this.beamRePosition) {
                this.beamRePosition = false;
                this.updateBeamCentre(iImagePositionEvent);
            } else if (this.isLine) {
                this.hideIDs(this.dragIDs);
                this.roi = this.interpretMouseDragging(((ImagePositionEvent)iImagePositionEvent).getImagePosition());
                this.roiHandler.setROI(this.roi);
                this.dragHandle = -1;
                this.hStatus = HandleStatus.NONE;
                this.drawCurrentOverlay();
                this.updatePlot();
            } else {
                this.rectROI = this.interpretMouseDraggingRectangle(((ImagePositionEvent)iImagePositionEvent).getImagePosition());
                this.rectRioHandler.setROI((ROIBase)this.rectROI);
                this.dragHandle = -1;
                this.hStatus = HandleStatus.NONE;
                this.updatePlot3D();
            }
        }
        if (this.rectRoiBox) {
            this.rectRoiBox = false;
            this.dragging = false;
            this.rectRioHandler.setROI((ROIBase)this.rectROI);
            this.drawRectangleOverlay(this.rectROI);
            this.updatePlot3D();
        }
    }

    private void updateMask(IImagePositionEvent iImagePositionEvent) {
        int[] nArray = iImagePositionEvent.getImagePosition();
        int[] nArray2 = this.detConfig.pixelCoords(this.detConfig.getBeamPosition());
        int n = (int)Math.sqrt((nArray[0] - nArray2[0]) * (nArray[0] - nArray2[0]) + (nArray[1] - nArray2[1]) * (nArray[1] - nArray2[1]));
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawRing(this.maskPrimID, nArray2[0], nArray2[1], n, this.detConfig.distToCloestEdgeInPx() * 2);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void updateBeamCentre(IImagePositionEvent iImagePositionEvent) {
        int[] nArray = iImagePositionEvent.getImagePosition();
        nArray[0] = (int)((double)nArray[0] * this.detConfig.getHPxSize());
        nArray[1] = (int)((double)nArray[1] * this.detConfig.getVPxSize());
        Vector3d vector3d = new Vector3d((double)nArray[0], (double)nArray[1], this.detConfig.getOrigin().z);
        this.detConfig.setOrigin(vector3d);
        this.diffViewMetadata.updateBeamPositionFromDragging();
        this.updateDiffractionObjects(true);
    }

    private RectangularROI interpretMouseDraggingRectangle(int[] nArray) {
        RectangularROI rectangularROI = null;
        switch (this.hStatus) {
            case MOVE: {
                rectangularROI = this.rectROI.copy();
                nArray[0] = nArray[0] - this.cpt[0];
                nArray[1] = nArray[1] - this.cpt[1];
                rectangularROI.addPoint(nArray);
                break;
            }
            case NONE: {
                rectangularROI = this.rectROI.copy();
                rectangularROI.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                rectangularROI = this.rectRioHandler.reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                rectangularROI = this.rectRioHandler.resize(this.dragHandle, this.cpt, nArray);
                break;
            }
            case ROTATE: {
                rectangularROI = this.rectROI.copy();
                double d = rectangularROI.getAngleRelativeToMidPoint(nArray);
                double[] dArray = rectangularROI.getMidPoint();
                rectangularROI.setAngle(d);
                rectangularROI.setMidPoint(dArray);
            }
        }
        return rectangularROI;
    }

    private LinearROI interpretMouseDragging(int[] nArray) {
        LinearROI linearROI = (LinearROI)this.roi;
        LinearROI linearROI2 = null;
        switch (this.hStatus) {
            case MOVE: {
                linearROI2 = linearROI.copy();
                linearROI2.addPoint(nArray);
                linearROI2.subPoint(this.cpt);
                break;
            }
            case NONE: {
                linearROI2 = linearROI.copy();
                linearROI2.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                linearROI2 = ((LinearROIHandler)this.roiHandler).reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                linearROI2 = ((LinearROIHandler)this.roiHandler).resize(this.dragHandle, nArray);
                break;
            }
            case ROTATE: {
                linearROI2 = linearROI.copy();
                double d = linearROI2.getAngleRelativeToMidPoint(nArray);
                double[] dArray = linearROI2.getMidPoint();
                linearROI2.setAngle(d);
                linearROI2.setMidPoint(dArray);
            }
        }
        return linearROI2;
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        LinearROI linearROI = (LinearROI)rOIBase;
        int[] nArray = linearROI.getIntPoint();
        int[] nArray2 = linearROI.getIntEndPoint();
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.LINE);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawLine(n2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void drawRectangleOverlay(RectangularROI rectangularROI) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        int[] nArray = rectangularROI.getIntPoint();
        double[] dArray = rectangularROI.getEndPoint();
        if (this.boxIDs.isEmpty()) {
            this.boxIDs.add(-1);
            this.boxIDs.add(-1);
        }
        if ((n2 = this.boxIDs.get(n = 0).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.boxIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawBox(n2, nArray[0], nArray[1], (int)dArray[0], (int)dArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    public void clearRings() {
        this.removeIDs(this.ringID);
        this.ringID.clear();
    }

    private void drawRings(ResolutionRingList resolutionRingList) {
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        while (n < resolutionRingList.size()) {
            int n2 = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE);
            int[] nArray = this.detConfig.pixelCoords(this.detConfig.getBeamPosition());
            int n3 = (int)Resolution.circularResolutionRingRadius((DetectorProperties)this.detConfig, (DiffractionCrystalEnvironment)this.diffEnv, (double)((ResolutionRing)resolutionRingList.get(n)).getWavelength());
            this.oProvider.setColour(n2, ((ResolutionRing)resolutionRingList.get(n)).getColour());
            this.oProvider.setStyle(n2, VectorOverlayStyles.OUTLINE);
            this.oProvider.setTransparency(n2, this.oTransparency);
            this.oProvider.setLineThickness(n2, this.oThickness);
            this.oProvider.setPrimitiveVisible(n2, ((ResolutionRing)resolutionRingList.get(n)).isVisible());
            this.oProvider.drawCircle(n2, nArray[0], nArray[1], n3);
            this.ringID.add(n2);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    public void drawBeamCentre(boolean bl) {
        this.diffViewMetadata.showBeamCentre(bl);
        this.resRingTable.showBeamCentre(bl);
        this.oProvider.begin(OverlayType.VECTOR2D);
        if (bl && this.detConfig != null) {
            if (this.beamCentrePrimitive[0] == -1) {
                this.beamCentrePrimitive[0] = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE);
            }
            if (this.beamCentrePrimitive[1] == -1) {
                this.beamCentrePrimitive[1] = this.oProvider.registerPrimitive(PrimitiveType.CIRCLE);
            }
            int[] nArray = this.detConfig.pixelCoords(this.detConfig.getBeamPosition());
            int n = (int)(1.0 + Math.sqrt(this.detConfig.getPx() * this.detConfig.getPx() + this.detConfig.getPy() * this.detConfig.getPy()) * 0.01);
            this.oProvider.setColour(this.beamCentrePrimitive[0], Color.RED);
            this.oProvider.setTransparency(this.beamCentrePrimitive[0], 0.6);
            this.oProvider.setLineThickness(this.beamCentrePrimitive[0], 3.0);
            this.oProvider.setOutlineColour(this.beamCentrePrimitive[0], Color.MAGENTA);
            this.oProvider.setPrimitiveVisible(this.beamCentrePrimitive[0], true);
            this.oProvider.drawCircle(this.beamCentrePrimitive[0], nArray[0], nArray[1], n);
            this.oProvider.setColour(this.beamCentrePrimitive[1], Color.YELLOW);
            this.oProvider.setTransparency(this.beamCentrePrimitive[1], 0.4);
            this.oProvider.setPrimitiveVisible(this.beamCentrePrimitive[1], true);
            this.oProvider.drawCircle(this.beamCentrePrimitive[1], nArray[0], nArray[1], (double)n * 0.3);
        }
        if (!bl && this.beamCentrePrimitive[0] != -1 && this.beamCentrePrimitive[1] != -1) {
            this.oProvider.unregisterPrimitive(this.beamCentrePrimitive[0]);
            this.oProvider.unregisterPrimitive(this.beamCentrePrimitive[1]);
            this.beamCentrePrimitive[0] = -1;
            this.beamCentrePrimitive[1] = -1;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void hideBeamCentre() {
        this.oProvider.setPrimitiveVisible(this.beamCentrePrimitive[0], false);
        this.oProvider.setPrimitiveVisible(this.beamCentrePrimitive[1], false);
    }

    public void updateRings(ResolutionRingList resolutionRingList) {
        this.clearRings();
        this.drawRings(resolutionRingList);
    }

    public void ringsVisible(boolean bl) {
        if (this.ringID.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < this.ringID.size()) {
            this.oProvider.setPrimitiveVisible(this.ringID.get(n), bl);
            ++n;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.drawCurrentOverlay();
            }
        });
    }

    public void selectionChanged(de.jreality.ui.viewerapp.SelectionEvent selectionEvent) {
    }

    @Override
    public void applyEditorValue() {
    }

    @Override
    public void processHistogramUpdate(HistogramUpdate histogramUpdate) {
        this.histoUpdate = histogramUpdate;
        this.peakViewer.sendHistogramUpdate(histogramUpdate);
        this.spotEximiner.sendHistogramUpdate(histogramUpdate);
    }

    public void drawMask() {
        if (this.detConfig == null) {
            return;
        }
        int[] nArray = this.detConfig.pixelCoords(this.detConfig.getBeamPosition());
        this.oProvider.begin(OverlayType.VECTOR2D);
        if (this.maskPrimID == -1) {
            int n = this.detConfig.distToCloestEdgeInPx();
            this.maskPrimID = this.oProvider.registerPrimitive(PrimitiveType.RING);
            this.oProvider.setColour(this.maskPrimID, Color.RED);
            this.oProvider.setTransparency(this.maskPrimID, 0.8);
            this.oProvider.setLineThickness(this.maskPrimID, 3.0);
            this.oProvider.drawRing(this.maskPrimID, nArray[0], nArray[1], n, n * 5);
        }
        this.oProvider.setPrimitiveVisible(this.maskPrimID, true);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    public void hideMask() {
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.setPrimitiveVisible(this.maskPrimID, false);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    private void showMask(boolean bl) {
        if (bl && this.resRingTable.isRingToggled()) {
            this.drawMask();
        }
        if (!bl) {
            this.hideMask();
        }
    }

    public void removeMask() {
        this.oProvider.unregisterPrimitive(this.maskPrimID);
        this.maskPrimID = -1;
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
    }

    @Override
    public void hideOverlays() {
        if (this.oProvider == null) {
            return;
        }
        super.hideOverlays();
        this.hideBeamCentre();
        this.hideMask();
        this.hideIDs(this.boxIDs);
        this.hideIDs(this.ringID);
    }

    @Override
    public void removePrimitives() {
        this.tabFolderIndex = this.peakAndMetadata.isDisposed() ? 0 : this.peakAndMetadata.getSelectionIndex();
        super.removePrimitives();
        if (this.oProvider == null) {
            return;
        }
        this.oProvider.unregisterPrimitive(this.beamCentrePrimitive[0]);
        this.oProvider.unregisterPrimitive(this.beamCentrePrimitive[1]);
        this.oProvider.unregisterPrimitive(this.boxIDs);
        this.boxIDs.clear();
        this.clearRings();
        this.removeMask();
    }

    @Override
    protected void updateDataList() {
        boolean bl = false;
        if (this.getDataset()) {
            this.diffViewMetadata.setDatasetInformation(this.data.max().doubleValue(), this.data.min().doubleValue(), (Double)this.data.mean());
            this.setThreshold();
            try {
                IMetaData iMetaData = this.data.getMetadata();
                if (iMetaData instanceof IDiffractionMetadata) {
                    IDiffractionMetadata iDiffractionMetadata = (IDiffractionMetadata)iMetaData;
                    this.detConfig = iDiffractionMetadata.getDetector2DProperties();
                    this.diffEnv = iDiffractionMetadata.getDiffractionCrystalEnvironment();
                    this.diffViewMetadata.setMetadata();
                    bl = true;
                }
            }
            catch (Exception exception) {
                logger.error("Could not create diffraction experiment objects");
            }
            if (!bl) {
                this.diffViewMetadata.setDatasetInformation(0.0, 0.0, 0.0);
                this.cleanUpDiffractionObjects();
                logger.warn("The metadata associated with this image appears to be corrupt or not in the expected format");
            }
        }
    }

    private void setThreshold() {
        IPreferenceStore iPreferenceStore;
        IMetaData iMetaData = this.data.getMetadata();
        if (iMetaData != null && this.mainPlotter instanceof DataSetPlotter) {
            try {
                Serializable serializable = iMetaData.getMetaValue("NXdetector:pixel_overload");
                Double d = null;
                if (serializable instanceof String) {
                    d = Double.valueOf((String)((Object)serializable));
                } else if (serializable instanceof Number) {
                    d = ((Number)serializable).doubleValue();
                }
                if (d != null) {
                    ((DataSetPlotter)this.mainPlotter).setOverloadThreshold(d);
                    this.diffViewMetadata.setThreshold(d);
                }
                return;
            }
            catch (Exception exception) {}
        }
        double d = (iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore()).isDefault("diffviewer.pixelOverLoadThreshold") ? iPreferenceStore.getDefaultDouble("diffviewer.pixelOverLoadThreshold") : iPreferenceStore.getDouble("diffviewer.pixelOverLoadThreshold");
        if (this.mainPlotter instanceof DataSetPlotter) {
            ((DataSetPlotter)this.mainPlotter).setOverloadThreshold(d);
            this.diffViewMetadata.setThreshold(d);
        }
    }

    private void cleanUpDiffractionObjects() {
        this.detConfig = null;
        this.diffEnv = null;
        this.diffViewMetadata.setMetadata();
    }

    private void addPropertyListeners() {
        AnalysisRCPActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
                if (string.equals("diffviewer.peaktype") || string.equals("diffviewer.maxNumPeaks") || string.equals("diffviewer.autoStopping") || string.equals("diffviewer.stoppingThreshold")) {
                    String string2 = iPreferenceStore.isDefault("diffviewer.peaktype") ? iPreferenceStore.getDefaultString("diffviewer.peaktype") : iPreferenceStore.getString("diffviewer.peaktype");
                    int n = iPreferenceStore.isDefault("diffviewer.maxNumPeaks") ? iPreferenceStore.getDefaultInt("diffviewer.maxNumPeaks") : iPreferenceStore.getInt("diffviewer.maxNumPeaks");
                    boolean bl = iPreferenceStore.isDefault("diffviewer.autoStopping") ? iPreferenceStore.getDefaultBoolean("diffviewer.autoStopping") : iPreferenceStore.getBoolean("diffviewer.autoStopping");
                    int n2 = iPreferenceStore.isDefault("diffviewer.stoppingThreshold") ? iPreferenceStore.getDefaultInt("diffviewer.stoppingThreshold") : iPreferenceStore.getInt("diffviewer.stoppingThreshold");
                    DiffractionViewer.this.diffSpotFit.pushPreferences(string2, n, bl, n2);
                } else if (string.equals("diffviewer.standardDistances") || string.equals("diffviewer.standardName")) {
                    if (iPreferenceStore.isDefault("diffviewer.standardName")) {
                        DiffractionViewer.this.standardName = iPreferenceStore.getDefaultString("diffviewer.standardName");
                    } else {
                        DiffractionViewer.this.standardName = iPreferenceStore.getDefaultString(iPreferenceStore.getString("diffviewer.standardName"));
                    }
                    if (iPreferenceStore.isDefault("diffviewer.standardDistances")) {
                        DiffractionViewer.this.standardDistances = iPreferenceStore.getDefaultString("diffviewer.standardDistances");
                    } else {
                        DiffractionViewer.this.standardDistances = iPreferenceStore.getString("diffviewer.standardDistances");
                    }
                } else if (string.equals("diffviewer.pixelOverLoadThreshold")) {
                    if (iPreferenceStore.isDefault("diffviewer.pixelOverLoadThreshold")) {
                        DiffractionViewer.this.threshold = iPreferenceStore.getDefaultInt("diffviewer.pixelOverLoadThreshold");
                    } else {
                        DiffractionViewer.this.threshold = iPreferenceStore.getInt("diffviewer.pixelOverLoadThreshold");
                    }
                    if (DiffractionViewer.this.mainPlotter instanceof DataSetPlotter) {
                        ((DataSetPlotter)DiffractionViewer.this.mainPlotter).setOverloadThreshold(DiffractionViewer.this.threshold);
                        DiffractionViewer.this.diffViewMetadata.setThreshold(DiffractionViewer.this.threshold);
                    }
                }
            }
        });
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, final IWorkbenchPartSite iWorkbenchPartSite) {
        this.diffractionViewer = new Action(){

            public void run() {
                IHandlerService iHandlerService = (IHandlerService)iWorkbenchPartSite.getService(IHandlerService.class);
                try {
                    iHandlerService.executeCommand("uk.ac.diamond.scisoft.analysis.rcp.ViewDiffractionViewerSettings", null);
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                }
            }
        };
        this.diffractionViewer.setText("Preferences");
        iMenuManager.add((IAction)this.diffractionViewer);
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        this.setDiffractionMode = new Action("", 2){

            public void run() {
                if (DiffractionViewer.this.mainPlotter instanceof DataSetPlotter) {
                    ((DataSetPlotter)DiffractionViewer.this.mainPlotter).setDiffractionMode(DiffractionViewer.this.setDiffractionMode.isChecked());
                    ((DataSetPlotter)DiffractionViewer.this.mainPlotter).setOverloadThreshold(DiffractionViewer.this.threshold);
                }
            }
        };
        this.setDiffractionMode.setText("Enable/Disable diffraction mode");
        this.setDiffractionMode.setDescription("Enable / Disable diffraction mode");
        this.setDiffractionMode.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/flag_red.png"));
        iToolBarManager.add((IAction)this.setDiffractionMode);
    }

    public void updateDiffractionObjects(final boolean bl) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DiffractionViewer.this.resRingTable.redrawExistingRings();
                DiffractionViewer.this.drawBeamCentre(bl || DiffractionViewer.this.resRingTable.isBeamCentreToggled());
                DiffractionViewer.this.updatePlot();
                DiffractionViewer.this.showMask(DiffractionViewer.this.resRingTable.isMaskToggled());
                if (DiffractionViewer.this.mainPlotter instanceof DataSetPlotter) {
                    if (DiffractionViewer.this.detConfig != null && DiffractionViewer.this.diffEnv != null) {
                        ((DataSetPlotter)DiffractionViewer.this.mainPlotter).setQSpace(new QSpace(DiffractionViewer.this.detConfig, DiffractionViewer.this.diffEnv));
                    } else {
                        ((DataSetPlotter)DiffractionViewer.this.mainPlotter).setQSpace(null);
                    }
                }
            }
        });
    }

    public static enum HandleStatus {
        NONE,
        MOVE,
        RESIZE,
        REORIENT,
        ROTATE;

    }
}

