/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.histogram.HistogramUpdate;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class DiffractionSpotExaminer
extends Composite {
    private DataSetPlotter plotter;
    private HistogramUpdate update;

    public DiffractionSpotExaminer(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new FillLayout(512));
        this.plotter = new DataSetPlotter(PlottingMode.TWOD, (Composite)this, false);
        this.plotter.setAxisModes(AxisMode.LINEAR_WITH_OFFSET, AxisMode.LINEAR_WITH_OFFSET, AxisMode.LINEAR);
    }

    public void processROI(IDataset iDataset, RectangularROI rectangularROI) {
        if (rectangularROI.getLengths()[0] <= 1.0 || rectangularROI.getLengths()[1] <= 1.0 || iDataset.getSize() <= 1) {
            return;
        }
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntPoint(1.0, 1.0);
        IDataset iDataset2 = iDataset.getSlice(new int[]{nArray[1], nArray[0]}, new int[]{nArray2[1], nArray2[0]}, new int[]{1, 1});
        this.plotter.setAxisOffset(rectangularROI.getPoint()[0], rectangularROI.getPoint()[1], 0.0);
        try {
            this.plotter.replaceCurrentPlot(iDataset2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        if (this.update != null) {
            this.plotter.applyColourCast(this.update.getRedMapFunction(), this.update.getGreenMapFunction(), this.update.getBlueMapFunction(), this.update.getAlphaMapFunction(), this.update.inverseRed(), this.update.inverseGreen(), this.update.inverseBlue(), this.update.inverseAlpha(), this.update.getMinValue(), this.update.getMaxValue());
        }
        this.plotter.refresh(true);
    }

    public void dispose() {
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
    }

    public void sendHistogramUpdate(HistogramUpdate histogramUpdate) {
        this.update = histogramUpdate;
        if (this.plotter == null) {
            return;
        }
        this.plotter.applyColourCast(histogramUpdate.getRedMapFunction(), histogramUpdate.getGreenMapFunction(), histogramUpdate.getBlueMapFunction(), histogramUpdate.getAlphaMapFunction(), histogramUpdate.inverseRed(), histogramUpdate.inverseGreen(), histogramUpdate.inverseBlue(), histogramUpdate.inverseAlpha(), histogramUpdate.getMinValue(), histogramUpdate.getMaxValue());
        this.plotter.refresh(true);
    }
}

