/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class DiffractionNumericalSpotExaminer
extends Composite {
    private static final double BACKGROUND_NOISE = 50.0;
    private String htmlTable = "<html><body></html></body>";
    public int MAX_NUMERICAL_SIZE = 100;
    private Browser browser;

    public DiffractionNumericalSpotExaminer(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new FormLayout());
        Composite composite2 = new Composite((Composite)this, 0);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.left = new FormAttachment(0);
        composite2.setLayoutData((Object)formData);
        composite2.setLayout((Layout)new FillLayout(256));
        try {
            this.browser = new Browser(composite2, 0);
            this.browser.setBackground(SWTResourceManager.getColor(1));
            this.browser.setText(this.htmlTable);
        }
        catch (Throwable throwable) {
            this.browser = null;
        }
    }

    public void populateTable(IDataset iDataset, RectangularROI rectangularROI) {
        if (rectangularROI.getLengths()[0] <= 1.0 || rectangularROI.getLengths()[1] <= 1.0 || iDataset.getSize() <= 1) {
            return;
        }
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntPoint(1.0, 1.0);
        IDataset iDataset2 = iDataset.getSlice(new int[]{nArray[1], nArray[0]}, new int[]{nArray2[1], nArray2[0]}, new int[]{1, 1});
        double d = iDataset2.min().doubleValue();
        double d2 = iDataset2.max().doubleValue() - d;
        this.htmlTable = "<html><body><table style=\"{align:right;font-size:10px}\">";
        int[] nArray3 = iDataset2.getShape();
        if (nArray3[0] > this.MAX_NUMERICAL_SIZE || nArray3[1] > this.MAX_NUMERICAL_SIZE) {
            this.htmlTable = "<html><body><p>Cannot plot numerical tabe of this size <br> Maximum Table size is " + this.MAX_NUMERICAL_SIZE + " X " + this.MAX_NUMERICAL_SIZE + "</p></html></body>";
        } else {
            int n = 0;
            while (n < nArray3[0]) {
                this.htmlTable = String.valueOf(this.htmlTable) + "<tr align=\"center\">";
                int n2 = 0;
                while (n2 < nArray3[1]) {
                    int n3;
                    try {
                        n3 = iDataset2.getInt(new int[]{n, n2});
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        System.out.println("fast is " + n2 + " and slow is " + n);
                        throw new IndexOutOfBoundsException();
                    }
                    this.htmlTable = d2 > 50.0 ? ((double)n3 > d + d2 * 0.5 ? String.valueOf(this.htmlTable) + "<td style=\"{color:red}\">" + n3 + "</td>" : ((double)n3 > d + d2 * 0.2 ? String.valueOf(this.htmlTable) + "<td style=\"{color:blue}\">" + n3 + "</td>" : ((double)n3 > d + d2 * 0.05 ? String.valueOf(this.htmlTable) + "<td style=\"{color:green}\">" + n3 + "</td>" : String.valueOf(this.htmlTable) + "<td>" + n3 + "</td>"))) : String.valueOf(this.htmlTable) + "<td>" + n3 + "</td>";
                    ++n2;
                }
                this.htmlTable = String.valueOf(this.htmlTable) + "</tr>";
                ++n;
            }
            this.htmlTable = String.valueOf(this.htmlTable) + "</table></html></body>";
        }
        if (this.browser != null) {
            this.browser.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiffractionNumericalSpotExaminer.this.browser.setText(DiffractionNumericalSpotExaminer.this.htmlTable);
                }
            });
        }
    }
}

