/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import com.swtdesigner.SWTResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.SDAPlotter;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DUIAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlottingMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlot;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.AbstractPlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotBean;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.PlotView;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.StaticScanPlotView;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.ui.actions.CheckableActionGroup;

public class DerivativeViewer
extends SidePlot
implements Overlay1DConsumer,
PlotView {
    private static final Logger logger = LoggerFactory.getLogger(DerivativeViewer.class);
    private DataSetPlotter plotter;
    private IPlotUI plotUI;
    private Composite parent;
    private Action first;
    private Action second;
    private Action third;
    private IAction showLeg;
    private Action sendToPlotView;
    private Action saveGraph;
    private Action printGraph;
    private Action copyGraph;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private int derivative = 1;

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        this.plotUI = iPlotUI;
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Derivative Viewer");
        action.setToolTipText("Show the derivative of the data set(s) plotted in a side plot.");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/SidePlot-Derivative.png"));
        return action;
    }

    @Override
    public void createPartControl(Composite composite) {
        this.parent = composite;
        this.parent.setLayout((Layout)new FillLayout());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        this.container = composite2;
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new FillLayout());
        this.plotter = new DataSetPlotter(PlottingMode.ONED, composite3);
        this.plotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        this.createDerivativeActions();
        this.createExportActions();
        this.createExtraActions();
        iToolBarManager.add((IAction)this.first);
        iToolBarManager.add((IAction)this.second);
        iToolBarManager.add((IAction)this.third);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "extraActions"));
        iToolBarManager.add((IAction)this.sendToPlotView);
        iToolBarManager.add(this.showLeg);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.plotter != null) {
            this.plotter.cleanUp();
        }
        this.plotter = null;
    }

    public AbstractDataset getXValues() {
        List<AxisValues> list = this.mainPlotter.getXAxisValues();
        return list.get(0).toDataset();
    }

    public Collection<AbstractDataset> getYValues() {
        List<AxisValues> list = this.mainPlotter.getXAxisValues();
        List<IDataset> list2 = this.mainPlotter.getCurrentDataSets();
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(list2.size());
        int n = 0;
        while (n < list2.size()) {
            DoubleDataset doubleDataset = list.get(n).toDataset();
            AbstractDataset abstractDataset = (AbstractDataset)list2.get(n);
            AbstractDataset abstractDataset2 = (AbstractDataset)list2.get(n);
            int n2 = 0;
            while (n2 < this.derivative) {
                abstractDataset2 = Maths.derivative((AbstractDataset)doubleDataset, (AbstractDataset)abstractDataset2, (int)this.derivative);
                ++n2;
            }
            abstractDataset2.setName("f" + this.getTicksFor(this.derivative) + " {" + abstractDataset.getName() + " }");
            arrayList.add(abstractDataset2);
            ++n;
        }
        return arrayList;
    }

    @Override
    public void processPlotUpdate() {
        if (this.mainPlotter == null) {
            this.clearPeakPlotter();
            return;
        }
        List<AxisValues> list = this.mainPlotter.getXAxisValues();
        List<IDataset> list2 = this.mainPlotter.getCurrentDataSets();
        if (list2 == null || list2.isEmpty()) {
            this.clearPeakPlotter();
            return;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(list2.size());
        int n = 0;
        while (n < list2.size()) {
            DoubleDataset doubleDataset = list.get(n).toDataset();
            AbstractDataset abstractDataset = (AbstractDataset)list2.get(n);
            AbstractDataset abstractDataset2 = (AbstractDataset)list2.get(n);
            int n2 = 0;
            while (n2 < this.derivative) {
                abstractDataset2 = Maths.derivative((AbstractDataset)doubleDataset, (AbstractDataset)abstractDataset2, (int)this.derivative);
                ++n2;
            }
            abstractDataset2.setName("f" + this.getTicksFor(this.derivative) + " {" + abstractDataset.getName() + " }");
            arrayList.add(abstractDataset2);
            ++n;
        }
        try {
            AbstractPlotView.createMultipleLegend(this.plotter, arrayList);
            this.plotter.replaceAllPlots(arrayList, list);
        }
        catch (PlotException plotException) {
            logger.error("Cannot update plot with " + arrayList);
        }
        this.plotter.refresh(false);
    }

    private String getTicksFor(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("'");
            ++n2;
        }
        return stringBuilder.toString();
    }

    @Override
    public void showSidePlot() {
        this.processPlotUpdate();
    }

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
    }

    @Override
    public void removePrimitives() {
    }

    private void clearPeakPlotter() {
        if (this.plotter != null) {
            try {
                this.plotter.replaceAllPlots(new ArrayList());
                this.removePrimitives();
            }
            catch (PlotException plotException) {
                logger.warn("The plot could not be cleared in " + this.getClass().getName());
            }
            this.plotter.refresh(false);
        }
    }

    @Override
    public void unregisterProvider() {
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
    }

    @Override
    public void addToHistory() {
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
        this.createExportActions();
        this.createExtraActions();
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iMenuManager.add((IAction)this.saveGraph);
        iMenuManager.add((IAction)this.copyGraph);
        iMenuManager.add((IAction)this.printGraph);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "extraActions"));
        iMenuManager.add((IAction)this.sendToPlotView);
    }

    @Override
    public void removeFromHistory() {
    }

    @Override
    public int updateGUI(GuiBean guiBean) {
        return 0;
    }

    @Override
    public String getPartName() {
        return this.getSite().getPart().getTitle();
    }

    @Override
    public PlotBean getPlotBean() {
        PlotBean plotBean = new PlotBean();
        return plotBean;
    }

    @Override
    public IWorkbenchPartSite getSite() {
        return ((ViewPart)this.plotUI.getSidePlotView()).getSite();
    }

    private void createDerivativeActions() {
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        this.first = new Action("First Derivative", 2){

            public void run() {
                DerivativeViewer.this.updatePlotInternal(1);
            }
        };
        checkableActionGroup.add((IAction)this.first);
        this.first.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/First-Derivative.png"));
        this.first.setChecked(true);
        this.second = new Action("Second Derivative", 2){

            public void run() {
                DerivativeViewer.this.updatePlotInternal(2);
            }
        };
        this.second.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/Second-Derivative.png"));
        checkableActionGroup.add((IAction)this.second);
        this.third = new Action("Third Derivative", 2){

            public void run() {
                DerivativeViewer.this.updatePlotInternal(3);
            }
        };
        this.third.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/Third-Derivative.png"));
        checkableActionGroup.add((IAction)this.third);
    }

    private void createExportActions() {
        this.saveGraph = new Action(){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(DerivativeViewer.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                DerivativeViewer.this.plotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.copyGraph = new Action(){

            public void run() {
                DerivativeViewer.this.plotter.copyGraph();
            }
        };
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.printGraph = new Action(){

            public void run() {
                DerivativeViewer.this.plotter.printGraph();
            }
        };
        this.printGraph.setText(this.printButtonText);
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
    }

    private void createExtraActions() {
        this.showLeg = Plot1DUIAdapter.createShowLegend(this.plotter);
        this.showLeg.setChecked(true);
        final DerivativeViewer derivativeViewer = this;
        this.sendToPlotView = new Action(){

            public void run() {
                try {
                    EclipseUtils.getActivePage().showView("uk.ac.diamond.scisoft.analysis.rcp.plotView2");
                    SDAPlotter.plot((String)"Plot 2", (IDataset)derivativeViewer.getXValues(), (IDataset[])((IDataset[])derivativeViewer.getYValues().toArray(new AbstractDataset[0])));
                }
                catch (Exception exception) {
                    logger.error("TODO put description of error here", (Throwable)exception);
                }
            }
        };
        this.sendToPlotView.setToolTipText("Send the results of the derivative to a separate plot view");
        Image image = SWTResourceManager.getImage(StaticScanPlotView.class, "/icons/chart_curve_add.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.sendToPlotView.setImageDescriptor(imageDescriptor);
        this.sendToPlotView.setText("Send derivative to Plot 2");
    }

    protected void updatePlotInternal(int n) {
        this.derivative = n;
        this.processPlotUpdate();
    }
}

