/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot;

import com.swtdesigner.SWTResourceManager;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.AxisValues;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.DataSetPlotter;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.IPlotUI;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotColorUtility;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.PlotException;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.actions.DropDownAction;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.AxisMode;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIDataList;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROIHandler;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.RectangularROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotProfile;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.SidePlotter1D;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.utils.PlotExportUtil;
import uk.ac.diamond.scisoft.analysis.rcp.queue.InteractiveJobAdapter;
import uk.ac.diamond.scisoft.analysis.rcp.util.FloatSpinner;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;
import uk.ac.diamond.scisoft.analysis.rcp.views.plot.StaticScanPlotView;
import uk.ac.diamond.scisoft.analysis.roi.ROIBase;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROIList;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class BoxProfile
extends SidePlotProfile {
    private static Logger logger = LoggerFactory.getLogger(BoxProfile.class);
    private DataSetPlotter majPlotter;
    private DataSetPlotter minPlotter;
    private Composite parent;
    private DropDownAction saveGraph;
    private DropDownAction copyGraph;
    private DropDownAction printGraph;
    private Action saveMin;
    private Action saveMaj;
    private Action copyMin;
    private Action copyMaj;
    private Action printMaj;
    private Action printMin;
    private MenuManager saveMenu;
    private MenuManager copyMenu;
    private MenuManager printMenu;
    private DropDownAction pushPlottingData;
    private Action pushMajorPlottingDataPlot1;
    private Action pushMajorPlottingDataPlot2;
    private Action pushMinorPlottingDataPlot1;
    private Action pushMinorPlottingDataPlot2;
    private Action removefromHistory;
    private Action addtoHistory;
    private String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    private String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    private String printImagePath = ResourceProperties.getResourceString("PRINT_IMAGE_PATH");
    private String copyButtonText = ResourceProperties.getResourceString("COPY_BUTTON");
    private String copyToolTipText = ResourceProperties.getResourceString("COPY_TOOLTIP");
    private String copyImagePath = ResourceProperties.getResourceString("COPY_IMAGE_PATH");
    private String saveButtonText = ResourceProperties.getResourceString("SAVE_BUTTON");
    private String saveToolTipText = ResourceProperties.getResourceString("SAVE_TOOLTIP");
    private String saveImagePath = ResourceProperties.getResourceString("SAVE_IMAGE_PATH");
    private HandleStatus hStatus = HandleStatus.NONE;
    private Spinner spsx;
    private Spinner spsy;
    private FloatSpinner splmaj;
    private FloatSpinner splmin;
    private FloatSpinner spang;
    private Text txSum;
    private SelectionListener clippingButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (((Button)selectionEvent.widget).getSelection()) {
                rectangularROI.setClippingCompensation(true);
            } else {
                rectangularROI.setClippingCompensation(false);
            }
            BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.updatePlot();
                }
            });
        }
    };
    private SelectionListener startPosListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            BoxProfile.this.roi.setPoint(BoxProfile.this.spsx.getSelection(), BoxProfile.this.spsy.getSelection());
            if (BoxProfile.this.isBulkUpdate) {
                return;
            }
            BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
            BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.updatePlot();
                    BoxProfile.this.drawCurrentOverlay();
                }
            });
        }
    };
    private SelectionListener lensListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            final RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (rectangularROI != null) {
                rectangularROI.setLengths(BoxProfile.this.splmaj.getDouble(), BoxProfile.this.splmin.getDouble());
                if (!BoxProfile.this.isBulkUpdate) {
                    BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
                }
                BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BoxProfile.this.splmaj.setDouble(rectangularROI.getLengths()[0]);
                        BoxProfile.this.splmin.setDouble(rectangularROI.getLengths()[1]);
                        if ((this).BoxProfile.this.isBulkUpdate) {
                            return;
                        }
                        BoxProfile.this.updatePlot();
                        BoxProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };
    private SelectionListener angListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            RectangularROI rectangularROI = (RectangularROI)BoxProfile.this.roi;
            if (rectangularROI != null) {
                rectangularROI.setAngleDegrees(BoxProfile.this.spang.getDouble());
                if (!BoxProfile.this.isBulkUpdate) {
                    BoxProfile.this.sendCurrentROI(BoxProfile.this.roi);
                }
                BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).BoxProfile.this.isBulkUpdate) {
                            return;
                        }
                        BoxProfile.this.updatePlot();
                        BoxProfile.this.drawCurrentOverlay();
                    }
                });
            }
        }
    };

    public BoxProfile() {
        this.roiClass = RectangularROI.class;
        this.roiListClass = RectangularROIList.class;
    }

    @Override
    public void createPartControl(Composite composite) {
        this.parent = composite;
        super.createPartControl(this.parent);
        this.container = new Composite(this.parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(this.container, 512);
        this.majPlotter = new SidePlotter1D((Composite)sashForm, "Major integrated profile");
        this.majPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.majPlotter.setXAxisLabel("Distance along major axis");
        this.minPlotter = new SidePlotter1D((Composite)sashForm, "Minor integrated profile");
        this.minPlotter.setAxisModes(AxisMode.CUSTOM, AxisMode.LINEAR, AxisMode.LINEAR);
        this.minPlotter.setXAxisLabel("Distance along minor axis");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)sashForm, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(6, false));
        group.setText("Current ROI");
        new Label((Composite)group, 0).setText("Start x:");
        this.spsx = new Spinner((Composite)group, 2048);
        this.spsx.setMinimum(-10000);
        this.spsx.setMaximum(10000);
        this.spsx.setIncrement(1);
        this.spsx.setPageIncrement(5);
        this.spsx.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("Length major:");
        this.splmaj = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.splmaj.addSelectionListener(this.lensListener);
        new Label((Composite)group, 0).setText("Angle:");
        this.spang = new FloatSpinner((Composite)group, 2048, 7, 2);
        this.spang.setMinimum(0.0);
        this.spang.setMaximum(360.0);
        this.spang.addSelectionListener(this.angListener);
        new Label((Composite)group, 0).setText("Start y:");
        this.spsy = new Spinner((Composite)group, 2048);
        this.spsy.setMinimum(-10000);
        this.spsy.setMaximum(10000);
        this.spsy.setIncrement(1);
        this.spsy.setPageIncrement(5);
        this.spsy.addSelectionListener(this.startPosListener);
        new Label((Composite)group, 0).setText("Length minor:");
        this.splmin = new FloatSpinner((Composite)group, 2048, 6, 2);
        this.splmin.addSelectionListener(this.lensListener);
        new Label((Composite)group, 0).setText("Sum:");
        this.txSum = new Text((Composite)group, 2056);
        this.txSum.setTextLimit(12);
        Object object = new GridData();
        object.horizontalSpan = 2;
        Button button = new Button((Composite)group, 32);
        button.setLayoutData(object);
        button.setText("Invert brightness");
        button.setToolTipText("Invert overlay brightness");
        button.addSelectionListener(this.brightnessButtonListener);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Button button2 = new Button((Composite)group, 32);
        button2.setLayoutData((Object)gridData);
        button2.setText("Clipping comp");
        button2.setToolTipText("Compensate for clipping of region of interests");
        button2.addSelectionListener(this.clippingButtonListener);
        new Label((Composite)group, 0).setText("");
        new Label((Composite)group, 0).setText("");
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        Button button3 = new Button((Composite)group, 8);
        button3.setLayoutData((Object)gridData2);
        button3.setText("Copy current to table");
        button3.addSelectionListener(this.copyButtonListener);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        Button button4 = new Button((Composite)group, 8);
        button4.setLayoutData((Object)gridData3);
        button4.setText("Delete current");
        button4.addSelectionListener(this.deleteButtonListener);
        group = new Composite((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{25, 25, 30, 20});
        group.setLayout((Layout)new FillLayout());
        this.tViewer = new RectangularROITableViewer((Composite)group, this, this);
        scrolledComposite.setContent((Control)composite2);
        composite2.setSize(composite2.computeSize(-1, -1));
        this.majPlotter.refresh(false);
        this.minPlotter.refresh(false);
        this.updateAllSpinnersInt((RectangularROI)this.roi);
        this.roiIDs = new ArrayList();
        this.dragIDs = new ArrayList();
        if (this.roiDataList == null) {
            this.roiDataList = new ROIDataList();
        }
        this.roisIDs = new ArrayList();
        this.tViewer.setInput(this.roiDataList);
        this.roiHandler = new RectangularROIHandler((RectangularROI)this.roi);
        this.dColour = new Color(0, 255, 0);
        object = Color.RGBtoHSB(this.dColour.getRed(), this.dColour.getGreen(), this.dColour.getBlue(), null);
        this.cColour = Color.getHSBColor((float)object[0], (float)object[1], (float)(1.0 - 0.7 * (double)object[2]));
        this.oColour = this.dColour;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.majPlotter != null) {
            this.majPlotter.cleanUp();
        }
        if (this.minPlotter != null) {
            this.minPlotter.cleanUp();
        }
    }

    @Override
    protected void updatePlot(ROIBase rOIBase) {
        RectangularROI rectangularROI = (RectangularROI)rOIBase;
        this.getDataset();
        if (this.data == null) {
            logger.warn("No data");
            return;
        }
        if (rectangularROI != null) {
            if (this.dragging && this.subData != null) {
                try {
                    BoxJob boxJob = new BoxJob(rectangularROI, true);
                    this.roiQueue.addJob(boxJob);
                }
                catch (Exception exception) {
                    logger.error("Cannot generate ROI data", (Throwable)exception);
                }
            } else {
                try {
                    BoxJob boxJob = new BoxJob(rectangularROI, false);
                    this.roiQueue.addJob(boxJob);
                }
                catch (Exception exception) {
                    logger.error("Cannot generate ROI data", (Throwable)exception);
                }
            }
        }
    }

    private void drawPlots(RectangularROI rectangularROI) {
        RectangularROIData rectangularROIData;
        Plot1DAppearance plot1DAppearance;
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        ArrayList<AxisValues> arrayList2 = new ArrayList<AxisValues>();
        int n = 0;
        int n2 = 0;
        Plot1DGraphTable plot1DGraphTable = this.majPlotter.getColourTable();
        int n3 = this.majPlotter.getNumHistory();
        if (rectangularROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add(this.roiData.getProfileData(0));
            arrayList2.add(this.roiData.getXAxis(0));
            ++n2;
            ++n;
        }
        int n4 = 0;
        int n5 = this.roiDataList.size();
        while (n4 < n5) {
            rectangularROIData = (RectangularROIData)this.roiDataList.get(n4);
            Color color = PlotColorUtility.getDefaultColour(n4 + 1);
            RGB rGB = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            rectangularROIData.setPlotColourRGB(rGB);
            if (rectangularROIData.isPlot()) {
                arrayList.add(rectangularROIData.getProfileData(0));
                arrayList2.add(rectangularROIData.getXAxis(0));
                if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(color, Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(color);
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                ++n2;
                ++n;
            }
            ++n4;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.majPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        arrayList.clear();
        arrayList2.clear();
        n = 0;
        n2 = 0;
        plot1DGraphTable = this.minPlotter.getColourTable();
        n3 = this.minPlotter.getNumHistory();
        if (rectangularROI != null) {
            if (n2 + n3 >= plot1DGraphTable.getLegendSize()) {
                plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(n), Plot1DStyles.SOLID, "Line 1");
                plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
            } else {
                plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n));
                plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                plot1DAppearance.setName("Line 1");
            }
            arrayList.add(this.roiData.getProfileData(1));
            arrayList2.add(this.roiData.getXAxis(1));
            ++n2;
            ++n;
        }
        int n6 = 0;
        n5 = this.roiDataList.size();
        while (n6 < n5) {
            rectangularROIData = (RectangularROIData)this.roiDataList.get(n6);
            if (rectangularROIData.isPlot()) {
                arrayList.add(rectangularROIData.getProfileData(1));
                arrayList2.add(rectangularROIData.getXAxis(1));
                if (n >= plot1DGraphTable.getLegendSize()) {
                    plot1DAppearance = new Plot1DAppearance(rectangularROIData.getPlotColour(), Plot1DStyles.SOLID, "Line " + (n + 1));
                    plot1DGraphTable.addEntryOnLegend(n2, plot1DAppearance);
                } else {
                    plot1DAppearance = plot1DGraphTable.getLegendEntry(n2);
                    plot1DAppearance.setColour(rectangularROIData.getPlotColour());
                    plot1DAppearance.setStyle(Plot1DStyles.SOLID);
                    plot1DAppearance.setName("Line " + (n + 1));
                }
                ++n2;
                ++n;
            }
            ++n6;
        }
        while (n3-- > 0) {
            plot1DAppearance = plot1DGraphTable.getLegendEntry(n2++);
            plot1DAppearance.setColour(PlotColorUtility.getDefaultColour(n++));
        }
        try {
            this.minPlotter.replaceAllPlots(arrayList, arrayList2);
        }
        catch (PlotException plotException) {
            plotException.printStackTrace();
        }
        this.majPlotter.updateAllAppearance();
        this.majPlotter.refresh(false);
        this.minPlotter.updateAllAppearance();
        this.minPlotter.refresh(false);
    }

    private void drawDraggedOverlay(ROIBase rOIBase) {
        int n;
        int n2;
        if (this.oProvider == null) {
            return;
        }
        if (this.dragIDs.isEmpty()) {
            this.dragIDs.add(-1);
        }
        if ((n2 = ((Integer)this.dragIDs.get(n = 0)).intValue()) == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.dragIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        RectangularROI rectangularROI = (RectangularROI)rOIBase;
        double[] dArray = rectangularROI.getPoint();
        double[] dArray2 = rectangularROI.getLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        this.oProvider.drawBox(n2, dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), dArray[0], dArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawCurrentOverlay() {
        if (this.oProvider == null || this.roi == null) {
            return;
        }
        if (this.roiIDs.isEmpty()) {
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
            this.roiIDs.add(-1);
        }
        int n = 0;
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        double[] dArray = this.roi.getPoint();
        double[] dArray2 = rectangularROI.getLengths();
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawBox(n2, dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), dArray[0], dArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, 0.9);
        this.oProvider.setStyle(n2, VectorOverlayStyles.FILLED);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawArrow(n2, dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1], 0.6666666666666666);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), dArray[0], dArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        n2 = (Integer)this.roiIDs.get(n);
        if (n2 == -1) {
            n2 = this.oProvider.registerPrimitive(PrimitiveType.ARROW);
            this.roiIDs.set(n, n2);
            if (n2 == -1) {
                return;
            }
        } else {
            this.oProvider.setPrimitiveVisible(n2, true);
        }
        ++n;
        this.oProvider.drawArrow(n2, dArray[0], dArray[1], dArray[0], dArray[1] + dArray2[1], 0.3333333333333333);
        this.oProvider.rotatePrimitive(n2, -rectangularROI.getAngle(), dArray[0], dArray[1]);
        this.oProvider.setColour(n2, this.oColour);
        this.oProvider.setTransparency(n2, this.oTransparency);
        this.getDataset();
        int n3 = this.calcHandleSize(this.data.getShape());
        int n4 = 0;
        int n5 = this.roiHandler.size();
        while (n4 < n5) {
            int n6 = (Integer)this.roiHandler.get(n4);
            if (n6 == -1) {
                n6 = this.oProvider.registerPrimitive(PrimitiveType.BOX, true);
                this.roiHandler.set(n4, n6);
            } else {
                this.oProvider.setPrimitiveVisible(n6, true);
            }
            int[] nArray = this.roiHandler.getHandlePoint(n4, n3);
            if (nArray == null) {
                this.oProvider.setPrimitiveVisible(n6, false);
            } else {
                this.oProvider.drawBox(n6, nArray[0], nArray[1], nArray[0] + n3, nArray[1] + n3);
                nArray = this.roiHandler.getAnchorPoint(n4, n3);
                this.oProvider.rotatePrimitive(n6, -rectangularROI.getAngle(), nArray[0], nArray[1]);
                this.oProvider.setAnchorPoints(n6, nArray[0], nArray[1]);
                this.oProvider.setStyle(n6, VectorOverlayStyles.FILLED_WITH_OUTLINE);
                this.oProvider.setColour(n6, this.oColour);
                this.oProvider.setOutlineColour(n6, this.oColour);
                this.oProvider.setLineThickness(n6, this.oThickness);
                this.oProvider.setTransparency(n6, 0.9);
                this.oProvider.setOutlineTransparency(n6, this.oTransparency);
            }
            ++n4;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    protected void drawOverlays() {
        if (this.oProvider == null) {
            return;
        }
        if (this.roiDataList.size() == 0) {
            return;
        }
        if (this.roisIDs.size() != this.roiDataList.size()) {
            logger.warn("Mismatch in number of primitives and ROIs!");
        }
        this.oProvider.begin(OverlayType.VECTOR2D);
        int n = 0;
        int n2 = this.roiDataList.size();
        while (n < n2) {
            int n3 = -1;
            try {
                n3 = (Integer)this.roisIDs.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.roisIDs.add(n, -1);
            }
            if (n3 == -1) {
                n3 = this.oProvider.registerPrimitive(PrimitiveType.BOX);
                this.roisIDs.set(n, n3);
            } else {
                this.oProvider.setPrimitiveVisible(n3, true);
            }
            RectangularROI rectangularROI = (RectangularROI)((ROIData)this.roiDataList.get(n)).getROI();
            double[] dArray = rectangularROI.getPoint();
            double[] dArray2 = rectangularROI.getLengths();
            this.oProvider.drawBox(n3, dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
            this.oProvider.rotatePrimitive(n3, -rectangularROI.getAngle(), dArray[0], dArray[1]);
            this.oProvider.setColour(n3, this.oColour);
            this.oProvider.setTransparency(n3, this.oTransparency);
            ++n;
        }
        this.oProvider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.hStatus = HandleStatus.NONE;
        if (this.roi == null) {
            this.roi = new RectangularROI();
            this.roi.setPlot(true);
            this.roiHandler.setROI(this.roi);
        }
        int n = iImagePositionEvent.getPrimitiveID();
        short s = iImagePositionEvent.getFlags();
        this.cpt = iImagePositionEvent.getImagePosition();
        if ((s & 1) != 0) {
            if (n == -1 || !this.roiHandler.contains(n)) {
                this.roi.setPoint(this.cpt);
                if (this.oProvider != null) {
                    this.oProvider.setPlotAreaCursor(2);
                }
                this.hideCurrent();
                this.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BoxProfile.this.spsx.setSelection(BoxProfile.this.roi.getIntPoint()[0]);
                        BoxProfile.this.spsy.setSelection(BoxProfile.this.roi.getIntPoint()[1]);
                    }
                });
                this.hStatus = HandleStatus.RESIZE;
                this.dragging = true;
            } else if (this.roiHandler.contains(n)) {
                int n2 = this.roiHandler.indexOf(n);
                if (n2 != 4) {
                    if ((s & 8) != 0) {
                        if (n2 % 2 == 1) {
                            this.hStatus = HandleStatus.ROTATE;
                            this.oProvider.setPlotAreaCursor(3);
                        } else {
                            this.hStatus = HandleStatus.REORIENT;
                            this.oProvider.setPlotAreaCursor(19);
                        }
                    } else {
                        this.hStatus = HandleStatus.RESIZE;
                        this.oProvider.setPlotAreaCursor(5);
                    }
                } else if (n2 == 4) {
                    if ((s & 8) != 0) {
                        this.hStatus = HandleStatus.ROTATE;
                        this.oProvider.setPlotAreaCursor(3);
                    } else {
                        this.hStatus = HandleStatus.MOVE;
                        this.oProvider.setPlotAreaCursor(21);
                    }
                }
                this.hideCurrent();
                this.drawDraggedOverlay(this.roi);
                this.dragging = true;
                this.dragHandle = n2;
                logger.debug("Selected handle {}", (Object)n2);
            }
        } else if ((s & 2) != 0 && this.roiHandler.contains(n)) {
            int n3 = this.roiHandler.indexOf(n);
            if (n3 != 4) {
                if (n3 % 2 == 1) {
                    this.hStatus = HandleStatus.ROTATE;
                    this.oProvider.setPlotAreaCursor(3);
                } else {
                    this.hStatus = HandleStatus.REORIENT;
                    this.oProvider.setPlotAreaCursor(19);
                }
            } else if (n3 == 4) {
                this.hStatus = HandleStatus.ROTATE;
                this.oProvider.setPlotAreaCursor(3);
            }
            this.hideCurrent();
            this.drawDraggedOverlay(this.roi);
            this.dragging = true;
            this.dragHandle = n3;
        }
    }

    private RectangularROI interpretMouseDragging(int[] nArray) {
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        RectangularROI rectangularROI2 = null;
        switch (this.hStatus) {
            case MOVE: {
                rectangularROI2 = rectangularROI.copy();
                nArray[0] = nArray[0] - this.cpt[0];
                nArray[1] = nArray[1] - this.cpt[1];
                rectangularROI2.addPoint(nArray);
                break;
            }
            case NONE: {
                rectangularROI2 = rectangularROI.copy();
                rectangularROI2.setEndPoint(nArray);
                break;
            }
            case REORIENT: {
                rectangularROI2 = ((RectangularROIHandler)this.roiHandler).reorient(this.dragHandle, nArray);
                break;
            }
            case RESIZE: {
                rectangularROI2 = ((RectangularROIHandler)this.roiHandler).resize(this.dragHandle, this.cpt, nArray);
                break;
            }
            case ROTATE: {
                rectangularROI2 = rectangularROI.copy();
                double d = rectangularROI2.getAngleRelativeToMidPoint(nArray);
                double[] dArray = rectangularROI2.getMidPoint();
                rectangularROI2.setAngle(d);
                rectangularROI2.setMidPoint(dArray);
            }
        }
        return rectangularROI2;
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        RectangularROI rectangularROI;
        if (this.dragging && (rectangularROI = this.interpretMouseDragging(iImagePositionEvent.getImagePosition())) != null) {
            this.drawDraggedOverlay((ROIBase)rectangularROI);
            if (System.currentTimeMillis() >= this.nextTime) {
                this.nextTime = System.currentTimeMillis() + this.updateInterval;
                this.updatePlot((ROIBase)rectangularROI);
                this.sendCurrentROI((ROIBase)rectangularROI);
                this.updateAllSpinners((ROIBase)rectangularROI);
            }
        }
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.hideIDs(this.dragIDs);
            this.oProvider.restoreDefaultPlotAreaCursor();
            this.roi = this.interpretMouseDragging(iImagePositionEvent.getImagePosition());
            this.roiHandler.setROI(this.roi);
            this.dragHandle = -1;
            this.hStatus = HandleStatus.NONE;
            this.drawCurrentOverlay();
            this.sendCurrentROI(this.roi);
            this.updateAllSpinners(this.roi);
            this.updatePlot();
        }
    }

    @Override
    protected void updateAllSpinners(ROIBase rOIBase) {
        if (rOIBase == null) {
            return;
        }
        final RectangularROI rectangularROI = (RectangularROI)rOIBase;
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BoxProfile.this.updateAllSpinnersInt(rectangularROI);
            }
        });
    }

    private void updateAllSpinnersInt(RectangularROI rectangularROI) {
        if (rectangularROI == null) {
            return;
        }
        this.isBulkUpdate = true;
        this.spsx.setSelection(rectangularROI.getIntPoint()[0]);
        this.spsy.setSelection(rectangularROI.getIntPoint()[1]);
        this.splmaj.setDouble(rectangularROI.getLengths()[0]);
        this.splmin.setDouble(rectangularROI.getLengths()[1]);
        this.isBulkUpdate = false;
        this.spang.setDouble(rectangularROI.getAngleDegrees());
    }

    public RectangularROIList createROIList() {
        RectangularROIList rectangularROIList = new RectangularROIList();
        if (this.roiDataList != null) {
            for (ROIData rOIData : this.roiDataList) {
                rectangularROIList.add((Object)((RectangularROI)rOIData.getROI()));
            }
        }
        return rectangularROIList;
    }

    @Override
    public ROIData createNewROIData(ROIBase rOIBase) {
        return new RectangularROIData((RectangularROI)rOIBase, this.data, (AbstractDataset)this.mask);
    }

    @Override
    public Action createSwitchAction(int n, IPlotUI iPlotUI) {
        Action action = super.createSwitchAction(n, iPlotUI);
        action.setText("Box profile");
        action.setToolTipText("Switch side plot to box profile mode");
        action.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/ProfileBox.png"));
        return action;
    }

    @Override
    public void addToHistory() {
        Plot1DAppearance plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.majPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.majPlotter.getNumHistory());
        this.majPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.majPlotter.pushGraphOntoHistory();
        plot1DAppearance = new Plot1DAppearance(PlotColorUtility.getDefaultColour(this.minPlotter.getColourTable().getLegendSize()), Plot1DStyles.SOLID, "History " + this.minPlotter.getNumHistory());
        this.minPlotter.getColourTable().addEntryOnLegend(plot1DAppearance);
        this.minPlotter.pushGraphOntoHistory();
    }

    @Override
    public void removeFromHistory() {
        if (this.majPlotter.getNumHistory() > 0) {
            this.majPlotter.getColourTable().deleteLegendEntry(this.majPlotter.getColourTable().getLegendSize() - 1);
            this.majPlotter.popGraphFromHistory();
            this.majPlotter.refresh(true);
        }
        if (this.minPlotter.getNumHistory() > 0) {
            this.minPlotter.getColourTable().deleteLegendEntry(this.minPlotter.getColourTable().getLegendSize() - 1);
            this.minPlotter.popGraphFromHistory();
            this.minPlotter.refresh(true);
        }
    }

    @Override
    public void generateToolActions(IToolBarManager iToolBarManager) {
        this.createExportActions();
        this.createHistoryActions();
        this.createPushPlotActions();
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        iToolBarManager.add((IAction)this.saveGraph);
        iToolBarManager.add((IAction)this.copyGraph);
        iToolBarManager.add((IAction)this.printGraph);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushHistoryActions"));
        iToolBarManager.add((IAction)this.addtoHistory);
        iToolBarManager.add((IAction)this.removefromHistory);
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushPlotActions"));
        iToolBarManager.add((IAction)this.pushPlottingData);
    }

    @Override
    public void generateMenuActions(IMenuManager iMenuManager, IWorkbenchPartSite iWorkbenchPartSite) {
        this.createExportActions();
        this.createHistoryActions();
        this.createPushPlotActions();
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + this.printButtonText));
        this.saveMenu = new MenuManager(this.saveButtonText, AnalysisRCPActivator.getImageDescriptor(this.saveImagePath), this.saveButtonText);
        this.saveMenu.add((IAction)this.saveMaj);
        this.saveMenu.add((IAction)this.saveMin);
        iMenuManager.add((IContributionItem)this.saveMenu);
        this.copyMenu = new MenuManager(this.copyButtonText, AnalysisRCPActivator.getImageDescriptor(this.copyImagePath), this.copyButtonText);
        this.copyMenu.add((IAction)this.copyMaj);
        this.copyMenu.add((IAction)this.copyMin);
        iMenuManager.add((IContributionItem)this.copyMenu);
        this.printMenu = new MenuManager(this.printButtonText, AnalysisRCPActivator.getImageDescriptor(this.printImagePath), this.printButtonText);
        this.printMenu.add((IAction)this.printMaj);
        this.printMenu.add((IAction)this.printMin);
        iMenuManager.add((IContributionItem)this.printMenu);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushHistoryActions"));
        iMenuManager.add((IAction)this.addtoHistory);
        iMenuManager.add((IAction)this.removefromHistory);
        iMenuManager.add((IContributionItem)new Separator(String.valueOf(this.getClass().getName()) + "pushPlotActions"));
        iMenuManager.add((IAction)this.pushMajorPlottingDataPlot1);
        iMenuManager.add((IAction)this.pushMinorPlottingDataPlot1);
        iMenuManager.add((IAction)this.pushMajorPlottingDataPlot2);
        iMenuManager.add((IAction)this.pushMinorPlottingDataPlot2);
    }

    private void createExportActions() {
        this.saveMaj = new Action("Save major profiles plot"){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(BoxProfile.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                BoxProfile.this.majPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveMin = new Action("Save minor profiles plot"){
            private String filename;

            public void run() {
                FileDialog fileDialog = new FileDialog(BoxProfile.this.parent.getShell(), 8192);
                String[] stringArray = new String[]{"*.jpg;*.JPG;*.jpeg;*.JPEG;*.png;*.PNG", "*.ps;*.eps", "*.svg;*.SVG"};
                if (this.filename != null) {
                    fileDialog.setFilterPath(new File(this.filename).getParent());
                } else {
                    String string = "/";
                    String string2 = SWT.getPlatform();
                    if (string2.equals("win32") || string2.equals("wpf")) {
                        string = "c:\\";
                    }
                    fileDialog.setFilterPath(string);
                }
                fileDialog.setFilterNames(PlotExportUtil.FILE_TYPES);
                fileDialog.setFilterExtensions(stringArray);
                this.filename = fileDialog.open();
                if (this.filename == null) {
                    return;
                }
                BoxProfile.this.minPlotter.saveGraph(this.filename, PlotExportUtil.FILE_TYPES[fileDialog.getFilterIndex()]);
            }
        };
        this.saveGraph = new DropDownAction();
        this.saveGraph.setText(this.saveButtonText);
        this.saveGraph.setToolTipText(this.saveToolTipText);
        this.saveGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.saveImagePath));
        this.saveGraph.add(this.saveMaj);
        this.saveGraph.add(this.saveMin);
        this.copyMaj = new Action("Copy major profiles plot"){

            public void run() {
                BoxProfile.this.majPlotter.copyGraph();
            }
        };
        this.copyMin = new Action("Copy minor profiles plot"){

            public void run() {
                BoxProfile.this.minPlotter.copyGraph();
            }
        };
        this.copyGraph = new DropDownAction();
        this.copyGraph.setText(this.copyButtonText);
        this.copyGraph.setToolTipText(this.copyToolTipText);
        this.copyGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.copyImagePath));
        this.copyGraph.add(this.copyMaj);
        this.copyGraph.add(this.copyMin);
        this.printMaj = new Action("Print major profiles plot"){

            public void run() {
                BoxProfile.this.majPlotter.printGraph();
            }
        };
        this.printMin = new Action("Print minor profiles plot"){

            public void run() {
                BoxProfile.this.minPlotter.printGraph();
            }
        };
        this.printGraph = new DropDownAction();
        this.printGraph.setToolTipText(this.printToolTipText);
        this.printGraph.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor(this.printImagePath));
        this.printGraph.add(this.printMaj);
        this.printGraph.add(this.printMin);
    }

    private void createHistoryActions() {
        this.addtoHistory = new Action(){

            public void run() {
                BoxProfile.this.addToHistory();
            }
        };
        this.addtoHistory.setText("Add current profiles to history");
        this.addtoHistory.setToolTipText("Add the current profiles to the plot history");
        this.addtoHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_put.png"));
        this.removefromHistory = new Action(){

            public void run() {
                BoxProfile.this.removeFromHistory();
            }
        };
        this.removefromHistory.setText("Remove last profiles from history");
        this.removefromHistory.setToolTipText("Remove the last profiles from the plot history");
        this.removefromHistory.setImageDescriptor(AnalysisRCPActivator.getImageDescriptor("icons/basket_remove.png"));
    }

    private void createPushPlotActions() {
        final IWorkbenchPartSite iWorkbenchPartSite = EclipseUtils.getPage().getActivePart().getSite();
        this.pushMajorPlottingDataPlot1 = new Action(){

            public void run() {
                BoxProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView1", 0);
            }
        };
        this.pushMajorPlottingDataPlot1.setText("Push major profiles to plot 1");
        Image image = SWTResourceManager.getImage(StaticScanPlotView.class, "/icons/chart_curve_add.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.pushMajorPlottingDataPlot1.setImageDescriptor(imageDescriptor);
        this.pushMajorPlottingDataPlot1.setToolTipText("Push major profiles to plot 1");
        this.pushMajorPlottingDataPlot2 = new Action(){

            public void run() {
                BoxProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView2", 0);
            }
        };
        this.pushMajorPlottingDataPlot2.setText("Push major profiles to plot 2");
        this.pushMajorPlottingDataPlot2.setImageDescriptor(imageDescriptor);
        this.pushMajorPlottingDataPlot2.setToolTipText("Push major profiles to plot 2");
        this.pushMinorPlottingDataPlot1 = new Action(){

            public void run() {
                BoxProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView1", 1);
            }
        };
        this.pushMinorPlottingDataPlot1.setText("Push minor profiles to plot 1");
        this.pushMinorPlottingDataPlot1.setImageDescriptor(imageDescriptor);
        this.pushMinorPlottingDataPlot1.setToolTipText("Push minor profiles to plot 1");
        this.pushMinorPlottingDataPlot2 = new Action(){

            public void run() {
                BoxProfile.this.pushPlottingData(iWorkbenchPartSite, "uk.ac.diamond.scisoft.analysis.rcp.plotView2", 1);
            }
        };
        this.pushMinorPlottingDataPlot2.setText("Push minor profiles to plot 2");
        this.pushMinorPlottingDataPlot2.setImageDescriptor(imageDescriptor);
        this.pushMinorPlottingDataPlot2.setToolTipText("Push minor profiles to plot 2");
        this.pushPlottingData = new DropDownAction();
        this.pushPlottingData.setToolTipText("Push plotting to plot 1 or 2");
        this.pushPlottingData.setImageDescriptor(imageDescriptor);
        this.pushPlottingData.add(this.pushMajorPlottingDataPlot1);
        this.pushPlottingData.add(this.pushMajorPlottingDataPlot2);
        this.pushPlottingData.add(this.pushMinorPlottingDataPlot1);
        this.pushPlottingData.add(this.pushMinorPlottingDataPlot2);
    }

    private class BoxJob
    extends InteractiveJobAdapter {
        private RectangularROI rroi = null;
        private boolean subsample;

        public BoxJob(RectangularROI rectangularROI, boolean bl) {
            this.rroi = rectangularROI;
            this.subsample = bl;
        }

        @Override
        public void run(IProgressMonitor iProgressMonitor) {
            if (this.isNull()) {
                return;
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            if (this.subsample) {
                BoxProfile.this.roiData = new RectangularROIData(this.rroi, BoxProfile.this.subData, (AbstractDataset)BoxProfile.this.mask, BoxProfile.this.subFactor);
            } else {
                if (BoxProfile.this.oProvider != null) {
                    BoxProfile.this.oProvider.setPlotAreaCursor(1);
                }
                BoxProfile.this.roiData = new RectangularROIData(this.rroi, BoxProfile.this.data, (AbstractDataset)BoxProfile.this.mask);
                if (BoxProfile.this.oProvider != null) {
                    BoxProfile.this.oProvider.restoreDefaultPlotAreaCursor();
                }
            }
            if (iProgressMonitor != null) {
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                iProgressMonitor.worked(1);
            }
            if (BoxProfile.this.roiData.isPlot()) {
                BoxProfile.this.drawPlots(this.rroi);
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.worked(1);
            }
            BoxProfile.this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BoxProfile.this.txSum.setText(String.format("%.3e", ((BoxJob)BoxJob.this).BoxProfile.this.roiData.getProfileSum()));
                }
            });
        }

        @Override
        public boolean isNull() {
            return this.rroi == null;
        }
    }

    private static enum HandleStatus {
        NONE,
        MOVE,
        RESIZE,
        REORIENT,
        ROTATE;

    }
}

