/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.SectorROIData;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public final class SectorROITableViewer
extends ROITableViewer {
    public SectorROITableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener) {
        super(composite, selectionListener, iCellEditorListener);
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        SectorROIData sectorROIData = (SectorROIData)object;
        if (sectorROIData != null) {
            SectorROI sectorROI = sectorROIData.getROI();
            switch (n) {
                case 1: {
                    string = Integer.toString(sectorROI.getIntPoint()[0]);
                    break;
                }
                case 2: {
                    string = Integer.toString(sectorROI.getIntPoint()[1]);
                    break;
                }
                case 3: {
                    string = String.format("%.2f", sectorROI.getRadii()[0]);
                    break;
                }
                case 4: {
                    string = String.format("%.2f", sectorROI.getRadii()[1]);
                    break;
                }
                case 5: {
                    string = String.format("%.2f", sectorROI.getAngles()[0]);
                    break;
                }
                case 6: {
                    string = String.format("%.2f", sectorROI.getAngles()[1]);
                    break;
                }
                case 7: {
                    if (sectorROI.isClippingCompensation()) {
                        string = "Y";
                        break;
                    }
                    string = "N";
                    break;
                }
                case 8: {
                    string = sectorROI.getSymmetryText();
                    break;
                }
                case 9: {
                    if (sectorROI.isCombineSymmetry()) {
                        string = "Y";
                        break;
                    }
                    string = "N";
                    break;
                }
                case 10: {
                    string = String.format("%.2f", sectorROIData.getProfileSum());
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Plot", "x_c", "y_c", "r_i", "r_o", "phi_s", "phi_e", "Clip", "Sym", "Combine", "Sum"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{40, 50, 50, 70, 70, 70, 70, 40, 40, 40, 80};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Plot", "Centre x", "Centre y", "Inner radius", "Outer radius", "Start angle", "End angle", "Clipping compensation", "Symmetry for ROI", "Combine symmetric sector", "Sum of profile"};
    }
}

