/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import uk.ac.diamond.scisoft.analysis.coords.SectorCoords;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIHandles;
import uk.ac.diamond.scisoft.analysis.roi.SectorROI;

public class SectorROIHandler
extends ROIHandles {
    private static final int NHANDLE = 10;

    public SectorROIHandler(SectorROI sectorROI) {
        int n = 0;
        while (n < 10) {
            this.add(-1);
            ++n;
        }
        this.roi = sectorROI;
    }

    public SectorROI getROI() {
        return (SectorROI)this.roi;
    }

    @Override
    public int[] getHandlePoint(int n, int n2) {
        return null;
    }

    public double[] getSectorPoint(int n, int n2, double d) {
        SectorROI sectorROI = (SectorROI)this.roi;
        double[] dArray = new double[2];
        switch (n) {
            case 0: {
                dArray[0] = sectorROI.getRadius(0);
                dArray[1] = sectorROI.getAngle(0);
                break;
            }
            case 1: {
                dArray[0] = sectorROI.getRadius(0);
                dArray[1] = 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1) - d);
                break;
            }
            case 2: {
                dArray[0] = sectorROI.getRadius(0);
                dArray[1] = sectorROI.getAngle(1) - d;
                break;
            }
            case 3: {
                dArray[0] = 0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1) - (double)n2);
                dArray[1] = sectorROI.getAngle(0);
                break;
            }
            case 4: {
                dArray[0] = 0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1) - (double)n2);
                dArray[1] = 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1) - d);
                break;
            }
            case 5: {
                dArray[0] = 0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1) - (double)n2);
                dArray[1] = sectorROI.getAngle(1) - d;
                break;
            }
            case 6: {
                dArray[0] = sectorROI.getRadius(1) - (double)n2;
                dArray[1] = sectorROI.getAngle(0);
                break;
            }
            case 7: {
                dArray[0] = sectorROI.getRadius(1) - (double)n2;
                dArray[1] = 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1) - d);
                break;
            }
            case 8: {
                dArray[0] = sectorROI.getRadius(1) - (double)n2;
                dArray[1] = sectorROI.getAngle(1) - d;
            }
        }
        return dArray;
    }

    @Override
    public int[] getAnchorPoint(int n, int n2) {
        SectorROI sectorROI = (SectorROI)this.roi;
        int[] nArray = new int[2];
        double[] dArray = this.roi.getPoint();
        SectorCoords sectorCoords = null;
        switch (n) {
            case 0: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(0), sectorROI.getAngle(0), false, false);
                break;
            }
            case 1: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(0), 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1)), false, false);
                break;
            }
            case 2: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(0), sectorROI.getAngle(1), false, false);
                break;
            }
            case 3: {
                sectorCoords = new SectorCoords(0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1)), sectorROI.getAngle(0), false, false);
                break;
            }
            case 4: {
                sectorCoords = new SectorCoords(0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1)), 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1)), false, false);
                break;
            }
            case 5: {
                sectorCoords = new SectorCoords(0.5 * (sectorROI.getRadius(0) + sectorROI.getRadius(1)), sectorROI.getAngle(1), false, false);
                break;
            }
            case 6: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(1), sectorROI.getAngle(0), false, false);
                break;
            }
            case 7: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(1), 0.5 * (sectorROI.getAngle(0) + sectorROI.getAngle(1)), false, false);
                break;
            }
            case 8: {
                sectorCoords = new SectorCoords(sectorROI.getRadius(1), sectorROI.getAngle(1), false, false);
            }
        }
        nArray[0] = (int)(dArray[0] + sectorCoords.getCartesian()[0]);
        nArray[1] = (int)(dArray[1] + sectorCoords.getCartesian()[1]);
        return nArray;
    }

    public SectorROI resize(int n, double[] dArray, double[] dArray2) {
        SectorROI sectorROI = null;
        if (n == 4) {
            return sectorROI;
        }
        sectorROI = (SectorROI)this.roi.copy();
        switch (n) {
            case -1: {
                double d;
                if (dArray[0] > dArray2[0]) {
                    d = dArray[0];
                    dArray[0] = dArray2[0];
                    dArray2[0] = d;
                }
                if (dArray[1] > dArray2[1]) {
                    d = dArray[1];
                    dArray[1] = dArray2[1];
                    dArray2[1] = d;
                }
                sectorROI.setRadii(dArray[0], dArray2[0]);
                sectorROI.setAngles(dArray[1], dArray2[1]);
                break;
            }
            case 0: {
                sectorROI.addRadius(0, dArray2[0] - dArray[0]);
                sectorROI.addAngle(0, dArray2[1] - dArray[1]);
                break;
            }
            case 1: {
                sectorROI.addRadius(0, dArray2[0] - dArray[0]);
                break;
            }
            case 2: {
                sectorROI.addRadius(0, dArray2[0] - dArray[0]);
                sectorROI.addAngle(1, dArray2[1] - dArray[1]);
                break;
            }
            case 3: {
                sectorROI.addAngle(0, dArray2[1] - dArray[1]);
                break;
            }
            case 5: {
                sectorROI.addAngle(1, dArray2[1] - dArray[1]);
                break;
            }
            case 6: {
                sectorROI.addRadius(1, dArray2[0] - dArray[0]);
                sectorROI.addAngle(0, dArray2[1] - dArray[1]);
                break;
            }
            case 7: {
                sectorROI.addRadius(1, dArray2[0] - dArray[0]);
                break;
            }
            case 8: {
                sectorROI.addRadius(1, dArray2[0] - dArray[0]);
                sectorROI.addAngle(1, dArray2[1] - dArray[1]);
            }
        }
        return sectorROI;
    }

    public SectorROI crmove(int n, double[] dArray, double[] dArray2) {
        SectorROI sectorROI = null;
        if (n == 4) {
            return sectorROI;
        }
        sectorROI = (SectorROI)this.roi.copy();
        switch (n) {
            case 0: 
            case 2: 
            case 6: 
            case 8: {
                sectorROI.addRadii(dArray2[0] - dArray[0]);
                sectorROI.addAngles(dArray2[1] - dArray[1]);
                break;
            }
            case 1: 
            case 7: {
                sectorROI.addRadii(dArray2[0] - dArray[0]);
                break;
            }
            case 3: 
            case 5: {
                sectorROI.addAngles(dArray2[1] - dArray[1]);
            }
        }
        return sectorROI;
    }
}

