/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIHandles;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class RectangularROIHandler
extends ROIHandles {
    private static final int NHANDLE = 9;

    public RectangularROIHandler(RectangularROI rectangularROI) {
        int n = 0;
        while (n < 9) {
            this.add(-1);
            ++n;
        }
        this.roi = rectangularROI;
    }

    public RectangularROI getROI() {
        return (RectangularROI)this.roi;
    }

    @Override
    public int[] getHandlePoint(int n, int n2) {
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        int[] nArray = null;
        switch (n) {
            case 0: {
                nArray = rectangularROI.getIntPoint();
                break;
            }
            case 1: {
                nArray = rectangularROI.getIntPoint(0.5, 0.0);
                nArray[0] = nArray[0] - n2 / 2;
                break;
            }
            case 2: {
                nArray = rectangularROI.getIntPoint(1.0, 0.0);
                nArray[0] = nArray[0] - n2;
                break;
            }
            case 3: {
                nArray = rectangularROI.getIntPoint(0.0, 0.5);
                nArray[1] = nArray[1] - n2 / 2;
                break;
            }
            case 4: {
                nArray = rectangularROI.getIntPoint(0.5, 0.5);
                nArray[0] = nArray[0] - n2 / 2;
                nArray[1] = nArray[1] - n2 / 2;
                break;
            }
            case 5: {
                nArray = rectangularROI.getIntPoint(1.0, 0.5);
                nArray[0] = nArray[0] - n2;
                nArray[1] = nArray[1] - n2 / 2;
                break;
            }
            case 6: {
                nArray = rectangularROI.getIntPoint(0.0, 1.0);
                nArray[1] = nArray[1] - n2;
                break;
            }
            case 7: {
                nArray = rectangularROI.getIntPoint(0.5, 1.0);
                nArray[0] = nArray[0] - n2 / 2;
                nArray[1] = nArray[1] - n2;
                break;
            }
            case 8: {
                nArray = rectangularROI.getIntPoint(1.0, 1.0);
                nArray[0] = nArray[0] - n2;
                nArray[1] = nArray[1] - n2;
            }
        }
        return nArray;
    }

    @Override
    public int[] getAnchorPoint(int n, int n2) {
        RectangularROI rectangularROI = (RectangularROI)this.roi;
        int[] nArray = null;
        switch (n) {
            case 0: {
                nArray = rectangularROI.getIntPoint();
                break;
            }
            case 1: {
                nArray = rectangularROI.getIntPoint(0.5, 0.0);
                break;
            }
            case 2: {
                nArray = rectangularROI.getIntPoint(1.0, 0.0);
                break;
            }
            case 3: {
                nArray = rectangularROI.getIntPoint(0.0, 0.5);
                break;
            }
            case 4: {
                nArray = rectangularROI.getIntPoint(0.5, 0.5);
                break;
            }
            case 5: {
                nArray = rectangularROI.getIntPoint(1.0, 0.5);
                break;
            }
            case 6: {
                nArray = rectangularROI.getIntPoint(0.0, 1.0);
                break;
            }
            case 7: {
                nArray = rectangularROI.getIntPoint(0.5, 1.0);
                break;
            }
            case 8: {
                nArray = rectangularROI.getIntPoint(1.0, 1.0);
            }
        }
        return nArray;
    }

    public RectangularROI resize(int n, int[] nArray, int[] nArray2) {
        RectangularROI rectangularROI = null;
        if (n == 4) {
            return rectangularROI;
        }
        rectangularROI = (RectangularROI)this.roi.copy();
        double[] dArray = rectangularROI.getEndPoint();
        switch (n) {
            case -1: {
                rectangularROI.setPoint(nArray);
                rectangularROI.setEndPoint(nArray2);
                break;
            }
            case 0: {
                nArray2[0] = nArray2[0] - nArray[0];
                nArray2[1] = nArray2[1] - nArray[1];
                rectangularROI.setPointKeepEndPoint(nArray2, true, true);
                break;
            }
            case 1: {
                nArray2[0] = nArray2[0] - nArray[0];
                nArray2[1] = nArray2[1] - nArray[1];
                rectangularROI.setPointKeepEndPoint(nArray2, false, true);
                break;
            }
            case 2: {
                rectangularROI.adjustKeepDiagonalPoint(nArray, dArray, nArray2, true);
                break;
            }
            case 3: {
                nArray2[0] = nArray2[0] - nArray[0];
                nArray2[1] = nArray2[1] - nArray[1];
                rectangularROI.setPointKeepEndPoint(nArray2, true, false);
                break;
            }
            case 5: {
                nArray2[0] = (int)((double)nArray2[0] + (dArray[0] - (double)nArray[0]));
                nArray2[1] = (int)((double)nArray2[1] + (dArray[1] - (double)nArray[1]));
                rectangularROI.setEndPoint(nArray2, true, false);
                break;
            }
            case 6: {
                rectangularROI.adjustKeepDiagonalPoint(nArray, dArray, nArray2, false);
                break;
            }
            case 7: {
                nArray2[0] = (int)((double)nArray2[0] + (dArray[0] - (double)nArray[0]));
                nArray2[1] = (int)((double)nArray2[1] + (dArray[1] - (double)nArray[1]));
                rectangularROI.setEndPoint(nArray2, false, true);
                break;
            }
            case 8: {
                nArray2[0] = (int)((double)nArray2[0] + (dArray[0] - (double)nArray[0]));
                nArray2[1] = (int)((double)nArray2[1] + (dArray[1] - (double)nArray[1]));
                rectangularROI.setEndPoint(nArray2, true, true);
                break;
            }
        }
        return rectangularROI;
    }

    public RectangularROI reorient(int n, int[] nArray) {
        RectangularROI rectangularROI = null;
        if (n == 4 || n % 2 == 1) {
            return rectangularROI;
        }
        RectangularROI rectangularROI2 = (RectangularROI)this.roi;
        rectangularROI = rectangularROI2.copy();
        switch (n) {
            case 0: {
                double d = rectangularROI2.getAngleRelativeToPoint(1.0, 1.0, rectangularROI2.getIntPoint());
                double d2 = rectangularROI2.getAngleRelativeToPoint(1.0, 1.0, nArray);
                rectangularROI.addAngle(d2 - d);
                rectangularROI.setEndPointKeepLengths(rectangularROI2.getEndPoint());
                break;
            }
            case 2: {
                double d = rectangularROI2.getAngleRelativeToPoint(0.0, 1.0, rectangularROI2.getIntPoint(1.0, 0.0));
                double d3 = rectangularROI2.getAngleRelativeToPoint(0.0, 1.0, nArray);
                rectangularROI.translate(0.0, 1.0);
                rectangularROI.addAngle(d3 - d);
                rectangularROI.translate(0.0, -1.0);
                break;
            }
            case 6: {
                double d = rectangularROI2.getAngleRelativeToPoint(1.0, 0.0, rectangularROI2.getIntPoint(0.0, 1.0));
                double d4 = rectangularROI2.getAngleRelativeToPoint(1.0, 0.0, nArray);
                rectangularROI.translate(1.0, 0.0);
                rectangularROI.addAngle(d4 - d);
                rectangularROI.translate(-1.0, 0.0);
                break;
            }
            case 8: {
                double d = rectangularROI2.getAngleRelativeToPoint(0.0, 0.0, rectangularROI2.getIntPoint(1.0, 1.0));
                double d5 = rectangularROI2.getAngleRelativeToPoint(0.0, 0.0, nArray);
                rectangularROI.addAngle(d5 - d);
            }
        }
        return rectangularROI;
    }
}

