/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.IRowData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROIData;

public abstract class ROITableViewer {
    private TableViewer tViewer;
    private static final int CHECKCOLNUM = 0;
    private Menu contextMenu;
    public static final int ROITABLEMENU_EDIT = 0;
    public static final int ROITABLEMENU_COPY = 1;
    public static final int ROITABLEMENU_DELETE = 2;
    public static final int ROITABLEMENU_DELETE_ALL = 3;

    public abstract String[] getTitles();

    public abstract String[] getTipTexts();

    public abstract int[] getWidths();

    public abstract String content(Object var1, int var2);

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public ROITableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener) {
        TableColumn tableColumn;
        TableViewerColumn tableViewerColumn;
        this.tViewer = new TableViewer(composite, 2564);
        String[] stringArray = this.getTitles();
        String[] stringArray2 = this.getTipTexts();
        int[] nArray = this.getWidths();
        int n = 0;
        while (n < stringArray.length) {
            tableViewerColumn = new TableViewerColumn(this.tViewer, 0);
            tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(stringArray[n]);
            tableColumn.setToolTipText(stringArray2[n]);
            tableColumn.setWidth(nArray[n]);
            tableColumn.setMoveable(true);
            tableViewerColumn.setEditingSupport((EditingSupport)new ROIEditingSupport((ColumnViewer)this.tViewer, n, iCellEditorListener));
            ++n;
        }
        Table table = this.tViewer.getTable();
        table.setHeaderVisible(true);
        this.tViewer.setContentProvider((IContentProvider)new ROIContentProvider());
        this.tViewer.setLabelProvider((IBaseLabelProvider)new ROILabelProvider());
        this.contextMenu = new Menu(this.tViewer.getControl());
        tableViewerColumn = new MenuItem(this.contextMenu, 8);
        tableViewerColumn.addSelectionListener(selectionListener);
        tableViewerColumn.setText("Edit");
        tableColumn = new MenuItem(this.contextMenu, 8);
        tableColumn.addSelectionListener(selectionListener);
        tableColumn.setText("Copy to current");
        MenuItem menuItem = new MenuItem(this.contextMenu, 8);
        menuItem.addSelectionListener(selectionListener);
        menuItem.setText("Delete");
        MenuItem menuItem2 = new MenuItem(this.contextMenu, 8);
        menuItem2.addSelectionListener(selectionListener);
        menuItem2.setText("Delete all");
        table.setMenu(this.contextMenu);
    }

    public void addLeftClickListener(ISelectionChangedListener iSelectionChangedListener) {
        this.tViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public final void refresh() {
        this.tViewer.refresh();
    }

    public final void setInput(Object object) {
        this.tViewer.setInput(object);
    }

    public final ISelection getSelection() {
        return this.tViewer.getSelection();
    }

    protected final class ROIContentProvider
    implements IStructuredContentProvider {
        protected ROIContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object == null) {
                return null;
            }
            return ((List)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    protected final class ROIEditingSupport
    extends EditingSupport {
        private CheckboxCellEditor editor;
        private int column;

        public ROIEditingSupport(ColumnViewer columnViewer, int n, ICellEditorListener iCellEditorListener) {
            super(columnViewer);
            if (n == 0) {
                this.editor = new CheckboxCellEditor(null, 32);
                this.editor.addListener(iCellEditorListener);
            }
            this.column = n;
        }

        protected boolean canEdit(Object object) {
            return true;
        }

        protected CellEditor getCellEditor(Object object) {
            return this.editor;
        }

        protected Object getValue(Object object) {
            ROIData rOIData = (ROIData)object;
            if (this.column == 0) {
                return rOIData.isPlot();
            }
            return null;
        }

        protected void setValue(Object object, Object object2) {
            IRowData iRowData = (IRowData)object;
            if (this.column == 0) {
                iRowData.setPlot((Boolean)object2);
            }
            this.getViewer().update(object, null);
        }
    }

    protected final class ROILabelProvider
    implements ITableLabelProvider {
        private final Image CROSSED = AnalysisRCPActivator.getImageDescriptor("icons/cross.png").createImage();
        private final int height;
        private final int width;
        private final int linehalfthickness = 2;
        private final RGB white;

        protected ROILabelProvider() {
            this.height = this.CROSSED.getImageData().height;
            this.width = this.CROSSED.getImageData().width;
            this.linehalfthickness = 2;
            this.white = new RGB(255, 255, 255);
        }

        private Image drawImage(RGB rGB) {
            int n;
            PaletteData paletteData = new PaletteData(new RGB[]{this.white, rGB});
            ImageData imageData = new ImageData(this.width, this.height, 2, paletteData);
            int n2 = 0;
            while (n2 < this.height) {
                n = 0;
                while (n < this.width) {
                    imageData.setAlpha(n, n2, 0);
                    ++n;
                }
                ++n2;
            }
            n2 = -2;
            while (n2 < 2) {
                n = 0;
                while (n < this.width) {
                    imageData.setPixel(n, this.height / 2 + n2, 1);
                    imageData.setAlpha(n, this.height / 2 + n2, 255);
                    ++n;
                }
                ++n2;
            }
            Image image = new Image(this.CROSSED.getDevice(), imageData);
            return image;
        }

        public Image getColumnImage(Object object, int n) {
            IRowData iRowData = (IRowData)object;
            if (iRowData != null && n == 0) {
                if (iRowData.isPlot()) {
                    return this.drawImage(iRowData.getPlotColourRGB());
                }
                return this.CROSSED;
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            return ROITableViewer.this.content(object, n);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

