/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.roi;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.GridROIData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.sideplot.GridProfile;
import uk.ac.diamond.scisoft.analysis.roi.GridROI;

public final class GridROITableViewer
extends ROITableViewer {
    private GridProfile gridProfile;

    public GridROITableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener, GridProfile gridProfile) {
        super(composite, selectionListener, iCellEditorListener);
        this.gridProfile = gridProfile;
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        GridROIData gridROIData = (GridROIData)object;
        if (gridROIData != null) {
            GridROI gridROI = (GridROI)gridROIData.getROI();
            switch (n) {
                case 1: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getXMicronsFromPixelsCoord(gridROI.getPoint()[0]));
                    break;
                }
                case 2: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getYMicronsFromPixelsCoord(gridROI.getPoint()[1]));
                    break;
                }
                case 3: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getXMicronsFromPixelsLen(gridROI.getLengths()[0]));
                    break;
                }
                case 4: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getYMicronsFromPixelsLen(gridROI.getLengths()[1]));
                    break;
                }
                case 5: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getXMicronsFromPixelsLen(gridROI.getSpacing()[0]));
                    break;
                }
                case 6: {
                    string = String.format("%.2f", this.gridProfile.getGridPrefs().getYMicronsFromPixelsLen(gridROI.getSpacing()[1]));
                    break;
                }
                case 7: {
                    string = gridROI.isGridLineOn() ? "Y" : "N";
                    break;
                }
                case 8: {
                    string = gridROI.isMidPointOn() ? "Y" : "N";
                    break;
                }
                case 9: {
                    string = String.format("%.2f", gridROI.getAngleDegrees());
                    break;
                }
                case 10: {
                    if (gridROI.isClippingCompensation()) {
                        string = "Y";
                        break;
                    }
                    string = "N";
                    break;
                }
                case 11: {
                    string = String.format("%.2f", gridROIData.getProfileSum());
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Plot", "x_s", "y_s", "w", "h", "x_sp", "y_sp", "grid", "mid", "phi", "Clip", "Sum"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{40, 50, 50, 70, 70, 50, 50, 40, 40, 70, 40, 80};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Plot", "Start x", "Start y", "Width", "Height", "X Spacing", "Y Spacing", "Grid Lines", "Mid Point Marks", "Angle", "Clipping compensation", "Sum of profile"};
    }
}

