/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.printing;

import de.jreality.ui.viewerapp.AbstractViewerApp;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.CreateImage;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.PrintMargin;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.printing.PrintSettings;
import uk.ac.diamond.scisoft.analysis.rcp.util.ResourceProperties;

public class PlotPrintPreviewDialog
extends Dialog {
    private Shell shell;
    private Display display;
    private Canvas canvas;
    private Printer printer;
    private PrintMargin margin;
    private Combo comboPrinterName;
    private Combo comboScale;
    private Combo comboOrientation;
    private Combo comboResolution;
    protected String printScaleText = ResourceProperties.getResourceString("PRINT_SCALE");
    protected String printButtonText = ResourceProperties.getResourceString("PRINT_BUTTON");
    protected String printToolTipText = ResourceProperties.getResourceString("PRINT_TOOLTIP");
    protected String printerSelectText = ResourceProperties.getResourceString("PRINTER_SELECT");
    protected String printPreviewText = ResourceProperties.getResourceString("PRINT_PREVIEW");
    protected String orientationText = ResourceProperties.getResourceString("ORIENTATION_TEXT");
    protected String resolutionText = ResourceProperties.getResourceString("RESOLUTION_TEXT");
    public static String portraitText = ResourceProperties.getResourceString("PORTRAIT_ORIENTATION");
    protected static String landscapeText = ResourceProperties.getResourceString("LANDSCAPE_ORIENTATION");
    protected String defaultPrinterText = ResourceProperties.getResourceString("DEFAULT_PRINTER");
    private AbstractViewerApp viewerApp = null;
    private Plot1DGraphTable legendTable;
    private PrintSettings settings;
    private PrinterData[] printerNames;
    private Image image;
    private String fileName = "SDA plot";
    private static final Logger logger = LoggerFactory.getLogger(PlotPrintPreviewDialog.class);
    private SelectionAdapter printerNameSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PlotPrintPreviewDialog.this.selectPrinter(PlotPrintPreviewDialog.this.comboPrinterName.getSelectionIndex());
            PlotPrintPreviewDialog.this.setPrinterNamePreference(PlotPrintPreviewDialog.this.comboPrinterName.getSelectionIndex());
        }
    };
    private SelectionAdapter scaleSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PlotPrintPreviewDialog.this.selectScale(PlotPrintPreviewDialog.this.comboScale.getSelectionIndex());
            PlotPrintPreviewDialog.this.setScalePreference(PlotPrintPreviewDialog.this.comboScale.getSelectionIndex());
        }
    };
    private SelectionAdapter resolutionSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PlotPrintPreviewDialog.this.selectResolution(PlotPrintPreviewDialog.this.comboResolution.getSelectionIndex());
            PlotPrintPreviewDialog.this.setResolutionPreference(PlotPrintPreviewDialog.this.comboResolution.getSelectionIndex());
        }
    };
    private SelectionAdapter orientationSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            PlotPrintPreviewDialog.this.selectOrientation(PlotPrintPreviewDialog.this.comboOrientation.getSelectionIndex());
            PlotPrintPreviewDialog.this.setOrientationPreference(PlotPrintPreviewDialog.this.comboOrientation.getSelectionIndex());
        }
    };

    public PlotPrintPreviewDialog(AbstractViewerApp abstractViewerApp, Display display, Plot1DGraphTable plot1DGraphTable, PrintSettings printSettings) {
        super(display.getActiveShell());
        this.display = display;
        this.viewerApp = abstractViewerApp;
        this.legendTable = plot1DGraphTable;
        this.settings = printSettings != null ? printSettings.clone() : new PrintSettings();
        this.printer = new Printer(this.settings.getPrinterData());
        CreateImage createImage = new CreateImage(abstractViewerApp, display, plot1DGraphTable, this.settings.getPrinterData(), this.settings.getResolution().getValue());
        new Thread(createImage);
        BusyIndicator.showWhile((Display)this.display, (Runnable)createImage);
        this.image = CreateImage.getImage();
    }

    public PrintSettings open() {
        this.setPrinter(this.printer, this.settings.getScale().getValue());
        this.shell = new Shell(this.display.getActiveShell(), 67696);
        this.shell.setText(this.printPreviewText);
        GridLayout gridLayout = new GridLayout(4, false);
        this.shell.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)this.shell, 128);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.center = true;
        composite.setLayout((Layout)rowLayout);
        Button button = new Button(composite, 8);
        button.setText(this.printerSelectText);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PrintDialog printDialog = new PrintDialog(PlotPrintPreviewDialog.this.shell);
                PrinterData printerData = printDialog.open();
                if (printerData == null) {
                    return;
                }
                PlotPrintPreviewDialog.this.settings.setPrinterData(printerData);
                PlotPrintPreviewDialog.this.setPrinter(PlotPrintPreviewDialog.this.printer, PlotPrintPreviewDialog.this.settings.getScale().getValue());
                PlotPrintPreviewDialog.this.print(PlotPrintPreviewDialog.this.printer, PlotPrintPreviewDialog.this.margin, PlotPrintPreviewDialog.this.settings);
                PlotPrintPreviewDialog.this.shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(this.printButtonText);
        button2.setToolTipText(this.printToolTipText);
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Printer printer = new Printer(PlotPrintPreviewDialog.this.settings.getPrinterData());
                PlotPrintPreviewDialog.this.print(printer, PlotPrintPreviewDialog.this.margin, PlotPrintPreviewDialog.this.settings);
                PlotPrintPreviewDialog.this.shell.dispose();
            }
        });
        Composite composite2 = new Composite(composite, 2048);
        RowLayout rowLayout2 = new RowLayout();
        rowLayout2.center = true;
        composite2.setLayout((Layout)rowLayout2);
        new Label(composite2, 1024).setText(String.valueOf(this.defaultPrinterText) + ":");
        this.comboPrinterName = new Combo(composite2, 8);
        PrinterData[] printerDataArray = Printer.getPrinterList();
        int n = 0;
        while (n < printerDataArray.length) {
            this.comboPrinterName.add(printerDataArray[n].name);
            ++n;
        }
        this.comboPrinterName.select(this.getPreferencePrinterName());
        this.comboPrinterName.addSelectionListener((SelectionListener)this.printerNameSelection);
        Composite composite3 = new Composite(composite, 2048);
        RowLayout rowLayout3 = new RowLayout();
        rowLayout3.center = true;
        composite3.setLayout((Layout)rowLayout3);
        new Label(composite3, 1024).setText(String.valueOf(this.printScaleText) + ":");
        this.comboScale = new Combo(composite3, 8);
        PrintSettings.Scale[] scaleArray = PrintSettings.Scale.values();
        int n2 = 0;
        while (n2 < scaleArray.length) {
            this.comboScale.add(scaleArray[n2].getName());
            ++n2;
        }
        this.comboScale.select(this.getPreferencePrintScale());
        this.comboScale.addSelectionListener((SelectionListener)this.scaleSelection);
        Composite composite4 = new Composite(composite, 2048);
        RowLayout rowLayout4 = new RowLayout();
        rowLayout4.center = true;
        composite4.setLayout((Layout)rowLayout4);
        Label label = new Label(composite4, 4);
        label.setText(String.valueOf(this.resolutionText) + ":");
        this.comboResolution = new Combo(composite4, 8);
        PrintSettings.Resolution[] resolutionArray = PrintSettings.Resolution.values();
        int n3 = 0;
        while (n3 < resolutionArray.length) {
            this.comboResolution.add(resolutionArray[n3].getName());
            ++n3;
        }
        this.comboResolution.select(this.getPreferencePrintResolution());
        this.comboResolution.addSelectionListener((SelectionListener)this.resolutionSelection);
        this.canvas = new Canvas((Composite)this.shell, 2048);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.canvas.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        Canvas cfr_ignored_0 = (Canvas)event.widget;
                        PlotPrintPreviewDialog.this.paint(event, PlotPrintPreviewDialog.this.settings.getOrientation());
                    }
                }
            }
        };
        this.canvas.addListener(9, listener);
        this.shell.setSize(800, 650);
        this.shell.open();
        this.setPrinter(this.printer, this.settings.getScale().getValue());
        this.addPropertyListeners();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.settings;
    }

    private void selectPrinter(int n) {
        PrinterData[] printerDataArray = Printer.getPrinterList();
        this.settings.setPrinterData(printerDataArray[n]);
        this.setPrinter(this.printer, this.settings.getScale().getValue());
    }

    private void selectScale(int n) {
        switch (n) {
            case 0: {
                this.settings.setScale(PrintSettings.Scale.DEFAULT);
                break;
            }
            case 1: {
                this.settings.setScale(PrintSettings.Scale.PERCENT75);
                break;
            }
            case 2: {
                this.settings.setScale(PrintSettings.Scale.PERCENT66);
                break;
            }
            case 3: {
                this.settings.setScale(PrintSettings.Scale.PERCENT50);
                break;
            }
            case 4: {
                this.settings.setScale(PrintSettings.Scale.PERCENT33);
                break;
            }
            case 5: {
                this.settings.setScale(PrintSettings.Scale.PERCENT25);
                break;
            }
            case 6: {
                this.settings.setScale(PrintSettings.Scale.PERCENT10);
            }
        }
        this.setPrinter(this.printer, this.settings.getScale().getValue());
    }

    private void selectResolution(int n) {
        switch (n) {
            case 0: {
                this.settings.setResolution(PrintSettings.Resolution.LOW);
                break;
            }
            case 1: {
                this.settings.setResolution(PrintSettings.Resolution.MEDIUM);
                break;
            }
            case 2: {
                this.settings.setResolution(PrintSettings.Resolution.MEDIUMHIGH);
                break;
            }
            case 3: {
                this.settings.setResolution(PrintSettings.Resolution.HIGH);
            }
        }
        CreateImage createImage = new CreateImage(this.viewerApp, this.display, this.legendTable, this.settings.getPrinterData(), this.settings.getResolution().getValue());
        new Thread(createImage);
        BusyIndicator.showWhile((Display)this.display, (Runnable)createImage);
        this.image = CreateImage.getImage();
        this.setPrinter(this.printer, this.settings.getScale().getValue());
    }

    private void selectOrientation(int n) {
        switch (n) {
            case 0: {
                this.settings.setOrientation(PrintSettings.Orientation.PORTRAIT);
                this.settings.getPrinterData().orientation = PrintSettings.Orientation.PORTRAIT.getValue();
                break;
            }
            case 1: {
                this.settings.setOrientation(PrintSettings.Orientation.LANDSCAPE);
                this.settings.getPrinterData().orientation = PrintSettings.Orientation.LANDSCAPE.getValue();
            }
        }
        this.canvas.redraw();
    }

    private void addPropertyListeners() {
        AnalysisRCPActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
                if (string.equals("printsettings.printername") || string.equals("printsettings.scale") || string.equals("printsettings.resolution") || string.equals("printsettings.orientation")) {
                    int n = iPreferenceStore.isDefault("printsettings.printername") ? iPreferenceStore.getDefaultInt("printsettings.printername") : iPreferenceStore.getInt("printsettings.printername");
                    PlotPrintPreviewDialog.this.printerNames = Printer.getPrinterList();
                    int n2 = 0;
                    while (n2 < PlotPrintPreviewDialog.this.printerNames.length) {
                        if (n2 == n) {
                            PlotPrintPreviewDialog.this.settings.setPrinterData(PlotPrintPreviewDialog.this.printerNames[n2]);
                            break;
                        }
                        ++n2;
                    }
                    n2 = iPreferenceStore.isDefault("printsettings.scale") ? iPreferenceStore.getDefaultInt("printsettings.scale") : iPreferenceStore.getInt("printsettings.scale");
                    PrintSettings.Scale[] scaleArray = PrintSettings.Scale.values();
                    int n3 = 0;
                    while (n3 < scaleArray.length) {
                        if (n3 == n2) {
                            PlotPrintPreviewDialog.this.settings.setScale(scaleArray[n3]);
                            break;
                        }
                        ++n3;
                    }
                    n3 = iPreferenceStore.isDefault("printsettings.resolution") ? iPreferenceStore.getDefaultInt("printsettings.resolution") : iPreferenceStore.getInt("printsettings.resolution");
                    PrintSettings.Resolution[] resolutionArray = PrintSettings.Resolution.values();
                    int n4 = 0;
                    while (n4 < resolutionArray.length) {
                        if (n4 == n3) {
                            PlotPrintPreviewDialog.this.settings.setResolution(resolutionArray[n4]);
                            break;
                        }
                        ++n4;
                    }
                    n4 = iPreferenceStore.isDefault("printsettings.orientation") ? iPreferenceStore.getDefaultInt("printsettings.orientation") : iPreferenceStore.getInt("printsettings.orientation");
                    PrintSettings.Orientation[] orientationArray = PrintSettings.Orientation.values();
                    int n5 = 0;
                    while (n5 < orientationArray.length) {
                        if (n5 == n4) {
                            PlotPrintPreviewDialog.this.settings.setOrientation(orientationArray[n5]);
                            break;
                        }
                        ++n5;
                    }
                }
            }
        });
    }

    private int getPreferencePrinterName() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("printsettings.printername") ? iPreferenceStore.getDefaultInt("printsettings.printername") : iPreferenceStore.getInt("printsettings.printername");
    }

    private int getPreferencePrintScale() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("printsettings.scale") ? iPreferenceStore.getDefaultInt("printsettings.scale") : iPreferenceStore.getInt("printsettings.scale");
    }

    private int getPreferencePrintResolution() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("printsettings.resolution") ? iPreferenceStore.getDefaultInt("printsettings.resolution") : iPreferenceStore.getInt("printsettings.resolution");
    }

    private int getPreferencePrintOrientation() {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        return iPreferenceStore.isDefault("printsettings.orientation") ? iPreferenceStore.getDefaultInt("printsettings.orientation") : iPreferenceStore.getInt("printsettings.orientation");
    }

    private void setPrinterNamePreference(int n) {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.settings.setPrinterData(Printer.getPrinterList()[n]);
        iPreferenceStore.setValue("printsettings.printername", n);
    }

    private void setScalePreference(int n) {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.settings.setScale(PrintSettings.Scale.values()[n]);
        iPreferenceStore.setValue("printsettings.scale", n);
    }

    private void setResolutionPreference(int n) {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.settings.setResolution(PrintSettings.Resolution.values()[n]);
        iPreferenceStore.setValue("printsettings.resolution", n);
    }

    private void setOrientationPreference(int n) {
        IPreferenceStore iPreferenceStore = AnalysisRCPActivator.getDefault().getPreferenceStore();
        this.settings.setOrientation(PrintSettings.Orientation.values()[n]);
        iPreferenceStore.setValue("printsettings.orientation", n);
    }

    private void paint(Event event, PrintSettings.Orientation orientation) {
        if (orientation.equals((Object)PrintSettings.Orientation.PORTRAIT)) {
            int n = 20;
            if (this.printer == null || this.printer.isDisposed()) {
                return;
            }
            Rectangle rectangle = this.printer.getBounds();
            Point point = this.canvas.getSize();
            double d = (double)(point.x - n * 2) * 1.0 / (double)rectangle.width;
            d = Math.min(d, (double)(point.y - n * 2) * 1.0 / (double)rectangle.height);
            int n2 = (point.x - (int)(d * (double)rectangle.width)) / 2;
            int n3 = (point.y - (int)(d * (double)rectangle.height)) / 2;
            event.gc.setBackground(this.shell.getDisplay().getSystemColor(1));
            event.gc.fillRectangle(n2, n3, (int)(d * (double)rectangle.width), (int)(d * (double)rectangle.height));
            event.gc.setLineStyle(2);
            event.gc.setForeground(this.shell.getDisplay().getSystemColor(2));
            int n4 = n2 + (int)(d * (double)this.margin.left);
            int n5 = n3 + (int)(d * (double)this.margin.top);
            if (this.image != null) {
                int n6 = this.image.getBounds().width;
                int n7 = this.image.getBounds().height;
                double d2 = (double)this.printer.getDPI().x * 1.0 / (double)this.shell.getDisplay().getDPI().x;
                double d3 = (double)this.printer.getDPI().y * 1.0 / (double)this.shell.getDisplay().getDPI().y;
                double d4 = Math.min(1.0, (double)(this.margin.right - this.margin.left) * 1.0 / (d2 * (double)n6));
                d4 = Math.min(d4, (double)(this.margin.bottom - this.margin.top) * 1.0 / (d3 * (double)n7));
                event.gc.drawImage(this.image, 0, 0, n6, n7, n4, n5, (int)(d2 * d4 * (double)n6 * d), (int)(d3 * d4 * (double)n7 * d));
            }
        } else if (orientation.equals((Object)PrintSettings.Orientation.LANDSCAPE)) {
            int n = 20;
            if (this.printer == null || this.printer.isDisposed()) {
                return;
            }
            Rectangle rectangle = this.printer.getBounds();
            Point point = this.canvas.getSize();
            double d = (double)(point.x - n * 2) * 1.0 / (double)rectangle.width;
            d = Math.min(d, (double)(point.y - n * 2) * 1.0 / (double)rectangle.height);
            int n8 = (point.y - (int)(d * (double)rectangle.width)) / 2;
            int n9 = (point.x - (int)(d * (double)rectangle.height)) / 2;
            event.gc.setBackground(this.shell.getDisplay().getSystemColor(1));
            event.gc.fillRectangle(n9, n8, (int)(d * (double)rectangle.height), (int)(d * (double)rectangle.width));
            event.gc.setLineStyle(2);
            event.gc.setForeground(this.shell.getDisplay().getSystemColor(2));
            int n10 = n9 + (int)(d * (double)this.margin.left);
            int n11 = n8 + (int)(d * (double)this.margin.top);
            if (this.image != null) {
                int n12 = this.image.getBounds().width;
                int n13 = this.image.getBounds().height;
                double d5 = (double)this.printer.getDPI().x * 1.0 / (double)this.shell.getDisplay().getDPI().x;
                double d6 = (double)this.printer.getDPI().y * 1.0 / (double)this.shell.getDisplay().getDPI().y;
                double d7 = Math.min(1.0, (double)(this.margin.right - this.margin.left) * 1.0 / (d5 * (double)n12));
                d7 = Math.min(d7, (double)(this.margin.bottom - this.margin.top) * 1.0 / (d6 * (double)n13));
                int cfr_ignored_0 = n12 / rectangle.width;
                event.gc.drawImage(this.image, 0, 0, n12, n13, n10, n11, (int)(d5 * d7 * (double)n13 * d), (int)(d6 * d7 * (double)n12 * d));
            }
        }
    }

    void setPrinter(Printer printer, double d) {
        if (printer == null) {
            printer = new Printer(Printer.getDefaultPrinterData());
        }
        this.printer = printer;
        this.margin = PrintMargin.getPrintMargin(printer, d);
        if (this.canvas != null) {
            this.canvas.redraw();
        }
    }

    void print() {
        PrintDialog printDialog = new PrintDialog(this.shell);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return;
        }
        Printer printer = new Printer(printerData);
        this.print(printer, null, this.settings);
    }

    void print(final Printer printer, PrintMargin printMargin, final PrintSettings printSettings) {
        if (this.image == null) {
            return;
        }
        final Point point = printer.getDPI();
        final Point point2 = this.display.getDPI();
        logger.info(point2 + " " + point);
        final PrintMargin printMargin2 = printMargin == null ? PrintMargin.getPrintMargin(printer, 1.0) : printMargin;
        Thread thread = new Thread(){

            @Override
            public void run() {
                double d;
                double d2;
                double d3;
                int n;
                int n2;
                if (!printer.startJob(PlotPrintPreviewDialog.this.fileName)) {
                    logger.error("Failed to start print job!");
                    printer.dispose();
                    return;
                }
                GC gC = new GC((Drawable)printer);
                if (!printer.startPage()) {
                    logger.error("Failed to start a new page!");
                    gC.dispose();
                    return;
                }
                printer.computeTrim(0, 0, 0, 0);
                if (printSettings.getOrientation().equals((Object)PrintSettings.Orientation.PORTRAIT)) {
                    n2 = ((PlotPrintPreviewDialog)PlotPrintPreviewDialog.this).image.getBounds().width;
                    n = ((PlotPrintPreviewDialog)PlotPrintPreviewDialog.this).image.getBounds().height;
                    d3 = (double)point.x * 1.0 / (double)point2.x;
                    d2 = (double)point.y * 1.0 / (double)point2.y;
                    d = Math.min(1.0, (double)(printMargin2.right - printMargin2.left) * 1.0 / (d3 * (double)n2));
                    d = Math.min(d, (double)(printMargin2.bottom - printMargin2.top) * 1.0 / (d2 * (double)n));
                    gC.drawImage(PlotPrintPreviewDialog.this.image, 0, 0, n2, n, printMargin2.left - 20, printMargin2.top - 20, (int)(d3 * d * (double)n2), (int)(d2 * d * (double)n));
                    gC.dispose();
                }
                if (printSettings.getOrientation().equals((Object)PrintSettings.Orientation.LANDSCAPE)) {
                    n2 = ((PlotPrintPreviewDialog)PlotPrintPreviewDialog.this).image.getBounds().width;
                    n = ((PlotPrintPreviewDialog)PlotPrintPreviewDialog.this).image.getBounds().height;
                    point.x = printer.getDPI().y;
                    point.y = printer.getDPI().x;
                    d3 = (double)point.x * 1.0 / (double)point2.x;
                    d2 = (double)point.y * 1.0 / (double)point2.y;
                    d = Math.min(1.0, (double)(printMargin2.right - printMargin2.left) * 1.0 / (d3 * (double)n2));
                    d = Math.min(d, (double)(printMargin2.bottom - printMargin2.top) * 1.0 / (d2 * (double)n));
                    gC.setAdvanced(true);
                    Transform transform = new Transform((Device)printer);
                    transform.rotate(90.0f);
                    transform.translate(0.0f, (float)(-(d2 * d * (double)n2 * 1.1)));
                    gC.setTransform(transform);
                    gC.drawImage(PlotPrintPreviewDialog.this.image, 0, 0, n2, n, printMargin2.left, printMargin2.top, (int)(d3 * d * (double)n2 * 1.35), (int)(d2 * d * (double)n * 1.35));
                    gC.dispose();
                    transform.dispose();
                }
                PlotPrintPreviewDialog.this.image.dispose();
                printer.endPage();
                printer.endJob();
                printer.dispose();
                logger.info("Printing job done!");
            }
        };
        thread.start();
    }
}

