/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;

public abstract class OverlayPrimitive {
    protected SceneGraphComponent comp;
    protected Color colour;
    protected boolean needToUpdateApp;
    protected boolean needToUpdateGeom;
    protected boolean needToUpdateTrans;
    protected boolean isHidden = false;
    protected boolean isFixedSize = false;
    protected Matrix transformMatrix;
    protected Matrix copyofTransformMatrix;
    protected Appearance ap;
    private double[] translationVec = new double[3];
    private double[] invTranslationVec = new double[3];
    private double[] ankorPoints = new double[2];

    public OverlayPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public OverlayPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        this.comp = sceneGraphComponent;
        this.isFixedSize = bl;
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }

    public void setColour(Color color) {
        this.colour = color;
        this.needToUpdateApp = true;
    }

    public void translate(double[] dArray) {
        this.needToUpdateTrans = true;
        this.translationVec[0] = dArray[0];
        this.translationVec[1] = dArray[1];
        this.translationVec[2] = 0.0;
        this.transformMatrix = this.transformMatrix == null ? MatrixBuilder.euclidean().translate(this.translationVec).getMatrix() : MatrixBuilder.euclidean((Matrix)this.transformMatrix).translate(this.translationVec).getMatrix();
        this.copyofTransformMatrix = MatrixBuilder.euclidean((Matrix)this.transformMatrix).getMatrix();
    }

    public void rotate(double d, double[] dArray) {
        this.needToUpdateTrans = true;
        this.translationVec[0] = -dArray[0];
        this.translationVec[1] = -dArray[1];
        this.translationVec[2] = 0.0;
        this.invTranslationVec[0] = dArray[0];
        this.invTranslationVec[1] = dArray[1];
        this.invTranslationVec[2] = 0.0;
        this.transformMatrix = this.transformMatrix == null ? MatrixBuilder.euclidean().translate(this.invTranslationVec).rotateZ(d).translate(this.translationVec).getMatrix() : MatrixBuilder.euclidean((Matrix)this.transformMatrix).translate(this.translationVec).rotateZ(d).translate(this.invTranslationVec).getMatrix();
        this.copyofTransformMatrix = MatrixBuilder.euclidean((Matrix)this.transformMatrix).getMatrix();
    }

    public abstract void updateNode();

    public abstract void setStyle(VectorOverlayStyles var1);

    public abstract void setOutlineColour(Color var1);

    public abstract void setLineThickness(double var1);

    public SceneGraphComponent getNode() {
        return this.comp;
    }

    public abstract void setTransparency(double var1);

    public abstract void setOutlineTransparency(double var1);

    public boolean isHidden() {
        return this.isHidden;
    }

    public void hide() {
        this.isHidden = true;
    }

    public void unhide() {
        this.isHidden = false;
    }

    public boolean isFixedSize() {
        return this.isFixedSize;
    }

    public void setAnchorPoint(double d, double d2) {
        this.ankorPoints[0] = d;
        this.ankorPoints[1] = d2;
    }

    public double[] getAnchorPoint() {
        return this.ankorPoints;
    }

    public Matrix getTransformationMatrix() {
        return this.copyofTransformMatrix;
    }
}

