/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives;

import de.jreality.geometry.PointSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultTextShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import java.awt.Font;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.enums.LabelOrientation;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.OverlayPrimitive;

public class LabelPrimitive
extends OverlayPrimitive {
    private DefaultPointShader dpsLabel;
    private DefaultTextShader dtsLabel;
    private String labelStr;
    private PointSetFactory factory;
    private Font currentFont;
    private int currentAllign;
    private int currentTextOrientation = 0;
    private double currentScale = 0.008;
    private double[][] coords = new double[1][3];
    private double[][] dataPoints = new double[1][2];

    public LabelPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public LabelPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("textShader.diffuseColor", (Object)Color.red);
        this.ap.setAttribute("pointShader.textShader.diffuseColor", (Object)Color.red);
        this.ap.setAttribute("useGLSL", false);
        sceneGraphComponent.setAppearance(this.ap);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dpsLabel = (DefaultPointShader)defaultGeometryShader.getPointShader();
        this.dpsLabel.setDiffuseColor(Color.WHITE);
        this.dpsLabel.setPointSize(Double.valueOf(0.0));
        this.dpsLabel.setPointRadius(Double.valueOf(0.0));
        this.dtsLabel = (DefaultTextShader)this.dpsLabel.getTextShader();
        this.dtsLabel.setScale(Double.valueOf(this.currentScale));
        this.dtsLabel.setDiffuseColor(Color.red);
        this.currentFont = this.dtsLabel.getFont();
        this.currentAllign = this.dtsLabel.getAlignment();
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(false));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(true));
        this.factory = new PointSetFactory();
    }

    @Override
    public void setLineThickness(double d) {
    }

    @Override
    public void setColour(Color color) {
        super.setColour(color);
        this.needToUpdateGeom = true;
    }

    @Override
    public void setOutlineColour(Color color) {
    }

    @Override
    public void setOutlineTransparency(double d) {
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
    }

    @Override
    public void setTransparency(double d) {
    }

    public void setLabelFont(Font font) {
        this.needToUpdateGeom = true;
        this.currentFont = font;
    }

    public void setLabelDirection(LabelOrientation labelOrientation) {
        switch (labelOrientation) {
            case HORIZONTAL: {
                this.currentTextOrientation = 0;
                break;
            }
            case VERTICAL: {
                this.currentTextOrientation = 1;
            }
        }
        this.needToUpdateGeom = true;
    }

    public void setDataPoints(double d, double d2) {
        this.dataPoints[0][0] = d;
        this.dataPoints[0][1] = d2;
    }

    public double[][] getDataPoints() {
        return this.dataPoints;
    }

    public void setLabelPosition(double d, double d2) {
        this.needToUpdateGeom = true;
        this.coords[0][0] = d;
        this.coords[0][1] = d2;
        this.coords[0][2] = 5.0E-4;
    }

    public void setLabelString(String string) {
        if (!string.equals(this.labelStr)) {
            this.labelStr = string;
            this.needToUpdateGeom = true;
        }
    }

    public void setLabelAlignment(int n) {
        this.currentAllign = n;
        this.needToUpdateGeom = true;
    }

    private PointSet createLabelGeometry() {
        String[] stringArray = new String[]{this.labelStr};
        this.factory.setVertexCount(1);
        this.factory.setVertexCoordinates(this.coords);
        this.factory.setVertexLabels(stringArray);
        this.factory.update();
        return this.factory.getPointSet();
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.dtsLabel = (DefaultTextShader)this.dpsLabel.getTextShader();
            this.dtsLabel.setTextdirection(Integer.valueOf(this.currentTextOrientation));
            this.dtsLabel.setScale(Double.valueOf(this.currentScale));
            this.dtsLabel.setDiffuseColor(this.colour);
            this.dtsLabel.setAlignment(Integer.valueOf(this.currentAllign));
            this.dtsLabel.setFont(this.currentFont);
            this.comp.setGeometry((Geometry)this.createLabelGeometry());
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }
}

