/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.ShaderUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.primitives.OverlayPrimitive;

public class ArrowPrimitive
extends OverlayPrimitive {
    private double[][] coords = new double[5][3];
    private double[] tempVec = new double[3];
    private IndexedLineSetFactory lineFactory = null;
    private int[][] edges = new int[3][2];
    private DefaultLineShader dls = null;
    private final double arrowSize = 0.5;
    private double lineThickness = 1.0;

    public ArrowPrimitive(SceneGraphComponent sceneGraphComponent) {
        this(sceneGraphComponent, false);
    }

    public ArrowPrimitive(SceneGraphComponent sceneGraphComponent, boolean bl) {
        super(sceneGraphComponent, bl);
        this.ap = new Appearance();
        sceneGraphComponent.setAppearance(this.ap);
        this.ap.setAttribute("pointShader.spheresDraw", false);
        this.ap.setAttribute("lineShader.tubeDraw", false);
        this.ap.setAttribute("useGLSL", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)this.ap, (boolean)true);
        this.dls = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        this.dls.setDiffuseColor(Color.WHITE);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        this.lineFactory = new IndexedLineSetFactory();
        this.edges[0][0] = 0;
        this.edges[0][1] = 1;
        this.edges[1][0] = 2;
        this.edges[1][1] = 3;
        this.edges[2][0] = 2;
        this.edges[2][1] = 4;
    }

    public void setArrowPoints(double d, double d2, double d3, double d4, double d5) {
        this.needToUpdateGeom = true;
        this.coords[0][0] = d;
        this.coords[0][1] = d2;
        this.coords[0][2] = 5.0E-4;
        this.coords[1][0] = d3;
        this.coords[1][1] = d4;
        this.coords[1][2] = 5.0E-4;
        double d6 = d3 - d;
        double d7 = d4 - d2;
        this.tempVec[0] = d6;
        this.tempVec[1] = d7;
        this.tempVec[2] = 0.0;
        double d8 = Math.max(1.0E-5, Math.sqrt(this.tempVec[0] * this.tempVec[0] + this.tempVec[1] * this.tempVec[1]));
        this.tempVec[0] = this.tempVec[0] / d8;
        this.tempVec[1] = this.tempVec[1] / d8;
        MatrixBuilder.euclidean().rotateZ(-3.9269908169872414).getMatrix().transformVector(this.tempVec);
        this.coords[2][0] = d + d5 * d6;
        this.coords[2][1] = d2 + d5 * d7;
        this.coords[2][2] = 5.0E-4;
        this.coords[3][0] = d + d5 * d6 + 0.5 * this.tempVec[0];
        this.coords[3][1] = d2 + d5 * d7 + 0.5 * this.tempVec[1];
        this.coords[3][2] = 5.0E-4;
        MatrixBuilder.euclidean().rotateZ(1.5707963267948966).getMatrix().transformVector(this.tempVec);
        this.coords[4][0] = d + d5 * d6 + 0.5 * this.tempVec[0];
        this.coords[4][1] = d2 + d5 * d7 + 0.5 * this.tempVec[1];
        this.coords[4][2] = 5.0E-4;
    }

    private IndexedLineSet createLineGeometry() {
        this.lineFactory.setVertexCount(5);
        this.lineFactory.setEdgeCount(3);
        this.lineFactory.setVertexCoordinates(this.coords);
        this.lineFactory.setEdgeIndices(this.edges);
        this.lineFactory.update();
        return this.lineFactory.getIndexedLineSet();
    }

    @Override
    public void updateNode() {
        if (this.needToUpdateTrans) {
            MatrixBuilder.euclidean((Matrix)this.transformMatrix).assignTo(this.comp);
        }
        if (this.needToUpdateGeom) {
            this.comp.setGeometry((Geometry)this.createLineGeometry());
        }
        if (this.needToUpdateApp) {
            this.dls.setDiffuseColor(this.colour);
            this.dls.setLineWidth(Double.valueOf(this.lineThickness));
        }
        this.needToUpdateApp = false;
        this.needToUpdateGeom = false;
        this.needToUpdateTrans = false;
        this.transformMatrix = null;
    }

    @Override
    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
    }

    @Override
    public void setOutlineColour(Color color) {
    }

    @Override
    public void setLineThickness(double d) {
        this.lineThickness = d;
        this.needToUpdateApp = true;
    }

    @Override
    public void setOutlineTransparency(double d) {
        this.setTransparency(d);
    }

    @Override
    public void setTransparency(double d) {
        if (d > 0.0) {
            this.ap.setAttribute("lineShader.transparencyEnabled", true);
            this.ap.setAttribute("transparencyEnabled", true);
        } else {
            this.ap.setAttribute("lineShader.transparencyEnabled", false);
            this.ap.setAttribute("transparencyEnabled", false);
        }
        this.ap.setAttribute("lineShader.transparency", d);
        this.ap.setAttribute("polygonShader.transparency", d);
        this.ap.setAttribute("additiveBlendingEnabled", true);
    }
}

