/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects;

import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.VectorOverlayStyles;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;

public class OverlayObject {
    protected int primID = -1;
    protected OverlayProvider provider;

    public void draw() {
    }

    public OverlayObject(int n, OverlayProvider overlayProvider) {
        this.provider = overlayProvider;
        this.primID = n;
    }

    public void setPrimID(int n) {
        this.primID = n;
    }

    public int getPrimID() {
        return this.primID;
    }

    public void translate(double d, double d2) {
        if (this.provider != null) {
            this.provider.translatePrimitive(this.primID, d, d2);
        }
    }

    public void rotate(double d, double d2, double d3) {
        if (this.provider != null) {
            this.provider.rotatePrimitive(this.primID, d, d2, d3);
        }
    }

    public void setOutlineColour(Color color) {
        if (this.provider != null) {
            this.provider.setOutlineColour(this.primID, color);
        }
    }

    public void setColour(Color color) {
        if (this.provider != null) {
            this.provider.setColour(this.primID, color);
        }
    }

    public void setTransparency(double d) {
        if (this.provider != null) {
            this.provider.setTransparency(this.primID, d);
        }
    }

    public void setStyle(VectorOverlayStyles vectorOverlayStyles) {
        if (this.provider != null) {
            this.provider.setStyle(this.primID, vectorOverlayStyles);
        }
    }

    public void setAnchorPoints(double d, double d2) {
        if (this.provider != null) {
            this.provider.setAnchorPoints(this.primID, d, d2);
        }
    }

    public void setVisible(boolean bl) {
        if (this.provider != null) {
            this.provider.setPrimitiveVisible(this.primID, bl);
        }
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.unregisterPrimitive(this.primID);
        }
        this.primID = -1;
    }

    public void finalize() {
        if (this.provider != null && this.primID != -1) {
            this.provider.unregisterPrimitive(this.primID);
        }
    }
}

