/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.swt.widgets.Display;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events.GraphSelectionEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events.GraphSelectionListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events.OverlayDrawingEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;

public abstract class AbstractOverlayConsumer
implements Overlay1DConsumer,
Overlay2DConsumer {
    protected OverlayProvider provider;
    protected int[] parts;
    private AreaSelectEvent start;
    private Display display;
    private Collection<GraphSelectionListener> selectionListeners;

    public AbstractOverlayConsumer(Display display) {
        this.display = display;
    }

    protected abstract int[] createDrawingParts(OverlayProvider var1);

    protected abstract void drawOverlay(OverlayDrawingEvent var1);

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = overlayProvider;
        this.parts = this.createDrawingParts(overlayProvider);
        this.drawOverlay(new OverlayDrawingEvent(overlayProvider, this.parts));
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
        if (this.selectionListeners != null) {
            this.selectionListeners.clear();
        }
        this.selectionListeners = null;
        this.parts = null;
        this.start = null;
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        if (areaSelectEvent.getMode() == '\u0000') {
            this.start = areaSelectEvent;
        }
        if (areaSelectEvent.getMode() == '\u0001' || areaSelectEvent.getMode() == '\u0002') {
            this.drawOverlay(new OverlayDrawingEvent(this.provider, this.start, areaSelectEvent, this.parts));
            this.notifyGraphSelectionListeners(areaSelectEvent);
        }
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new HashSet<GraphSelectionListener>(5);
        }
        this.selectionListeners.add(graphSelectionListener);
    }

    protected void notifyGraphSelectionListeners(final AreaSelectEvent areaSelectEvent) {
        if (this.selectionListeners == null) {
            return;
        }
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GraphSelectionEvent graphSelectionEvent = new GraphSelectionEvent(this);
                    graphSelectionEvent.setStart(AbstractOverlayConsumer.this.start);
                    graphSelectionEvent.setEnd(areaSelectEvent);
                    for (GraphSelectionListener graphSelectionListener : AbstractOverlayConsumer.this.selectionListeners) {
                        graphSelectionListener.graphSelectionPerformed(graphSelectionEvent);
                    }
                }
            });
        }
    }

    @Override
    public void removePrimitives() {
        this.parts = null;
    }

    @Override
    public void hideOverlays() {
        if (this.parts != null) {
            int n = 0;
            while (n < this.parts.length) {
                this.provider.setPrimitiveVisible(this.parts[n], false);
                ++n;
            }
        }
    }

    @Override
    public void showOverlays() {
        if (this.parts != null) {
            int n = 0;
            while (n < this.parts.length) {
                this.provider.setPrimitiveVisible(this.parts[n], true);
                ++n;
            }
        }
    }
}

