/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

public class OverlayImage {
    private byte[] data;
    private int width;
    private int height;
    private boolean isDirty;

    public OverlayImage(int n, int n2) {
        this.data = new byte[n * n2 * 4];
        this.width = n;
        this.height = n2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getImageData() {
        return this.data;
    }

    public void zap() {
        this.data = new byte[this.width * this.height * 4];
        this.isDirty = true;
    }

    public void clear(short s, short s2, short s3, short s4) {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.data[(n2 + n * this.width) * 4] = (byte)s;
                this.data[(n2 + n * this.width) * 4 + 1] = (byte)s2;
                this.data[(n2 + n * this.width) * 4 + 2] = (byte)s3;
                this.data[(n2 + n * this.width) * 4 + 3] = (byte)s4;
                ++n2;
            }
            ++n;
        }
        this.isDirty = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void putPixel(int n, int n2, short s, short s2, short s3, short s4) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.data[(n + n2 * this.width) * 4] = (byte)s;
            this.data[(n + n2 * this.width) * 4 + 1] = (byte)s2;
            this.data[(n + n2 * this.width) * 4 + 2] = (byte)s3;
            this.data[(n + n2 * this.width) * 4 + 3] = (byte)s4;
        }
        this.isDirty = true;
    }

    public void clean() {
        this.isDirty = false;
    }

    public int[] getShape() {
        return new int[]{this.height, this.width};
    }
}

