/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import java.awt.Color;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events.AbstractOverlayConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.events.OverlayDrawingEvent;

public class LinesOverlay
extends AbstractOverlayConsumer {
    private double[] xValues;
    private double min;
    private double max;
    private Color[] colours;

    public LinesOverlay(Display display, Color[] colorArray) {
        super(display);
        this.colours = colorArray;
    }

    @Override
    protected int[] createDrawingParts(OverlayProvider overlayProvider) {
        int[] nArray = new int[this.colours.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = overlayProvider.registerPrimitive(PrimitiveType.LINE);
            ++n;
        }
        return nArray;
    }

    @Override
    protected void drawOverlay(OverlayDrawingEvent overlayDrawingEvent) {
        this.draw();
    }

    private void draw() {
        int n = 0;
        while (n < this.xValues.length) {
            this.drawLine(this.xValues[n], this.colours[n], n);
            ++n;
        }
    }

    private void drawLine(double d, Color color, int n) {
        this.provider.begin(OverlayType.VECTOR2D);
        this.provider.setColour(this.parts[n], color);
        ((Overlay1DProvider)this.provider).drawLine(this.parts[n], d, this.min, d, this.max);
        this.provider.end(OverlayType.VECTOR2D);
    }

    public void setXValues(double[] dArray) {
        this.xValues = dArray;
    }

    public void setY(AbstractDataset abstractDataset) {
        this.min = abstractDataset.min().doubleValue();
        this.max = abstractDataset.min().doubleValue();
    }

    public void setYs(List<IDataset> list) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        for (IDataset iDataset : list) {
            this.min = Math.min(this.min, iDataset.min().doubleValue());
            this.max = Math.max(this.max, iDataset.max().doubleValue());
        }
    }
}

