/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay2DProvider2;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayImage;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.ArrowObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.BoxObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.CircleObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.objects.PointListObject;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.IImagePositionEvent;

public class DemoOverlay
implements Overlay2DConsumer {
    private Overlay2DProvider2 provider = null;
    private int sx = 0;
    private int sy = 0;
    private int ex = 0;
    private int ey = 0;
    private boolean drawing = false;
    private ArrowObject line;
    private BoxObject box;
    private CircleObject circle;
    private PointListObject pointList;
    private OverlayImage image;
    int primID = -1;
    int primID2 = -1;

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay2DProvider2)overlayProvider;
        this.line = (ArrowObject)this.provider.registerObject(PrimitiveType.ARROW);
        this.box = (BoxObject)this.provider.registerObject(PrimitiveType.BOX);
        this.circle = (CircleObject)this.provider.registerObject(PrimitiveType.CIRCLE);
        this.pointList = (PointListObject)this.provider.registerObject(PrimitiveType.POINTLIST);
        this.image = this.provider.registerOverlayImage(128, 128);
        if (this.line != null) {
            this.line.setLinePoints(30.0, 30.0, 60.0, 60.0);
        }
        if (this.box != null) {
            this.box.setBoxPoints(80.0, 80.0, 120.0, 110.0);
        }
        if (this.circle != null) {
            this.circle.setCirclePoint(128.0, 128.0);
            this.circle.setRadius(30.0);
        }
        if (this.pointList != null) {
            double[] dArray = new double[100];
            double[] dArray2 = new double[100];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = 256.0 * Math.random();
                dArray2[n] = 256.0 * Math.random();
                ++n;
            }
            this.pointList.setPointPositions(dArray, dArray2);
        }
        this.drawOverlay();
    }

    private void drawOverlay() {
        this.provider.begin(OverlayType.VECTOR2D);
        this.line.setColour(Color.blue);
        this.line.draw();
        this.box.setColour(Color.red);
        this.box.draw();
        this.circle.setColour(Color.DARK_GRAY);
        this.circle.draw();
        this.pointList.setColour(Color.MAGENTA);
        this.pointList.draw();
        this.provider.end(OverlayType.VECTOR2D);
        this.provider.begin(OverlayType.IMAGE);
        this.image.clear((short)255, (short)0, (short)0, (short)128);
        this.image.putPixel(64, 64, (short)255, (short)255, (short)255, (short)255);
        this.provider.end(OverlayType.IMAGE);
    }

    @Override
    public void imageDragged(IImagePositionEvent iImagePositionEvent) {
        this.ex = iImagePositionEvent.getImagePosition()[0];
        this.ey = iImagePositionEvent.getImagePosition()[1];
        this.provider.setPlotAreaCursor(2);
    }

    @Override
    public void imageFinished(IImagePositionEvent iImagePositionEvent) {
        this.provider.restoreDefaultPlotAreaCursor();
    }

    @Override
    public void imageStart(IImagePositionEvent iImagePositionEvent) {
        this.sx = iImagePositionEvent.getImagePosition()[0];
        this.sy = iImagePositionEvent.getImagePosition()[1];
        System.out.println(iImagePositionEvent.getPrimitiveID());
        this.provider.setPlotAreaCursor(4);
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    @Override
    public void hideOverlays() {
        if (this.provider != null) {
            this.provider.setPrimitiveVisible(this.primID, false);
        }
    }

    @Override
    public void showOverlays() {
        if (this.provider != null) {
            this.provider.setPrimitiveVisible(this.primID, true);
        }
    }

    @Override
    public void removePrimitives() {
        this.primID = -1;
    }
}

