/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay;

import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.OverlayType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.PrimitiveType;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DConsumer;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.Overlay1DProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.overlay.OverlayProvider;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.tools.AreaSelectEvent;

public class Demo1DOverlay
implements Overlay1DConsumer {
    private Overlay1DProvider provider = null;
    private boolean drawing = false;
    private int primID = -1;
    private int primID2 = -1;
    private double sx = 0.0;
    private double sy = 0.0;
    private double ex = 0.0;
    private double ey = 0.0;

    @Override
    public void registerProvider(OverlayProvider overlayProvider) {
        this.provider = (Overlay1DProvider)overlayProvider;
        this.primID = overlayProvider.registerPrimitive(PrimitiveType.BOX);
        this.primID2 = overlayProvider.registerPrimitive(PrimitiveType.LINE);
        this.drawOverlay();
    }

    @Override
    public void unregisterProvider() {
        this.provider = null;
    }

    private void drawOverlay() {
        this.provider.begin(OverlayType.VECTOR2D);
        this.provider.setColour(this.primID, Color.GRAY);
        this.provider.setTransparency(this.primID, 0.5);
        this.provider.drawBox(this.primID, 15.0, 0.2, 40.0, 0.8);
        this.provider.setColour(this.primID2, Color.BLUE);
        this.provider.drawLine(this.primID2, 50.0, 0.1, 150.0, 0.9);
        this.provider.end(OverlayType.VECTOR2D);
    }

    @Override
    public void areaSelected(AreaSelectEvent areaSelectEvent) {
        if (areaSelectEvent.getMode() == '\u0000') {
            this.sx = areaSelectEvent.getPosition()[0];
            this.sy = areaSelectEvent.getPosition()[1];
        }
        if (areaSelectEvent.getMode() == '\u0001') {
            this.ex = areaSelectEvent.getPosition()[0];
            this.ey = areaSelectEvent.getPosition()[1];
        }
    }

    @Override
    public void removePrimitives() {
        this.primID = -1;
        this.primID2 = -1;
    }
}

