/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.legend;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.enums.Plot1DStyles;

public class TableCanvas
extends Canvas
implements PaintListener {
    private Plot1DStyles currentStyle;
    private Color currentColour;

    public TableCanvas(Composite composite, int n) {
        super(composite, n);
        super.addPaintListener((PaintListener)this);
    }

    public void setStyle(Plot1DStyles plot1DStyles) {
        this.currentStyle = plot1DStyles;
    }

    public void setColour(Color color) {
        this.currentColour = color;
    }

    public void paintControl(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        paintEvent.gc.setBackground(this.getDisplay().getSystemColor(1));
        paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
        paintEvent.gc.setBackground(this.currentColour);
        int n = rectangle.width;
        int n2 = (rectangle.height >> 1) - 2;
        switch (this.currentStyle) {
            case SOLID: 
            case SOLID_POINT: {
                paintEvent.gc.fillRectangle(0, n2, n, 4);
                break;
            }
            case DASHED: {
                int n3 = n >> 3;
                int n4 = 0;
                while (n4 < 4) {
                    paintEvent.gc.fillRectangle(n4 * 2 * n3, n2, n3, 4);
                    ++n4;
                }
                break;
            }
            case POINT: 
            case DASHED_POINT: {
                int n5 = n >> 3;
                int n6 = 0;
                while (n6 < 4) {
                    paintEvent.gc.fillOval(n6 * 2 * n5, n2, n5 >> 1, n5 >> 1);
                    ++n6;
                }
                break;
            }
        }
    }
}

