/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.legend;

import gda.observable.IObserver;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DAppearance;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.Plot1DGraphTable;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEvent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendChangeEventListener;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.LegendComponent;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.legend.TableCanvas;

public class LegendTable
extends LegendComponent
implements SelectionListener,
KeyListener {
    private Table tblLegend;
    private LinkedList<TableEditor> editors;
    private LinkedList<Button> buttons;
    private Plot1DGraphTable plotTable;
    private static final int DEL_KEY = 127;

    public LegendTable(Composite composite, int n) {
        super(composite, n);
        this.setLayout((Layout)new GridLayout(1, false));
        this.editors = new LinkedList();
        this.buttons = new LinkedList();
        this.observers = new LinkedList();
        this.tblLegend = new Table((Composite)this, 0x20000000);
        this.tblLegend.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tblLegend.setHeaderVisible(false);
        this.tblLegend.setLinesVisible(true);
        this.tblLegend.setEnabled(true);
        this.tblLegend.addKeyListener((KeyListener)this);
        TableColumn tableColumn = new TableColumn(this.tblLegend, 0);
        tableColumn.setWidth(82);
        tableColumn.setResizable(false);
        tableColumn.setText("Colour");
        tableColumn = new TableColumn(this.tblLegend, 0);
        tableColumn.setWidth(250);
        tableColumn.setResizable(true);
        tableColumn.setText("Description");
        tableColumn = new TableColumn(this.tblLegend, 0);
        tableColumn.setWidth(80);
        tableColumn.setResizable(false);
        tableColumn.setText("Visible");
        tableColumn = new MenuManager();
        tableColumn.add((IAction)new Action("Resizable", 2){
            private boolean show;
            {
                this.show = false;
            }

            public void run() {
                this.show = !this.show;
                LegendTable.this.tblLegend.setHeaderVisible(this.show);
            }
        });
        Menu menu = tableColumn.createContextMenu((Control)this.tblLegend);
        this.tblLegend.setMenu(menu);
    }

    @Override
    public void updateTable(Plot1DGraphTable plot1DGraphTable) {
        this.removeAllTableEntries();
        this.plotTable = plot1DGraphTable;
        int n = 0;
        while (n < plot1DGraphTable.getLegendSize()) {
            Plot1DAppearance plot1DAppearance = plot1DGraphTable.getLegendEntry(n);
            TableItem tableItem = new TableItem(this.tblLegend, 0x20000000);
            TableEditor tableEditor = new TableEditor(this.tblLegend);
            this.editors.add(tableEditor);
            TableCanvas tableCanvas = new TableCanvas((Composite)this.tblLegend, 0x20000000);
            plot1DAppearance.updateCanvas(tableCanvas);
            tableCanvas.pack();
            tableEditor.minimumWidth = tableCanvas.getSize().x;
            tableEditor.horizontalAlignment = 0x1000000;
            tableEditor.setEditor((Control)tableCanvas, tableItem, 0);
            tableEditor.grabHorizontal = true;
            tableItem.setText(1, plot1DAppearance.getName());
            TableEditor tableEditor2 = new TableEditor(this.tblLegend);
            tableEditor2.horizontalAlignment = 0x1000000;
            tableEditor2.grabHorizontal = true;
            tableEditor2.grabVertical = true;
            Button button = new Button((Composite)this.tblLegend, 0x20000020);
            button.setText("Active");
            button.pack();
            button.addSelectionListener((SelectionListener)this);
            button.setBackground(this.getDisplay().getSystemColor(1));
            this.buttons.add(button);
            if (plot1DAppearance.isVisible()) {
                button.setSelection(true);
            } else {
                button.setSelection(false);
            }
            tableEditor2.setEditor((Control)button, tableItem, 2);
            this.editors.add(tableEditor2);
            ++n;
        }
    }

    private void removeAllTableEntries() {
        this.tblLegend.removeAll();
        for (TableEditor tableEditor : this.editors) {
            tableEditor.getEditor().dispose();
            tableEditor.dispose();
        }
        this.editors.clear();
        this.buttons.clear();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void notifyAllObservers() {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            ((IObserver)iterator.next()).update((Object)this, null);
        }
    }

    private void notifyAllListeners(int n) {
        Iterator iterator = this.listeners.iterator();
        LegendChangeEvent legendChangeEvent = new LegendChangeEvent((Object)this, n);
        while (iterator.hasNext()) {
            ((LegendChangeEventListener)iterator.next()).legendDeleted(legendChangeEvent);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n = this.buttons.indexOf(selectionEvent.getSource());
        if (n >= 0 && n < this.plotTable.getLegendSize()) {
            Plot1DAppearance plot1DAppearance = this.plotTable.getLegendEntry(n);
            Button button = (Button)selectionEvent.getSource();
            plot1DAppearance.setVisible(button.getSelection());
            this.notifyAllObservers();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        TableItem tableItem;
        if (keyEvent.keyCode == 127 && (tableItem = this.tblLegend.getItem(this.tblLegend.getSelectionIndex())).getText(1).contains("History")) {
            this.notifyAllListeners(this.tblLegend.getSelectionIndex());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

