/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting;

import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import uk.ac.diamond.scisoft.analysis.fitting.functions.APeak;
import uk.ac.diamond.scisoft.analysis.rcp.AnalysisRCPActivator;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.fitting.FittedPeakData;
import uk.ac.diamond.scisoft.analysis.rcp.plotting.roi.ROITableViewer;

public final class FittedPeakTableViewer
extends ROITableViewer {
    public FittedPeakTableViewer(Composite composite, SelectionListener selectionListener, ICellEditorListener iCellEditorListener, ISelectionChangedListener iSelectionChangedListener) {
        super(composite, selectionListener, iCellEditorListener);
        this.addLeftClickListener(iSelectionChangedListener);
    }

    @Override
    public String content(Object object, int n) {
        String string = null;
        FittedPeakData fittedPeakData = (FittedPeakData)object;
        if (fittedPeakData != null) {
            APeak aPeak = fittedPeakData.getFittedPeak();
            switch (n) {
                case 1: {
                    string = this.formatCellToCorrectDP(aPeak.getPosition());
                    break;
                }
                case 2: {
                    string = this.formatCellToCorrectDP(aPeak.getFWHM());
                    break;
                }
                case 3: {
                    string = this.formatCellToCorrectDP(aPeak.getArea());
                    break;
                }
                case 4: {
                    string = aPeak.getClass().getSimpleName();
                }
            }
        }
        return string;
    }

    @Override
    public String[] getTitles() {
        return new String[]{"Visible", "Peak Position", "FWHM", "Area", "Name"};
    }

    @Override
    public int[] getWidths() {
        return new int[]{60, 100, 100, 100, 150};
    }

    @Override
    public String[] getTipTexts() {
        return new String[]{"Visible", "Peak position", "Full width at half maximum", "Area under peak", "Name of distribution"};
    }

    private String formatCellToCorrectDP(double d) {
        int n = AnalysisRCPActivator.getDefault().getPreferenceStore().getInt("fitting1d.peak.dp");
        return String.format("%." + n + "f", d);
    }
}

