/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.rcp.plotting.errors;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class ErrorHelpers {
    private static void buildErrorBar(double[] dArray, int[] nArray, int n, double d, double d2, double d3, double d4, double d5, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        int n2 = 0;
        while (n2 < 3) {
            dArray4[n2] = dArray2[n2] * d4;
            dArray5[n2] = dArray3[n2] * d5;
            ++n2;
        }
        double[] dArray6 = new double[]{d, d2, d3};
        ErrorHelpers.buildErrorBar(dArray, nArray, n, dArray6, dArray4, dArray5);
    }

    private static void buildErrorBar(double[] dArray, int[] nArray, int n, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n2 = n * 6 * 3;
        int n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] + dArray3[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] - dArray3[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] + dArray3[n3] + dArray4[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] + dArray3[n3] - dArray4[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] - dArray3[n3] + dArray4[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 3) {
            dArray[n2++] = dArray2[n3] - dArray3[n3] - dArray4[n3];
            ++n3;
        }
        n2 = n * 3 * 2;
        nArray[n2++] = n * 6 + 0;
        nArray[n2++] = n * 6 + 1;
        nArray[n2++] = n * 6 + 2;
        nArray[n2++] = n * 6 + 3;
        nArray[n2++] = n * 6 + 4;
        nArray[n2++] = n * 6 + 5;
    }

    public static SceneGraphComponent createErrorNode(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5, double[] dArray6) {
        int n = dArray.length;
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        int n2 = n * 6;
        int n3 = n * 3;
        indexedLineSetFactory.setVertexCount(n2);
        double[] dArray7 = new double[n2 * 3];
        indexedLineSetFactory.setEdgeCount(n3);
        int[] nArray = new int[n3 * 2];
        int n4 = 0;
        while (n4 < n) {
            if (dArray4[n4] > 0.0) {
                ErrorHelpers.buildErrorBar(dArray7, nArray, n4, dArray[n4], dArray2[n4], dArray3[n4], dArray4[n4], d, dArray5, dArray6);
            }
            ++n4;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray7);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        SceneGraphComponent sceneGraphComponent = SceneGraphUtility.createFullSceneGraphComponent((String)"AxisNode");
        sceneGraphComponent.setGeometry((Geometry)indexedLineSetFactory.getIndexedLineSet());
        Appearance appearance = new Appearance();
        sceneGraphComponent.setAppearance(appearance);
        appearance.setAttribute("lineShader.tubeDraw", false);
        appearance.setAttribute("pointShader.spheresDraw", false);
        appearance.setAttribute("attenuatePointSize", false);
        appearance.setAttribute("lightingEnabled", false);
        DefaultGeometryShader defaultGeometryShader = ShaderUtility.createDefaultGeometryShader((Appearance)appearance, (boolean)true);
        defaultGeometryShader.setShowFaces(Boolean.valueOf(false));
        defaultGeometryShader.setShowLines(Boolean.valueOf(true));
        defaultGeometryShader.setShowPoints(Boolean.valueOf(false));
        DefaultLineShader defaultLineShader = (DefaultLineShader)defaultGeometryShader.createLineShader("default");
        defaultLineShader.setDiffuseColor(Color.BLACK);
        defaultLineShader.setTubeDraw(Boolean.valueOf(false));
        defaultLineShader.setLineWidth(Double.valueOf(1.0));
        return sceneGraphComponent;
    }

    public static void updateErrorNode(SceneGraphComponent sceneGraphComponent, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5, double[] dArray6) {
        int n = dArray.length;
        IndexedLineSetFactory indexedLineSetFactory = new IndexedLineSetFactory();
        int n2 = n * 6;
        int n3 = n * 3;
        indexedLineSetFactory.setVertexCount(n2);
        double[] dArray7 = new double[n2 * 3];
        indexedLineSetFactory.setEdgeCount(n3);
        int[] nArray = new int[n3 * 2];
        int n4 = 0;
        while (n4 < n) {
            if (dArray4[n4] > 0.0) {
                ErrorHelpers.buildErrorBar(dArray7, nArray, n4, dArray[n4], dArray2[n4], dArray3[n4], dArray4[n4], d, dArray5, dArray6);
            }
            ++n4;
        }
        indexedLineSetFactory.setVertexCoordinates(dArray7);
        indexedLineSetFactory.setEdgeIndices(nArray);
        indexedLineSetFactory.update();
        sceneGraphComponent.setGeometry((Geometry)indexedLineSetFactory.getIndexedLineSet());
    }

    public static double[] extractAndScale(IDataset iDataset, double d, double d2, double d3) {
        if (iDataset.getShape().length > 1) {
            throw new IllegalArgumentException("Only 1D datasets can be processed by extract and scale");
        }
        double[] dArray = new double[iDataset.getShape()[0]];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (iDataset.getDouble(new int[]{n}) - d) * (d2 / (d3 - d));
            ++n;
        }
        return dArray;
    }

    public static double[] extractAndScaleError(IDataset iDataset, double d, double d2, double d3) {
        if (iDataset.getShape().length > 1) {
            throw new IllegalArgumentException("Only 1D datasets can be processed by extract and scale");
        }
        double[] dArray = new double[iDataset.getShape()[0]];
        AbstractDataset abstractDataset = (AbstractDataset)iDataset;
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = abstractDataset.getErrorDouble(new int[]{n}) * (d2 / (d3 - d));
            ++n;
        }
        return dArray;
    }

    public static double[] constantPoints(double d, int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = d;
            ++n2;
        }
        return dArray;
    }
}

